/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.pcl;

import com.klg.jclass.page.FontParser;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.page.pcl.FontPCL;
import com.klg.jclass.page.pcl.Graphics2DPCL;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;

public class JCPCLPrinter
extends JCPrinter {
    protected Rectangle2D oldPageSize = null;
    protected boolean isGL2Mode = false;
    protected Rectangle2D currentPageSize;
    protected static final Rectangle2D.Double letter = new Rectangle2D.Double(0.0, 0.0, 612.0, 792.0);
    protected static final Rectangle2D.Double legal = new Rectangle2D.Double(0.0, 0.0, 612.0, 1008.0);
    protected static final Rectangle2D.Double executive = new Rectangle2D.Double(0.0, 0.0, 522.0, 756.0);
    protected static final Rectangle2D.Double ledger = new Rectangle2D.Double(0.0, 0.0, 792.0, 1224.0);
    protected static final Rectangle2D.Double a4 = new Rectangle2D.Double(0.0, 0.0, 595.3, 841.9);
    protected static final Rectangle2D.Double a3 = new Rectangle2D.Double(0.0, 0.0, 841.9, 1190.6);

    public JCPCLPrinter(OutputStream outputStream, FontParser fontParser, String string, String string2, String string3) {
        this.os = outputStream;
        FontPCL.getAllFonts(fontParser, string, string2, string3);
    }

    public JCPCLPrinter(OutputStream outputStream) {
        this.os = outputStream;
        FontPCL.getAllFonts();
    }

    public void setup() {
    }

    public boolean isImageScalable() {
        return true;
    }

    public void openDocument(Rectangle2D rectangle2D) {
        super.openDocument(rectangle2D);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            ((Graphics2DPCL)graphics).resetFont = true;
        }
        this.output("\u001b%-12345X");
        this.output("\u001bE");
        this.output("\u001b&u720D");
        this.setupPage(rectangle2D);
    }

    public void closeDocument(Rectangle2D rectangle2D) {
        if (this.graphics != null && this.isGL2Mode) {
            ((Graphics2DPCL)this.graphics).exitGl2Mode();
        }
        this.output("\u001bE");
        this.output("\u001b%-12345X");
        super.closeDocument(rectangle2D);
        this.graphics.dispose();
    }

    public void beginPage(Rectangle2D rectangle2D, int n2) {
        super.beginPage(rectangle2D, n2);
        if (this.graphics != null && this.isGL2Mode) {
            ((Graphics2DPCL)this.graphics).exitGl2Mode();
        }
        double d2 = 90.0;
        if (this.paperChanged(rectangle2D)) {
            this.setupPage(rectangle2D);
        }
        ((Graphics2DPCL)this.getGraphics()).initialiseClip(rectangle2D);
    }

    protected void setupPage(Rectangle2D rectangle2D) {
        this.currentPageSize = (Rectangle2D)rectangle2D.clone();
        int n2 = this.getPaperCode(rectangle2D.getWidth(), rectangle2D.getHeight());
        this.output("\u001b&l" + n2 + "A");
        if (this.isLandscape(rectangle2D.getWidth(), rectangle2D.getHeight())) {
            this.output("\u001b&l1O");
        } else {
            this.output("\u001b&l0O");
        }
        this.output("\u001b&l0e0C");
        this.output("\u001b*p0x0Y");
        String string = "\u001b*c" + (rectangle2D.getX() + rectangle2D.getWidth()) * Graphics2DPCL.DECIPOINT + "x" + (rectangle2D.getY() + rectangle2D.getHeight()) * Graphics2DPCL.DECIPOINT + "Y\n\u001b*c0T";
        this.output(string);
    }

    protected int getPaperCode(double d2, double d3) {
        if (d2 > d3) {
            double d4 = d2;
            d2 = d3;
            d3 = d4;
        }
        int n2 = 2;
        if (executive.contains(d2 -= 9.0, d3 -= 9.0)) {
            n2 = 1;
        } else if (a4.contains(d2, d3)) {
            n2 = 26;
        } else if (letter.contains(d2, d3)) {
            n2 = 2;
        } else if (legal.contains(d2, d3)) {
            n2 = 3;
        } else if (ledger.contains(d2, d3)) {
            n2 = 6;
        } else if (a3.contains(d2, d3)) {
            n2 = 27;
        }
        return n2;
    }

    public void endPage(Rectangle2D rectangle2D) {
        if (this.graphics != null && this.isGL2Mode) {
            ((Graphics2DPCL)this.graphics).exitGl2Mode();
        }
        this.output("\f");
        super.endPage(rectangle2D);
    }

    public Graphics getGraphics() {
        if (this.graphics == null) {
            this.graphics = new Graphics2DPCL(this.os, this);
            ((Graphics2DPCL)this.graphics).setFrameRoot();
        }
        return this.graphics;
    }

    protected boolean paperChanged(Rectangle2D rectangle2D) {
        if (this.oldPageSize == null) {
            this.oldPageSize = (Rectangle2D)rectangle2D.clone();
            return false;
        }
        return !this.oldPageSize.equals(rectangle2D);
    }
}

