/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.pcl;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.pcl.CharSetEntryPCL;
import com.klg.jclass.page.pcl.FontMetricsPCL;
import com.klg.jclass.page.pcl.FontPCL;
import com.klg.jclass.page.pcl.JCPCLPrinter;
import com.klg.jclass.page.pcl.KernPairPCL;
import com.klg.jclass.page.pcl.TypeFacePCL;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class Graphics2DPCL
extends Graphics2DBase
implements Cloneable {
    protected double base_x = 0.0;
    protected double base_y = 0.0;
    protected Color currentTextColor = null;
    protected Color currentLineColor = null;
    protected Color currentFillColor = null;
    protected boolean textColorChanged = true;
    protected boolean lineColorChanged = true;
    protected boolean fillColorChanged = true;
    protected String symbolSet = new String("");
    protected JCPCLPrinter printer;
    protected static double DECIPOINT = 10.0;
    protected boolean landscapeMode = false;
    protected boolean resetFont = true;
    protected static int[] greyscale = new int[]{0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 100};
    protected static final int MOVE = 0;
    protected static final int INTERSECT = 1;
    protected static final int PUSH = 0;
    protected static final int REPLACE = 1;

    public Graphics2DPCL(OutputStream outputStream) {
        super(outputStream);
        this.printer = null;
    }

    public Graphics2DPCL(OutputStream outputStream, JCPCLPrinter jCPCLPrinter) {
        super(outputStream);
        this.printer = jCPCLPrinter;
    }

    public Object clone() {
        Graphics2DPCL graphics2DPCL;
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        try {
            graphics2DPCL = (Graphics2DPCL)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        graphics2DPCL.transform = new AffineTransform(this.transform);
        graphics2DPCL.clip = (Rectangle2D)rectangle2D.clone();
        return graphics2DPCL;
    }

    public void drawString(String string, float f2, float f3) {
        if (string == null || string.equals("")) {
            return;
        }
        int n2 = 0;
        int n3 = string.length();
        CharSetEntryPCL charSetEntryPCL = null;
        this.updateContext();
        Rectangle rectangle = this.getClipBounds();
        if ((double)f2 < ((RectangularShape)rectangle).getX() || (double)f3 < ((RectangularShape)rectangle).getY() || (double)f2 > ((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth() || (double)f3 > ((RectangularShape)rectangle).getY() + ((RectangularShape)rectangle).getHeight()) {
            return;
        }
        if (this.isGL2Mode()) {
            this.exitGl2Mode();
        }
        this.outputTextColor();
        FontPCL fontPCL = (FontPCL)this.getFont();
        if (this.resetFont || this.currentFont == null || !this.currentFont.equals(fontPCL)) {
            this.outputFontDefinition(fontPCL);
            this.resetFont = false;
            this.currentFont = fontPCL;
        }
        if (this.underline) {
            this.output("\u001b&d0D");
        }
        f2 = (float)((this.base_x + (double)f2) * DECIPOINT);
        f3 = (float)((this.base_y + (double)f3) * DECIPOINT);
        this.initializeOutString(f2, f3);
        FontMetricsPCL fontMetricsPCL = new FontMetricsPCL(fontPCL);
        for (n2 = 0; n2 < n3; ++n2) {
            Integer n4;
            KernPairPCL kernPairPCL;
            char c2 = string.charAt(n2);
            CharSetEntryPCL charSetEntryPCL2 = fontPCL.getCharMetric(c2);
            if (charSetEntryPCL != null && charSetEntryPCL.getKerns().size() > 0 && (kernPairPCL = charSetEntryPCL.getKernPair(n4 = new Integer(charSetEntryPCL2.getIndex()))) != null && kernPairPCL.kernValue != 0) {
                this.printOutString();
                double d2 = fontMetricsPCL.convertToDecipoints(kernPairPCL.kernValue, fontPCL.getSize());
                this.out.x += d2;
            }
            double d3 = fontMetricsPCL.convertToDecipoints(charSetEntryPCL2.metrics.getHorizontalEscapement(), fontPCL.getSize());
            this.appendToOutString(c2, d3);
            charSetEntryPCL = charSetEntryPCL2;
        }
        this.printOutString();
        if (this.underline) {
            this.output("\u001b&d@");
        }
    }

    public void translate(int n2, int n3) {
        this.translate((double)n2, (double)n3);
    }

    public void translate(double d2, double d3) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.translate(d2, d3);
        double d4 = rectangle2D.getX() - d2;
        double d5 = rectangle2D.getY() - d3;
        double d6 = rectangle2D.getWidth();
        double d7 = rectangle2D.getHeight();
        rectangle2D.setRect(d4, d5, d6, d7);
        this.translateInternal(d2, d3);
    }

    public void scale(double d2, double d3) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.scale(d2, d3);
        double d4 = rectangle2D.getX() / d2;
        double d5 = rectangle2D.getY() / d3;
        double d6 = rectangle2D.getWidth() / d2;
        double d7 = rectangle2D.getHeight() / d3;
        rectangle2D.setRect(d4, d5, d6, d7);
    }

    protected void restoreTranslation() {
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.clipRect((double)n2, (double)n3, (double)n4, (double)n5);
    }

    public void clipRect(double d2, double d3, double d4, double d5) {
        this.setClipInternal(d2, d3, d4, d5, 1);
    }

    protected void restoreClip() {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
    }

    protected void setCurrentClip(Rectangle2D rectangle2D) {
        if (this.isGL2Mode()) {
            double d2 = (rectangle2D.getX() + this.base_x) * DECIPOINT;
            double d3 = d2 + rectangle2D.getWidth() * DECIPOINT;
            double d4 = (rectangle2D.getY() + this.base_y) * DECIPOINT;
            double d5 = d4 + rectangle2D.getHeight() * DECIPOINT;
            d2 = this.adjustPoint(d2, d5, this.landscapeMode);
            d3 = this.adjustPoint(d3, d4, this.landscapeMode);
            this.output("IW" + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d5) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d4));
        }
        this.clip = rectangle2D;
    }

    public void setFont(Font font) {
        this.updateContext();
        if (this.isGL2Mode()) {
            this.exitGl2Mode();
        }
        if (!(font instanceof FontPCL)) {
            font = FontPCL.getNativeFont(font);
        }
        if (this.currentFont != null && this.currentFont.equals(font) && !this.resetFont) {
            return;
        }
        this.resetFont = false;
        this.currentFont = font;
        this.fontChanged = true;
        this.outputFontDefinition(font);
    }

    private void outputFontDefinition(Font font) {
        FontPCL fontPCL = (FontPCL)font;
        TypeFacePCL typeFacePCL = fontPCL.getTypeface();
        if (!this.symbolSet.equals(typeFacePCL.symbol.latin1Set)) {
            this.output("\u001b(" + typeFacePCL.symbol.latin1Set);
            this.symbolSet = new String(typeFacePCL.symbol.latin1Set);
        }
        String string = (typeFacePCL.getStyle() & 0x40) == 0 ? new String("\u001b(s1p") : new String("\u001b(s0p" + fontPCL.getCharsPerInch() + "h");
        string = string + fontPCL.getSize() + "v";
        string = (typeFacePCL.getStyle() & 4) == 0 ? string + "0s" : string + "1s";
        string = (typeFacePCL.getStyle() & 2) == 0 ? string + "0b" : string + "3b";
        string = string + typeFacePCL.general.typefaceSelectionString + "T";
        this.output(string);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        this.setupGraphics(false);
        int n3 = nArray[0];
        int n4 = nArray2[0];
        n3 = (int)((this.base_x + (double)n3) * DECIPOINT);
        n4 = (int)((this.base_y + (double)n4) * DECIPOINT);
        n3 = (int)this.adjustPoint(n3, n4, this.landscapeMode);
        this.output("PU" + n3 + "," + n4 + ";");
        this.printPoly(nArray, nArray2, n2);
        this.cleanupGraphics();
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        boolean bl = true;
        this.printPolygon(nArray, nArray2, n2, bl);
    }

    public FontMetrics getFontMetrics(Font font) {
        if (!(font instanceof FontPCL)) {
            font = FontPCL.getNativeFont(font);
        }
        return new FontMetricsPCL((FontPCL)font);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        boolean bl = false;
        this.printPolygon(nArray, nArray2, n2, bl);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        this.updateContext();
        if (image instanceof EPSImage) {
            Color color2 = this.getColor();
            this.setColor(Color.lightGray);
            this.fillRect(n2, n3, n4, n5);
            this.setColor(color2);
            return true;
        }
        return this.drawJavaImage(image, n2, n3, n4, n5, color, imageObserver);
    }

    public void startContext() {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.resetFont = true;
        this.colorChanged = true;
    }

    public void endContext() {
    }

    protected void setClipInternal(double d2, double d3, double d4, double d5, int n2) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        if (n2 == 1) {
            if (rectangle2D.getX() > d2) {
                d4 -= rectangle2D.getX() - d2;
                d2 = rectangle2D.getX();
            }
            if (rectangle2D.getY() > d3) {
                d5 -= rectangle2D.getY() - d3;
                d3 = rectangle2D.getY();
            }
            if (d2 + d4 > rectangle2D.getX() + rectangle2D.getWidth()) {
                d4 = rectangle2D.getX() + rectangle2D.getWidth() - d2;
            }
            if (d3 + d5 > rectangle2D.getY() + rectangle2D.getHeight()) {
                d5 = rectangle2D.getY() + rectangle2D.getHeight() - d3;
            }
        }
        rectangle2D.setRect(d2, d3, d4, d5);
        if (this.isContextCurrent()) {
            this.setCurrentClip(rectangle2D);
        }
    }

    protected void translateInternal(double d2, double d3) {
        this.base_x += d2;
        this.base_y += d3;
    }

    public void drawArcPW(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        boolean bl;
        double d8 = 1.0;
        double d9 = d4 / 2.0;
        double d10 = d5 / 2.0;
        boolean bl2 = bl = d4 != d5;
        if (d4 == 0.0) {
            this.drawLinePW(d2, d3 + d10, d2, d3 - d10);
            return;
        }
        if (d5 == 0.0) {
            this.drawLinePW(d2 + d9, d3, d2 - d9, d3);
            return;
        }
        this.setupGraphics(false);
        d2 = (d2 + this.base_x + d9) * DECIPOINT;
        d3 = (d3 + this.base_y + d10) * DECIPOINT;
        d9 *= DECIPOINT;
        d10 *= DECIPOINT;
        d2 = this.adjustPoint(d2, d3, this.landscapeMode);
        if (bl) {
            d8 = d5 / d4;
            this.output("SC0,1.411111,0,-" + d8 * 1.411111 + ",2;");
            d3 /= d8;
        }
        if (Math.abs(d7) < 360.0) {
            double d11 = d6 / 180.0 * Math.PI;
            double d12 = d2 + d9 * Math.cos(d11);
            double d13 = d3 + d10 * Math.sin(d11);
            if (bl) {
                d13 /= d8;
            }
            this.output("PU" + this.truncateDecimalDigits(d12) + "," + this.truncateDecimalDigits(d13) + ";PD;AA" + this.truncateDecimalDigits(d2) + "," + this.truncateDecimalDigits(d3) + "," + this.truncateDecimalDigits(d7) + ";");
        } else {
            this.output("PU" + this.truncateDecimalDigits(d2) + "," + this.truncateDecimalDigits(d3) + ";CI" + this.truncateDecimalDigits(d9) + ";");
        }
        if (bl) {
            this.output("SC0,1.411111,0,-1.4111111,2");
        }
        this.cleanupGraphics();
    }

    public void fillArcPW(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        boolean bl;
        double d8 = d4 / 2.0;
        double d9 = d5 / 2.0;
        boolean bl2 = bl = d4 != d5;
        if (d4 == 0.0) {
            this.drawLinePW(d2, d3 + d9, d2, d3 - d9);
            return;
        }
        if (d5 == 0.0) {
            this.drawLinePW(d2 + d8, d3, d2 - d8, d3);
            return;
        }
        this.setupGraphics(true);
        d2 = (d2 + this.base_x + d8) * DECIPOINT;
        d3 = (d3 + this.base_y + d9) * DECIPOINT;
        d8 *= DECIPOINT;
        d9 *= DECIPOINT;
        d2 = this.adjustPoint(d2, d3, this.landscapeMode);
        if (bl) {
            double d10 = d5 / d4;
            this.output("SC0,1.411111,0,-" + d10 * 1.411111 + ",2;");
            d3 /= d10;
        }
        this.output("PU" + this.truncateDecimalDigits(d2) + "," + this.truncateDecimalDigits(d3) + ";");
        if (Math.abs(d7) < 360.0) {
            this.output("WG" + d8 + "," + -d6 + "," + -d7 + ";");
        } else {
            this.output("PM0;CI" + d8 + ";PM2;FP;");
        }
        if (bl) {
            this.output("SC0,1.411111,0,-1.4111111,2");
        }
        this.cleanupGraphics();
    }

    public void fillRectPW(double d2, double d3, double d4, double d5) {
        this.setupGraphics(true);
        d2 *= DECIPOINT;
        d3 *= DECIPOINT;
        d2 = this.base_x * DECIPOINT + d2;
        d3 = this.base_y * DECIPOINT + d3;
        d2 = this.adjustPoint(d2, d3, this.landscapeMode);
        this.output("PU" + this.truncateDecimalDigits(d2) + "," + this.truncateDecimalDigits(d3) + ";RR" + this.truncateDecimalDigits(d4 *= DECIPOINT) + "," + this.truncateDecimalDigits(d5 *= DECIPOINT) + ";");
        this.cleanupGraphics();
    }

    public void setClipPW(double d2, double d3, double d4, double d5) {
        this.setClipInternal(d2, d3, d4, d5, 0);
    }

    public void drawRectPW(double d2, double d3, double d4, double d5) {
        this.setupGraphics(false);
        d2 *= DECIPOINT;
        d3 *= DECIPOINT;
        d2 = this.base_x * DECIPOINT + d2;
        d3 = this.base_y * DECIPOINT + d3;
        d2 = this.adjustPoint(d2, d3, this.landscapeMode);
        this.output("PU" + this.truncateDecimalDigits(d2) + "," + this.truncateDecimalDigits(d3) + ";ER" + this.truncateDecimalDigits(d4 *= DECIPOINT) + "," + this.truncateDecimalDigits(d5 *= DECIPOINT) + ";");
        this.cleanupGraphics();
    }

    public void drawLinePW(double d2, double d3, double d4, double d5) {
        this.setupGraphics(false);
        d2 = (d2 + this.base_x) * DECIPOINT;
        d3 = (d3 + this.base_y) * DECIPOINT;
        d4 = (d4 + this.base_x) * DECIPOINT;
        d5 = (d5 + this.base_y) * DECIPOINT;
        d2 = this.adjustPoint(d2, d3, this.landscapeMode);
        d4 = this.adjustPoint(d4, d5, this.landscapeMode);
        this.output("PU" + this.truncateDecimalDigits(d2) + "," + this.truncateDecimalDigits(d3) + ";PD" + this.truncateDecimalDigits(d4) + "," + this.truncateDecimalDigits(d5) + ";");
        this.cleanupGraphics();
    }

    public void drawRoundRectPW(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.drawRRect(d2, d3, d4, d5, d6, d7, "EP;");
    }

    public void fillRoundRectPW(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.drawRRect(d2, d3, d4, d5, d6, d7, "FP;");
    }

    public Shape getClip() {
        Shape shape = super.getClip() instanceof Rectangle2D ? super.getClip() : super.getClip().getBounds2D();
        return shape;
    }

    protected void exitGl2Mode() {
        if (this.printer != null) {
            this.printer.isGL2Mode = false;
        }
        this.output("\u001b%0A");
    }

    protected void initialiseClip(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = (Rectangle2D)this.getClip();
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        this.base_x = d2;
        this.base_y = d3;
        rectangle2D2.setRect(0.0, 0.0, d4, d5);
    }

    protected void appendToOutString(char c2, double d2) {
        this.out.text.append(c2);
        this.out.width += d2;
    }

    protected double adjustPoint(double d2, double d3, boolean bl) {
        return d2 - 180.0;
    }

    protected void printOutString() {
        double d2 = this.out.x;
        double d3 = this.out.y;
        d2 = this.adjustPoint(d2, d3, this.landscapeMode);
        try {
            String string = new String("\u001b&a" + this.truncateDecimalDigits(d2) + "h" + this.truncateDecimalDigits(d3) + "V" + this.out.text);
            this.os.write(string.getBytes());
            this.os.write(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.out.x += this.out.width;
        this.out.width = 0.0;
        this.out.text.delete(0, this.out.text.length());
    }

    protected void outputGraphicsColor(boolean bl) {
        if (this.colorChanged) {
            this.textColorChanged = true;
            this.lineColorChanged = true;
            this.fillColorChanged = true;
            this.colorChanged = false;
        }
        Color color = this.getColor();
        if (bl) {
            if (color.equals(this.currentFillColor) && !this.fillColorChanged) {
                return;
            }
            this.currentFillColor = color;
            this.fillColorChanged = false;
        } else {
            if (color.equals(this.currentLineColor) && !this.lineColorChanged) {
                return;
            }
            this.currentLineColor = color;
            this.lineColorChanged = false;
        }
        double d2 = (double)color.getRed() / 255.0;
        double d3 = (double)color.getGreen() / 255.0;
        double d4 = (double)color.getBlue() / 255.0;
        int n2 = this.convertRGBToGrey(d2, d3, d4);
        if (bl) {
            this.output("FT10," + n2 + ";");
        } else if (n2 == 100) {
            this.output("SV0;");
        } else {
            this.output("SV1," + n2 + ";");
        }
    }

    protected void outputTextColor() {
        Color color;
        if (this.colorChanged) {
            this.textColorChanged = true;
            this.lineColorChanged = true;
            this.fillColorChanged = true;
            this.colorChanged = false;
        }
        if ((color = this.getColor()).equals(this.currentTextColor) && !this.textColorChanged) {
            return;
        }
        this.currentTextColor = color;
        this.textColorChanged = false;
        double d2 = (double)color.getRed() / 255.0;
        double d3 = (double)color.getGreen() / 255.0;
        double d4 = (double)color.getBlue() / 255.0;
        int n2 = this.convertRGBToGrey(d2, d3, d4);
        this.output("\u001b*c" + n2 + "G");
    }

    protected int convertRGBToGrey(double d2, double d3, double d4) {
        float f2 = (float)(0.3 * d2 + 0.59 * d3 + 0.11 * d4);
        int n2 = 100 - Math.round(f2 * 100.0f);
        return greyscale[n2];
    }

    protected void enterGl2Mode(Rectangle2D rectangle2D) {
        if (this.printer != null) {
            this.printer.isGL2Mode = true;
        }
        this.output("\u001b%0B");
        this.output("IN;SP1;TR0;");
        this.output("SC0,1.411111,0,-1.4111111,2");
        this.output("IR0,100,100,0");
        this.setCurrentClip(rectangle2D);
    }

    protected void setLineStroke() {
        if (!this.strokeChanged) {
            return;
        }
        float f2 = ((BasicStroke)this.currentStroke).getLineWidth();
        double d2 = JCUnit.getAsCentimeters(JCUnit.POINTS, f2) * 10.0;
        if (d2 == 0.0) {
            this.output("PW;");
        } else {
            this.output("PW" + this.truncateDecimalDigits(d2) + ";");
        }
        float[] fArray = ((BasicStroke)this.currentStroke).getDashArray();
        float f3 = ((BasicStroke)this.currentStroke).getDashPhase();
        if (fArray != null) {
            double d3 = JCUnit.getAsCentimeters(JCUnit.POINTS, fArray[0]) * 20.0;
            this.output("LT2," + this.truncateDecimalDigits(d3) + ",1;");
            this.dashMode = true;
        } else if (this.dashMode) {
            this.output("LT;");
            this.dashMode = false;
        }
        this.strokeChanged = false;
    }

    protected void traceRectanglePath(double d2, double d3, double d4, double d5, double d6) {
        double d7 = d2 + d6;
        double d8 = d3 + d6;
        double d9 = d3 + d5 - d6;
        double d10 = d2 + d4 - d6;
        double d11 = d3 + d5;
        double d12 = d2 + d4;
        this.output("PU" + d7 + "," + d3 + ";");
        this.output("PM0;PD;AA" + d7 + "," + d8 + "," + "-90;");
        this.output("PD" + d2 + "," + d9 + ";" + "AA" + d7 + "," + d9 + ",-90;");
        this.output("PD" + d10 + "," + d11 + ";" + "AA" + d10 + "," + d9 + ",-90;");
        this.output("PD" + d12 + "," + d8 + ";" + "AA" + d10 + "," + d8 + ",-90;PM2;");
    }

    public void drawRRect(double d2, double d3, double d4, double d5, double d6, double d7, String string) {
        double d8;
        if (d6 <= 0.0 || d7 <= 0.0) {
            if (string.equals("EP")) {
                this.drawRectPW(d2, d3, d4, d5);
            } else {
                this.fillRectPW(d2, d3, d4, d5);
            }
        }
        this.setupGraphics(string.equals("FP"));
        d2 = (d2 + this.base_x) * DECIPOINT;
        d3 = (d3 + this.base_y) * DECIPOINT;
        d4 *= DECIPOINT;
        d5 *= DECIPOINT;
        d2 = this.adjustPoint(d2, d3, this.landscapeMode);
        if (d6 != d7) {
            d8 = d7 / d6;
            this.output("SC0,1,0," + d8 + ",2;");
            d3 /= d8;
            d5 /= d8;
        }
        this.traceRectanglePath(d2, d3, d4, d5, d6 * DECIPOINT);
        this.output(string);
        if (d6 != d7) {
            d8 = d6 / d7;
            this.output("SC0,1,0," + d8 + ",2;");
        }
        this.cleanupGraphics();
    }

    protected void printPoly(int[] nArray, int[] nArray2, int n2) {
        for (int i2 = 1; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            int n4 = nArray2[i2];
            n3 = (int)((this.base_x + (double)n3) * DECIPOINT);
            n4 = (int)((this.base_y + (double)n4) * DECIPOINT);
            n3 = (int)this.adjustPoint(n3, n4, this.landscapeMode);
            this.output("PD" + n3 + "," + n4 + ";");
        }
    }

    protected void printPolygon(int[] nArray, int[] nArray2, int n2, boolean bl) {
        this.setupGraphics(bl);
        int n3 = nArray[0];
        int n4 = nArray2[0];
        n3 = (int)((this.base_x + (double)n3) * DECIPOINT);
        n4 = (int)((this.base_y + (double)n4) * DECIPOINT);
        n3 = (int)this.adjustPoint(n3, n4, this.landscapeMode);
        this.output("PU" + n3 + "," + n4 + ";" + "\nPM0;");
        this.printPoly(nArray, nArray2, n2);
        if (bl) {
            if (this.getWindingRule() == 0) {
                this.output("PM2;\nFP;");
            } else {
                this.output("PM2;\nFP1;");
            }
        } else {
            this.output("PM2;\nEP;");
        }
        this.cleanupGraphics();
    }

    protected void setupGraphics(boolean bl) {
        if (!this.isContextCurrent()) {
            this.updateContext();
        }
        if (!this.isGL2Mode()) {
            Rectangle rectangle = this.getClipBounds();
            this.enterGl2Mode(rectangle);
        }
        if (!bl) {
            this.setLineStroke();
        }
        this.outputGraphicsColor(bl);
    }

    protected void cleanupGraphics() {
        if (this.printer == null) {
            this.exitGl2Mode();
        }
    }

    protected void terminateRun(int n2, int n3, int n4) {
        this.output("PU" + (n2 - n3) + "," + n4 + ";RR" + n3 + ",1;");
    }

    protected boolean drawJavaImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        int[] nArray = new int[n6 * n7];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n6, n7, nArray, 0, n6);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        if (this.isGL2Mode()) {
            this.exitGl2Mode();
        }
        n2 = (int)((this.base_x + (double)n2) * DECIPOINT);
        n3 = (int)((this.base_y + (double)n3) * DECIPOINT);
        n4 = (int)((double)n4 * DECIPOINT);
        n5 = (int)((double)n5 * DECIPOINT);
        this.output("\u001b*c" + n4 + "x" + n5 + "Y");
        n2 = (int)this.adjustPoint(n2, n3, this.landscapeMode);
        this.output("\u001b*p" + n2 + "x" + n3 + "Y");
        this.output("\u001b*c0T");
        this.output("\u001b%0B");
        this.output("IN;SP1;TR0;");
        this.output("SC0," + pixelGrabber.getWidth() + ",0," + pixelGrabber.getHeight() + ";");
        this.output("IR0,100,100,0;");
        int n8 = -2;
        int n9 = pixelGrabber.getWidth();
        int n10 = pixelGrabber.getHeight();
        for (int i2 = 0; i2 < n10; ++i2) {
            int n11;
            int n12 = 0;
            for (n11 = 0; n11 < n9; ++n11) {
                int n13 = nArray[i2 * n9 + n11];
                int n14 = n13 >> 16 & 0xFF;
                int n15 = n13 >> 8 & 0xFF;
                int n16 = n13 & 0xFF;
                int n17 = this.convertRGBToGrey((double)n14 / 255.0, (double)n15 / 255.0, (double)n16 / 255.0);
                if (n17 == -1) {
                    if (n12 <= 0) continue;
                    this.terminateRun(n11, n12, i2);
                    n12 = 0;
                    continue;
                }
                if (n17 != n8) {
                    if (n12 > 0) {
                        this.terminateRun(n11, n12, i2);
                        n12 = 0;
                    }
                    StringBuffer stringBuffer = new StringBuffer("FT10,");
                    stringBuffer.append(n17);
                    this.output(stringBuffer.toString());
                    n8 = n17;
                }
                ++n12;
            }
            if (n12 <= 0) continue;
            this.terminateRun(n11, n12, i2);
        }
        this.output("\u001b%0A");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u001b*p0x0Y\n\u001b*c");
        double d2 = this.printer.currentPageSize.getX() + this.printer.currentPageSize.getWidth();
        stringBuffer.append((int)(d2 * DECIPOINT));
        stringBuffer.append("x");
        double d3 = this.printer.currentPageSize.getY() + this.printer.currentPageSize.getHeight();
        stringBuffer.append((int)(d3 * DECIPOINT));
        stringBuffer.append("y0T");
        this.output(stringBuffer.toString());
        return true;
    }

    protected boolean isGL2Mode() {
        return this.printer != null && this.printer.isGL2Mode;
    }
}

