/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.awt;

import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.OS;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCAWTPrinter
extends JCPrinter {
    protected PrinterThread printerThread;
    protected Thread thread;
    protected PrinterJob printerJob;
    protected boolean actuallyPrinting = false;
    protected JCDocument document;
    protected boolean showDialog = true;
    protected PageFormat pageFormat = new PageFormat();
    protected boolean abort = false;
    protected int firstToPrint = -1;
    protected int lastToPrint = -1;
    protected PrinterException threadException = null;
    protected boolean printToFile = false;
    protected File tempFile = null;
    protected JCPage firstPage = null;
    protected boolean updatePageFormat = false;

    public JCAWTPrinter() throws PrinterJobCancelledException, PrinterException {
        this(true);
    }

    public JCAWTPrinter(boolean bl) throws PrinterJobCancelledException, PrinterException {
        this(bl, false);
    }

    public JCAWTPrinter(boolean bl, boolean bl2) throws PrinterJobCancelledException, PrinterException {
        this.showDialog = bl;
        this.printToFile = bl2;
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, 612.0, 792.0);
        this.pageFormat.setPaper(paper);
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            if (this.threadException != null) {
                throw this.threadException;
            }
            throw new PrinterJobCancelledException();
        }
    }

    public JCAWTPrinter(List<JCPage> list) throws PrinterJobCancelledException, PrinterException {
        this(list, true);
    }

    public JCAWTPrinter(List<JCPage> list, boolean bl) throws PrinterJobCancelledException, PrinterException {
        this(null, null, list, bl);
    }

    public JCAWTPrinter(PageFormat pageFormat) throws PrinterJobCancelledException, PrinterException {
        this(pageFormat, true);
    }

    public JCAWTPrinter(PageFormat pageFormat, boolean bl) throws PrinterJobCancelledException, PrinterException {
        this(null, pageFormat, null, bl);
    }

    public JCAWTPrinter(PageFormat pageFormat, List<JCPage> list) throws PrinterJobCancelledException, PrinterException {
        this(pageFormat, list, true);
    }

    public JCAWTPrinter(PageFormat pageFormat, List<JCPage> list, boolean bl) throws PrinterJobCancelledException, PrinterException {
        this(null, pageFormat, list, bl);
    }

    public JCAWTPrinter(PrinterJob printerJob, PageFormat pageFormat) throws PrinterJobCancelledException, PrinterException {
        this(printerJob, pageFormat, true);
    }

    public JCAWTPrinter(PrinterJob printerJob, PageFormat pageFormat, boolean bl) throws PrinterJobCancelledException, PrinterException {
        this(printerJob, pageFormat, null, bl);
    }

    public JCAWTPrinter(PrinterJob printerJob, PageFormat pageFormat, List<JCPage> list) throws PrinterJobCancelledException, PrinterException {
        this(printerJob, pageFormat, list, true);
    }

    public JCAWTPrinter(PrinterJob printerJob, PageFormat pageFormat, List<JCPage> list, boolean bl) throws PrinterJobCancelledException, PrinterException {
        this(printerJob, pageFormat, list, bl, false);
    }

    public JCAWTPrinter(PrinterJob printerJob, PageFormat pageFormat, List<JCPage> list, boolean bl, boolean bl2) throws PrinterJobCancelledException, PrinterException {
        Graphics2D graphics2D;
        this.showDialog = bl;
        this.printToFile = bl2;
        if (printerJob != null) {
            this.printerJob = printerJob;
        }
        if (pageFormat != null) {
            this.pageFormat = pageFormat;
        }
        if (list != null) {
            this.updatePageFormat = true;
            if (list.size() > 0) {
                this.firstPage = list.get(0);
            }
        }
        if ((graphics2D = (Graphics2D)this.getGraphics()) == null) {
            if (this.threadException != null) {
                throw this.threadException;
            }
            throw new PrinterJobCancelledException();
        }
    }

    @Override
    public void setup() {
    }

    @Override
    public boolean isImageScalable() {
        return false;
    }

    public void registerDocument(JCDocument jCDocument) {
        this.document = jCDocument;
    }

    public void registerFirstLast(int n2, int n3) {
        this.firstToPrint = n2;
        this.lastToPrint = n3;
    }

    @Override
    public synchronized void openDocument(Rectangle2D rectangle2D) {
        if (this.printerThread == null) {
            this.getGraphics();
        }
        if (!this.actuallyPrinting) {
            this.actuallyPrinting = true;
            this.printerThread.wakeUp();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void openDocument(Rectangle2D rectangle2D, boolean bl) {
        super.openDocument(rectangle2D);
    }

    protected synchronized void wakeUpMainThread() {
        this.notifyAll();
    }

    protected synchronized void clearThread() {
        this.printerThread = null;
        this.graphics = null;
    }

    public void print(JCDocument jCDocument) {
        this.document = jCDocument;
        this.actuallyPrinting = true;
        this.printerThread.wakeUp();
    }

    @Override
    public synchronized void closeDocument(Rectangle2D rectangle2D) {
    }

    public void closeDocument(Rectangle2D rectangle2D, boolean bl) {
        super.closeDocument(rectangle2D);
    }

    @Override
    public void beginPage(Rectangle2D rectangle2D, int n2) {
    }

    @Override
    public void endPage(Rectangle2D rectangle2D) {
    }

    protected void initPrinterJob() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        this.printerThread = new PrinterThread(this.printerJob);
        if (this.updatePageFormat && this.firstPage != null) {
            this.updatePageFormat(this.firstPage);
            this.firstPage = null;
        }
        this.printerJob.setPrintable(this.printerThread, this.pageFormat);
    }

    protected void updatePageFormat(JCPage jCPage) {
        Paper paper = this.pageFormat.getPaper();
        if (paper == null) {
            paper = new Paper();
        }
        this.setOrientation(jCPage.getOrientation());
        Rectangle2D rectangle2D = jCPage.getPageSize();
        if (this.isLandscape(rectangle2D.getWidth(), rectangle2D.getHeight())) {
            this.pageFormat.setOrientation(0);
            paper.setImageableArea(rectangle2D.getY(), rectangle2D.getX(), rectangle2D.getHeight(), rectangle2D.getWidth());
            paper.setSize(rectangle2D.getHeight(), rectangle2D.getWidth());
        } else {
            this.pageFormat.setOrientation(1);
            paper.setImageableArea(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            paper.setSize(rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        this.pageFormat.setPaper(paper);
    }

    @Override
    public Graphics getGraphics() {
        if (this.graphics == null) {
            this.initPrinterJob();
            if (this.showDialog && !this.printerJob.printDialog()) {
                return null;
            }
            this.thread = new Thread((Runnable)this.printerThread, "PageLayout print thread");
            this.thread.start();
            while (this.graphics == null && !this.abort) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        return this.graphics;
    }

    protected void printPage(JCDocument jCDocument, int n2) {
        super.beginPage(null, n2);
        if (n2 >= 0 && n2 < jCDocument.getPages().size()) {
            JCPage jCPage = (JCPage)jCDocument.getPages().get(n2);
            jCPage.draw((Graphics2D)this.getGraphics());
        }
        super.endPage(null);
    }

    protected void setGraphics(Graphics2D graphics2D) {
        this.graphics = graphics2D;
        if (JCEnvironment.getJavaVersion() < 130) {
            this.graphics.translate(-13, -13);
        }
    }

    public void setShowDialog(boolean bl) {
    }

    public boolean getShowDialog() {
        return this.showDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.printerThread != null) {
            this.abort = true;
            this.printerThread.wakeUp();
            JCAWTPrinter jCAWTPrinter = this;
            synchronized (jCAWTPrinter) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.abort = false;
            if (this.printerJob != null) {
                this.printerJob.cancel();
            }
        }
    }

    public void cancelFromPrinterThread(PrinterException printerException) {
        this.threadException = printerException;
        if (this.printerJob != null) {
            this.printerJob.cancel();
        }
    }

    public boolean isPrintToFile() {
        return this.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printToFile = bl;
    }

    public File getPrintFile(String string) {
        File file = null;
        if (this.tempFile != null) {
            try {
                this.copyFile(this.tempFile.getCanonicalPath(), string);
                file = new File(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return file;
    }

    protected void sendPrintFileToPrinter() {
        if (this.tempFile != null) {
            try {
                PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
                this.submitPrnFile(this.tempFile.getCanonicalPath(), printService.getName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void submitPrnFile(String string, String string2) {
        OS oS = OS.getCurrent();
        String[] stringArray = oS.getPrnFileCommandArray(string, string2);
        if (stringArray == null) {
            throw new RuntimeException("Unsupported OS -- print aborted");
        }
        this.execute(stringArray);
    }

    protected void copyFile(String string, String string2) {
        OS oS = OS.getCurrent();
        String[] stringArray = oS.getCopyCommandArray(string, string2);
        if (stringArray == null) {
            throw new RuntimeException("Unsupported OS -- copy aborted");
        }
        this.execute(stringArray);
    }

    protected void execute(String[] stringArray) {
        try {
            String string = stringArray[0];
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                string = string + " " + stringArray[i2];
            }
            Process process = Runtime.getRuntime().exec(stringArray);
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "ERROR");
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "OUTPUT");
            streamGobbler.start();
            streamGobbler2.start();
            process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class PrinterJobCancelledException
    extends Exception {
        public PrinterJobCancelledException() {
            super("User elected not to print");
        }
    }

    protected class PrinterThread
    implements Runnable,
    Printable {
        protected PrinterJob pj;
        protected int copies;
        protected int first;
        protected int last;
        protected int pageCount;
        protected boolean collate;
        protected boolean reverse;
        protected int currentPage;
        protected int lastPageIndex = -1;
        protected int pageIncr = 1;
        protected int numPages;
        protected boolean firstPass = true;

        public PrinterThread(PrinterJob printerJob) {
            this.pj = printerJob;
        }

        public void run() {
            try {
                this.firstPass = true;
                JCAWTPrinter.this.tempFile = null;
                if (JCAWTPrinter.this.printToFile) {
                    HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                    URI uRI = null;
                    try {
                        JCAWTPrinter.this.tempFile = File.createTempFile("jclass", ".prn");
                        JCAWTPrinter.this.tempFile.deleteOnExit();
                        uRI = JCAWTPrinter.this.tempFile.toURI();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    Destination destination = new Destination(uRI);
                    hashPrintRequestAttributeSet.add(destination);
                    this.pj.print(hashPrintRequestAttributeSet);
                } else {
                    this.pj.print();
                }
                JCAWTPrinter.this.clearThread();
                JCAWTPrinter.this.wakeUpMainThread();
            }
            catch (PrinterException printerException) {
                JCAWTPrinter.this.clearThread();
                JCAWTPrinter.this.cancelFromPrinterThread(printerException);
            }
        }

        public synchronized int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
            if (JCAWTPrinter.this.abort) {
                return 1;
            }
            int n3 = 0;
            int n4 = JCEnvironment.isWorking("PrintingUse2ndCall");
            if (n4 == 1 && this.firstPass) {
                this.firstPass = false;
                this.lastPageIndex = n2;
                return n3;
            }
            JCAWTPrinter.this.setGraphics((Graphics2D)graphics);
            try {
                if (!JCAWTPrinter.this.actuallyPrinting) {
                    this.wait();
                    if (JCAWTPrinter.this.abort) {
                        return 1;
                    }
                    JCAWTPrinter.this.openDocument(null, true);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.reverse) {
                this.currentPage = this.copies == 1 ? this.first + n2 : (this.collate ? this.first + n2 % this.pageCount : this.first + n2 / this.copies);
                this.pageIncr = 1;
            } else {
                this.currentPage = this.copies == 1 ? this.first - n2 : (this.collate ? this.first - n2 % this.pageCount : this.first - n2 / this.copies);
                this.pageIncr = -1;
            }
            if (n2 < this.numPages) {
                boolean bl;
                JCAWTPrinter.this.printPage(JCAWTPrinter.this.document, this.currentPage);
                boolean bl2 = bl = JCAWTPrinter.this.updatePageFormat && n2 + 1 < this.numPages;
                if (bl && n4 == 1 && this.lastPageIndex != n2) {
                    bl = false;
                }
                if (bl) {
                    JCPage jCPage = (JCPage)JCAWTPrinter.this.document.getPages().get(this.currentPage + this.pageIncr);
                    JCAWTPrinter.this.updatePageFormat(jCPage);
                }
            } else {
                n3 = 1;
                JCAWTPrinter.this.actuallyPrinting = false;
                JCAWTPrinter.this.closeDocument(null, true);
            }
            this.lastPageIndex = n2;
            return n3;
        }

        public synchronized void wakeUp() {
            if (!JCAWTPrinter.this.abort) {
                this.copies = JCAWTPrinter.this.getNumCopies();
                if (this.copies <= 0) {
                    this.copies = 1;
                }
                this.collate = JCAWTPrinter.this.getCollate();
                this.reverse = JCAWTPrinter.this.getReverseOrder();
                this.first = JCAWTPrinter.this.firstToPrint;
                this.last = JCAWTPrinter.this.lastToPrint;
                this.pageCount = JCAWTPrinter.this.document.getPages().size();
                if (!this.reverse) {
                    if (this.first < 0) {
                        this.first = 0;
                    }
                    if (this.last == -1 || this.last >= this.pageCount) {
                        this.last = this.pageCount - 1;
                    }
                    if (this.first > this.last) {
                        this.first = this.last;
                    }
                    this.pageCount = this.last - this.first + 1;
                    this.numPages = this.pageCount * this.copies;
                } else {
                    if (this.last < 0) {
                        this.last = 0;
                    }
                    if (this.first == -1 || this.first >= this.pageCount) {
                        this.first = this.pageCount - 1;
                    }
                    if (this.last > this.first) {
                        this.last = this.first;
                    }
                    this.pageCount = this.first - this.last + 1;
                    this.numPages = this.pageCount * this.copies;
                }
                this.currentPage = -1;
            }
            this.notifyAll();
        }
    }

    protected class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream inputStream, String string) {
            this.is = inputStream;
            this.type = string;
        }

        public void run() {
            try {
                String string;
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(this.type + ">" + string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

