/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.postscript;

import com.klg.jclass.page.FontFileLookup;
import com.klg.jclass.page.FontLibrary;
import com.klg.jclass.page.FontParser;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.page.adobe.postscript.PairKern;
import com.klg.jclass.page.ttf.FontFileReader;
import com.klg.jclass.page.ttf.TTFFile;
import com.klg.jclass.page.ttf.TTFMtxEntry;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;

public class TTFParser
implements FontParser {
    public FontFileReader fontFileReader = null;
    public TTFFile ttfFile = null;

    public TTFParser() {
    }

    public TTFParser(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.parse(fileInputStream);
        fileInputStream.close();
    }

    public Vector parse(InputStream inputStream) throws IOException {
        return this.parse(inputStream, null);
    }

    public Vector parse(InputStream inputStream, String string) throws IOException {
        return this.parse(inputStream, string, -1, false);
    }

    public Vector parse(FontFileLookup fontFileLookup, String string, boolean bl) throws IOException {
        FontFileReader fontFileReader;
        InputStream inputStream = fontFileLookup.openInputStream();
        int n2 = (int)fontFileLookup.getFileLength();
        this.ttfFile = new TTFFile();
        this.ttfFile.setFontFileName(fontFileLookup.toString());
        this.fontFileReader = fontFileReader = new FontFileReader(inputStream, n2);
        this.ttfFile.readFont(fontFileReader, string);
        if (!FontLibrary.getSuppressErrorMessages() && this.ttfFile.getStatus() != 1) {
            System.err.println(this.ttfFile.getStatusMessage());
        }
        if (this.ttfFile.getStatus() == 3) {
            return new Vector();
        }
        return this.populateFont(this.ttfFile);
    }

    public Vector parse(InputStream inputStream, String string, int n2, boolean bl) throws IOException {
        FontFileReader fontFileReader;
        if (inputStream == null) {
            throw new NullPointerException("parse(): Input stream is null");
        }
        this.ttfFile = new TTFFile();
        this.fontFileReader = fontFileReader = new FontFileReader(inputStream, n2);
        this.ttfFile.readFont(fontFileReader, string);
        if (!FontLibrary.getSuppressErrorMessages() && this.ttfFile.getStatus() != 1) {
            System.err.println(this.ttfFile.getStatusMessage());
        }
        if (this.ttfFile.getStatus() == 3) {
            return new Vector();
        }
        return this.populateFont(this.ttfFile);
    }

    protected Vector populateFont(TTFFile tTFFile) {
        FontPS fontPS = new FontPS("uninitialized", 0, 1);
        fontPS.ttfParser = this;
        fontPS.usingTTF = true;
        fontPS.setFontName(tTFFile.getFontName());
        fontPS.setFullName(tTFFile.getFullName());
        fontPS.setFamilyName(tTFFile.getFamilyName());
        fontPS.setNotice(tTFFile.getNotice());
        fontPS.setItalicAngle((float)tTFFile.getItalicAngleValue());
        fontPS.setFixedPitch(tTFFile.isFixedPitch());
        fontPS.setSerif(tTFFile.isSerif());
        fontPS.setUnderlinePosition(tTFFile.getUnderlinePosition());
        fontPS.setUnderlineThickness(tTFFile.getUnderlineThickness());
        fontPS.setVersion(Double.toString(tTFFile.getVersion()));
        fontPS.setEncodingScheme("Unicode");
        fontPS.setWeight("");
        fontPS.setStdHW(0);
        fontPS.setStdVW(0);
        int[] nArray = tTFFile.getFontBBox();
        fontPS.getFontBBox().llx = nArray[0];
        fontPS.getFontBBox().lly = nArray[1];
        fontPS.getFontBBox().urx = nArray[2];
        fontPS.getFontBBox().ury = nArray[3];
        fontPS.setCapHeight(tTFFile.getCapHeight());
        fontPS.setXHeight(tTFFile.getXHeight());
        fontPS.setDescender(tTFFile.getLowerCaseDescent());
        fontPS.setAscender(tTFFile.getLowerCaseAscent());
        int n2 = (int)((double)(fontPS.getAscender() - fontPS.getDescender()) * 1.15);
        fontPS.setFullHeight(n2);
        Vector<FontPS> vector = new Vector<FontPS>(1);
        vector.addElement(fontPS);
        return vector;
    }

    public List parseFontNames(FontFileLookup fontFileLookup) throws IOException {
        InputStream inputStream = fontFileLookup.openInputStream();
        int n2 = (int)fontFileLookup.getFileLength();
        TTFFile tTFFile = new TTFFile();
        tTFFile.setFontFileName(fontFileLookup.toString());
        FontFileReader fontFileReader = new FontFileReader(inputStream, n2);
        List list = tTFFile.readFontNames(fontFileReader);
        if (!FontLibrary.getSuppressErrorMessages() && tTFFile.getStatus() != 1) {
            System.err.println(tTFFile.getStatusMessage());
        }
        inputStream.close();
        return list;
    }

    public List parseFontNames(InputStream inputStream, int n2) throws IOException {
        TTFFile tTFFile = new TTFFile();
        FontFileReader fontFileReader = new FontFileReader(inputStream, n2);
        List list = tTFFile.readFontNames(fontFileReader);
        if (!FontLibrary.getSuppressErrorMessages() && tTFFile.getStatus() != 1) {
            System.err.println(tTFFile.getStatusMessage());
        }
        return list;
    }

    public List parseAllFontNames(FontFileLookup fontFileLookup) throws IOException {
        InputStream inputStream = fontFileLookup.openInputStream();
        int n2 = (int)fontFileLookup.getFileLength();
        TTFFile tTFFile = new TTFFile();
        tTFFile.setFontFileName(fontFileLookup.toString());
        FontFileReader fontFileReader = new FontFileReader(inputStream, n2);
        List list = tTFFile.readAllFontNames(fontFileReader);
        if (!FontLibrary.getSuppressErrorMessages() && tTFFile.getStatus() != 1) {
            System.err.println(tTFFile.getStatusMessage());
        }
        inputStream.close();
        return list;
    }

    public List parseAllFontNames(InputStream inputStream, int n2) throws IOException {
        TTFFile tTFFile = new TTFFile();
        FontFileReader fontFileReader = new FontFileReader(inputStream, n2);
        List list = tTFFile.readAllFontNames(fontFileReader);
        if (!FontLibrary.getSuppressErrorMessages() && tTFFile.getStatus() != 1) {
            System.err.println(tTFFile.getStatusMessage());
        }
        return list;
    }

    public CharMetricPS createCharMetric(int n2) {
        TTFMtxEntry tTFMtxEntry = this.ttfFile.getGlyphMetricsByUnicode(n2);
        if (tTFMtxEntry == null) {
            return null;
        }
        return this.createCharMetric(n2, tTFMtxEntry);
    }

    public CharMetricPS createCharMetricFromGlyph(int n2) {
        TTFMtxEntry tTFMtxEntry = this.ttfFile.getGlyphMetricsByGlyphCode(n2);
        if (tTFMtxEntry == null) {
            return null;
        }
        return this.createCharMetric(n2, tTFMtxEntry);
    }

    public CharMetricPS createCharMetric(int n2, TTFMtxEntry tTFMtxEntry) {
        Hashtable hashtable;
        CharMetricPS charMetricPS = new CharMetricPS();
        charMetricPS.setCode(n2);
        charMetricPS.setWx(this.ttfFile.get_ttf_funit(tTFMtxEntry.getWx()));
        charMetricPS.setWy(0);
        int[] nArray = tTFMtxEntry.getBBox();
        charMetricPS.getCharBBox().llx = this.ttfFile.get_ttf_funit(nArray[0]);
        charMetricPS.getCharBBox().lly = this.ttfFile.get_ttf_funit(nArray[1]);
        charMetricPS.getCharBBox().urx = this.ttfFile.get_ttf_funit(nArray[2]);
        charMetricPS.getCharBBox().ury = this.ttfFile.get_ttf_funit(nArray[3]);
        charMetricPS.setName(tTFMtxEntry.getName());
        Hashtable hashtable2 = this.ttfFile.getKerning();
        int n3 = this.ttfFile.unicodeToGlyphCode(n2);
        if (n3 != -1 && (hashtable = (Hashtable)hashtable2.get(new Integer(n3))) != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n4 = (Integer)enumeration.nextElement();
                Integer n5 = (Integer)hashtable.get(n4);
                List list = this.ttfFile.glyphCodeToUnicodes(n4);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    PairKern pairKern = new PairKern();
                    pairKern.code1 = n2;
                    Integer n6 = (Integer)list.get(i2);
                    pairKern.code2 = n6;
                    pairKern.xAmount = n5;
                    pairKern.yAmount = 0;
                    charMetricPS.getUnicodeKernPairs().put(n6, pairKern);
                }
            }
        }
        return charMetricPS;
    }

    public void writeFont(OutputStream outputStream) {
        if (this.fontFileReader != null) {
            try {
                byte[] byArray = this.fontFileReader.getBytes(0, this.fontFileReader.getFileSize());
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void writeReducedFont(OutputStream outputStream, SortedSet sortedSet, SortedSet sortedSet2) {
        if (this.fontFileReader != null && this.ttfFile != null) {
            try {
                this.ttfFile.writeReducedFont(outputStream, this.fontFileReader, sortedSet, sortedSet2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public CharMetricPS createEmptyCharMetric(int n2) {
        CharMetricPS charMetricPS = new CharMetricPS();
        charMetricPS.setCode(n2);
        charMetricPS.setWx(0);
        charMetricPS.setWy(0);
        charMetricPS.getCharBBox().llx = 0;
        charMetricPS.getCharBBox().lly = 0;
        charMetricPS.getCharBBox().urx = 0;
        charMetricPS.getCharBBox().ury = 0;
        return charMetricPS;
    }

    public int unicodeToGlyphCode(int n2) {
        return this.ttfFile.unicodeToGlyphCode(n2);
    }

    public List glyphCodeToUnicodes(int n2) {
        return this.ttfFile.glyphCodeToUnicodes(n2);
    }

    public int getGlyphWidthByUnicode(int n2) {
        if (this.ttfFile != null) {
            return this.ttfFile.getGlyphWidthByUnicode(n2);
        }
        return 0;
    }

    public int getGlyphWidthByGlyphCode(int n2) {
        if (this.ttfFile != null) {
            return this.ttfFile.getGlyphWidthByGlyphCode(n2);
        }
        return 0;
    }
}

