/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.postscript;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.FontMetricsPS;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.page.adobe.postscript.JCPostScriptPrinter;
import com.klg.jclass.page.adobe.postscript.PairKern;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.label.JCLabel;
import com.klg.jclass.util.swing.JCSwingUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class Graphics2DPS
extends Graphics2DBase {
    boolean fontWritten = false;
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected int readAheadAmount = 1000;
    protected JCPostScriptPrinter printer = null;

    public Graphics2DPS(OutputStream outputStream) {
        super(outputStream);
    }

    public Graphics2DPS(OutputStream outputStream, JCPostScriptPrinter jCPostScriptPrinter) {
        super(outputStream);
        this.printer = jCPostScriptPrinter;
    }

    public void drawString(String string, float f2, float f3) {
        Object object;
        Cloneable cloneable;
        Object object2;
        Object object3;
        if (string == null || string.equals("")) {
            return;
        }
        Component component = this.getComponent();
        if (component instanceof JComponent) {
            object3 = (JComponent)component;
            if (Graphics2DPS.getStoreFontMetricInfo() == 2) {
                object2 = this.getFontMetrics(this.currentFont);
                if (object3 instanceof AbstractButton || object3 instanceof JLabel && (!(object3 instanceof JCLabel) || !JCLabel.isUsingAlternativeLabelUI())) {
                    cloneable = GraphicsUtil.getDrawingArea((JComponent)object3, null);
                    Rectangle rectangle = new Rectangle();
                    object = new Rectangle();
                    String string2 = JCSwingUtilities.layoutCompoundLabel((JComponent)object3, (FontMetrics)object2, (Rectangle)cloneable, rectangle, (Rectangle)object);
                    f2 = ((Rectangle)object).x;
                    f3 = ((Rectangle)object).y + ((FontMetrics)object2).getAscent();
                    string = string2;
                }
            }
        }
        this.updateContext();
        f3 = -f3;
        object2 = null;
        this.outputCurrentColor();
        cloneable = (FontPS)this.getFont();
        if (!this.fontWritten) {
            this.outputFont((Font)((Object)cloneable));
        }
        this.initializeOutString(f2, f3);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            object3 = ((FontPS)cloneable).getCharMetric(string.charAt(i2));
            if (object2 != null && (object = ((CharMetricPS)object2).getKernByName(((CharMetricPS)object3).getName())) != null && ((PairKern)object).xAmount != 0) {
                this.printOutString();
                this.out.x += FontMetricsPS.asPoints(((PairKern)object).xAmount, ((Font)((Object)cloneable)).getSize());
            }
            double d2 = FontMetricsPS.asPoints(((CharMetricPS)object3).getWx(), ((Font)((Object)cloneable)).getSize());
            this.appendToOutString(string.charAt(i2), d2);
            object2 = object3;
        }
        this.printOutString();
        if (this.underline) {
            double d3 = FontMetricsPS.asPoints(((FontPS)cloneable).getUnderlineThickness(), ((Font)((Object)cloneable)).getSize());
            this.setStroke(new BasicStroke((float)d3));
            f3 = (float)((double)(-f3) - FontMetricsPS.asPoints(((FontPS)cloneable).getUnderlinePosition(), ((Font)((Object)cloneable)).getSize()));
            this.drawLinePW(f2, f3, this.out.x, f3);
        }
    }

    public void translate(int n2, int n3) {
        this.translate((double)n2, (double)n3);
    }

    public void translate(double d2, double d3) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.translate(d2, d3);
        double d4 = rectangle2D.getX() - d2;
        double d5 = rectangle2D.getY() - d3;
        double d6 = rectangle2D.getWidth();
        double d7 = rectangle2D.getHeight();
        rectangle2D.setRect(d4, d5, d6, d7);
        this.clipSet = true;
        if (this.isContextCurrent()) {
            d3 = -d3;
            this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " translate");
        }
    }

    public void scale(double d2, double d3) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.scale(d2, d3);
        double d4 = rectangle2D.getX() / d2;
        double d5 = rectangle2D.getY() / d3;
        double d6 = rectangle2D.getWidth() / d2;
        double d7 = rectangle2D.getHeight() / d3;
        rectangle2D.setRect(d4, d5, d6, d7);
        this.clipSet = true;
        if (this.isContextCurrent()) {
            this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " scale");
        }
    }

    public void rotate(double d2) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.rotate(d2);
        if (d2 == 1.5707963267948966 || d2 == 4.71238898038469) {
            double d3 = rectangle2D.getY();
            double d4 = rectangle2D.getX();
            double d5 = rectangle2D.getHeight();
            double d6 = rectangle2D.getWidth();
            rectangle2D.setRect(d3, d4, d5, d6);
            this.clipSet = true;
        }
        d2 = Math.PI * 2 - d2;
        d2 = Math.toDegrees(d2);
        if (this.isContextCurrent()) {
            this.output(this.truncateDecimalDigits(d2) + " " + " rotate");
        }
    }

    public void rotate(double d2, double d3, double d4) {
        this.translate(d3, d4);
        this.rotate(d2);
        this.translate(-d3, -d4);
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.clipRect((double)n2, (double)n3, (double)n4, (double)n5);
    }

    public void clipRect(double d2, double d3, double d4, double d5) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        if (this.clipSet) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Rectangle2D.intersect(rectangle2D, new Rectangle2D.Double(d2, d3, d4, d5), double_);
            rectangle2D = double_;
        } else {
            rectangle2D.setRect(d2, d3, d4, d5);
            this.clipSet = true;
        }
        if (this.isContextCurrent()) {
            this.output(this.truncateDecimalDigits(rectangle2D.getX()) + " " + this.truncateDecimalDigits(-rectangle2D.getY()) + " " + this.truncateDecimalDigits(rectangle2D.getWidth()) + " " + this.truncateDecimalDigits(-rectangle2D.getHeight()) + " rc");
        }
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        this.updateContext();
        this.outputCurrentColor();
        this.setLineStroke();
        this.output("newpath " + nArray[0] + " " + -nArray2[0] + " moveto");
        for (int i2 = 1; i2 < n2; ++i2) {
            this.output(nArray[i2] + " " + -nArray2[i2] + " lineto");
        }
        this.output("stroke");
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.printPolygon(nArray, nArray2, n2, "stroke");
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.printPolygon(nArray, nArray2, n2, "fill");
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return false;
        }
        Component component = this.getComponent();
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (Graphics2DPS.getStoreFontMetricInfo() == 2) {
                FontMetrics fontMetrics = this.getFontMetrics(this.currentFont);
                if (jComponent instanceof AbstractButton || jComponent instanceof JLabel && (!(jComponent instanceof JCLabel) || !JCLabel.isUsingAlternativeLabelUI())) {
                    Rectangle rectangle = GraphicsUtil.getDrawingArea(jComponent, null);
                    Rectangle rectangle2 = new Rectangle();
                    Rectangle rectangle3 = new Rectangle();
                    JCSwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, rectangle, rectangle2, rectangle3);
                    n2 = rectangle2.x;
                    n3 = rectangle2.y;
                }
            }
        }
        this.updateContext();
        if (image instanceof EPSImage) {
            return this.drawEPSImage((EPSImage)image, n2, n3, n4, n5, color, imageObserver);
        }
        return this.drawJavaImage(image, n2, n3, n4, n5, color, imageObserver);
    }

    public void setFont(Font font) {
        this.updateContext();
        if (!(font instanceof FontPS)) {
            font = FontPS.getNativeFont(font);
        }
        if (this.currentFont != null && this.fontWritten && this.currentFont.equals(font) && this.currentFont.getStyle() == font.getStyle() && this.currentFont.getSize() == font.getSize()) {
            return;
        }
        this.currentFont = font;
        this.outputFont(font);
    }

    protected void outputFont(Font font) {
        String string = font.getName();
        int n2 = font.getSize();
        if (!string.equals("Symbol") && !string.equals("ZapfDingbats")) {
            if (!this.loadedFonts.contains(string)) {
                this.loadedFonts.put(string, string);
                this.output("/" + string + "-ISOLatin1 /" + string + " iso");
            }
            this.output("/" + string + "-ISOLatin1 " + n2 + " sf");
        } else {
            this.output("/" + string + n2 + " sf");
        }
        this.fontWritten = true;
    }

    public FontMetrics getFontMetrics(Font font) {
        if (!(font instanceof FontPS)) {
            font = FontPS.getNativeFont(font);
        }
        return new FontMetricsPS((FontPS)font);
    }

    public void startContext() {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.output("gsave % frame begin");
        double[] dArray = new double[6];
        this.transform.getMatrix(dArray);
        this.output("[" + this.truncateDecimalDigits(dArray[0]) + " " + this.truncateDecimalDigits(dArray[1]) + " " + this.truncateDecimalDigits(dArray[2]) + " " + this.truncateDecimalDigits(dArray[3]) + " " + this.truncateDecimalDigits(dArray[4]) + " " + this.truncateDecimalDigits(-1.0 * dArray[5]) + "] concat");
        this.output(this.truncateDecimalDigits(rectangle2D.getX()) + " " + this.truncateDecimalDigits(-rectangle2D.getY()) + " " + this.truncateDecimalDigits(rectangle2D.getWidth()) + " " + this.truncateDecimalDigits(-rectangle2D.getHeight()) + " rc");
        this.strokeChanged = true;
    }

    public void endContext() {
        this.output("grestore % frame end");
        this.fontWritten = false;
    }

    public void drawArcPW(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        this.updateContext();
        this.setLineStroke();
        this.outputCurrentColor();
        this.output("newpath");
        this.outputEllipticArc(d2, d3, d4 / 2.0, d5 / 2.0, d6, d7);
        this.output("stroke");
    }

    public void fillArcPW(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        this.updateContext();
        this.outputCurrentColor();
        this.output("newpath");
        this.output(this.truncateDecimalDigits(d2 + d4 / 2.0) + " " + this.truncateDecimalDigits(-(d3 + d5 / 2.0)) + " moveto");
        this.outputEllipticArc(d2, d3, d4 / 2.0, d5 / 2.0, d6, d7);
        this.output("closepath fill");
    }

    protected void outputEllipticArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        String string = d7 >= 0.0 ? " arc" : " arcn";
        double d8 = d6 + d7;
        if (d4 == d5) {
            this.output(this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(-(d3 + d5)) + " " + this.truncateDecimalDigits(d4) + " " + this.truncateDecimalDigits(d6) + " " + this.truncateDecimalDigits(d8) + string);
        } else {
            this.output(this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(-(d3 + d5)) + " translate");
            this.output(this.truncateDecimalDigits(d4) + " " + this.truncateDecimalDigits(d5) + " scale");
            this.output("0 0 1 " + this.truncateDecimalDigits(d6) + " " + this.truncateDecimalDigits(d8) + string);
            this.output(this.truncateDecimalDigits(1.0 / d4) + " " + this.truncateDecimalDigits(1.0 / d5) + " scale");
            this.output(this.truncateDecimalDigits(-(d2 + d4)) + " " + this.truncateDecimalDigits(d3 + d5) + " translate");
        }
    }

    public void setClipPW(double d2, double d3, double d4, double d5) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        boolean bl = this.isContextCurrent();
        if (bl) {
            this.endContext();
        }
        if (this.parent != null && ((Graphics2DPS)this.parent).clipSet) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Rectangle2D rectangle2D2 = (Rectangle2D)this.parent.getClip();
            try {
                Object object;
                AffineTransform affineTransform;
                if (((Graphics2DBase)this.parent).isFrameRoot()) {
                    affineTransform = this.transform.createInverse();
                } else {
                    object = (Graphics2D)this.parent;
                    AffineTransform affineTransform2 = (AffineTransform)((Graphics2D)object).getTransform().clone();
                    if (affineTransform2.isIdentity()) {
                        affineTransform = this.transform.createInverse();
                    } else {
                        affineTransform = affineTransform2.createInverse();
                        affineTransform.concatenate(this.transform);
                    }
                }
                object = affineTransform.createTransformedShape(rectangle2D2);
                Rectangle2D.intersect(object.getBounds2D(), new Rectangle2D.Double(d2, d3, d4, d5), double_);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Rectangle2D.intersect(rectangle2D2, new Rectangle2D.Double(d2, d3, d4, d5), double_);
            }
            d2 = ((RectangularShape)double_).getX();
            d3 = ((RectangularShape)double_).getY();
            d4 = ((RectangularShape)double_).getWidth();
            d5 = ((RectangularShape)double_).getHeight();
        }
        rectangle2D.setRect(d2, d3, d4, d5);
        this.clipSet = true;
        if (bl) {
            this.startContext();
        }
    }

    public void fillRectPW(double d2, double d3, double d4, double d5) {
        this.updateContext();
        this.outputCurrentColor();
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(-d3) + " " + this.truncateDecimalDigits(d4) + " " + this.truncateDecimalDigits(-d5) + " rf");
    }

    public void drawRectPW(double d2, double d3, double d4, double d5) {
        this.updateContext();
        this.outputCurrentColor();
        this.setLineStroke();
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(-d3) + " " + this.truncateDecimalDigits(d4) + " " + this.truncateDecimalDigits(-d5) + " rs");
    }

    public void drawLinePW(double d2, double d3, double d4, double d5) {
        this.updateContext();
        this.outputCurrentColor();
        this.setLineStroke();
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(-d3) + " " + this.truncateDecimalDigits(d4) + " " + this.truncateDecimalDigits(-d5) + " dla");
    }

    public void drawRoundRectPW(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.drawRRect(d2, -d3, d4, -d5, d6, d7, "stroke");
    }

    public void fillRoundRectPW(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.drawRRect(d2, -d3, d4, -d5, d6, d7, "fill");
    }

    public void flushLoadedFonts() {
        this.loadedFonts.clear();
    }

    public void epsfOutputFile(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null && !string.equals("%%EOF")) {
                this.output(string);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    public boolean drawEPSImage(EPSImage ePSImage, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        this.output("PFBeginEpsf");
        n3 = -n3;
        n5 = -n5;
        this.output(n2 + " " + (n3 + n5) + " translate");
        Rectangle2D rectangle2D = this.getEPSBBox(ePSImage.getInputSource());
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        this.output(this.truncateDecimalDigits((double)n4 / (d4 - d2)) + " " + this.truncateDecimalDigits((double)(-n5) / (d5 - d3)) + " scale");
        this.output(this.truncateDecimalDigits(-d2) + " " + this.truncateDecimalDigits(-d3) + " translate");
        this.output("%%BeginDocument");
        this.epsfOutputFile(ePSImage.getInputSource());
        this.output("%%EndDocument");
        this.output("PFEndEpsf");
        return true;
    }

    protected void appendToOutString(char c2, double d2) {
        String string = "\\()";
        char c3 = '\\';
        if (c2 < ' ' || c2 > '~') {
            if (c2 <= '\u00ff') {
                this.out.text.append(this.octal3(c2));
            } else if (c2 == '\u20ac') {
                if (this.printer != null && this.printer.getCharacterEncoding() == 1) {
                    this.out.text.append(this.octal3('\u0080'));
                } else {
                    this.out.text.append(this.octal3('\u00a4'));
                }
            } else {
                System.err.println("Warning: expecting single-byte character, found multi-byte character 0x" + Integer.toHexString(c2));
                this.out.text.append(this.octal3(' '));
            }
        } else {
            if (string.indexOf(c2) != -1) {
                this.out.text.append(c3);
            }
            this.out.text.append(c2);
        }
        this.out.width += d2;
    }

    protected String octal3(char c2) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(Integer.toOctalString(c2));
        for (int i2 = n2 = stringBuffer.length(); i2 < 3; ++i2) {
            stringBuffer.insert(0, 0);
        }
        stringBuffer.insert(0, '\\');
        return stringBuffer.toString();
    }

    protected void printOutString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.out.text.toString());
        stringBuffer.append(") ");
        stringBuffer.append(this.truncateDecimalDigits(this.out.x));
        stringBuffer.append(" ");
        stringBuffer.append(this.truncateDecimalDigits(this.out.y));
        stringBuffer.append(" st");
        this.output(stringBuffer.toString());
        this.out.x += this.out.width;
        this.out.width = 0.0;
        this.out.text.delete(0, this.out.text.length());
    }

    protected void outputCurrentColor() {
        if (!this.colorChanged) {
            return;
        }
        Color color = this.getColor();
        String string = this.truncateDecimalDigits((double)color.getRed() / 255.0) + " " + this.truncateDecimalDigits((double)color.getGreen() / 255.0) + " " + this.truncateDecimalDigits((double)color.getBlue() / 255.0) + " setrgbcolor";
        this.output(string);
        this.colorChanged = false;
    }

    protected void printPolygon(int[] nArray, int[] nArray2, int n2, String string) {
        this.updateContext();
        this.outputCurrentColor();
        this.output("newpath " + nArray[0] + " " + -nArray2[0] + " moveto");
        for (int i2 = 1; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            int n4 = -nArray2[i2];
            this.output(n3 + " " + n4 + " lineto");
        }
        if (string.equals("fill") && this.getWindingRule() != 1) {
            string = "eofill";
        }
        this.output("closepath " + string);
    }

    protected void drawRRect(double d2, double d3, double d4, double d5, double d6, double d7, String string) {
        double d8 = 1.0;
        this.updateContext();
        this.outputCurrentColor();
        this.setLineStroke();
        if (d7 != d6) {
            d8 = d7 / d6;
            this.output("1 " + this.truncateDecimalDigits(d8) + " scale");
            d3 /= d8;
            d5 /= d8;
        }
        this.output("newpath");
        this.output(this.truncateDecimalDigits(d2 + d6) + " " + this.truncateDecimalDigits(d3) + " moveto");
        this.output(this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d3 + d5) + " " + this.truncateDecimalDigits(d6) + " arct");
        this.output(this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d3 + d5) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3 + d5) + " " + this.truncateDecimalDigits(d6) + " arct");
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3 + d5) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d6) + " arct");
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d6) + " arct");
        this.output("closepath " + string);
        if (d7 != d6) {
            this.output("1 " + this.truncateDecimalDigits(1.0 / d8) + " scale");
        }
    }

    protected void setLineStroke() {
        if (this.strokeChanged) {
            float f2 = ((BasicStroke)this.currentStroke).getLineWidth();
            this.output(this.truncateDecimalDigits(f2) + " setlinewidth");
            float[] fArray = ((BasicStroke)this.currentStroke).getDashArray();
            float f3 = ((BasicStroke)this.currentStroke).getDashPhase();
            if (fArray != null) {
                this.output("[");
                for (float f4 : fArray) {
                    this.output(" " + this.truncateDecimalDigits(f4) + " ");
                }
                this.output("] ");
                this.output(String.valueOf(f3));
                this.output(" setdash");
                this.dashMode = true;
            } else if (this.dashMode) {
                this.output("[] 0 setdash");
                this.dashMode = false;
            }
        }
        this.strokeChanged = false;
    }

    protected void emitColorImageProlog(int n2) {
        this.output("% Color picture");
        this.output("% define string to hold a scanline's worth of data");
        this.output("/pix " + n2 * 3);
        this.output(" string def");
        this.output("% define space for color conversions");
        this.output("/grays " + n2);
        this.output(" string def  % space for gray scale line");
        this.output("/npixls 0 def");
        this.output("/rgbindx 0 def");
        this.output("% define 'colorimage' if it isn't defined");
        this.output("%   ('colortogray' and 'mergeprocs' come from xwd2ps");
        this.output("%     via xgrab)");
        this.output("/colorimage where   % do we know about 'colorimage'?");
        this.output("{ pop }           % yes: pop off the 'dict' returned");
        this.output("{                 % no:  define one");
        this.output("/colortogray {  % define an RGB->I function");
        this.output("/rgbdata exch store    % call input 'rgbdata'");
        this.output("rgbdata length 3 idiv");
        this.output("/npixls exch store");
        this.output("/rgbindx 0 store");
        this.output("0 1 npixls 1 sub {");
        this.output("grays exch");
        this.output("rgbdata rgbindx       get 20 mul    % Red");
        this.output("rgbdata rgbindx 1 add get 32 mul    % Green");
        this.output("rgbdata rgbindx 2 add get 12 mul    % Blue");
        this.output("add add 64 idiv      % I = .5G + .31R + .18B");
        this.output("put");
        this.output("/rgbindx rgbindx 3 add store");
        this.output("} for");
        this.output("grays 0 npixls getinterval");
        this.output("} bind def");
        this.output("");
        this.output("% Utility procedure for colorimage operator.");
        this.output("% This procedure takes two procedures off the");
        this.output("% stack and merges them into a single procedure.");
        this.output("");
        this.output("/mergeprocs { % def");
        this.output("dup length");
        this.output("3 -1 roll");
        this.output("dup");
        this.output("length");
        this.output("dup");
        this.output("5 1 roll");
        this.output("3 -1 roll");
        this.output("add");
        this.output("array cvx");
        this.output("dup");
        this.output("3 -1 roll");
        this.output("0 exch");
        this.output("putinterval");
        this.output("dup");
        this.output("4 2 roll");
        this.output("putinterval");
        this.output("} bind def");
        this.output("");
        this.output("/colorimage { % def");
        this.output("pop pop     % remove 'false 3' operands");
        this.output("{colortogray} mergeprocs");
        this.output("image");
        this.output("} bind def");
        this.output("} ifelse          % end of 'false' case");
    }

    protected boolean drawJavaImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.output("%doImage");
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        int n8 = (int)rectangle2D.getWidth();
        int n9 = (int)rectangle2D.getHeight();
        if (n4 == n6 && n5 == n7 && (n8 < n4 || n9 < n5)) {
            n6 = Math.min(n8, n6);
            n7 = Math.min(n9, n7);
            n4 = n6;
            n5 = n7;
        }
        int[] nArray = new int[n6 * n7];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n6, n7, nArray, 0, n6);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        this.output("gsave");
        this.output("% build a temporary dictionary");
        this.output("20 dict begin");
        this.emitColorImageProlog(pixelGrabber.getWidth());
        this.output("% lower left corner");
        n3 = -n3;
        this.output(n2 + " " + n3 + " translate");
        if (n4 == 0 || n5 == 0) {
            n5 = pixelGrabber.getHeight();
            n4 = pixelGrabber.getWidth();
        }
        this.output("% size of image");
        this.output(n4 + " " + n5 + " scale");
        this.output(pixelGrabber.getWidth() + " " + pixelGrabber.getHeight());
        this.output(" 8");
        this.output("[" + pixelGrabber.getWidth() + " 0 0 -" + pixelGrabber.getHeight() + " 0 " + "0" + "]");
        this.output("{currentfile pix readhexstring pop}");
        this.output("false 3 colorimage");
        this.output("");
        int n10 = 0;
        int n11 = 72;
        char[] cArray = new char[n11 + 1];
        int n12 = pixelGrabber.getHeight();
        int n13 = pixelGrabber.getWidth();
        for (int i2 = 0; i2 < n12; ++i2) {
            int n14 = 0;
            ++n10;
            for (int i3 = 0; i3 < n13; ++i3) {
                int n15 = nArray[i2 * n13 + i3];
                cArray[n14++] = hd[(n15 & 0xF00000) >> 20];
                cArray[n14++] = hd[(n15 & 0xF0000) >> 16];
                cArray[n14++] = hd[(n15 & 0xF000) >> 12];
                cArray[n14++] = hd[(n15 & 0xF00) >> 8];
                cArray[n14++] = hd[(n15 & 0xF0) >> 4];
                cArray[n14++] = hd[n15 & 0xF];
                if (n14 < n11) continue;
                String string = String.copyValueOf(cArray, 0, n14);
                this.output(string);
                if (n10 > 5) {
                    try {
                        Thread.sleep(15L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n10 = 0;
                }
                n14 = 0;
            }
            if (n14 == 0) continue;
            String string = String.copyValueOf(cArray, 0, n14);
            this.output(string);
        }
        this.output("");
        this.output("end");
        this.output("grestore");
        return true;
    }

    protected Rectangle2D getEPSBBox(BufferedReader bufferedReader) {
        String string = "%%BoundingBox:";
        try {
            String string2;
            bufferedReader.mark(this.readAheadAmount);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf(string) <= -1 || string2.indexOf("(atend)") != -1) continue;
                int n2 = string2.indexOf(string) + string.length();
                StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n2 + 1, string2.length()));
                double d2 = Double.valueOf(stringTokenizer.nextToken());
                double d3 = Double.valueOf(stringTokenizer.nextToken());
                double d4 = Double.valueOf(stringTokenizer.nextToken());
                double d5 = Double.valueOf(stringTokenizer.nextToken());
                bufferedReader.reset();
                return new Rectangle2D.Double(d2, d3, d4, d5);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            iOException.printStackTrace();
        }
        throw new RuntimeException("Bounding box not set for EPS image");
    }

    public Graphics create() {
        Graphics graphics = super.create();
        ((Graphics2DPS)graphics).fontWritten = false;
        return graphics;
    }
}

