/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.pdf;

import com.klg.jclass.page.FontLibrary;
import com.klg.jclass.page.FontParser;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.page.PrintException;
import com.klg.jclass.page.TrueTypeFontProperties;
import com.klg.jclass.page.adobe.pdf.AcroFontEntry;
import com.klg.jclass.page.adobe.pdf.Ascii85OutputStream;
import com.klg.jclass.page.adobe.pdf.Graphics2DPDF;
import com.klg.jclass.page.adobe.pdf.ShadedPattern;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.util.SeqRangeCollector;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.zip.DeflaterOutputStream;
import javax.swing.tree.DefaultMutableTreeNode;

public class JCPDFPrinter
extends JCPrinter {
    protected int objectNumber;
    protected int rootPagesReference;
    protected int totalPageCount = 0;
    protected int pagesReference;
    protected int currentPageObjectNumber = -1;
    protected int encodingObj;
    protected int graphicsDictionaryObj;
    protected Hashtable<AlphaTransparency, Integer> alphaValues = new Hashtable();
    protected Vector pageList = new Vector();
    protected Vector pagesList = new Vector();
    protected Vector contentsList = new Vector();
    protected Vector annotationList = new Vector();
    protected Hashtable fontList = new Hashtable();
    protected Rectangle2D bounds = new Rectangle2D.Double();
    protected Rectangle2D oldPageSize = null;
    protected Rectangle2D currentPageSize = null;
    protected boolean docOpen = false;
    protected WeakHashMap imageCache = new WeakHashMap();
    protected Vector docImageList = new Vector();
    protected boolean useAutoStrokeAdjustment = true;
    protected int drawJavaComponentObjectNumber = -1;
    protected int drawJavaComponentLengthObjectNumber = -1;
    protected int drawJavaComponentResourcesObjectNumber = -1;
    protected boolean drawingJavaComponent = false;
    protected Vector annotationRectangles = new Vector();
    protected Vector hyperlinkInfoList = new Vector();
    protected Hashtable hyperlinkObjects = new Hashtable();
    protected TreeMap annoInternalLocations = new TreeMap();
    protected Hashtable annoInternalPages = new Hashtable();
    protected StreamInfo streamInfo = new StreamInfo();
    protected Stack streamStack = new Stack();
    protected Vector pageXObjectReferences = new Vector();
    protected Vector pageXObjectStreams = new Vector();
    protected int patternIndex = 0;
    protected final double tolerance = 0.01;

    public JCPDFPrinter(OutputStream outputStream) {
        this.os = outputStream;
        this.streamInfo.os = outputStream;
        FontLibrary.initFontLibrary();
        FontPS.getAllFonts();
    }

    public JCPDFPrinter(OutputStream outputStream, FontParser fontParser, String string, String string2, String string3) {
        this.os = outputStream;
        FontLibrary.initFontLibrary();
        FontPS.getAllFonts(fontParser, string, string2, string3);
    }

    public void setOutputStream(OutputStream outputStream) {
        super.setOutputStream(outputStream);
        this.streamInfo.os = outputStream;
    }

    public void setAutoStrokeAdjustment(boolean bl) {
        this.useAutoStrokeAdjustment = bl;
    }

    public boolean getAutoStrokeAdjustment() {
        return this.useAutoStrokeAdjustment;
    }

    public boolean isDocOpen() {
        return this.docOpen;
    }

    public void setup() {
    }

    public boolean isImageScalable() {
        return true;
    }

    public void openDocument(Rectangle2D rectangle2D) {
        super.openDocument(rectangle2D);
        this.totalPageCount = 0;
        this.streamInfo.openDocument();
        this.pageList.clear();
        this.pagesList.clear();
        this.contentsList.clear();
        this.annoInternalLocations.clear();
        this.annoInternalPages.clear();
        this.annotationRectangles.clear();
        this.hyperlinkInfoList.clear();
        this.hyperlinkObjects.clear();
        this.annotationList.clear();
        this.imageCache.clear();
        this.docImageList.clear();
        this.alphaValues.clear();
        this.output("%PDF-1.4");
        byte[] byArray = new byte[]{37, -30, -29, -49, -45, 10};
        this.output(byArray);
        this.objectNumber = 0;
        ++this.objectNumber;
        this.rootPagesReference = this.objectNumber++;
        this.pagesReference = this.objectNumber;
        this.writeFontEncoding();
        this.encodingObj = this.objectNumber;
        this.writeDocGraphicsDictionary();
        this.graphicsDictionaryObj = this.objectNumber;
        this.docOpen = true;
    }

    public void closeDocument(Rectangle2D rectangle2D) {
        Comparable<Integer> comparable;
        Object object;
        Object object22;
        this.writePagesTree(rectangle2D);
        Graphics2DPDF graphics2DPDF = (Graphics2DPDF)this.getGraphics();
        boolean bl = !this.annoInternalLocations.isEmpty();
        int n2 = -1;
        int n3 = -1;
        if (bl) {
            Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
            for (Object object22 : this.annoInternalLocations.keySet()) {
                object = (Point2D.Double)this.annoInternalLocations.get(object22);
                comparable = (Integer)this.annoInternalPages.get(object22);
                this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
                hashtable.put(object22, new Integer(this.objectNumber));
                this.output(this.objectNumber + " 0 obj");
                this.output("[ " + comparable + " 0 R /XYZ " + graphics2DPDF.truncateDecimalDigits(((Point2D.Double)object).getX()) + " " + graphics2DPDF.truncateDecimalDigits(((Point2D.Double)object).getY()) + " 0 ]");
                this.output("endobj");
            }
            n2 = ++this.objectNumber;
            this.storeObjectReference(n2, this.getCurrentOffset());
            this.output(n2 + " 0 obj\n<<");
            this.output("/Names [");
            for (Object object22 : this.annoInternalLocations.keySet()) {
                object = (Integer)hashtable.get(object22);
                this.output("(" + (String)object22 + ") " + (Integer)object + " 0 R");
            }
            this.output("]");
            this.output(">> \nendobj");
            n3 = ++this.objectNumber;
            this.storeObjectReference(n3, this.getCurrentOffset());
            this.output(n3 + " 0 obj\n<<");
            this.output("/Dests " + n2 + " 0 R");
            this.output(">> \nendobj");
        }
        this.annoInternalLocations.clear();
        this.annoInternalPages.clear();
        boolean bl2 = false;
        int n4 = -1;
        if (this.bookmarkTree != null) {
            bl2 = true;
            n4 = ++this.objectNumber;
            this.outputBookmarkTree((DefaultMutableTreeNode)this.bookmarkTree.getRoot(), n4);
        }
        object22 = this.fontList.elements();
        while (object22.hasMoreElements()) {
            object = (AcroFontEntry)object22.nextElement();
            this.writeFontDescription((AcroFontEntry)object);
        }
        this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
        int n5 = this.objectNumber;
        this.output(this.objectNumber + " 0 obj\n<<");
        this.output("/Type /Catalog");
        this.output("/Pages " + this.rootPagesReference + " 0 R");
        if (bl) {
            this.output("/Names " + n3 + " 0 R");
        }
        if (bl2) {
            this.output("/Outlines " + n4 + " 0 R");
            if (this.isBookmarkTreeVisible()) {
                this.output("/PageMode /UseOutlines");
            }
        }
        this.output(">> \nendobj");
        this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
        int n6 = this.objectNumber;
        this.output(this.objectNumber + " 0 obj\n<<");
        this.output("/Creator (Dell Software's PageLayout 6.5.2)");
        this.output("/CreationDate (" + this.createDateString(new GregorianCalendar()) + ") ");
        this.output(">> \nendobj");
        long l2 = this.streamInfo.fileOffset;
        this.output("xref");
        this.output("0 " + (this.objectNumber + 1) + "\n0000000000 65535 f ");
        Collections.sort(this.streamInfo.referenceList);
        for (int i2 = 0; i2 < this.objectNumber; ++i2) {
            comparable = (AcroReference)this.streamInfo.referenceList.elementAt(i2);
            this.output(this.pad10(((AcroReference)comparable).offset) + " 00000 n ");
        }
        this.output("trailer\n<<\n/Size " + (this.objectNumber + 1));
        this.output("/Root " + n5 + " 0 R");
        this.output("/Info " + n6 + " 0 R");
        this.output(">>");
        this.output("startxref\n" + l2 + "\n%%EOF");
        super.closeDocument(rectangle2D);
        this.graphics.dispose();
        this.graphics = null;
        this.fontList.clear();
        this.docOpen = false;
    }

    protected String padIntToLength(int n2, int n3) {
        int n4;
        if (n3 <= 0) {
            return "";
        }
        String string = "";
        String string2 = Integer.toString(n2);
        for (int i2 = n4 = string2.length(); i2 < n3; ++i2) {
            string = string + "0";
        }
        return string + string2;
    }

    protected String createDateString(Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        StringBuffer stringBuffer = new StringBuffer("D:");
        stringBuffer.append(calendar.get(1));
        stringBuffer.append(this.padIntToLength(calendar.get(2) + 1, 2));
        stringBuffer.append(this.padIntToLength(calendar.get(5), 2));
        stringBuffer.append(this.padIntToLength(calendar.get(11), 2));
        stringBuffer.append(this.padIntToLength(calendar.get(12), 2));
        stringBuffer.append(this.padIntToLength(calendar.get(13), 2));
        int n2 = calendar.getTimeZone().getOffset(calendar.getTimeInMillis());
        if (n2 == 0) {
            stringBuffer.append("Z");
        } else {
            int n3 = Math.abs(n2 / 60000) % 60;
            int n4 = n2 / 3600000;
            stringBuffer.append(n2 < 0 ? "-" : "+");
            stringBuffer.append(this.padIntToLength(Math.abs(n4), 2) + "'");
            stringBuffer.append(this.padIntToLength(Math.abs(n3), 2) + "'");
        }
        return stringBuffer.toString();
    }

    protected void outputBookmarkTree(DefaultMutableTreeNode defaultMutableTreeNode, int n2) {
    }

    public void beginPage(Rectangle2D rectangle2D, int n2) {
        super.beginPage(rectangle2D, n2);
        if (this.pageChanged(rectangle2D)) {
            this.writePagesObject(this.pagesReference, this.pageList, this.rootPagesReference, this.oldPageSize);
            this.pageList.clear();
            this.pagesList.add(new Integer(this.pagesReference));
            this.pagesReference = ++this.objectNumber;
            this.oldPageSize = (Rectangle2D)rectangle2D.clone();
        }
        this.streamInfo.beginPage();
        this.contentsList.clear();
        this.annotationList.clear();
        this.pageXObjectReferences.clear();
        this.pageXObjectStreams.clear();
        this.alphaValues.clear();
        this.currentPageObjectNumber = ++this.objectNumber;
        this.currentPageSize = rectangle2D;
        this.beginPageStream();
        this.output("q");
        this.output("/GSDOC gs");
        StringBuffer stringBuffer = new StringBuffer("1 0 0 1 ");
        stringBuffer.append(rectangle2D.getX());
        stringBuffer.append(" ");
        stringBuffer.append(rectangle2D.getHeight() + rectangle2D.getY());
        stringBuffer.append(" cm");
        this.output(stringBuffer.toString());
        StringBuffer stringBuffer2 = new StringBuffer("0 0 ");
        stringBuffer2.append(rectangle2D.getWidth());
        stringBuffer2.append(" ");
        stringBuffer2.append(-rectangle2D.getHeight());
        stringBuffer2.append(" re W n");
        this.output(stringBuffer2.toString());
        this.bounds.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + rectangle2D.getX(), rectangle2D.getHeight() + rectangle2D.getY());
    }

    public void endPage(Rectangle2D rectangle2D) {
        int n2;
        int n3;
        int n4 = 0;
        this.output("Q");
        this.endStream();
        Iterator iterator = this.streamInfo.patternList.iterator();
        while (iterator.hasNext()) {
            this.writePatternDescription((PatternInfo)iterator.next());
        }
        this.annotationRectangles.clear();
        this.hyperlinkInfoList.clear();
        this.createNecessaryFontObjects(this.streamInfo.fontList);
        this.writeAlphaValueDictionaries();
        this.storeObjectReference(this.currentPageObjectNumber, this.getCurrentOffset());
        this.pageList.add(new Integer(this.currentPageObjectNumber));
        this.output(this.currentPageObjectNumber + " 0 obj\n<<\n/Type /Page");
        String string = "/CropBox [ " + this.bounds.getX() + " " + this.bounds.getY() + " " + this.bounds.getWidth() + " " + this.bounds.getHeight() + " ] ";
        this.output(string);
        this.output("/Parent " + this.pagesReference + " 0 R");
        this.output("/Resources <<");
        this.writeResourcesDictionary();
        this.output(">>");
        n4 = this.contentsList.size();
        if (n4 > 0) {
            this.output("/Contents [");
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = (Integer)this.contentsList.elementAt(n3);
                this.output(n2 + " 0 R");
            }
            this.output("]");
        }
        if ((n4 = this.annotationList.size()) > 0) {
            this.output("/Annots [");
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = (Integer)this.annotationList.elementAt(n3);
                this.output(n2 + " 0 R");
            }
            this.output("]");
        }
        this.output(">>\nendobj");
        for (n3 = 0; n3 < this.pageXObjectStreams.size(); ++n3) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.pageXObjectStreams.elementAt(n3);
            Vector vector = (Vector)this.pageXObjectReferences.elementAt(n3);
            long l2 = this.streamInfo.fileOffset;
            int n5 = byteArrayOutputStream.size();
            try {
                byteArrayOutputStream.writeTo(this.os);
                this.streamInfo.fileOffset += (long)n5;
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    AcroReference acroReference = (AcroReference)vector.elementAt(i2);
                    acroReference.offset += l2;
                    this.streamInfo.referenceList.addElement(acroReference);
                }
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        super.endPage(rectangle2D);
    }

    protected void writeResourcesDictionary() {
        int n2;
        int n3;
        int n4 = this.streamInfo.xObjectList.size();
        if (n4 > 0) {
            this.output("/XObject <<");
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = (Integer)this.streamInfo.xObjectList.elementAt(n3);
                int n5 = (Integer)this.streamInfo.imageList.elementAt(n3);
                String string = "/Im" + n5 + " " + n2 + " " + "0 R";
                this.output(string);
            }
            this.output(">>");
        }
        if ((n4 = this.streamInfo.colorSpaceList.size()) > 0) {
            this.output("/ColorSpace <<");
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = (Integer)this.streamInfo.colorSpaceList.elementAt(n3);
                String string = "/CS" + n3 + " " + n2 + " " + " 0 R";
                this.output(string);
            }
            this.output(">>");
        }
        this.writeResourcesFontList(this.streamInfo.fontList);
        this.writeResourcesPatternList();
        this.output("/ExtGState <<");
        this.output("/GSDOC " + this.graphicsDictionaryObj + " 0 R");
        Enumeration<AlphaTransparency> enumeration = this.alphaValues.keys();
        while (enumeration.hasMoreElements()) {
            AlphaTransparency alphaTransparency = enumeration.nextElement();
            int n6 = this.alphaValues.get(alphaTransparency);
            this.output("/GS" + n6 + " " + n6 + " 0 R");
        }
        this.output(">>");
        StringBuffer stringBuffer = new StringBuffer("/ProcSet [ /PDF ");
        if (this.streamInfo.textPresent) {
            stringBuffer.append(" /Text ");
        }
        if (this.streamInfo.imagePresent) {
            stringBuffer.append(" /ImageC ");
        }
        if (this.streamInfo.maskPresent) {
            stringBuffer.append(" /ImageB ");
        }
        if (this.streamInfo.indexImage) {
            stringBuffer.append(" /ImageI ");
        }
        stringBuffer.append("]");
        this.output(stringBuffer.toString());
    }

    protected void createNecessaryFontObjects(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            AcroFontEntry acroFontEntry = (AcroFontEntry)this.fontList.get(string);
            if (acroFontEntry.usingAnsi && acroFontEntry.number == -1) {
                acroFontEntry.number = ++this.objectNumber;
            }
            if (!acroFontEntry.usingUnicode || acroFontEntry.unicodeNumber != -1) continue;
            acroFontEntry.unicodeNumber = ++this.objectNumber;
        }
    }

    protected void writeResourcesFontList(Hashtable hashtable) {
        if (hashtable.size() > 0) {
            this.output("/Font <<");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                AcroFontEntry acroFontEntry = (AcroFontEntry)this.fontList.get(string2);
                String string3 = "";
                if (!string.endsWith("-Unicode") && acroFontEntry.usingAnsi) {
                    string3 = "/" + acroFontEntry.abbrev + " " + acroFontEntry.number + " " + "0 R";
                    this.output(string3);
                }
                if (!string.endsWith("-Unicode") || !acroFontEntry.usingUnicode) continue;
                string3 = "/" + acroFontEntry.abbrev + "U " + acroFontEntry.unicodeNumber + " " + "0 R";
                this.output(string3);
            }
            this.output(">>");
        }
    }

    protected void writeResourcesPatternList() {
        if (this.streamInfo.patternList.size() > 0) {
            this.output("/Pattern <<");
            for (PatternInfo patternInfo : this.streamInfo.patternList) {
                this.output(patternInfo.patternName + " " + patternInfo.patternObjectNumber + " 0 R");
            }
            this.output(">>");
        }
    }

    public Graphics getGraphics() {
        if (this.graphics == null) {
            this.graphics = new Graphics2DPDF(this.os, this);
            ((Graphics2DBase)this.graphics).setFrameRoot();
        }
        return this.graphics;
    }

    public boolean supportsHyperlinks() {
        return false;
    }

    private int getXObjectNumber(int n2) {
        int n3 = this.streamInfo.imageList.indexOf(new Integer(n2));
        if (n3 < 0 || n3 >= this.streamInfo.xObjectList.size()) {
            return -1;
        }
        return (Integer)this.streamInfo.xObjectList.elementAt(n3);
    }

    protected void writePatternDescription(PatternInfo patternInfo) {
        if (patternInfo.img != null) {
            this.writeImagePatternDescription(patternInfo);
        } else if (patternInfo.shadedPattern != null) {
            this.writeShadingPatternDescription(patternInfo);
        }
    }

    protected void writeImagePatternDescription(PatternInfo patternInfo) {
        int n2;
        BufferedImage bufferedImage = patternInfo.img;
        Integer n3 = (Integer)this.imageCache.get(bufferedImage);
        if (n3 != null && (n2 = n3.intValue()) >= 0) {
            String string = "/Im" + n2;
            int n4 = this.getXObjectNumber(n2);
            if (n4 >= 0) {
                int n5 = bufferedImage.getWidth();
                int n6 = bufferedImage.getHeight();
                double d2 = n5;
                double d3 = n6;
                String string2 = "/Type /Pattern\n/PatternType 1\n/Name " + patternInfo.patternName + "\n" + "/PaintType 1\n" + "/TilingType 1\n" + "/Matrix [ " + d2 + " 0 0 " + d3 + " 0 0 ]\n" + "/BBox [ 0 0 " + n5 + " " + n6 + " ]\n" + "/Resources <<\n" + "/ProcSet [ /PDF /Text /ImageC ]\n" + "/XObject << " + string + " " + n4 + " 0 R >>\n" + ">>\n" + "/XStep 1\n" + "/YStep 1";
                String string3 = "q " + string + " Do Q";
                patternInfo.patternObjectNumber = ++this.objectNumber;
                if (this.compressed) {
                    this.writeCompressedStreamObject(patternInfo.patternObjectNumber, string3.getBytes(), string2);
                } else {
                    this.writeUncompressedStreamObject(patternInfo.patternObjectNumber, string3, string2);
                }
            }
        }
    }

    protected void writeShadingPatternDescription(PatternInfo patternInfo) {
        Color color;
        GradientPaint gradientPaint = patternInfo.shadedPattern.gradientPaint;
        int n2 = patternInfo.patternObjectNumber;
        AffineTransform affineTransform = patternInfo.shadedPattern.pdfTransform;
        AffineTransform affineTransform2 = patternInfo.shadedPattern.translateTransform;
        Color color2 = gradientPaint.getColor1();
        if (color2 == null) {
            color2 = Color.white;
        }
        if ((color = gradientPaint.getColor2()) == null) {
            color2 = Color.white;
        }
        Point2D.Double double_ = new Point2D.Double();
        Point2D point2D = gradientPaint.getPoint1();
        affineTransform.transform(point2D, double_);
        Point2D.Double double_2 = new Point2D.Double();
        Point2D point2D2 = gradientPaint.getPoint2();
        affineTransform.transform(point2D2, double_2);
        affineTransform2.transform(double_, double_);
        affineTransform2.transform(double_2, double_2);
        double d2 = (double)color2.getRed() / 255.0;
        double d3 = (double)color2.getGreen() / 255.0;
        double d4 = (double)color2.getBlue() / 255.0;
        double d5 = (double)color.getRed() / 255.0;
        double d6 = (double)color.getGreen() / 255.0;
        double d7 = (double)color.getBlue() / 255.0;
        double d8 = this.bounds.getHeight() - ((Point2D)double_).getY();
        double d9 = this.bounds.getHeight() - ((Point2D)double_2).getY();
        if (gradientPaint.isCyclic()) {
            double d10 = ((Point2D)double_2).getX() - ((Point2D)double_).getX();
            double d11 = d9 - d8;
            double d12 = 2.0 * Math.sqrt(d10 * d10 + d11 * d11);
            int n3 = ++this.objectNumber;
            String string = "/FunctionType 4\n/Domain [-10000.0 10000.0 -10000.0 10000.0]\n/Range [0.0 1.0 0.0 1.0 0.0 1.0]";
            String string2 = "";
            if (d12 != 0.0) {
                String string3 = "dup " + d12 + " div truncate " + d12 + " mul sub " + d12 + " div\n" + "360.0 mul cos 1.0 add 2.0 div\n" + "dup dup 1.0 exch sub " + d5 + " mul exch " + d2 + " mul add\n" + "exch dup dup 1.0 exch sub " + d6 + " mul exch " + d3 + " mul add\n" + "exch dup 1.0 exch sub " + d7 + " mul exch " + d4 + " mul add\n";
                if (this.isHorizontalAxis(double_, double_2)) {
                    string2 = "{\npop " + ((Point2D)double_).getX() + " exch sub\n" + string3 + "}";
                } else if (this.isVerticalAxis(double_, double_2)) {
                    string2 = "{\nexch pop " + d8 + " exch sub\n" + string3 + "}";
                } else {
                    long l2 = (long)(500000.0 / d12);
                    l2 /= 2L;
                    double d13 = (double)(-(l2 *= 2L)) * d10 + ((Point2D)double_).getX();
                    double d14 = (double)(-l2) * d11 + d8;
                    string2 = "{\n" + d14 + " exch sub dup mul\n" + "exch " + d13 + " exch sub dup mul\n" + "add sqrt\n" + string3 + "}";
                }
            } else {
                string2 = "{\npop pop " + d2 + " " + d3 + " " + d4 + "\n}";
            }
            if (this.compressed) {
                this.writeCompressedStreamObject(n3, string2.getBytes(), string);
            } else {
                this.writeUncompressedStreamObject(n3, string2, string);
            }
            this.storeObjectReference(n2, this.getCurrentOffset());
            this.output(n2 + " 0 obj\n<<");
            this.output("/PatternType 2");
            this.output("/Shading <<");
            this.output("/ShadingType 1");
            this.output("/ColorSpace /DeviceRGB");
            this.output("/Function " + n3 + " 0 R");
            this.output(">>\n>>\nendobj");
        } else {
            int n4 = ++this.objectNumber;
            this.storeObjectReference(n4, this.getCurrentOffset());
            this.output(n4 + " 0 obj\n<<");
            this.output("/FunctionType 2");
            this.output("/Domain [0.0 1.0]");
            this.output("/C0 [" + d2 + " " + d3 + " " + d4 + "]");
            if (!point2D.equals(point2D2)) {
                this.output("/C1 [" + d5 + " " + d6 + " " + d7 + "]");
            } else {
                this.output("/C1 [" + d2 + " " + d3 + " " + d4 + "]");
                ((Point2D)double_2).setLocation(((Point2D)double_2).getX(), ((Point2D)double_2).getY() + 1.0);
            }
            this.output("/N 1");
            this.output(">>\nendobj");
            this.storeObjectReference(n2, this.getCurrentOffset());
            this.output(n2 + " 0 obj\n<<");
            this.output("/PatternType 2");
            this.output("/Shading <<");
            this.output("/ShadingType 2");
            this.output("/ColorSpace /DeviceRGB");
            this.output("/Coords [" + ((Point2D)double_).getX() + " " + (this.bounds.getHeight() - ((Point2D)double_).getY()) + " " + ((Point2D)double_2).getX() + " " + (this.bounds.getHeight() - ((Point2D)double_2).getY()) + "]");
            this.output("/Extend [true true]");
            this.output("/Function " + n4 + " 0 R");
            this.output(">>\n>>\nendobj");
        }
    }

    protected boolean isHorizontalAxis(Point2D point2D, Point2D point2D2) {
        return Math.abs(point2D.getY() - point2D2.getY()) < 0.01;
    }

    protected boolean isVerticalAxis(Point2D point2D, Point2D point2D2) {
        return Math.abs(point2D.getX() - point2D2.getX()) < 0.01;
    }

    protected void writeFontDescription(AcroFontEntry acroFontEntry) {
        int n2;
        int n3;
        int n4;
        Serializable serializable;
        int n5 = 256;
        int n6 = -1;
        int[] nArray = new int[256];
        int n7 = -1;
        int n8 = -1;
        CharMetricPS charMetricPS = null;
        if (acroFontEntry.usingAnsi && acroFontEntry.number == -1) {
            acroFontEntry.number = ++this.objectNumber;
        }
        if (acroFontEntry.usingUnicode && acroFontEntry.unicodeNumber == -1) {
            acroFontEntry.unicodeNumber = ++this.objectNumber;
        }
        String string = "";
        if (acroFontEntry.embeddingRules != 0) {
            serializable = new Random();
            string = "";
            for (int i2 = 0; i2 < 6; ++i2) {
                string = string + (char)(((Random)serializable).nextInt(26) + 65);
            }
            string = string + '+';
        }
        if (acroFontEntry.usingTTF) {
            serializable = new StringBuffer();
            char[] cArray = acroFontEntry.name.toCharArray();
            for (n4 = 0; n4 < cArray.length; ++n4) {
                if (cArray[n4] == ' ') continue;
                ((StringBuffer)serializable).append(cArray[n4]);
            }
            string = string + ((StringBuffer)serializable).toString();
        } else {
            string = string + acroFontEntry.name.replace(' ', '_');
        }
        serializable = acroFontEntry.font;
        if (acroFontEntry.usingAnsi) {
            this.storeObjectReference(acroFontEntry.number, this.getCurrentOffset());
            this.output(acroFontEntry.number + " 0 obj\n<<");
            if (acroFontEntry.usingTTF) {
                this.output("/Type /Font\n/Subtype /TrueType");
            } else {
                this.output("/Type /Font\n/Subtype /Type1");
            }
            String string2 = "/Name /" + acroFontEntry.abbrev + "\n/BaseFont /" + string;
            this.output(string2);
            if (!acroFontEntry.usingTTF) {
                this.output("/Encoding " + this.encodingObj + " 0 R");
            } else {
                this.output("/Encoding /WinAnsiEncoding");
            }
            if (!acroFontEntry.usingTTF && this.isBaseFont(acroFontEntry.name)) {
                this.output(">>\nendobj");
                return;
            }
            n7 = ++this.objectNumber;
            this.output("/FontDescriptor " + n7 + " 0 R");
            charMetricPS = ((FontPS)serializable).getCharMetric(' ');
            n4 = charMetricPS.getWx();
            for (n3 = 0; n3 < 256; ++n3) {
                nArray[n3] = n4;
            }
            if (((FontPS)serializable).isFixedPitch()) {
                n6 = n5 = ((Integer)acroFontEntry.ansiCharactersUsed.first()).intValue();
                charMetricPS = ((FontPS)serializable).getCharByCode(n5);
                nArray[n5] = charMetricPS.getWx();
            } else {
                n5 = (Integer)acroFontEntry.ansiCharactersUsed.first();
                n6 = (Integer)acroFontEntry.ansiCharactersUsed.last();
                if (n6 > 255) {
                    n6 = 255;
                }
                Iterator iterator = acroFontEntry.ansiCharactersUsed.iterator();
                while (iterator.hasNext()) {
                    int n9 = (Integer)iterator.next();
                    if (n9 < 0 || n9 > 255) continue;
                    charMetricPS = n9 == 128 && acroFontEntry.usingTTF ? ((FontPS)serializable).getCharByCode(8364) : ((FontPS)serializable).getCharByCode(n9);
                    nArray[n9] = charMetricPS.getWx();
                }
            }
            this.output("/FirstChar " + n5);
            this.output("/LastChar " + n6);
            this.output("/Widths " + (this.objectNumber + 1) + " 0 R");
            this.output(">>\nendobj");
            this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
            this.output(this.objectNumber + " 0 obj");
            this.output("[");
            n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = n5; n2 <= n6; ++n2) {
                stringBuffer.append(nArray[n2]);
                if (++n3 % 16 == 0) {
                    this.output(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                stringBuffer.append(" ");
            }
            this.output(stringBuffer.toString());
            this.output("]");
            this.output("endobj");
        }
        if (acroFontEntry.usingTTF && acroFontEntry.usingUnicode) {
            this.storeObjectReference(acroFontEntry.unicodeNumber, this.getCurrentOffset());
            this.output(acroFontEntry.unicodeNumber + " 0 obj\n<<");
            this.output("/Type /Font\n/Subtype /Type0");
            this.output("/Name /" + acroFontEntry.abbrev + "U");
            this.output("/BaseFont /" + string);
            this.output("/Encoding /Identity-H");
            ++this.objectNumber;
            int n10 = this.objectNumber++;
            this.output("/DescendantFonts [ " + n10 + " 0 R ]");
            n4 = -1;
            if (acroFontEntry.includeUnicodeMap) {
                n4 = this.objectNumber;
                this.output("/ToUnicode " + n4 + " 0 R");
            }
            this.output(">>\nendobj");
            this.storeObjectReference(n10, this.getCurrentOffset());
            this.output(n10 + " 0 obj\n<<");
            this.output("/Type /Font\n/Subtype /CIDFontType2");
            this.output("/BaseFont /" + string);
            ++this.objectNumber;
            n3 = this.objectNumber++;
            n8 = this.objectNumber;
            this.output("/CIDSystemInfo " + n3 + " 0 R");
            this.output("/FontDescriptor " + n8 + " 0 R");
            if (((FontPS)serializable).isFixedPitch()) {
                int n11 = (Integer)acroFontEntry.unicodeCharactersUsed.first();
                this.output("/DW " + ((FontPS)serializable).ttfParser.getGlyphWidthByGlyphCode(n11));
            } else {
                Object object;
                Integer n12;
                Object object2;
                int n13 = -1;
                if (acroFontEntry.unicodeWidths.size() <= acroFontEntry.unicodeCharactersUsed.size() / 2) {
                    n2 = -1;
                    object2 = acroFontEntry.unicodeWidths.keys();
                    while (object2.hasMoreElements()) {
                        n12 = (Integer)object2.nextElement();
                        object = (Integer)acroFontEntry.unicodeWidths.get(n12);
                        if ((Integer)object <= n2) continue;
                        n13 = n12;
                        n2 = (Integer)object;
                    }
                }
                if (n13 >= 0) {
                    this.output("/DW " + n13);
                }
                this.output("/W [");
                Iterator iterator = acroFontEntry.unicodeCharactersUsed.iterator();
                object2 = null;
                n12 = null;
                object = null;
                Integer n14 = null;
                int n15 = -1;
                int n16 = -1;
                boolean bl = false;
                while (iterator.hasNext() || object2 != null) {
                    if (iterator.hasNext()) {
                        n12 = (Integer)iterator.next();
                        n15 = ((FontPS)serializable).ttfParser.getGlyphWidthByGlyphCode(n12);
                        if (n13 >= 0 && n15 == n13) {
                            if (object2 == null) {
                                n15 = -1;
                                continue;
                            }
                            n12 = null;
                            bl = true;
                        } else if (object2 == null) {
                            object2 = n12;
                            object = n12;
                            n14 = n12;
                            n16 = n15;
                        } else if (n12 == (Integer)object + 1) {
                            if (n15 == n16) {
                                object = n12;
                            } else if ((Integer)object - n14 >= 2) {
                                bl = true;
                            } else {
                                object = n12;
                                n14 = n12;
                                n16 = n15;
                            }
                        } else {
                            bl = true;
                        }
                    } else {
                        n12 = null;
                        bl = true;
                    }
                    if (!bl) continue;
                    if ((Integer)object - n14 >= 2) {
                        if ((Integer)object2 < n14) {
                            this.writeCharRangeDiffWidth((FontPS)serializable, (Integer)object2, n14 - 1);
                        }
                        this.writeCharRangeSameWidth((FontPS)serializable, n14, (Integer)object);
                    } else {
                        this.writeCharRangeDiffWidth((FontPS)serializable, (Integer)object2, (Integer)object);
                    }
                    bl = false;
                    object2 = n12;
                    n14 = n12;
                    n16 = n15;
                    object = object2;
                }
                this.output("]");
            }
            this.output(">>\nendobj");
            this.storeObjectReference(n3, this.getCurrentOffset());
            this.output(n3 + " 0 obj\n<<");
            this.output("/Type /CIDSystemInfo");
            this.output("/Registry (Adobe)");
            this.output("/Ordering (Identity)");
            this.output("/Supplement 0");
            this.output(">>\nendobj");
            if (acroFontEntry.includeUnicodeMap) {
                this.writeToUnicodeCMap(n4, acroFontEntry, (FontPS)serializable);
            }
        }
        if (n7 >= 0) {
            this.writeFontDescriptor(n7, acroFontEntry, (FontPS)serializable, string);
        }
        if (n8 >= 0) {
            this.writeFontDescriptor(n8, acroFontEntry, (FontPS)serializable, string);
        }
        if (acroFontEntry.embeddingRules != 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (acroFontEntry.embeddingRules == 2) {
                ((FontPS)serializable).ttfParser.writeFont(byteArrayOutputStream);
            } else if (acroFontEntry.embeddingRules == 1) {
                ((FontPS)serializable).ttfParser.writeReducedFont(byteArrayOutputStream, acroFontEntry.usingAnsi ? acroFontEntry.ansiCharactersUsed : null, acroFontEntry.usingUnicode ? acroFontEntry.unicodeCharactersUsed : null);
            }
            n4 = ++this.objectNumber;
            this.writeCompressedStreamObject(n4, byteArrayOutputStream, "/Length1 " + byteArrayOutputStream.size());
        }
    }

    protected void writeFontDescriptor(int n2, AcroFontEntry acroFontEntry, FontPS fontPS, String string) {
        CharMetricPS charMetricPS = null;
        int n3 = 0;
        this.storeObjectReference(n2, this.getCurrentOffset());
        this.output(n2 + " 0 obj\n<<");
        this.output("/Type /FontDescriptor");
        this.output("/Ascent " + fontPS.getAscender());
        this.output("/CapHeight " + fontPS.getCapHeight());
        this.output("/Descent " + fontPS.getDescender());
        if (acroFontEntry.usingAnsi && fontPS.isFixedPitch()) {
            int n4 = (Integer)acroFontEntry.ansiCharactersUsed.first();
            charMetricPS = fontPS.getCharByCode(n4);
            this.output("/MissingWidth " + charMetricPS.getWx());
        }
        if (fontPS.isFixedPitch()) {
            n3 |= 1;
        }
        if (fontPS.isSerif()) {
            n3 |= 2;
        }
        n3 = fontPS.getName().equals("Symbol") || fontPS.getName().equals("ZapfDingbats") || !fontPS.getEncodingScheme().equals("AdobeStandardEncoding") && !fontPS.getEncodingScheme().equals("Unicode") ? (n3 |= 4) : (n3 |= 0x20);
        if (Math.abs(fontPS.getItalicAngle()) > 4.0f) {
            n3 |= 0x40;
        }
        this.output("/Flags " + (n3 |= 0x40000));
        String string2 = "/FontBBox [ " + fontPS.getFontBBox().llx + " " + fontPS.getFontBBox().lly + " " + fontPS.getFontBBox().urx + " " + fontPS.getFontBBox().ury + " ]";
        this.output(string2);
        this.output("/FontName /" + string);
        this.output("/ItalicAngle " + (int)fontPS.getItalicAngle());
        double d2 = fontPS.getStdVW();
        if (d2 <= 0.0) {
            charMetricPS = fontPS.getCharMetric('!');
            d2 = charMetricPS.getCharBBox().urx - charMetricPS.getCharBBox().llx;
            if (fontPS.getItalicAngle() != 0.0f) {
                d2 -= (double)(charMetricPS.getCharBBox().ury - charMetricPS.getCharBBox().lly) * Math.tan(fontPS.getItalicAngle());
            }
            d2 -= 4.0;
        }
        this.output("/StemV " + (int)d2);
        if (acroFontEntry.embeddingRules != 0) {
            this.output("/FontFile2 " + (this.objectNumber + 1) + " 0 R");
        }
        this.output(">>\nendobj");
    }

    protected void writeToUnicodeCMap(int n2, AcroFontEntry acroFontEntry, FontPS fontPS) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/CIDInit /ProcSet findresource begin\n");
        stringBuffer.append("12 dict begin\n");
        stringBuffer.append("begincmap\n");
        stringBuffer.append("/CIDSystemInfo\n");
        stringBuffer.append("<< /Registry (Adobe)\n");
        stringBuffer.append("/Ordering (UCS)\n");
        stringBuffer.append("/Supplement 0\n");
        stringBuffer.append(">> def\n");
        stringBuffer.append("/CMapName /Adobe-Identity-UCS def\n");
        stringBuffer.append("/CMapType 2 def\n");
        stringBuffer.append("1 begincodespacerange\n");
        stringBuffer.append("<0001> <FFFF>\n");
        stringBuffer.append("endcodespacerange\n");
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        SeqRangeCollector seqRangeCollector = new SeqRangeCollector();
        seqRangeCollector.setRangeBreak(1);
        Iterator iterator = acroFontEntry.unicodeCharactersUsed.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            seqRangeCollector.addItem(n4);
        }
        seqRangeCollector.done();
        List<SeqRangeCollector.Range> list = seqRangeCollector.getRanges();
        for (n3 = 0; n3 < list.size(); ++n3) {
            List<SeqRangeCollector.Range> list2;
            SeqRangeCollector.Range range = list.get(n3);
            if (range.end - range.start > 1) {
                int n5;
                SeqRangeCollector seqRangeCollector2 = new SeqRangeCollector();
                for (int i2 = range.start; i2 <= range.end; ++i2) {
                    List list3 = fontPS.ttfParser.glyphCodeToUnicodes(i2);
                    if (list3 == null || list3.size() == 0) continue;
                    n5 = (Integer)list3.get(0);
                    seqRangeCollector2.addItem(n5);
                }
                seqRangeCollector2.done();
                list2 = seqRangeCollector2.getRanges();
                int n6 = 0;
                for (n5 = 0; n5 < list2.size(); ++n5) {
                    SeqRangeCollector.Range range2 = list2.get(n5);
                    if (range2.end - range2.start > 1) {
                        vector.add("<" + this.formatHexString(range.start + n6, 4) + "> <" + this.formatHexString(range.start + n6 + range2.size - 1, 4) + "> <" + this.formatHexString(range2.start, 4) + ">\n");
                        n6 += range2.size;
                        continue;
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append("<");
                    stringBuffer2.append(this.formatHexString(range.start + n6, 4));
                    stringBuffer2.append("> ");
                    StringBuffer stringBuffer3 = new StringBuffer();
                    int n7 = 0;
                    SeqRangeCollector.Range range3 = range2;
                    while (n5 < list2.size() && range3.end - range3.start <= 1) {
                        for (int i3 = range3.start; i3 <= range3.end; ++i3) {
                            stringBuffer3.append("<");
                            stringBuffer3.append(this.formatHexString(i3, 4));
                            stringBuffer3.append(">");
                            stringBuffer3.append(" ");
                            ++n7;
                        }
                        if (++n5 >= list2.size()) continue;
                        range3 = list2.get(n5);
                    }
                    --n5;
                    stringBuffer2.append("<");
                    stringBuffer2.append(this.formatHexString(range.start + n6 + n7 - 1, 4));
                    n6 += n7;
                    stringBuffer2.append("> ");
                    stringBuffer2.append("[ ");
                    while (stringBuffer3.length() > 49) {
                        stringBuffer2.append(stringBuffer3.substring(0, 49));
                        stringBuffer2.append("\n");
                        stringBuffer2.append("                ");
                        stringBuffer3 = new StringBuffer(stringBuffer3.substring(49));
                    }
                    stringBuffer2.append(stringBuffer3.toString());
                    stringBuffer2.append("]\n");
                    vector.add(stringBuffer2.toString());
                }
                continue;
            }
            for (int i4 = range.start; i4 <= range.end; ++i4) {
                list2 = fontPS.ttfParser.glyphCodeToUnicodes(i4);
                if (list2 == null || list2.size() == 0) continue;
                vector2.add("<" + this.formatHexString(i4, 4) + "> <" + this.formatHexString((Integer)((Object)list2.get(0)), 4) + ">\n");
            }
        }
        n3 = 0;
        while (n3 * 100 < vector.size()) {
            int n8 = Math.min(vector.size() - n3 * 100, 100);
            stringBuffer.append("" + n8 + " beginbfrange\n");
            for (int i5 = 0; i5 < n8; ++i5) {
                stringBuffer.append((String)vector.get(n3 * 100 + i5));
            }
            stringBuffer.append("endbfrange\n");
            ++n3;
        }
        n3 = 0;
        while (n3 * 100 < vector2.size()) {
            int n9 = Math.min(vector2.size() - n3 * 100, 100);
            stringBuffer.append("" + n9 + " beginbfchar\n");
            for (int i6 = 0; i6 < n9; ++i6) {
                stringBuffer.append((String)vector2.get(n3 * 100 + i6));
            }
            stringBuffer.append("endbfchar\n");
            ++n3;
        }
        stringBuffer.append("endcmap\n");
        stringBuffer.append("CMapName currentdict /CMap defineresource pop\n");
        stringBuffer.append("end\n");
        stringBuffer.append("end");
        if (this.compressed) {
            byte[] byArray = null;
            try {
                byArray = stringBuffer.toString().getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = stringBuffer.toString().getBytes();
            }
            this.writeCompressedStreamObject(n2, byArray, null);
        } else {
            this.writeUncompressedStreamObject(n2, stringBuffer.toString(), null);
        }
    }

    public String formatHexString(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(n2));
        while (stringBuffer.length() < n3) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    protected void writeCompressedStreamObject(int n2, ByteArrayOutputStream byteArrayOutputStream, String string) {
        this.writeCompressedStreamObject(n2, byteArrayOutputStream.toByteArray(), string);
    }

    protected void writeCompressedStreamObject(int n2, byte[] byArray, String string) {
        int n3 = ++this.objectNumber;
        this.writeCompressedStreamHeader(n2, n3, string);
        int n4 = this.writeCompressedStreamBody(byArray);
        this.writeCompressedStreamFooter(n3, n4);
    }

    protected void writeCompressedStreamHeader(int n2, int n3, String string) {
        this.storeObjectReference(n2, this.getCurrentOffset());
        this.output(n2 + " 0 obj\n<<");
        this.output("/Filter [ /ASCII85Decode /FlateDecode ]");
        this.output("/Length " + n3 + " 0 R");
        if (string != null) {
            this.output(string);
        }
        this.output(">>");
        this.output("stream");
    }

    protected int writeCompressedStreamBody(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(new Ascii85OutputStream(byteArrayOutputStream));
        try {
            deflaterOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            deflaterOutputStream.finish();
            deflaterOutputStream.flush();
            deflaterOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        long l2 = this.getCurrentOffset();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n2 = byArray2.length;
        int n3 = 0;
        while (n3 + 72 < n2) {
            this.output(byArray2, n3, 72);
            n3 += 72;
            this.output((byte)10);
        }
        this.output(byArray2, n3, n2 - n3);
        this.output((byte)10);
        return (int)(this.getCurrentOffset() - l2 - 1L);
    }

    protected void writeCompressedStreamFooter(int n2, int n3) {
        this.output("endstream\nendobj");
        this.storeObjectReference(n2, this.getCurrentOffset());
        this.output(n2 + " 0 obj\n" + n3 + " \nendobj");
    }

    protected void writeUncompressedStreamObject(int n2, String string, String string2) {
        int n3 = ++this.objectNumber;
        this.writeUncompressedStreamHeader(n2, n3, string2);
        long l2 = this.getCurrentOffset();
        this.output(string);
        int n4 = (int)(this.getCurrentOffset() - l2 - 1L);
        this.writeUncompressedStreamFooter(n3, n4);
    }

    protected void writeUncompressedStreamHeader(int n2, int n3, String string) {
        this.storeObjectReference(n2, this.getCurrentOffset());
        this.output(n2 + " 0 obj\n<<");
        this.output("/Length " + n3 + " 0 R");
        if (string != null) {
            this.output(string);
        }
        this.output(">>");
        this.output("stream");
    }

    protected void writeUncompressedStreamFooter(int n2, int n3) {
        this.output("endstream\nendobj");
        this.storeObjectReference(n2, this.getCurrentOffset());
        this.output(n2 + " 0 obj\n" + n3 + " \nendobj");
    }

    protected void writeCharRangeSameWidth(FontPS fontPS, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    " + n2);
        stringBuffer.append(" " + n3);
        int n4 = fontPS.ttfParser.getGlyphWidthByGlyphCode(n2);
        stringBuffer.append(" " + n4);
        this.output(stringBuffer.toString());
    }

    protected void writeCharRangeDiffWidth(FontPS fontPS, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    " + n2 + " [");
        int n4 = stringBuffer.toString().indexOf(91);
        int n5 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            stringBuffer.append(" " + fontPS.ttfParser.getGlyphWidthByGlyphCode(i2));
            if (++n5 % 12 != 0 || i2 == n3) continue;
            this.output(stringBuffer.toString());
            stringBuffer.delete(0, stringBuffer.length());
            for (int i3 = 0; i3 <= n4; ++i3) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(" ]");
        this.output(stringBuffer.toString());
    }

    protected void writeFontEncoding() {
        this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
        this.output(this.objectNumber + " 0 obj\n<<");
        this.output("/Type /Encoding \n/BaseEncoding /WinAnsiEncoding");
        this.output("/Differences [");
        this.output("39 /quoteright 45 /minus 96 /quoteleft");
        this.output("127 /.notdef");
        this.output("129 /.notdef /.notdef /.notdef /.notdef");
        this.output("   /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef");
        this.output("   /.notdef /.notdef /.notdef /.notdef /.notdef");
        this.output("144 /dotlessi /grave /acute /circumflex /tilde /macron /breve");
        this.output("   /dotaccent /dieresis");
        this.output("153 /.notdef");
        this.output("154 /ring /cedilla");
        this.output("156 /.notdef");
        this.output("157 /hungarumlaut /ogonek /caron ]");
        this.output(">>\nendobj");
    }

    protected void writeAlphaValueDictionaries() {
        Set<AlphaTransparency> set = this.alphaValues.keySet();
        for (AlphaTransparency alphaTransparency : set) {
            int n2 = this.alphaValues.get(alphaTransparency);
            this.writeGraphicsStateDictionary(n2, alphaTransparency);
        }
    }

    protected void writeDocGraphicsDictionary() {
        this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
        this.output(this.objectNumber + " 0 obj\n<<");
        this.output("/Type /ExtGState");
        if (this.useAutoStrokeAdjustment) {
            this.output("/SA true");
        } else {
            this.output("/SA false");
        }
        this.output(">>\nendobj");
    }

    protected void writeGraphicsStateDictionary(int n2, AlphaTransparency alphaTransparency) {
        this.storeObjectReference(n2, this.getCurrentOffset());
        this.output(n2 + " 0 obj\n<<");
        this.output("/Type /ExtGState");
        this.output("/AIS false");
        String string = alphaTransparency.fill ? "/ca " : "/CA ";
        this.output(string + alphaTransparency.alpha);
        this.output(">>\nendobj");
    }

    protected void writePagesTree(Rectangle2D rectangle2D) {
        this.writePagesObject(this.pagesReference, this.pageList, this.rootPagesReference, rectangle2D);
        this.pagesList.add(new Integer(this.pagesReference));
        this.writePagesObject(this.rootPagesReference, this.pagesList, 0, null);
    }

    protected void writePagesObject(int n2, Vector vector, int n3, Rectangle2D rectangle2D) {
        this.storeObjectReference(n2, this.getCurrentOffset());
        this.output(n2 + " 0 obj");
        this.output("<<\n/Type /Pages\n/Kids [");
        int n4 = vector.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = (Integer)vector.elementAt(i2);
            this.output(n5 + " 0 R");
        }
        if (n3 != 0) {
            this.output("]\n/Count " + n4);
            this.totalPageCount += n4;
        } else {
            this.output("]\n/Count " + this.totalPageCount);
        }
        if (n3 != 0) {
            this.output("/Parent " + n3 + " 0 R");
        }
        if (rectangle2D != null) {
            String string = "/MediaBox [ " + rectangle2D.getX() + " " + rectangle2D.getY() + " " + (rectangle2D.getWidth() + rectangle2D.getX()) + " " + (rectangle2D.getHeight() + rectangle2D.getY()) + " ]";
            this.output(string);
        }
        this.output(">>\nendobj");
    }

    protected boolean pageChanged(Rectangle2D rectangle2D) {
        if (this.oldPageSize == null) {
            this.oldPageSize = (Rectangle2D)rectangle2D.clone();
            return false;
        }
        return !this.oldPageSize.equals(rectangle2D);
    }

    public boolean isBaseFont(String string) {
        String string2;
        String string3 = null;
        if (string.indexOf(45) != -1) {
            string3 = string.substring(string.indexOf(45) + 1, string.length());
            string2 = string.substring(0, string.indexOf(45));
        } else {
            string2 = string;
        }
        return string2.equals("Courier") || string2.equals("Helvetica") ? string3 == null || string3.equals("Bold") || string3.equals("Oblique") || string3.equals("BoldOblique") : (string2.equals("Times") ? string3.equals("Roman") || string3.equals("Bold") || string3.equals("Italic") || string3.equals("BoldItalic") : string2.equals("Symbol") || string2.equals("ZapfDingbats"));
    }

    protected void switchToNewStream() {
        this.streamStack.push(this.streamInfo);
        this.os = new ByteArrayOutputStream();
        this.streamInfo = new StreamInfo();
        this.streamInfo.os = this.os;
    }

    protected void switchBackToOldStream() {
        this.pageXObjectReferences.addElement(this.streamInfo.referenceList);
        this.pageXObjectStreams.addElement(this.os);
        this.streamInfo = (StreamInfo)this.streamStack.pop();
        this.os = this.streamInfo.os;
    }

    protected void storeObjectReference(int n2, long l2) {
        AcroReference acroReference = new AcroReference();
        acroReference.number = n2;
        acroReference.offset = l2;
        this.streamInfo.referenceList.add(acroReference);
    }

    protected long getCurrentOffset() {
        return this.streamInfo.fileOffset;
    }

    protected long getStreamStart() {
        return this.streamInfo.contentsStart;
    }

    protected void setStreamStart() {
        this.streamInfo.contentsStart = this.streamInfo.fileOffset;
    }

    protected String pad10(long l2) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(Long.toString(l2));
        for (int i2 = n2 = stringBuffer.length(); i2 < 10; ++i2) {
            stringBuffer.insert(0, 0);
        }
        return stringBuffer.toString();
    }

    protected void beginPageStream() {
        ++this.objectNumber;
        this.streamInfo.objectNumber = this.objectNumber++;
        this.streamInfo.lengthObjectNumber = this.objectNumber;
        this.contentsList.add(new Integer(this.streamInfo.objectNumber));
        if (!this.streamInfo.collectStream && this.compressed) {
            this.writeCompressedStreamHeader(this.streamInfo.objectNumber, this.streamInfo.lengthObjectNumber, null);
            this.streamInfo.collectStream = true;
            this.streamInfo.collectedStream = new ByteArrayOutputStream();
        } else {
            this.writeUncompressedStreamHeader(this.streamInfo.objectNumber, this.streamInfo.lengthObjectNumber, null);
            this.setStreamStart();
        }
    }

    protected void beginNonPageStream() {
        this.output("stream");
        if (!this.streamInfo.collectStream && this.compressed) {
            this.streamInfo.collectStream = true;
            this.streamInfo.collectedStream = new ByteArrayOutputStream();
        } else {
            this.setStreamStart();
        }
    }

    protected void endStream() {
        if (this.streamInfo.collectStream && this.compressed) {
            this.streamInfo.collectStream = false;
            int n2 = this.writeCompressedStreamBody(this.streamInfo.collectedStream.toByteArray());
            this.writeCompressedStreamFooter(this.streamInfo.lengthObjectNumber, n2);
            this.streamInfo.collectedStream = null;
        } else {
            int n3 = (int)(this.streamInfo.fileOffset - this.streamInfo.contentsStart - 1L);
            this.writeUncompressedStreamFooter(this.streamInfo.lengthObjectNumber, n3);
        }
    }

    protected void output(String string) {
        if (!this.isDocumentOpen()) {
            return;
        }
        if (!this.streamInfo.collectStream) {
            this.streamInfo.fileOffset += (long)(string.length() + 1);
            super.output(string);
        } else {
            try {
                try {
                    this.streamInfo.collectedStream.write(string.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.streamInfo.collectedStream.write(string.getBytes());
                }
                this.streamInfo.collectedStream.write(10);
            }
            catch (IOException iOException) {
                throw new PrintException(iOException.toString());
            }
        }
    }

    protected void output(byte[] byArray) {
        if (!this.isDocumentOpen()) {
            return;
        }
        if (!this.streamInfo.collectStream) {
            this.streamInfo.fileOffset += (long)byArray.length;
            super.output(byArray);
        } else {
            try {
                this.streamInfo.collectedStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new PrintException(iOException.toString());
            }
        }
    }

    protected void output(byte[] byArray, int n2, int n3) {
        if (!this.isDocumentOpen()) {
            return;
        }
        if (!this.streamInfo.collectStream) {
            this.streamInfo.fileOffset += (long)n3;
            super.output(byArray, n2, n3);
        } else {
            this.streamInfo.collectedStream.write(byArray, n2, n3);
        }
    }

    protected void output(byte by) {
        if (!this.isDocumentOpen()) {
            return;
        }
        if (!this.streamInfo.collectStream) {
            ++this.streamInfo.fileOffset;
            super.output(by);
        } else {
            this.streamInfo.collectedStream.write(by);
        }
    }

    protected String getFontAbbreviation(String string) {
        AcroFontEntry acroFontEntry = (AcroFontEntry)this.fontList.get(string);
        return acroFontEntry.abbrev;
    }

    protected AcroFontEntry getFontEntry(String string) {
        AcroFontEntry acroFontEntry = (AcroFontEntry)this.fontList.get(string);
        return acroFontEntry;
    }

    protected void addFontToList(FontPS fontPS) {
        String string = "F" + (this.fontList.size() + 1);
        AcroFontEntry acroFontEntry = new AcroFontEntry();
        acroFontEntry.font = fontPS;
        acroFontEntry.name = fontPS.getName();
        if (fontPS.usingTTF) {
            acroFontEntry.usingTTF = true;
            TrueTypeFontProperties trueTypeFontProperties = FontLibrary.lookupTrueTypeFontProperties(acroFontEntry.name);
            acroFontEntry.expectedCharacterRange = trueTypeFontProperties.getCharacterRange();
            if (acroFontEntry.expectedCharacterRange == 1) {
                acroFontEntry.usingAnsi = true;
                acroFontEntry.usingUnicode = false;
            } else if (acroFontEntry.expectedCharacterRange == 2) {
                acroFontEntry.usingAnsi = false;
                acroFontEntry.usingUnicode = true;
            } else if (acroFontEntry.expectedCharacterRange == 0) {
                acroFontEntry.usingAnsi = false;
                acroFontEntry.usingUnicode = false;
            } else {
                acroFontEntry.usingAnsi = false;
                acroFontEntry.usingUnicode = false;
            }
            acroFontEntry.embeddingRules = trueTypeFontProperties.getEmbeddingRules();
            acroFontEntry.ansiCharactersUsed = new TreeSet();
            acroFontEntry.unicodeCharactersUsed = new TreeSet();
            acroFontEntry.unicodeWidths = new Hashtable();
            acroFontEntry.includeUnicodeMap = trueTypeFontProperties.getIncludeUnicodeMap();
        } else {
            acroFontEntry.usingTTF = false;
            acroFontEntry.expectedCharacterRange = 1;
            acroFontEntry.usingAnsi = true;
            acroFontEntry.usingUnicode = false;
            acroFontEntry.embeddingRules = 0;
            acroFontEntry.ansiCharactersUsed = new TreeSet();
            acroFontEntry.unicodeCharactersUsed = null;
            acroFontEntry.unicodeWidths = null;
            acroFontEntry.includeUnicodeMap = false;
        }
        acroFontEntry.abbrev = string;
        acroFontEntry.number = -1;
        acroFontEntry.unicodeNumber = -1;
        this.fontList.put(acroFontEntry.name, acroFontEntry);
    }

    public boolean isCompressed() {
        return super.isCompressed();
    }

    public void setCompressed(boolean bl) {
        super.setCompressed(bl);
    }

    protected void addPattern(String string, BufferedImage bufferedImage) {
        PatternInfo patternInfo = new PatternInfo(string, bufferedImage);
        this.streamInfo.patternList.add(patternInfo);
    }

    protected void addPattern(String string, ShadedPattern shadedPattern, int n2) {
        PatternInfo patternInfo = new PatternInfo(string, shadedPattern, n2);
        this.streamInfo.patternList.add(patternInfo);
    }

    public class AlphaTransparency {
        protected double alpha = 1.0;
        protected boolean fill = false;

        public AlphaTransparency(double d2, boolean bl) {
            this.alpha = d2;
            this.fill = bl;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof AlphaTransparency) {
                AlphaTransparency alphaTransparency = (AlphaTransparency)object;
                return this.alpha == alphaTransparency.alpha && this.fill == alphaTransparency.fill;
            }
            return false;
        }

        public int hashCode() {
            int n2 = 7;
            n2 = 31 * n2 + (this.fill ? 1 : 0);
            long l2 = Double.doubleToLongBits(this.alpha);
            n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
            return n2;
        }
    }

    public class StreamInfo {
        protected OutputStream os = null;
        protected Vector imageList = new Vector();
        protected Vector xObjectList = new Vector();
        protected Hashtable fontList = new Hashtable();
        protected Vector patternList;
        protected long fileOffset = 0L;
        protected long contentsStart = 0L;
        protected Vector referenceList = new Vector();
        protected int objectNumber = 0;
        protected int lengthObjectNumber = 0;
        protected boolean textPresent = false;
        protected boolean imagePresent = false;
        protected boolean maskPresent = false;
        protected boolean indexImage = false;
        protected Vector colorSpaceList = new Vector();
        protected boolean collectStream = false;
        protected ByteArrayOutputStream collectedStream = null;

        public StreamInfo() {
            this.patternList = new Vector();
        }

        public void openDocument() {
            this.fileOffset = 0L;
            this.xObjectList.clear();
            this.fontList.clear();
            this.referenceList.clear();
            this.colorSpaceList.clear();
            this.patternList.clear();
        }

        public void beginPage() {
            this.xObjectList.clear();
            this.imageList.clear();
            this.fontList.clear();
            this.colorSpaceList.clear();
            this.patternList.clear();
            this.imagePresent = false;
            this.indexImage = false;
            this.maskPresent = false;
            this.textPresent = false;
        }
    }

    protected class AcroReference
    implements Comparable {
        protected int number;
        protected long offset;

        public AcroReference() {
        }

        public AcroReference(int n2, long l2) {
            this.number = n2;
            this.offset = l2;
        }

        public int compareTo(Object object) {
            AcroReference acroReference = (AcroReference)object;
            return this.number - acroReference.number;
        }
    }

    protected class PatternInfo {
        protected String patternName;
        protected int patternObjectNumber;
        protected int imageObjectNumber;
        protected BufferedImage img;
        protected ShadedPattern shadedPattern;

        protected PatternInfo() {
        }

        protected PatternInfo(String string, BufferedImage bufferedImage) {
            this.patternName = string;
            this.img = bufferedImage;
        }

        protected PatternInfo(String string, ShadedPattern shadedPattern, int n2) {
            this.patternName = string;
            this.shadedPattern = shadedPattern;
            this.patternObjectNumber = n2;
        }
    }
}

