/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCFlow;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.render.LineRender;
import com.klg.jclass.page.render.Render;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public class PageArea {
    protected String name = null;
    protected JCDocument document = null;
    protected JCUnit.Point location;
    protected JCUnit.Dimension size;
    protected Color color = null;
    protected Render background = null;
    protected List frameList = new Vector();
    protected int layoutStatus = 1;
    private static int NUM_LINES = 11;
    private static double[][] WATERMARK_POINTS = new double[][]{{0.23061515, 0.37929364, 0.41679985, 0.26812136}, {0.23061515, 0.37929364, 0.30255015, 0.45122864}, {0.41679985, 0.26812136, 0.48873485, 0.34005636}, {0.3237075, 0.3237075, 0.37765875, 0.37765875}, {0.52470235, 0.37602386, 0.37448514, 0.52316364}, {0.37448514, 0.52316364, 0.59663735, 0.44795886}, {0.41045264, 0.55913113, 0.63260485, 0.48392636}, {0.63260485, 0.48392636, 0.48238765, 0.63106614}, {0.52152875, 0.52152875, 0.55749625, 0.55749625}, {0.70453985, 0.55586136, 0.51835515, 0.66703364}, {0.51835515, 0.66703364, 0.59029015, 0.73896864}};

    public PageArea() {
        this.location = new JCUnit.Point();
        this.size = new JCUnit.Dimension();
    }

    public PageArea(String string) {
        this();
        this.name = string;
    }

    public PageArea(JCDocument jCDocument) {
        this();
        this.document = jCDocument;
    }

    public PageArea(String string, JCDocument jCDocument) {
        this();
        this.name = string;
        this.document = jCDocument;
    }

    public PageArea(String string, JCUnit.Point point, JCUnit.Dimension dimension) {
        this();
        this.name = string;
        this.location = point;
        this.size = dimension;
    }

    public PageArea(String string, JCDocument jCDocument, JCUnit.Point point, JCUnit.Dimension dimension) {
        this();
        this.name = string;
        this.document = jCDocument;
        this.location = point;
        this.size = dimension;
    }

    public String getName() {
        return this.name;
    }

    public JCDocument getDocument() {
        return this.document;
    }

    public void setDocument(JCDocument jCDocument) {
        this.document = jCDocument;
        int n2 = this.frameList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JCFrame jCFrame = (JCFrame)this.frameList.get(i2);
            jCFrame.setDocument(jCDocument);
        }
    }

    public JCUnit.Point getLocation() {
        return this.location;
    }

    public void setLocation(JCUnit.Point point) {
        this.location = point;
    }

    public JCUnit.Dimension getSize() {
        return this.size;
    }

    public void setSize(JCUnit.Dimension dimension) {
        this.size = dimension;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            this.color = null;
            return;
        }
        if (!color.equals(this.color)) {
            this.color = new Color(color.getRGB());
        }
    }

    public int getLayoutStatus() {
        return this.layoutStatus;
    }

    public void setLayoutStatus(int n2) {
        this.layoutStatus = n2;
    }

    public JCFrame stringToFrame(String string) {
        for (JCFrame jCFrame : this.frameList) {
            if (!jCFrame.getName().equalsIgnoreCase(string)) continue;
            return jCFrame;
        }
        throw new NoSuchElementException("Frame not Found: " + string);
    }

    protected void setName() {
    }

    protected Render getBackground() {
        return this.background;
    }

    public void setFrameList(List list) {
        this.frameList = list;
    }

    public List getFrameList() {
        return this.frameList;
    }

    protected void calcLayoutStatus() {
        int n2 = 4;
        for (JCFrame jCFrame : this.frameList) {
            jCFrame.calcLayoutStatus();
            int n3 = jCFrame.getLayoutStatus();
            if (!Render.isLayoutLower(n2, n3)) continue;
            n2 = n3;
        }
        this.layoutStatus = n2;
    }

    public void updateLayoutStatus(JCFlow jCFlow, JCPage jCPage) {
        int n2 = 4;
        if (this.layoutStatus == 4) {
            return;
        }
        for (JCFrame jCFrame : this.frameList) {
            jCFrame.updateLayoutStatus(jCFlow, jCPage);
            int n3 = jCFrame.getLayoutStatus();
            if (!Render.isLayoutLower(n2, n3)) continue;
            n2 = n3;
        }
        this.layoutStatus = n2;
    }

    public void draw(Graphics2D graphics2D) {
    }

    protected void drawEvalWatermark(Graphics2D graphics2D) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        if (graphics2D2 instanceof Graphics2DBase) {
            ((Graphics2DBase)graphics2D2).setFrameRoot();
        }
        double d2 = this.size.getWidth().getAs(JCUnit.POINTS);
        double d3 = this.size.getHeight().getAs(JCUnit.POINTS);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d2, d3);
        graphics2D2.setClip(double_);
        JCDrawStyle jCDrawStyle = new JCDrawStyle();
        jCDrawStyle.setForegroundColor(Color.lightGray);
        jCDrawStyle.setLineWidth(new JCUnit.Measure(JCUnit.POINTS, 4.0));
        jCDrawStyle.makeImmutable();
        for (int i2 = 0; i2 < NUM_LINES; ++i2) {
            JCUnit.Point point = new JCUnit.Point(JCUnit.POINTS, WATERMARK_POINTS[i2][0] * d2, WATERMARK_POINTS[i2][1] * d3);
            JCUnit.Point point2 = new JCUnit.Point(JCUnit.POINTS, WATERMARK_POINTS[i2][2] * d2, WATERMARK_POINTS[i2][3] * d3);
            LineRender lineRender = new LineRender(point, point2, jCDrawStyle);
            lineRender.draw(graphics2D2);
        }
        graphics2D2.dispose();
    }
}

