/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.FontBase;
import com.klg.jclass.page.JCTab;
import com.klg.jclass.page.JCUnit;
import java.awt.Color;
import java.awt.Font;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class JCTextStyle
implements Cloneable {
    public static final int LINEMODE_NONE = 1;
    public static final int LINEMODE_UNDERLINE = 2;
    public static final int OFFSET_NONE = 1;
    public static final int OFFSET_SUBSCRIPT = 2;
    public static final int OFFSET_SUPERSCRIPT = 3;
    public static final int ALIGNMENT_NONE = 1;
    public static final int ALIGNMENT_LEFT = 2;
    public static final int ALIGNMENT_RIGHT = 3;
    public static final int ALIGNMENT_CENTER = 4;
    public static final int ALIGNMENT_JUSTIFY = 5;
    protected String name;
    protected Color color;
    protected int underline;
    protected Font font;
    protected String fontFamily;
    protected int fontStyle;
    protected double pointSize;
    protected double subscriptRatio;
    protected int baselineOffset;
    protected int alignment;
    protected JCUnit.Measure indentLeft;
    protected JCUnit.Measure indentRight;
    protected JCUnit.Measure indentParagraph;
    protected double lineSpacing;
    protected double paragraphSpacing;
    protected List tabList;
    protected boolean immutable = false;
    protected static int styleCount = 0;
    protected static TreeMap instanceCollection = new TreeMap();
    protected static Map immutableTextStyles = Collections.synchronizedMap(new Hashtable());
    protected static final String UNAMED_STYLE_PREFIX = "jcplstyle";
    public static final JCTextStyle NORMAL = new JCTextStyle("Normal", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "TimesRoman", 0, 10.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle PLAIN = new JCTextStyle("Plain", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "TimesRoman", 0, 10.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle BOLD = new JCTextStyle("Bold", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "TimesRoman", 1, 10.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle BOLD_ITALIC = new JCTextStyle("Bold Italic", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "TimesRoman", 3, 10.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle ITALIC = new JCTextStyle("Italic", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "TimesRoman", 2, 10.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle INDENTED = new JCTextStyle("Indented", new JCUnit.Measure(JCUnit.INCHES, 0.25), new JCUnit.Measure(JCUnit.INCHES, 0.25), new JCUnit.Measure(JCUnit.INCHES, 0.25), Color.black, null, "TimesRoman", 0, 10.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle CODE = new JCTextStyle("Code", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "Courier", 0, 10.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle CODE_INDENTED = new JCTextStyle("CodeIndented", new JCUnit.Measure(JCUnit.INCHES, 0.25), new JCUnit.Measure(JCUnit.INCHES, 0.25), new JCUnit.Measure(JCUnit.INCHES, 0.25), Color.black, null, "Courier", 0, 10.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle HEADING = new JCTextStyle("Heading", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "Helvetica", 0, 10.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle HEADING_BOLD = new JCTextStyle("HeadingBold", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "Helvetica", 1, 10.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle HEADING1 = new JCTextStyle("H1", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "Helvetica", 1, 18.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle HEADING2 = new JCTextStyle("H2", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "Helvetica", 0, 18.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle HEADING3 = new JCTextStyle("H3", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "Helvetica", 1, 16.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle HEADING4 = new JCTextStyle("H4", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "Helvetica", 0, 16.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle HEADING5 = new JCTextStyle("H5", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "Helvetica", 1, 14.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle HEADING6 = new JCTextStyle("H6", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "Helvetica", 0, 14.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle HEADING7 = new JCTextStyle("H7", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "Helvetica", 1, 12.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle WHITE_BOLD = new JCTextStyle("WhiteBold", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.white, null, "TimesRoman", 1, 12.0, 1, 2, 0.75, 1, 1.0, 1.0, true);
    public static final JCTextStyle DEFAULT_TEXT = new JCTextStyle("default text");
    public static final JCTextStyle DEFAULT_HEADER = new JCTextStyle("default header", new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "TimesRoman", 1, 14.0, 1, 4, 0.75, 1, 1.0, 1.0, true);

    public JCTextStyle(String string, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure measure3, Color color, List list, String string2, int n2, double d2, int n3, int n4, double d3, int n5, double d4, double d5, boolean bl) {
        this.name = string;
        this.indentLeft = measure;
        this.indentRight = measure2;
        this.indentParagraph = measure3;
        this.color = color;
        this.tabList = list;
        if (this.tabList == null) {
            this.tabList = new Vector();
        }
        this.fontFamily = string2;
        this.fontStyle = n2;
        this.pointSize = d2;
        this.font = FontBase.deriveFont(Font.decode(this.fontFamily), this.fontStyle, (float)this.pointSize);
        this.underline = n3;
        this.alignment = n4;
        this.subscriptRatio = d3;
        this.baselineOffset = n5;
        this.lineSpacing = d4;
        this.paragraphSpacing = d5;
        this.immutable = bl;
        if (!string.regionMatches(0, UNAMED_STYLE_PREFIX, 0, UNAMED_STYLE_PREFIX.length())) {
            instanceCollection.put(string, this);
        }
    }

    public JCTextStyle() {
        this(UNAMED_STYLE_PREFIX + ++styleCount, new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), new JCUnit.Measure(JCUnit.INTERNAL), Color.black, null, "TimesRoman", 0, 12.0, 1, 2, 0.75, 1, 1.0, 1.0, false);
    }

    public JCTextStyle(String string) {
        this();
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (instanceCollection.containsKey(this.name)) {
            instanceCollection.remove(this.name);
        }
        this.name = string;
        if (!string.regionMatches(0, UNAMED_STYLE_PREFIX, 0, UNAMED_STYLE_PREFIX.length())) {
            instanceCollection.put(string, this);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        this.color = color;
    }

    public int getUnderlining() {
        return this.underline;
    }

    public void setUnderlining(int n2) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (n2 <= 0 || n2 > 2) {
            throw new IllegalArgumentException("Unrecognised Line type");
        }
        this.underline = n2;
    }

    public double getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(double d2) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (d2 < 1.0) {
            throw new IllegalArgumentException("Point size must be >= 1");
        }
        this.pointSize = d2;
        this.font = FontBase.deriveFont(this.font, this.fontStyle, (float)d2);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        this.font = font;
        this.fontFamily = font.getFamily();
        this.fontStyle = font.getStyle();
        this.pointSize = FontBase.getSize2D(font);
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String string) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        this.fontFamily = string;
        this.font = FontBase.deriveFont(Font.decode(string), this.fontStyle, (float)this.pointSize);
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int n2) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        this.fontStyle = n2;
        this.font = FontBase.deriveFont(this.font, n2);
    }

    public int getBaselineOffset() {
        return this.baselineOffset;
    }

    public void setBaselineOffset(int n2) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (n2 <= 0 || n2 > 3) {
            throw new IllegalArgumentException("Unrecognised baseline offset");
        }
        this.baselineOffset = n2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (n2 <= 0 || n2 > 5) {
            throw new IllegalArgumentException("Unrecognised paragraph alignment");
        }
        this.alignment = n2;
    }

    public JCUnit.Measure getLeftIndent() {
        return this.indentLeft;
    }

    public void setLeftIndent(JCUnit.Measure measure) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (measure.distance < 0.0) {
            throw new IllegalArgumentException("Indentation must be >= 0");
        }
        this.indentLeft = measure;
    }

    public JCUnit.Measure getRightIndent() {
        return this.indentRight;
    }

    public void setRightIndent(JCUnit.Measure measure) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (measure.distance < 0.0) {
            throw new IllegalArgumentException("Indentation must be >= 0");
        }
        this.indentRight = measure;
    }

    public JCUnit.Measure getParagraphIndent() {
        return this.indentParagraph;
    }

    public void setParagraphIndent(JCUnit.Measure measure) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (measure.distance < 0.0) {
            throw new IllegalArgumentException("Indentation must be >= 0");
        }
        this.indentParagraph = measure;
    }

    public double getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(double d2) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Line spacing must be > 0");
        }
        this.lineSpacing = d2;
    }

    public double getParagraphSpacing() {
        return this.paragraphSpacing;
    }

    public void setParagraphSpacing(double d2) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Paragraph spacing must be > 0");
        }
        this.paragraphSpacing = d2;
    }

    public List getTabs() {
        return this.tabList;
    }

    public void addTab(JCTab jCTab) {
        boolean bl = false;
        JCUnit.Measure measure = jCTab.getPosition();
        for (int i2 = 0; i2 < this.tabList.size() && !bl; ++i2) {
            JCTab jCTab2 = (JCTab)this.tabList.get(i2);
            if (!measure.lessThan(jCTab2.getPosition())) continue;
            this.tabList.add(i2, jCTab);
            bl = true;
        }
        if (!bl) {
            this.tabList.add(jCTab);
        }
    }

    public void addTab(int n2, JCUnit.Measure measure) {
        boolean bl = false;
        JCTab jCTab = new JCTab(measure, n2);
        for (int i2 = 0; i2 < this.tabList.size() && !bl; ++i2) {
            JCTab jCTab2 = (JCTab)this.tabList.get(i2);
            if (!measure.lessThan(jCTab2.getPosition())) continue;
            this.tabList.add(i2, jCTab);
            bl = true;
        }
        if (!bl) {
            this.tabList.add(jCTab);
        }
    }

    public void setTabs(int n2, List list) {
        this.tabList.clear();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.addTab(n2, (JCUnit.Measure)list.get(i2));
        }
    }

    public void setTabs(int n2, JCUnit.Measure measure, int n3) {
        this.tabList.clear();
        this.setTabs(n2, measure, measure, n3);
    }

    public void setTabs(int n2, JCUnit.Measure measure, JCUnit.Measure measure2, int n3) {
        this.tabList.clear();
        JCUnit.Measure measure3 = (JCUnit.Measure)measure.clone();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.addTab(n2, measure3);
            measure3.add(measure2);
        }
    }

    public void deleteTabs() {
        this.tabList.clear();
    }

    public void deleteTab(JCUnit.Measure measure) {
        boolean bl = false;
        for (int i2 = 0; i2 < this.tabList.size() && !bl; ++i2) {
            JCTab jCTab = (JCTab)this.tabList.get(i2);
            if (!measure.equals(jCTab.getPosition())) continue;
            this.tabList.remove(i2);
            bl = true;
        }
    }

    public double getSubscriptRatio() {
        return this.subscriptRatio;
    }

    public void setSubscriptRatio(double d2) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable styles");
        }
        if (d2 < 0.01 || d2 > 10.0) {
            throw new IllegalArgumentException("Subscript ratio must be between 0.01 and 10");
        }
        this.subscriptRatio = d2;
    }

    public boolean isMutable() {
        return !this.immutable;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public Object clone() {
        JCTextStyle jCTextStyle;
        try {
            jCTextStyle = (JCTextStyle)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        jCTextStyle.indentLeft = (JCUnit.Measure)this.indentLeft.clone();
        jCTextStyle.indentRight = (JCUnit.Measure)this.indentRight.clone();
        jCTextStyle.indentParagraph = (JCUnit.Measure)this.indentParagraph.clone();
        Iterator iterator = this.tabList.iterator();
        jCTextStyle.tabList = new Vector();
        while (iterator.hasNext()) {
            JCTab jCTab = (JCTab)iterator.next();
            JCTab jCTab2 = (JCTab)jCTab.clone();
            jCTextStyle.tabList.add(jCTab2);
        }
        jCTextStyle.name = new String("Copy of " + this.name);
        jCTextStyle.immutable = false;
        return jCTextStyle;
    }

    public static Iterator getStyles() {
        return instanceCollection.entrySet().iterator();
    }

    public static Map getStyleList() {
        return instanceCollection;
    }

    public static JCTextStyle stringToStyle(String string) {
        if (instanceCollection.containsKey(string)) {
            return (JCTextStyle)instanceCollection.get(string);
        }
        return null;
    }

    public int hashCode() {
        int n2 = this.color.hashCode();
        n2 += this.underline;
        n2 += this.fontFamily.hashCode();
        n2 += this.fontStyle;
        n2 = (int)((double)n2 + this.pointSize);
        n2 = (int)((double)n2 + this.subscriptRatio);
        n2 += this.baselineOffset;
        n2 += this.alignment;
        n2 += this.indentLeft.hashCode();
        n2 += this.indentRight.hashCode();
        n2 += this.indentParagraph.hashCode();
        n2 = (int)((double)n2 + this.lineSpacing);
        n2 = (int)((double)n2 + this.paragraphSpacing);
        n2 += this.tabList.size();
        for (int i2 = 0; i2 < this.tabList.size(); ++i2) {
            n2 += this.tabList.get(i2).hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof JCTextStyle)) {
            return false;
        }
        JCTextStyle jCTextStyle = (JCTextStyle)object;
        if (this.color.equals(jCTextStyle.color) && this.underline == jCTextStyle.underline && this.fontFamily.equals(jCTextStyle.fontFamily) && this.fontStyle == jCTextStyle.fontStyle && this.pointSize == jCTextStyle.pointSize && this.subscriptRatio == jCTextStyle.subscriptRatio && this.baselineOffset == jCTextStyle.baselineOffset && this.alignment == jCTextStyle.alignment && this.indentLeft.equals(jCTextStyle.indentLeft) && this.indentRight.equals(jCTextStyle.indentRight) && this.indentParagraph.equals(jCTextStyle.indentParagraph) && this.lineSpacing == jCTextStyle.lineSpacing && this.paragraphSpacing == jCTextStyle.paragraphSpacing) {
            if (this.tabList.size() != jCTextStyle.tabList.size()) {
                return false;
            }
            for (int i2 = 0; i2 < this.tabList.size(); ++i2) {
                JCTab jCTab;
                JCTab jCTab2 = (JCTab)this.tabList.get(i2);
                if (jCTab2.equals(jCTab = (JCTab)jCTextStyle.tabList.get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public JCTextStyle getImmutable() {
        if (this.immutable) {
            return this;
        }
        JCTextStyle jCTextStyle = (JCTextStyle)immutableTextStyles.get(this);
        if (jCTextStyle == null) {
            jCTextStyle = (JCTextStyle)this.clone();
            jCTextStyle.makeImmutable();
            immutableTextStyles.put(jCTextStyle, jCTextStyle);
        }
        return jCTextStyle;
    }
}

