/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.PageArea;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import com.klg.jclass.util.xml.JCXMLDTDResolver;
import com.klg.jclass.util.xml.JCXMLErrorPrinter;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JCPageTemplate {
    public static void importTemplates(JCDocument jCDocument, File file) throws SAXException, IOException, ParserConfigurationException {
        InputSource inputSource = JCXMLDTDResolver.createInputSource(file);
        JCPageTemplate.importTemplates(jCDocument, inputSource);
        JCPageTemplate.closeStream(inputSource);
    }

    public static void importTemplates(JCDocument jCDocument, Reader reader) throws SAXException, IOException, ParserConfigurationException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId("file:/");
        JCPageTemplate.importTemplates(jCDocument, inputSource);
    }

    public static void importTemplates(JCDocument jCDocument, InputSource inputSource) throws SAXException, IOException, ParserConfigurationException {
        List list = JCPageTemplate.loadTemplates(inputSource);
        jCDocument.setTemplates(list);
    }

    public static List loadTemplates(File file) throws SAXException, IOException, ParserConfigurationException {
        InputSource inputSource = JCXMLDTDResolver.createInputSource(file);
        List list = JCPageTemplate.loadTemplates(inputSource);
        JCPageTemplate.closeStream(inputSource);
        return list;
    }

    public static List loadTemplates(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId("file:/");
        return JCPageTemplate.loadTemplates(inputSource);
    }

    private static void closeStream(InputSource inputSource) throws IOException {
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            inputStream.close();
        }
    }

    protected static String getNameAttribute(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("NAME");
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    protected static Color getColorAttribute(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("COLOR");
        if (node2 == null) {
            return null;
        }
        return JCSwingTypeConverter.toColor(node2.getNodeValue());
    }

    protected static boolean getFirstAttribute(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("FIRST");
        if (node2 == null) {
            return false;
        }
        return JCTypeConverter.toBoolean(node2.getNodeValue(), false);
    }

    protected static int getOrientationAttribute(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("ORIENTATION");
        if (node2 == null) {
            return 0;
        }
        String string = node2.getNodeValue();
        int n2 = 0;
        if (string.equals("portrait")) {
            n2 = 1;
        } else if (string.equals("landscape")) {
            n2 = 2;
        }
        return n2;
    }

    protected static JCUnit getUnitAttribute(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("UNIT");
        String string = node2.getNodeValue();
        JCUnit jCUnit = null;
        if (string.equals("inches")) {
            jCUnit = JCUnit.INCHES;
        } else if (string.equals("points")) {
            jCUnit = JCUnit.POINTS;
        } else if (string.equals("cm")) {
            jCUnit = JCUnit.CM;
        } else if (string.equals("cms")) {
            jCUnit = JCUnit.CM;
        } else if (string.equals("centimeters")) {
            jCUnit = JCUnit.CM;
        } else if (string.equals("centimetres")) {
            jCUnit = JCUnit.CM;
        }
        return jCUnit;
    }

    protected static JCUnit.Point getLocation(Node node, JCUnit jCUnit) {
        double d2;
        double d3;
        NodeList nodeList = ((Element)node).getElementsByTagName("LOCATION");
        Node node2 = nodeList.item(0);
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Node node3 = namedNodeMap.getNamedItem("X");
        if (node3 == null) {
            d3 = 0.0;
        } else {
            try {
                d3 = Double.valueOf(node3.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                d3 = 0.0;
            }
        }
        Node node4 = namedNodeMap.getNamedItem("Y");
        if (node4 == null) {
            d2 = 0.0;
        } else {
            try {
                d2 = Double.valueOf(node4.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                d2 = 0.0;
            }
        }
        return new JCUnit.Point(jCUnit, d3, d2);
    }

    protected static JCUnit.Dimension getSize(Node node, JCUnit jCUnit) {
        double d2;
        double d3;
        NodeList nodeList = ((Element)node).getElementsByTagName("SIZE");
        Node node2 = nodeList.item(0);
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Node node3 = namedNodeMap.getNamedItem("WIDTH");
        if (node3 == null) {
            d3 = 0.0;
        } else {
            try {
                d3 = Double.valueOf(node3.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                d3 = 0.0;
            }
        }
        Node node4 = namedNodeMap.getNamedItem("HEIGHT");
        if (node4 == null) {
            d2 = 0.0;
        } else {
            try {
                d2 = Double.valueOf(node4.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                d2 = 0.0;
            }
        }
        return new JCUnit.Dimension(jCUnit, d3, d2);
    }

    protected static ColumnDefinition getColumnSetup(Node node, JCUnit jCUnit) {
        NodeList nodeList = ((Element)node).getElementsByTagName("COLUMN");
        Node node2 = nodeList.item(0);
        int n2 = 1;
        JCUnit.Measure measure = new JCUnit.Measure(JCUnit.INTERNAL, 0.25);
        if (node2 != null) {
            Node node3;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node4 = namedNodeMap.getNamedItem("COUNT");
            if (node4 != null) {
                try {
                    n2 = Integer.valueOf(node4.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 1;
                }
            }
            if ((node3 = namedNodeMap.getNamedItem("SPACING")) != null) {
                try {
                    double d2 = Double.valueOf(node3.getNodeValue());
                    measure = new JCUnit.Measure(jCUnit, d2);
                }
                catch (NumberFormatException numberFormatException) {
                    measure = new JCUnit.Measure(JCUnit.INTERNAL, 0.25);
                }
            }
        }
        return new ColumnDefinition(n2, measure);
    }

    protected static int getBorderType(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("TYPE");
        String string = node2.getNodeValue();
        int n2 = 1;
        if (string.equals("blank")) {
            n2 = 1;
        } else if (string.equals("broken")) {
            n2 = 3;
        } else if (string.equals("dashed")) {
            n2 = 3;
        } else if (string.equals("double")) {
            n2 = 4;
        } else if (string.equals("none")) {
            n2 = 1;
        } else if (string.equals("plain")) {
            n2 = 2;
        } else if (string.equals("regular")) {
            n2 = 2;
        } else if (string.equals("single")) {
            n2 = 2;
        }
        return n2;
    }

    protected static JCUnit.Measure getBorderThickness(Node node, JCUnit jCUnit) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("THICKNESS");
        JCUnit.Measure measure = new JCUnit.Measure();
        if (node2 == null) {
            measure = new JCUnit.Measure(JCUnit.POINTS, 0.1);
        } else {
            try {
                double d2 = Double.valueOf(node2.getNodeValue());
                measure = new JCUnit.Measure(jCUnit, d2);
            }
            catch (NumberFormatException numberFormatException) {
                measure = new JCUnit.Measure(JCUnit.POINTS, 0.1);
            }
        }
        return measure;
    }

    protected static BorderDefinition getBorderSetup(Node node, JCUnit jCUnit) {
        NodeList nodeList = ((Element)node).getElementsByTagName("BORDER");
        Node node2 = nodeList.item(0);
        int n2 = 1;
        Color color = Color.black;
        JCUnit.Measure measure = new JCUnit.Measure(JCUnit.POINTS, 0.1);
        if (node2 != null) {
            n2 = JCPageTemplate.getBorderType(node2);
            color = JCPageTemplate.getColorAttribute(node2);
            if (color == null) {
                color = Color.black;
            }
            measure = JCPageTemplate.getBorderThickness(node2, jCUnit);
        }
        return new BorderDefinition(n2, color, measure);
    }

    protected static JCFrame getFrameFromListByName(List list, String string) {
        JCFrame jCFrame = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!((JCFrame)list.get(i2)).getName().equals(string)) continue;
            jCFrame = (JCFrame)list.get(i2);
            break;
        }
        return jCFrame;
    }

    protected static double getMarginSide(NamedNodeMap namedNodeMap, String string) {
        double d2;
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            d2 = 0.0;
        } else {
            try {
                d2 = Double.valueOf(node.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                d2 = 0.0;
            }
        }
        return d2;
    }

    protected static JCUnit.Margins getMargins(Node node, JCUnit jCUnit) {
        NodeList nodeList = ((Element)node).getElementsByTagName("MARGIN");
        Node node2 = nodeList.item(0);
        JCUnit.Margins margins = new JCUnit.Margins(jCUnit);
        if (node2 != null) {
            NamedNodeMap namedNodeMap = node2.getAttributes();
            double d2 = JCPageTemplate.getMarginSide(namedNodeMap, "TOP");
            margins.setTop(new JCUnit.Measure(jCUnit, d2));
            d2 = JCPageTemplate.getMarginSide(namedNodeMap, "LEFT");
            margins.setLeft(new JCUnit.Measure(jCUnit, d2));
            d2 = JCPageTemplate.getMarginSide(namedNodeMap, "RIGHT");
            margins.setRight(new JCUnit.Measure(jCUnit, d2));
            d2 = JCPageTemplate.getMarginSide(namedNodeMap, "BOTTOM");
            margins.setBottom(new JCUnit.Measure(jCUnit, d2));
        }
        return margins;
    }

    protected static JCPage getTemplateByName(List list, String string) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!((JCPage)list.get(i2)).getName().equals(string)) continue;
            return (JCPage)list.get(i2);
        }
        return null;
    }

    public static List loadTemplates(InputSource inputSource) throws SAXException, IOException, ParserConfigurationException {
        JCPage jCPage;
        Object object;
        Object object2;
        int n2;
        Object object3;
        Object object4;
        Document document = null;
        ArrayList<JCPage> arrayList = new ArrayList<JCPage>();
        try {
            object4 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object4).setValidating(true);
            object3 = ((DocumentBuilderFactory)object4).newDocumentBuilder();
            ((DocumentBuilder)object3).setErrorHandler(new JCXMLErrorPrinter());
            ((DocumentBuilder)object3).setEntityResolver(new JCXMLDTDResolver("JCPageTemplate.dtd", JCPageTemplate.class));
            document = ((DocumentBuilder)object3).parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace(System.err);
            throw parserConfigurationException;
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
            throw sAXParseException;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
            throw sAXException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw iOException;
        }
        if (document == null) {
            return null;
        }
        NodeList nodeList = document.getElementsByTagName("PAGE");
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            object2 = nodeList.item(n2);
            object3 = JCPageTemplate.getNameAttribute((Node)object2);
            object = JCPageTemplate.getUnitAttribute((Node)object2);
            int n3 = JCPageTemplate.getOrientationAttribute((Node)object2);
            object4 = JCPageTemplate.getColorAttribute((Node)object2);
            boolean bl = JCPageTemplate.getFirstAttribute((Node)object2);
            JCUnit.Point point = JCPageTemplate.getLocation((Node)object2, (JCUnit)object);
            JCUnit.Dimension dimension = JCPageTemplate.getSize((Node)object2, (JCUnit)object);
            jCPage = new JCPage((String)object3, point, dimension);
            jCPage.setColor((Color)object4);
            jCPage.setFirstTemplate(bl);
            jCPage.setOrientation(n3);
            jCPage.setPageType(1);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(10);
            NodeList nodeList2 = ((Element)object2).getElementsByTagName("FRAME");
            for (int i2 = 0; i2 < nodeList2.getLength(); ++i2) {
                object11 = nodeList2.item(i2);
                object3 = JCPageTemplate.getNameAttribute((Node)object11);
                object10 = JCPageTemplate.getUnitAttribute((Node)object11);
                object4 = JCPageTemplate.getColorAttribute((Node)object11);
                point = JCPageTemplate.getLocation((Node)object11, (JCUnit)object10);
                dimension = JCPageTemplate.getSize((Node)object11, (JCUnit)object10);
                object9 = JCPageTemplate.getBorderSetup((Node)object11, (JCUnit)object10);
                object8 = JCPageTemplate.getColumnSetup((Node)object11, (JCUnit)object10);
                object7 = JCPageTemplate.getMargins((Node)object11, (JCUnit)object10);
                object6 = new JCFrame((String)object3, point, dimension);
                ((PageArea)object6).setColor((Color)object4);
                ((JCFrame)object6).setColumnCount(((ColumnDefinition)object8).getCount());
                ((JCFrame)object6).setColumnSpace(((ColumnDefinition)object8).getSpacing());
                ((JCFrame)object6).setMargins((JCUnit.Margins)object7);
                object5 = (JCDrawStyle)JCDrawStyle.BLANK.clone();
                ((JCDrawStyle)object5).setLineWidth(((BorderDefinition)object9).getThickness());
                ((JCDrawStyle)object5).setForegroundColor(((BorderDefinition)object9).getColor());
                ((JCDrawStyle)object5).setLineType(((BorderDefinition)object9).getType());
                ((JCFrame)object6).setBorder((JCDrawStyle)object5);
                arrayList2.add(object6);
            }
            jCPage.setFrameList(arrayList2);
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            object11 = ((Element)object2).getElementsByTagName("FLOWFRAME");
            for (int i3 = 0; i3 < object11.getLength(); ++i3) {
                object9 = object11.item(i3);
                object3 = JCPageTemplate.getNameAttribute((Node)object9);
                object8 = JCPageTemplate.getFrameFromListByName(arrayList2, (String)object3);
                if (object8 == null) {
                    System.err.println("Blowed up real good");
                }
                arrayList3.add(object8);
            }
            jCPage.setFlowFrameList(arrayList3);
            object10 = ((Element)object2).getElementsByTagName("FLOWPAGE");
            object9 = object10.item(0);
            object3 = JCPageTemplate.getNameAttribute((Node)object9);
            object8 = new JCPage((String)object3);
            ((JCPage)object8).setPageType(1);
            jCPage.setFlowPageTemplate((JCPage)object8);
            object7 = ((Element)object2).getElementsByTagName("FLOWSECTION");
            object6 = object7.item(0);
            object3 = JCPageTemplate.getNameAttribute((Node)object6);
            object5 = new JCPage((String)object3);
            ((JCPage)object5).setPageType(1);
            jCPage.setFlowSectionTemplate((JCPage)object5);
            arrayList.add(jCPage);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object2 = (JCPage)arrayList.get(n2);
            jCPage = ((JCPage)object2).getFlowPageTemplate();
            object = JCPageTemplate.getTemplateByName(arrayList, jCPage.getName());
            if (object != null) {
                ((JCPage)object2).setFlowPageTemplate((JCPage)object);
            } else {
                ((JCPage)object2).setFlowPageTemplate((JCPage)object2);
            }
            jCPage = ((JCPage)object2).getFlowSectionTemplate();
            object = JCPageTemplate.getTemplateByName(arrayList, jCPage.getName());
            if (object != null) {
                ((JCPage)object2).setFlowSectionTemplate((JCPage)object);
                continue;
            }
            ((JCPage)object2).setFlowSectionTemplate((JCPage)object2);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        try {
            JCPageTemplate.loadTemplates(new File(stringArray[0]));
        }
        catch (Exception exception) {
            System.err.println("Threw excetopnm = " + exception);
            exception.printStackTrace();
        }
    }

    static class ColumnDefinition {
        int count;
        JCUnit.Measure spacing;

        public ColumnDefinition(int n2, JCUnit.Measure measure) {
            this.count = n2;
            this.spacing = measure;
        }

        public int getCount() {
            return this.count;
        }

        public JCUnit.Measure getSpacing() {
            return this.spacing;
        }
    }

    static class BorderDefinition {
        int type;
        Color colour;
        JCUnit.Measure line_width;

        public BorderDefinition(int n2, Color color, JCUnit.Measure measure) {
            this.type = n2;
            this.colour = color;
            this.line_width = measure;
        }

        public int getType() {
            return this.type;
        }

        public Color getColor() {
            return this.colour;
        }

        public JCUnit.Measure getThickness() {
            return this.line_width;
        }
    }
}

