/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JCPageTableFromJTable {
    protected static int defaultColumnWidth = 75;
    protected static int[][] alignment_map = new int[][]{{0, 4}, {2, 2}, {4, 3}, {10, 1}, {11, 1}};

    public static JCPageTable createTable(JCDocument jCDocument, JTable jTable, boolean bl) {
        TableModel tableModel = jTable.getModel();
        return JCPageTableFromJTable.createTable(jCDocument, tableModel, jTable, bl);
    }

    public static JCPageTable createTable(JCDocument jCDocument, TableModel tableModel, boolean bl) {
        return JCPageTableFromJTable.createTable(jCDocument, tableModel, null, bl);
    }

    protected static JCPageTable createTable(JCDocument jCDocument, TableModel tableModel, JTable jTable, boolean bl) {
        JCPageTable jCPageTable = null;
        TableColumnModel tableColumnModel = null;
        int n2 = 0;
        if (jTable != null) {
            tableColumnModel = jTable.getColumnModel();
            n2 = jTable.getColumnCount();
        } else if (tableModel != null) {
            n2 = tableModel.getColumnCount();
        }
        Vector<Object> vector = new Vector<Object>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            int n3 = defaultColumnWidth;
            if (tableColumnModel != null) {
                object = tableColumnModel.getColumn(i2);
                n3 = ((TableColumn)object).getPreferredWidth();
            }
            object = new JCUnit.Measure(JCUnit.POINTS, n3);
            vector.add(object);
        }
        jCPageTable = new JCPageTable(jCDocument, vector);
        jCPageTable.setAlignment(4);
        jCPageTable.createHeaders();
        if (bl) {
            JCPageTableFromJTable.populateTable(jCPageTable, tableModel, jTable, true);
        }
        return jCPageTable;
    }

    public static void populateTable(JCPageTable jCPageTable, JTable jTable) {
        JCPageTableFromJTable.populateTable(jCPageTable, jTable.getModel(), jTable, true);
    }

    public static void populateTable(JCPageTable jCPageTable, JTable jTable, boolean bl) {
        JCPageTableFromJTable.populateTable(jCPageTable, jTable.getModel(), jTable, bl);
    }

    public static void populateTable(JCPageTable jCPageTable, TableModel tableModel) {
        JCPageTableFromJTable.populateTable(jCPageTable, tableModel, null, false);
    }

    protected static int convertSwingToTextStyleAlignment(int n2) {
        int n3 = 2;
        for (int i2 = 0; i2 < alignment_map.length; ++i2) {
            if (alignment_map[i2][0] != n2) continue;
            n3 = alignment_map[i2][1];
        }
        return n3;
    }

    protected static JLabel getLabelComponent(Component component) {
        JLabel jLabel = null;
        if (component instanceof JLabel) {
            jLabel = (JLabel)component;
        } else if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            if (componentArray == null) {
                return null;
            }
            for (int i2 = 0; i2 < componentArray.length && (jLabel = JCPageTableFromJTable.getLabelComponent(componentArray[i2])) == null; ++i2) {
            }
        }
        return jLabel;
    }

    protected static JCTextStyle setFontAndAlignment(TableCellRenderer tableCellRenderer, JCTextStyle jCTextStyle, JTable jTable, Object object, int n2, int n3) {
        if (tableCellRenderer == null || jCTextStyle == null) {
            return null;
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, n2, n3);
        if (component != null) {
            JLabel jLabel = JCPageTableFromJTable.getLabelComponent(component);
            int n4 = jCTextStyle.getAlignment();
            if (jLabel != null) {
                n4 = jLabel.getHorizontalAlignment();
                n4 = JCPageTableFromJTable.convertSwingToTextStyleAlignment(n4);
            }
            if (component.getFont() != jCTextStyle.getFont() || jCTextStyle.getAlignment() != n4) {
                jCTextStyle = (JCTextStyle)jCTextStyle.clone();
                if (component.getFont() != jCTextStyle.getFont()) {
                    jCTextStyle.setFont(component.getFont());
                }
                if (jCTextStyle.getAlignment() != n4) {
                    jCTextStyle.setAlignment(n4);
                }
                jCTextStyle = jCTextStyle.getImmutable();
            }
        }
        return jCTextStyle;
    }

    protected static void populateTable(JCPageTable jCPageTable, TableModel tableModel, JTable jTable) {
        JCPageTableFromJTable.populateTable(jCPageTable, tableModel, jTable, true);
    }

    protected static void populateTable(JCPageTable jCPageTable, TableModel tableModel, JTable jTable, boolean bl) {
        JCTextStyle jCTextStyle;
        JCTextStyle jCTextStyle2 = jCTextStyle = JCTextStyle.stringToStyle("default text");
        JCTextStyle jCTextStyle3 = null;
        TableColumnModel tableColumnModel = null;
        TableColumn tableColumn = null;
        int n2 = 0;
        if (jTable != null) {
            tableColumnModel = jTable.getColumnModel();
            n2 = jTable.getColumnCount();
        } else if (tableModel != null) {
            n2 = tableModel.getColumnCount();
        }
        JCPageTable jCPageTable2 = jCPageTable.getHeaders();
        if (jCPageTable2 == null) {
            jCPageTable2 = jCPageTable.createHeaders();
        }
        try {
            Object object;
            int n3;
            TableCellRenderer tableCellRenderer = null;
            for (n3 = 0; n3 < n2; ++n3) {
                JCFrame jCFrame = jCPageTable2.getCellFrame(0, n3);
                Object object2 = "";
                if (tableColumnModel != null) {
                    tableColumn = tableColumnModel.getColumn(n3);
                    object2 = tableColumn.getHeaderValue();
                } else if (tableModel != null) {
                    object2 = tableModel.getColumnName(n3);
                }
                jCTextStyle3 = null;
                if (jTable != null && bl) {
                    if (tableColumnModel != null) {
                        tableColumn = tableColumnModel.getColumn(n3);
                        tableCellRenderer = tableColumn.getHeaderRenderer();
                    }
                    if (tableCellRenderer == null && (object = jTable.getTableHeader()) != null) {
                        tableCellRenderer = ((JTableHeader)object).getDefaultRenderer();
                    }
                    if (tableCellRenderer != null) {
                        object = jCPageTable.getHeaders().getCell(0, n3).getStyle();
                        jCTextStyle3 = JCPageTableFromJTable.setFontAndAlignment(tableCellRenderer, (JCTextStyle)object, jTable, object2, -1, n3);
                    }
                }
                if (jCTextStyle3 == null && (jCTextStyle3 = jCPageTable.getHeaders().getCell(0, n3).getStyle()) == null) {
                    jCTextStyle3 = jCTextStyle;
                }
                jCTextStyle2 = jCTextStyle3;
                if (object2 instanceof Image) {
                    jCFrame.embedImage(jCTextStyle2, (Image)object2);
                    continue;
                }
                if (object2 instanceof Icon) {
                    jCFrame.embedIcon(jCTextStyle2, (Icon)object2);
                    continue;
                }
                object = object2 != null ? object2.toString() : "";
                jCFrame.printWithNewlines(jCTextStyle2, (String)object);
            }
            for (n3 = 0; n3 < tableModel.getRowCount(); ++n3) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object3;
                    int n4 = i2;
                    if (jTable != null) {
                        n4 = jTable.convertColumnIndexToModel(i2);
                    }
                    object = jCPageTable.getCellFrame(n3, i2);
                    Object object4 = tableModel.getValueAt(n3, n4);
                    jCTextStyle3 = null;
                    if (jTable != null && bl) {
                        if (tableColumnModel != null) {
                            tableColumn = tableColumnModel.getColumn(i2);
                            tableCellRenderer = tableColumn.getCellRenderer();
                        }
                        if (tableCellRenderer == null) {
                            tableCellRenderer = jTable.getDefaultRenderer(jTable.getColumnClass(i2));
                        }
                        if (tableCellRenderer != null) {
                            object3 = jCPageTable.getCell(n3, i2).getStyle();
                            jCTextStyle3 = JCPageTableFromJTable.setFontAndAlignment(tableCellRenderer, (JCTextStyle)object3, jTable, object4, n3, i2);
                        }
                    }
                    if (jCTextStyle3 == null && (jCTextStyle3 = jCPageTable.getCell(n3, i2).getStyle()) == null) {
                        jCTextStyle3 = jCTextStyle;
                    }
                    jCTextStyle2 = jCTextStyle3;
                    if (object4 instanceof Image) {
                        ((JCFrame)object).embedImage(jCTextStyle2, (Image)object4);
                        continue;
                    }
                    if (object4 instanceof Icon) {
                        ((JCFrame)object).embedIcon(jCTextStyle2, (Icon)object4);
                        continue;
                    }
                    object3 = object4 != null ? object4.toString() : "";
                    ((JCFrame)object).printWithNewlines(jCTextStyle2, (String)object3);
                }
            }
        }
        catch (EndOfFrameException endOfFrameException) {
            // empty catch block
        }
    }
}

