/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class JCPageTableFromJDBC {
    public static JCTextStyle defStyle = null;

    public static JCPageTable createTable(JCDocument jCDocument, ResultSet resultSet) {
        return JCPageTableFromJDBC.createTable(jCDocument, resultSet, true);
    }

    public static JCPageTable createTable(JCDocument jCDocument, ResultSet resultSet, boolean bl) {
        JCPageTable jCPageTable = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Vector<JCUnit.Measure> vector = new Vector<JCUnit.Measure>(resultSetMetaData.getColumnCount());
            for (int i2 = 0; i2 < resultSetMetaData.getColumnCount(); ++i2) {
                int n2 = resultSetMetaData.getColumnDisplaySize(i2 + 1);
                n2 = Math.max(n2, 75);
                JCUnit.Measure measure = new JCUnit.Measure(JCUnit.POINTS, n2);
                vector.add(measure);
            }
            jCPageTable = new JCPageTable(jCDocument, vector);
            jCPageTable.setAlignment(4);
            jCPageTable.createHeaders();
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, sQLException.toString(), "SQL error", 0);
            return jCPageTable;
        }
        if (bl) {
            JCPageTableFromJDBC.populateTable(jCPageTable, resultSet);
        }
        return jCPageTable;
    }

    public static void populateTable(JCPageTable jCPageTable, ResultSet resultSet) {
        try {
            try {
                Cloneable cloneable;
                int n2;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                JCPageTable jCPageTable2 = jCPageTable.createHeaders();
                for (n2 = 0; n2 < resultSetMetaData.getColumnCount(); ++n2) {
                    JCTextStyle jCTextStyle = JCPageTableFromJDBC.deriveCellStyle(jCPageTable2.getCell(0, n2));
                    cloneable = jCPageTable2.getCellFrame(0, n2);
                    cloneable.printWithNewlines(jCTextStyle, resultSetMetaData.getColumnLabel(n2 + 1));
                }
                n2 = 0;
                while (resultSet.next()) {
                    for (int i2 = 0; i2 < resultSetMetaData.getColumnCount(); ++i2) {
                        cloneable = JCPageTableFromJDBC.deriveCellStyle(jCPageTable.getCell(n2, i2));
                        JCFrame jCFrame = jCPageTable.getCellFrame(n2, i2);
                        String string = resultSet.getString(i2 + 1);
                        jCFrame.printWithNewlines((JCTextStyle)cloneable, string);
                    }
                    ++n2;
                }
            }
            catch (SQLException sQLException) {
                JOptionPane.showMessageDialog(null, sQLException.toString(), "SQL error", 0);
            }
        }
        catch (EndOfFrameException endOfFrameException) {
            // empty catch block
        }
    }

    protected static JCTextStyle deriveCellStyle(JCPageTable.Cell cell) {
        JCTextStyle jCTextStyle = null;
        if (defStyle == null) {
            defStyle = JCTextStyle.stringToStyle("default text");
        }
        if (cell != null) {
            jCTextStyle = cell.getStyle();
        }
        if (jCTextStyle == null) {
            jCTextStyle = defStyle;
        }
        return jCTextStyle;
    }
}

