/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.FontBase;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCFlow;
import com.klg.jclass.page.JCFlowInfo;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCTab;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.Markup;
import com.klg.jclass.page.PageArea;
import com.klg.jclass.page.TextMacro;
import com.klg.jclass.page.render.ArcRender;
import com.klg.jclass.page.render.BoxRender;
import com.klg.jclass.page.render.Embedable;
import com.klg.jclass.page.render.Floatable;
import com.klg.jclass.page.render.HRuleMarker;
import com.klg.jclass.page.render.ImageMarker;
import com.klg.jclass.page.render.ImageRender;
import com.klg.jclass.page.render.LineRender;
import com.klg.jclass.page.render.MacroRender;
import com.klg.jclass.page.render.Render;
import com.klg.jclass.page.render.RoundRectRender;
import com.klg.jclass.page.render.Splitable;
import com.klg.jclass.page.render.StringRender;
import com.klg.jclass.page.render.SymbolRender;
import com.klg.jclass.page.render.TableMarker;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.swing.JCSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class JCFrame
extends PageArea
implements Cloneable,
Floatable {
    protected static JCUnit.Measure FLEXIBLE_SIZE = new JCUnit.Measure(JCUnit.INTERNAL, 10000.0);
    protected JCDrawStyle border;
    protected int columnCount = 1;
    protected JCUnit.Measure columnSpace = new JCUnit.Measure(JCUnit.INTERNAL, 0.25);
    protected JCUnit.Measure columnWidth;
    protected JCUnit.Margins margin = new JCUnit.Margins();
    protected List renderList;
    protected JCUnit.Margins clipMask;
    protected JCUnit.Measure yExtent;
    protected JCFlowInfo info;
    protected int floatAlignment;
    protected JCPage page;
    public static final String HEADER = "header";
    public static final String FOOTER = "footer";

    public JCFrame() {
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public JCFrame(JCDocument jCDocument) {
        super(jCDocument);
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public JCFrame(String string) {
        super(string);
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public JCFrame(String string, JCDocument jCDocument) {
        super(string, jCDocument);
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public JCFrame(String string, JCUnit.Point point, JCUnit.Dimension dimension) {
        super(string, point, dimension);
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.computeColumnWidth();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public JCFrame(String string, JCDocument jCDocument, JCUnit.Point point, JCUnit.Dimension dimension) {
        super(string, jCDocument, point, dimension);
        this.border = JCDrawStyle.stringToStyle("default blank");
        this.columnWidth = new JCUnit.Measure();
        this.computeColumnWidth();
        this.info = new JCFlowInfo();
        this.renderList = new Vector();
        this.yExtent = new JCUnit.Measure();
        this.clipMask = null;
    }

    public int getAlignment() {
        return this.floatAlignment;
    }

    public void setAlignment(int n2) {
        if (n2 <= 0 || n2 > 5) {
            throw new IllegalArgumentException("Unrecognised horizontal alignment");
        }
        this.floatAlignment = n2;
    }

    public JCDrawStyle getBorder() {
        return this.border;
    }

    public void setBorder(JCDrawStyle jCDrawStyle) {
        if (jCDrawStyle == null) {
            throw new IllegalArgumentException("border style must be non-null");
        }
        this.border = jCDrawStyle = jCDrawStyle.getImmutable();
    }

    public JCUnit.Margins getClipMask() {
        return this.clipMask;
    }

    public void setClipMask(JCUnit.Margins margins) {
        JCUnit.Measure measure;
        JCUnit.Margins margins2 = (JCUnit.Margins)margins.clone();
        JCUnit.Measure measure2 = margins2.getLeft();
        JCUnit.Measure measure3 = margins2.getRight();
        measure3.add(measure2);
        if (measure2.isNegative()) {
            margins2.setLeft(new JCUnit.Measure());
            measure2 = margins2.getLeft();
        }
        if (measure3.greaterThan(measure = this.size.getWidth())) {
            measure.subtract(measure2);
            margins2.setRight(measure);
        } else {
            margins2.setRight(measure3);
        }
        measure2 = margins2.getTop();
        measure3 = margins2.getBottom();
        measure3.add(measure2);
        if (measure2.isNegative()) {
            margins2.setTop(new JCUnit.Measure());
            measure2 = margins2.getTop();
        }
        if (measure3.greaterThan(measure = this.size.getHeight())) {
            measure.subtract(measure2);
            margins2.setBottom(measure);
        } else {
            margins2.setBottom(measure3);
        }
        this.clipMask = margins2;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Number of columns must be >= 1");
        }
        if (this.columnCount != n2) {
            this.columnCount = n2;
            this.computeColumnWidth();
        }
    }

    public JCUnit.Measure getColumnWidth() {
        return this.columnWidth;
    }

    public JCUnit.Measure getColumnSpace() {
        return this.columnSpace;
    }

    public void setColumnSpace(JCUnit.Measure measure) {
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Column spacing must be >= 0");
        }
        if (this.columnSpace.internal() != measure.internal()) {
            this.columnSpace = measure;
            this.computeColumnWidth();
        }
    }

    public JCUnit.Margins getMargins() {
        return (JCUnit.Margins)this.margin.clone();
    }

    public void setMargins(JCUnit.Margins margins) {
        if (margins.top < 0.0 || margins.bottom < 0.0 || margins.left < 0.0 || margins.right < 0.0) {
            throw new IllegalArgumentException("Margin width must be >= 0");
        }
        JCUnit.Measure measure = this.size.getWidth();
        measure.subtract(margins.getLeft());
        measure.subtract(margins.getRight());
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Margins can't be wider than the frame");
        }
        JCUnit.Measure measure2 = this.size.getHeight();
        measure2.subtract(margins.getTop());
        measure2.subtract(margins.getBottom());
        if (measure2.isNegative()) {
            throw new IllegalArgumentException("Margins can't be taller than the frame");
        }
        boolean bl = !this.margin.getLeft().equals(margins.getLeft()) || !this.margin.getRight().equals(margins.getRight());
        this.margin = (JCUnit.Margins)margins.clone();
        if (bl) {
            this.computeColumnWidth();
        }
    }

    public void setPage(JCPage jCPage) {
        this.page = jCPage;
        int n2 = this.frameList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JCFrame jCFrame = (JCFrame)this.frameList.get(i2);
            jCFrame.setPage(jCPage);
        }
    }

    public void setSize(JCUnit.Dimension dimension) {
        if (dimension.width < 0.0 || dimension.height < 0.0) {
            throw new IllegalArgumentException("Dimensions must be non-negative");
        }
        this.size = (JCUnit.Dimension)dimension.clone();
        this.computeColumnWidth();
        if (this.clipMask != null) {
            JCUnit.Measure measure = this.clipMask.getLeft();
            JCUnit.Measure measure2 = this.clipMask.getRight();
            if (measure.isNegative()) {
                measure2.add(measure);
                this.clipMask.setLeft(new JCUnit.Measure());
            }
            if (measure2.greaterThan(dimension.getWidth())) {
                this.clipMask.setRight(dimension.getWidth());
            }
            measure = this.clipMask.getTop();
            measure2 = this.clipMask.getBottom();
            if (measure.isNegative()) {
                measure2.add(measure);
                this.clipMask.setTop(new JCUnit.Measure());
            }
            if (measure2.greaterThan(dimension.getWidth())) {
                this.clipMask.setBottom(dimension.getWidth());
            }
        }
    }

    public JCFlowInfo getInfo() {
        return this.info;
    }

    public void print(JCTextStyle jCTextStyle, String string) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle = jCTextStyle.getImmutable();
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        StringRender stringRender = new StringRender(graphics2D, string, jCTextStyle);
        this.flowPrint(graphics2D, stringRender, false);
    }

    public void print(JCTextStyle jCTextStyle, TextMacro textMacro) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle = jCTextStyle.getImmutable();
        textMacro.evaluate(null, this.page);
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        MacroRender macroRender = new MacroRender(graphics2D, textMacro, jCTextStyle);
        this.flowPrint(graphics2D, macroRender, false);
    }

    public void print(JCTextStyle jCTextStyle, MacroRender macroRender) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle = jCTextStyle.getImmutable();
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.flowPrint(graphics2D, macroRender, false);
    }

    public void print(JCTextStyle jCTextStyle, String string, JCUnit.Point point) {
        this.info.currentTextStyle = jCTextStyle = jCTextStyle.getImmutable();
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        StringRender stringRender = new StringRender(graphics2D, string, jCTextStyle);
        stringRender.setLocation(point);
        this.renderList.add(stringRender);
    }

    protected void printWithNewlines(JCTextStyle jCTextStyle, String string) throws EndOfFrameException {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.print(jCTextStyle, stringTokenizer.nextToken());
            this.newLine(jCTextStyle);
        }
    }

    public void print(JCPageTable jCPageTable) throws EndOfFrameException {
        this.renderList.add(new TableMarker(jCPageTable, this.info.currentTextStyle));
        this.print(jCPageTable, 0, 0);
    }

    public void print(JCPageTable jCPageTable, int n2, int n3) throws EndOfFrameException {
        int n4 = jCPageTable.getRowCount() - 1;
        int n5 = jCPageTable.getColumnCount() - 1;
        this.print(jCPageTable, n2, n3, n4, n5);
    }

    public void print(JCPageTable jCPageTable, int n2, int n3, int n4, int n5) throws EndOfFrameException {
        JCUnit.Measure measure;
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        this.renderList.add(new TableMarker(jCPageTable, this.info.currentTextStyle, n2, n3));
        jCPageTable.completeLayout();
        if (n4 == -1) {
            JCPageTable jCPageTable2;
            int n6;
            if (jCPageTable.hasHeaders() && (n6 = (jCPageTable2 = jCPageTable.getHeaders()).getRowCount() - 1) != -1) {
                this.print(jCPageTable2, 0, n3);
            }
            return;
        }
        JCUnit.Measure measure2 = jCPageTable.getColumnRangeWidth(n3, n5);
        JCUnit.Measure measure3 = jCPageTable.getRowRangeHeight(n2, n4);
        if (jCPageTable.hasHeaders()) {
            JCPageTable jCPageTable3 = jCPageTable.getHeaders();
            int n7 = jCPageTable3.getRowCount() - 1;
            measure = jCPageTable3.getRowRangeHeight(0, n7);
        } else {
            measure = new JCUnit.Measure();
        }
        if (this.info.currentTextStyle == null) {
            this.info.currentTextStyle = JCTextStyle.DEFAULT_TEXT;
        }
        if (this.info.currentLine.size() != 0) {
            this.doLineBreak(this.info.currentTextStyle, false);
        }
        JCUnit.Measure measure4 = this.size.getHeight();
        JCUnit.Measure measure5 = (JCUnit.Measure)measure4.clone();
        measure5.subtract(this.info.insertion.getY());
        measure5.subtract(this.margin.getBottom());
        int n8 = n3;
        int n9 = n5;
        JCUnit.Measure measure6 = (JCUnit.Measure)measure2.clone();
        int n10 = jCPageTable.getOverflowMode();
        if (this.columnWidth.lessThan(measure2) && n10 != 1) {
            n9 = jCPageTable.getColumnSet(n8, this.columnWidth, measure6);
        }
        int n11 = n2;
        JCUnit.Measure measure7 = (JCUnit.Measure)measure3.clone();
        JCUnit.Measure measure8 = (JCUnit.Measure)measure3.clone();
        JCUnit.Measure measure9 = (JCUnit.Measure)measure5.clone();
        measure9.subtract(measure);
        while (measure7.distance > 0.0) {
            int n12 = jCPageTable.getRowSet(n11, measure9, measure8);
            if (n12 > n4) {
                n12 = n4;
            }
            JCUnit.Measure measure10 = this.margin.getTop();
            measure10.add(this.getFirstLineOffset(this.info.currentTextStyle));
            if (measure8.greaterThan(measure9) && (n11 + 1 < n12 || this.info.insertion.getY().greaterThan(measure10))) {
                try {
                    this.newColumn(this.info.currentTextStyle, false);
                }
                catch (EndOfFrameException endOfFrameException) {
                    if (n11 == n2) {
                        endOfFrameException.setTableFlow(jCPageTable, n11, n8);
                    } else {
                        endOfFrameException.setTableFlow(jCPageTable, n11, n8, n9);
                    }
                    throw endOfFrameException;
                }
                measure5 = (JCUnit.Measure)measure4.clone();
                measure5.subtract(this.info.insertion.getY());
                measure5.subtract(this.margin.getBottom());
                measure9 = (JCUnit.Measure)measure5.clone();
                measure9.subtract(measure);
                continue;
            }
            jCPageTable.drawTablePart(this, n11, n8, n12, n9, measure, measure8, measure6);
            JCUnit.Measure measure11 = this.info.insertion.getY();
            measure11.add(measure8);
            measure11.add(measure);
            measure11.add(this.getFirstLineOffset(this.info.currentTextStyle));
            this.info.insertion.setY(measure11);
            n11 = n12 + 1;
            if (n11 <= n4) {
                measure7 = jCPageTable.getRowRangeHeight(n11, n4);
                try {
                    this.newColumn(this.info.currentTextStyle, false);
                }
                catch (EndOfFrameException endOfFrameException) {
                    if (n11 == n2) {
                        endOfFrameException.setTableFlow(jCPageTable, n11, n8);
                    } else {
                        endOfFrameException.setTableFlow(jCPageTable, n11, n8, n9);
                    }
                    throw endOfFrameException;
                }
                measure5 = (JCUnit.Measure)measure4.clone();
                measure5.subtract(this.info.insertion.getY());
                measure5.subtract(this.margin.getBottom());
            } else if (n9 < n5 && n10 == 2) {
                n8 = n9 + 1;
                n9 = jCPageTable.getColumnSet(n8, this.columnWidth, measure6);
                n11 = n2;
                measure7 = measure3;
                measure5 = (JCUnit.Measure)measure4.clone();
                measure5.subtract(this.info.insertion.getY());
                measure5.subtract(this.margin.getBottom());
            } else if (n9 < n5 && n10 == 4) {
                n8 = n9 + 1;
                n9 = jCPageTable.getColumnSet(n8, this.columnWidth, measure6);
                n11 = n2;
                measure7 = measure3;
                try {
                    this.newColumn(this.info.currentTextStyle, false);
                }
                catch (EndOfFrameException endOfFrameException) {
                    if (n11 == n2) {
                        endOfFrameException.setTableFlow(jCPageTable, n11, n8);
                    } else {
                        endOfFrameException.setTableFlow(jCPageTable, n11, n8, n9);
                    }
                    throw endOfFrameException;
                }
                measure5 = (JCUnit.Measure)measure4.clone();
                measure5.subtract(this.info.insertion.getY());
                measure5.subtract(this.margin.getBottom());
            } else {
                measure7.distance = 0.0;
            }
            measure9 = (JCUnit.Measure)measure5.clone();
            measure9.subtract(measure);
        }
    }

    public void tab(JCTextStyle jCTextStyle) {
        JCTab jCTab = null;
        JCUnit.Measure measure = null;
        this.info.currentTextStyle = jCTextStyle = jCTextStyle.getImmutable();
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        if (this.info.currentLine.size() == 0 && this.info.firstLine) {
            this.computeLineBounds(jCTextStyle, this.info.firstLine);
            this.info.insertion.setX(this.info.lineBegin);
        }
        JCUnit.Measure measure2 = this.info.insertion.getX();
        for (JCTab jCTab2 : jCTextStyle.getTabs()) {
            measure = (JCUnit.Measure)jCTab2.getPosition().clone();
            measure.add(this.info.leftOfColumn);
            if (!measure.greaterThan(measure2)) continue;
            jCTab = jCTab2;
            break;
        }
        if (jCTab == null || measure.greaterThan(this.info.lineEnd)) {
            SymbolRender symbolRender = new SymbolRender(1, jCTextStyle);
            symbolRender.setLeaderFill(1);
            this.info.currentLine.add(symbolRender);
            JCUnit.Measure measure3 = this.info.insertion.getY();
            measure3.add(this.info.ascender);
            JCUnit.Point point = (JCUnit.Point)this.info.insertion.clone();
            point.setY(measure3);
            symbolRender.setLocation(point);
            this.doLineBreak(jCTextStyle, false);
            return;
        }
        this.info.insertion.setX(measure);
        this.info.currentTab = jCTab;
        this.info.tabUsed = true;
        this.info.tabIndex = this.info.currentLine.size() + 1;
        SymbolRender symbolRender = new SymbolRender(1, jCTextStyle);
        JCUnit.Measure measure4 = this.info.insertion.getY();
        measure4.add(this.info.ascender);
        JCUnit.Point point = (JCUnit.Point)this.info.insertion.clone();
        point.setY(measure4);
        symbolRender.setLocation(point);
        symbolRender.setLeaderStart(measure2);
        symbolRender.setLeaderEnd(this.info.insertion.getX());
        symbolRender.setLeaderFill(jCTab.getTabFill());
        symbolRender.setAlignment(jCTab.getTabAlignment());
        this.info.currentLine.add(symbolRender);
        this.info.tabSymbol = symbolRender;
    }

    public JCTab nextTab(JCTextStyle jCTextStyle) {
        JCTab jCTab = null;
        jCTextStyle = jCTextStyle.getImmutable();
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        JCUnit.Measure measure = this.info.insertion.getX();
        for (JCTab jCTab2 : jCTextStyle.getTabs()) {
            JCUnit.Measure measure2 = jCTab2.getPosition();
            measure2.add(this.info.leftOfColumn);
            if (!measure2.greaterThan(measure)) continue;
            jCTab = jCTab2;
            break;
        }
        return jCTab;
    }

    public void floatImage(Image image) {
        ImageIcon imageIcon = new ImageIcon(image);
        this.floatImage(image, 4, new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight()));
    }

    public void floatImage(Image image, int n2) {
        ImageIcon imageIcon = new ImageIcon(image);
        this.floatImage(image, n2, new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight()));
    }

    public void floatImage(Image image, JCUnit.Dimension dimension) {
        this.floatImage(image, 4, dimension);
    }

    public void floatImage(Image image, int n2, JCUnit.Dimension dimension) {
        int n3 = new Double(this.columnWidth.getAs(JCUnit.POINTS)).intValue();
        int n4 = new Double(dimension.getWidth().getAs(JCUnit.POINTS)).intValue();
        int n5 = new Double(this.getUseableColumnHeight().getAs(JCUnit.POINTS)).intValue();
        int n6 = new Double(dimension.getHeight().getAs(JCUnit.POINTS)).intValue();
        if (n4 > n3) {
            image = image.getScaledInstance(n3, -1, 4);
            n6 = new ImageIcon(image).getIconHeight();
            n4 = n3;
        }
        if (n6 > n5) {
            image = image.getScaledInstance(-1, n5, 4);
            n6 = n5;
        }
        dimension = new JCUnit.Dimension(JCUnit.POINTS, n4, n6);
        ImageRender imageRender = new ImageRender(image, dimension, n2);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public JCUnit.Measure getUseableColumnHeight() {
        JCUnit.Measure measure = this.size.getHeight();
        measure.subtract(this.getMargins().getTop());
        measure.subtract(this.getMargins().getBottom());
        if (this.info != null && this.info.currentTextStyle != null) {
            double d2 = this.info.currentTextStyle.getPointSize();
            measure.subtract(new JCUnit.Measure(JCUnit.POINTS, d2));
        }
        return measure;
    }

    public void floatIcon(Icon icon) {
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, icon.getIconWidth(), icon.getIconHeight());
        this.floatIcon(icon, 4, dimension);
    }

    public void floatIcon(Icon icon, int n2) {
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, icon.getIconWidth(), icon.getIconHeight());
        this.floatIcon(icon, n2, dimension);
    }

    public void floatIcon(Icon icon, JCUnit.Dimension dimension) {
        this.floatIcon(icon, 4, dimension);
    }

    public void floatIcon(Icon icon, int n2, JCUnit.Dimension dimension) {
        Object object;
        if (!(icon instanceof ImageIcon)) {
            throw new IllegalArgumentException("Unknown Icon Type");
        }
        int n3 = new Double(this.columnWidth.getAs(JCUnit.POINTS)).intValue();
        int n4 = new Double(dimension.getWidth().getAs(JCUnit.POINTS)).intValue();
        int n5 = new Double(this.getUseableColumnHeight().getAs(JCUnit.POINTS)).intValue();
        int n6 = new Double(dimension.getHeight().getAs(JCUnit.POINTS)).intValue();
        if (n4 > n3) {
            object = ((ImageIcon)icon).getImage();
            object = ((Image)object).getScaledInstance(n3, -1, 4);
            icon = new ImageIcon((Image)object);
            n6 = icon.getIconHeight();
            n4 = n3;
        }
        if (n6 > n5) {
            object = ((ImageIcon)icon).getImage();
            object = ((Image)object).getScaledInstance(-1, n5, 4);
            icon = new ImageIcon((Image)object);
            n6 = n5;
        }
        dimension = new JCUnit.Dimension(JCUnit.POINTS, n4, n6);
        object = new ImageRender(icon, dimension, n2);
        this.renderList.add(new ImageMarker((ImageRender)object));
        this.addFloat((ImageRender)object);
    }

    public void floatComponent(Component component) {
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, component.getWidth(), component.getHeight());
        this.floatComponent(component, 4, dimension);
    }

    public void floatComponent(Component component, int n2) {
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, component.getWidth(), component.getHeight());
        this.floatComponent(component, n2, dimension);
    }

    public void floatComponent(Component component, JCUnit.Dimension dimension) {
        this.floatComponent(component, 4, dimension);
    }

    public void floatComponent(Component component, int n2, JCUnit.Dimension dimension) {
        double d2;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.sizeComponent(component, graphics2D, (int)JCUnit.getAsPoints(dimension.units, dimension.width), (int)JCUnit.getAsPoints(dimension.units, dimension.height));
        int n3 = new Double(this.columnWidth.getAs(JCUnit.POINTS)).intValue();
        int n4 = new Double(dimension.getWidth().getAs(JCUnit.POINTS)).intValue();
        int n5 = new Double(this.getUseableColumnHeight().getAs(JCUnit.POINTS)).intValue();
        int n6 = new Double(dimension.getHeight().getAs(JCUnit.POINTS)).intValue();
        if (n4 > n3) {
            d2 = n3 / n4;
            component.setSize(n3, new Double((double)n5 * d2).intValue());
            n6 = component.getHeight();
            n4 = n3;
        }
        if (n6 > n5) {
            d2 = n5 / n6;
            component.setSize(new Double((double)n3 * d2).intValue(), n5);
            n6 = n5;
            n4 = component.getWidth();
        }
        dimension = new JCUnit.Dimension(JCUnit.POINTS, n4, n6);
        ImageRender imageRender = new ImageRender(component, dimension, n2);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    public void floatEPS(EPSImage ePSImage) {
        JCUnit.Dimension dimension = ePSImage.getSize();
        double d2 = JCUnit.getAsPoints(dimension.units, dimension.width);
        double d3 = JCUnit.getAsPoints(dimension.units, dimension.height);
        dimension = new JCUnit.Dimension(JCUnit.POINTS, d2, d3);
        this.floatEPS(ePSImage, 4, dimension);
    }

    public void floatEPS(EPSImage ePSImage, int n2) {
        JCUnit.Dimension dimension = ePSImage.getSize();
        double d2 = JCUnit.getAsPoints(dimension.units, dimension.width);
        double d3 = JCUnit.getAsPoints(dimension.units, dimension.height);
        dimension = new JCUnit.Dimension(JCUnit.POINTS, d2, d3);
        this.floatEPS(ePSImage, n2, dimension);
    }

    public void floatEPS(EPSImage ePSImage, JCUnit.Dimension dimension) {
        this.floatEPS(ePSImage, 4, dimension);
    }

    public void floatEPS(EPSImage ePSImage, int n2, JCUnit.Dimension dimension) {
        double d2;
        int n3 = new Double(this.columnWidth.getAs(JCUnit.POINTS)).intValue();
        int n4 = new Double(dimension.getWidth().getAs(JCUnit.POINTS)).intValue();
        int n5 = new Double(this.getUseableColumnHeight().getAs(JCUnit.POINTS)).intValue();
        int n6 = new Double(dimension.getHeight().getAs(JCUnit.POINTS)).intValue();
        if (n4 > n3) {
            d2 = (double)n3 / (double)n4;
            ePSImage = (EPSImage)ePSImage.getScaledInstance(n3, new Double((double)n5 * d2).intValue(), 0);
            n6 = new Double(ePSImage.getHeight(null)).intValue();
            n4 = n3;
        }
        if (n6 > n5) {
            d2 = (double)n5 / (double)n6;
            ePSImage = (EPSImage)ePSImage.getScaledInstance(new Double((double)n3 * d2).intValue(), n5, 0);
            n6 = n5;
            n4 = new Double(ePSImage.getWidth(null)).intValue();
        }
        dimension = new JCUnit.Dimension(JCUnit.POINTS, n4, n6);
        ImageRender imageRender = new ImageRender(ePSImage, dimension, n2);
        this.renderList.add(new ImageMarker(imageRender));
        this.addFloat(imageRender);
    }

    protected void addFloat(ImageRender imageRender) {
        this.info.floatList.add(imageRender);
        if (this.info.currentLine == null || this.info.currentLine.size() == 0) {
            this.pasteFloats();
        }
    }

    public void embedImage(JCTextStyle jCTextStyle, Image image) throws EndOfFrameException {
        ImageIcon imageIcon = new ImageIcon(image);
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        this.embedImage(jCTextStyle, image, 4, dimension);
    }

    public void embedImage(JCTextStyle jCTextStyle, Image image, int n2) throws EndOfFrameException {
        ImageIcon imageIcon = new ImageIcon(image);
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        this.embedImage(jCTextStyle, image, n2, dimension);
    }

    public void embedImage(JCTextStyle jCTextStyle, Image image, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.embedImage(jCTextStyle, image, 4, dimension);
    }

    public void embedImage(JCTextStyle jCTextStyle, Image image, int n2, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)image, dimension);
        imageRender.setScaleImage(!this.document.getPrinter().isImageScalable());
        imageRender.setVerticalAlignment(n2);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedIcon(JCTextStyle jCTextStyle, Icon icon) throws EndOfFrameException {
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, icon.getIconWidth(), icon.getIconHeight());
        this.embedIcon(jCTextStyle, icon, 4, dimension);
    }

    public void embedIcon(JCTextStyle jCTextStyle, Icon icon, int n2) throws EndOfFrameException {
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, icon.getIconWidth(), icon.getIconHeight());
        this.embedIcon(jCTextStyle, icon, n2, dimension);
    }

    public void embedIcon(JCTextStyle jCTextStyle, Icon icon, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.embedIcon(jCTextStyle, icon, 4, dimension);
    }

    public void embedIcon(JCTextStyle jCTextStyle, Icon icon, int n2, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)icon, dimension);
        imageRender.setScaleImage(!this.document.getPrinter().isImageScalable());
        imageRender.setVerticalAlignment(n2);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void embedComponent(JCTextStyle jCTextStyle, Component component) throws EndOfFrameException {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        JCUnit.Dimension dimension = this.sizeComponent(component, graphics2D, 0, 0);
        this.embedComponent(jCTextStyle, component, 4, dimension);
    }

    public void embedComponent(JCTextStyle jCTextStyle, Component component, int n2) throws EndOfFrameException {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        JCUnit.Dimension dimension = this.sizeComponent(component, graphics2D, 0, 0);
        this.embedComponent(jCTextStyle, component, n2, dimension);
    }

    public void embedComponent(JCTextStyle jCTextStyle, Component component, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.embedComponent(jCTextStyle, component, 4, dimension);
    }

    public void embedComponent(JCTextStyle jCTextStyle, Component component, int n2, JCUnit.Dimension dimension) throws EndOfFrameException {
        double d2;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.info.currentTextStyle = jCTextStyle;
        this.sizeComponent(component, graphics2D, (int)JCUnit.getAsPoints(dimension.units, dimension.width), (int)JCUnit.getAsPoints(dimension.units, dimension.height));
        int n3 = new Double(this.columnWidth.getAs(JCUnit.POINTS)).intValue();
        int n4 = new Double(dimension.getWidth().getAs(JCUnit.POINTS)).intValue();
        int n5 = new Double(this.getUseableColumnHeight().getAs(JCUnit.POINTS)).intValue();
        int n6 = new Double(dimension.getHeight().getAs(JCUnit.POINTS)).intValue();
        if (n4 > n3) {
            d2 = (double)n3 / (double)n4;
            component.setSize(n3, new Double((double)n5 * d2).intValue());
            n6 = component.getHeight();
            n4 = n3;
        }
        if (n6 > n5) {
            d2 = (double)n5 / (double)n6;
            component.setSize(new Double((double)n3 * d2).intValue(), n5);
            n6 = n5;
            n4 = component.getWidth();
        }
        dimension = new JCUnit.Dimension(JCUnit.POINTS, n4, n6);
        ImageRender imageRender = new ImageRender((Object)component, dimension);
        imageRender.setVerticalAlignment(n2);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    protected JCUnit.Dimension sizeComponent(Component component, Graphics graphics, int n2, int n3) {
        int n4 = component.getWidth();
        int n5 = component.getHeight();
        if (n4 == 0 || n5 == 0) {
            Object object;
            if (!component.isShowing() && component instanceof ServerRenderable) {
                object = (ServerRenderable)((Object)component);
                object.setGraphics(graphics);
            }
            object = component instanceof JComponent ? JCSwingUtilities.getPreferredSizeFromGraphics((JComponent)component, graphics, false) : component.getPreferredSize();
            n4 = n2 == 0 ? ((Dimension)object).width : n2;
            n5 = n3 == 0 ? ((Dimension)object).height : n3;
            component.setSize(n4, n5);
        }
        return new JCUnit.Dimension(JCUnit.POINTS, n4, n5);
    }

    public void embedEPS(JCTextStyle jCTextStyle, EPSImage ePSImage) throws EndOfFrameException {
        JCUnit.Dimension dimension = ePSImage.getSize();
        double d2 = JCUnit.getAsPoints(dimension.units, dimension.width);
        double d3 = JCUnit.getAsPoints(dimension.units, dimension.height);
        dimension = new JCUnit.Dimension(JCUnit.POINTS, d2, d3);
        this.embedEPS(jCTextStyle, ePSImage, 4, dimension);
    }

    public void embedEPS(JCTextStyle jCTextStyle, EPSImage ePSImage, int n2) throws EndOfFrameException {
        JCUnit.Dimension dimension = ePSImage.getSize();
        double d2 = JCUnit.getAsPoints(dimension.units, dimension.width);
        double d3 = JCUnit.getAsPoints(dimension.units, dimension.height);
        dimension = new JCUnit.Dimension(JCUnit.POINTS, d2, d3);
        this.embedEPS(jCTextStyle, ePSImage, n2, dimension);
    }

    public void embedEPS(JCTextStyle jCTextStyle, EPSImage ePSImage, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.embedEPS(jCTextStyle, ePSImage, 4, dimension);
    }

    public void embedEPS(JCTextStyle jCTextStyle, EPSImage ePSImage, int n2, JCUnit.Dimension dimension) throws EndOfFrameException {
        this.info.currentTextStyle = jCTextStyle;
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        ImageRender imageRender = new ImageRender((Object)ePSImage, dimension);
        imageRender.setVerticalAlignment(n2);
        this.renderList.add(new ImageMarker(imageRender, true));
        this.flowPrint(graphics2D, imageRender, false);
    }

    public void pasteImage(Image image, JCUnit.Point point) {
        ImageIcon imageIcon = new ImageIcon(image);
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        ImageRender imageRender = new ImageRender(image, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteImage(Image image, JCUnit.Dimension dimension, JCUnit.Point point) {
        ImageRender imageRender = new ImageRender(image, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteIcon(Icon icon, JCUnit.Point point) {
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, icon.getIconWidth(), icon.getIconHeight());
        ImageRender imageRender = new ImageRender(icon, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteIcon(Icon icon, JCUnit.Dimension dimension, JCUnit.Point point) {
        ImageRender imageRender = new ImageRender(icon, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteComponent(Component component, JCUnit.Point point) {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.sizeComponent(component, graphics2D, 0, 0);
        JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, component.getWidth(), component.getHeight());
        ImageRender imageRender = new ImageRender(component, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteComponent(Component component, JCUnit.Dimension dimension, JCUnit.Point point) {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.sizeComponent(component, graphics2D, (int)JCUnit.getAsPoints(dimension.units, dimension.width), (int)JCUnit.getAsPoints(dimension.units, dimension.height));
        ImageRender imageRender = new ImageRender(component, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteEPS(EPSImage ePSImage, JCUnit.Point point) {
        JCUnit.Dimension dimension = ePSImage.getSize();
        double d2 = JCUnit.getAsPoints(dimension.units, dimension.width);
        double d3 = JCUnit.getAsPoints(dimension.units, dimension.height);
        dimension = new JCUnit.Dimension(JCUnit.POINTS, d2, d3);
        ImageRender imageRender = new ImageRender(ePSImage, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void pasteEPS(EPSImage ePSImage, JCUnit.Dimension dimension, JCUnit.Point point) {
        ImageRender imageRender = new ImageRender(ePSImage, dimension, 4);
        imageRender.setLocation(point);
        this.renderList.add(imageRender);
    }

    public void hRule(JCTextStyle jCTextStyle, JCDrawStyle jCDrawStyle, double d2) throws EndOfFrameException {
        jCTextStyle = jCTextStyle.getImmutable();
        jCDrawStyle = jCDrawStyle.getImmutable();
        JCUnit.Measure measure = (JCUnit.Measure)this.info.rightOfColumn.clone();
        measure.subtract(this.info.leftOfColumn);
        measure.multiply(d2 / 100.0);
        this.hRule(jCTextStyle, jCDrawStyle, measure);
    }

    public void hRule(JCTextStyle jCTextStyle, JCDrawStyle jCDrawStyle, JCUnit.Measure measure) throws EndOfFrameException {
        JCUnit.Measure measure2;
        JCUnit.Measure measure3;
        this.renderList.add(new HRuleMarker(jCTextStyle, jCDrawStyle, measure));
        jCTextStyle = jCTextStyle.getImmutable();
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        if (this.info.currentLine.size() != 0) {
            this.doLineBreak(jCTextStyle, false);
        }
        switch (jCTextStyle.getAlignment()) {
            case 3: {
                measure3 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                measure2 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                measure2.subtract(measure);
                if (!measure2.lessThan(this.info.leftOfColumn)) break;
                measure2 = (JCUnit.Measure)this.info.leftOfColumn.clone();
                break;
            }
            case 4: 
            case 5: {
                measure2 = (JCUnit.Measure)this.info.leftOfColumn.clone();
                measure2.add(this.info.rightOfColumn);
                measure2.subtract(measure);
                measure2.divide(2.0);
                measure3 = (JCUnit.Measure)measure2.clone();
                measure3.add(measure);
                if (measure2.lessThan(this.info.leftOfColumn)) {
                    measure2 = (JCUnit.Measure)this.info.leftOfColumn.clone();
                }
                if (!measure3.greaterThan(this.info.rightOfColumn)) break;
                measure3 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                break;
            }
            case 1: 
            case 2: {
                measure2 = (JCUnit.Measure)this.info.leftOfColumn.clone();
                measure3 = (JCUnit.Measure)measure2.clone();
                measure3.add(measure);
                if (!measure3.greaterThan(this.info.rightOfColumn)) break;
                measure3 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid text alignment");
            }
        }
        JCUnit.Measure measure4 = this.info.insertion.getY();
        JCUnit.Measure measure5 = jCDrawStyle.getDrawnWidth();
        JCUnit.Measure measure6 = (JCUnit.Measure)measure5.clone();
        measure6.multiply(2.0);
        measure6.add(measure4);
        JCUnit.Measure measure7 = this.size.getHeight();
        measure7.subtract(this.margin.getBottom());
        if (measure6.greaterThan(measure7)) {
            this.newColumn(jCTextStyle, false);
            measure4 = this.info.insertion.getY();
        }
        measure5.multiply(1.5);
        measure4.add(measure5);
        JCUnit.Point point = new JCUnit.Point(measure2.units, measure2.distance, 0.0);
        point.setY(measure4);
        JCUnit.Point point2 = new JCUnit.Point(measure3.units, measure3.distance, 0.0);
        point2.setY(measure4);
        this.drawLine(jCDrawStyle, point, point2);
        JCUnit.Measure measure8 = new JCUnit.Measure(JCUnit.POINTS, 2.0);
        if (measure5.lessThan(measure8)) {
            measure4.add(measure8);
        } else {
            measure4.add(measure5);
        }
        this.info.insertion.setY(measure4);
    }

    public void newLine(JCTextStyle jCTextStyle) {
        SymbolRender symbolRender = new SymbolRender(2, jCTextStyle);
        symbolRender.setLocation(this.info.insertion);
        this.info.currentLine.add(symbolRender);
        this.doLineBreak(jCTextStyle, false);
    }

    public void newParagraph(JCTextStyle jCTextStyle) {
        SymbolRender symbolRender = new SymbolRender(3, jCTextStyle);
        symbolRender.setLocation(this.info.insertion);
        this.info.currentLine.add(symbolRender);
        this.doLineBreak(jCTextStyle, true);
    }

    protected void newLine(JCTextStyle jCTextStyle, boolean bl) {
        if (bl) {
            this.newParagraph(jCTextStyle);
        } else {
            this.newLine(jCTextStyle);
        }
    }

    protected void doLineBreak(JCTextStyle jCTextStyle, boolean bl) {
        this.doLineBreak(jCTextStyle, bl, false);
    }

    protected void doLineBreak(JCTextStyle jCTextStyle, boolean bl, boolean bl2) {
        JCUnit.Measure measure;
        JCUnit.Measure measure2;
        Render render;
        int n2;
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        jCTextStyle = jCTextStyle.getImmutable();
        int n3 = jCTextStyle.getAlignment();
        if (this.info.tabUsed) {
            n3 = 1;
        }
        if ((n2 = this.info.currentLine.size()) > 0 && (n3 == 4 || n3 == 3 || n3 == 5) && (render = (Render)this.info.currentLine.get(n2 - 1)) instanceof StringRender) {
            ((StringRender)render).trimTrailingWhitespace();
            measure2 = render.getLocation().getX();
            measure2.add(render.getSize().getWidth());
            this.info.insertion.setX(measure2);
        }
        JCUnit.Measure measure3 = (JCUnit.Measure)this.info.rightOfColumn.clone();
        measure3.subtract(this.info.insertion.getX());
        measure3.subtract(jCTextStyle.getRightIndent());
        if (measure3.isZero() || measure3.isNegative()) {
            n3 = 1;
        }
        if (bl && n3 == 5) {
            n3 = 1;
        }
        switch (n3) {
            case 3: 
            case 4: {
                JCUnit.Point point;
                int n4;
                if (n3 == 4) {
                    measure3.divide(2.0);
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    render = (Render)this.info.currentLine.get(n4);
                    point = render.getLocation();
                    measure2 = point.getX();
                    measure2.add(measure3);
                    point.setX(measure2);
                }
                break;
            }
            case 5: {
                JCUnit.Point point;
                int n4;
                int n5 = 0;
                for (n4 = n2 - 1; n4 >= 0; --n4) {
                    render = (Render)this.info.currentLine.get(n4);
                    if (render instanceof StringRender) {
                        List list = ((StringRender)render).splitIntoWords();
                        n5 += list.size();
                        for (int i2 = 0; i2 < list.size(); ++i2) {
                            this.info.currentLine.insertElementAt(list.get(i2), n4 + 1);
                        }
                        this.info.currentLine.remove(n4);
                        continue;
                    }
                    if (render instanceof SymbolRender) continue;
                    ++n5;
                }
                n2 = this.info.currentLine.size();
                if (n5 == 0) break;
                if (n5 == 1) {
                    measure3.divide(2.0);
                    for (n4 = 0; n4 < n2; ++n4) {
                        render = (Render)this.info.currentLine.get(n4);
                        if (render instanceof SymbolRender) continue;
                        point = render.getLocation();
                        measure2 = point.getX();
                        measure2.add(measure3);
                        point.setX(measure2);
                    }
                } else {
                    measure3.divide(n5 - 1);
                    JCUnit.Measure measure4 = (JCUnit.Measure)measure3.clone();
                    boolean bl3 = true;
                    for (n4 = 0; n4 < n2; ++n4) {
                        render = (Render)this.info.currentLine.get(n4);
                        if (render instanceof SymbolRender) continue;
                        if (bl3) {
                            bl3 = false;
                            continue;
                        }
                        point = render.getLocation();
                        measure2 = point.getX();
                        measure2.add(measure4);
                        point.setX(measure2);
                        measure4.add(measure3);
                    }
                }
                break;
            }
        }
        for (Render render2 : this.info.currentLine) {
            this.renderList.add(render2);
        }
        this.info.currentLine.removeAllElements();
        this.computeLineBounds(jCTextStyle, bl);
        this.info.insertion.setX(this.info.lineBegin);
        if (!bl2 || this.info.floatList.size() > 0) {
            measure = new JCUnit.Measure(JCUnit.POINTS, jCTextStyle.getPointSize());
            if (bl) {
                measure.multiply(jCTextStyle.getParagraphSpacing() - 1.0);
            } else {
                measure.multiply(jCTextStyle.getLineSpacing() - 1.0);
            }
        } else {
            measure = new JCUnit.Measure(JCUnit.POINTS, 0.0);
        }
        if (this.info.lineSpacing.isZero()) {
            double d2 = jCTextStyle.getPointSize();
            measure.add(new JCUnit.Measure(JCUnit.POINTS, d2));
            Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(jCTextStyle.getFont());
            d2 -= (double)(fontMetrics.getAscent() + fontMetrics.getDescent());
            if (d2 <= 0.0) {
                d2 = 1.0;
            }
            this.info.leading = new JCUnit.Measure(JCUnit.POINTS, d2);
        } else {
            measure.add(this.info.lineSpacing);
        }
        if (!bl2 || this.info.floatList.size() > 0) {
            measure.add(this.info.leading);
        }
        measure.add(this.info.insertion.getY());
        this.info.insertion.setY(measure);
        this.info.lineSpacing = new JCUnit.Measure(JCUnit.POINTS);
        this.info.ascender = new JCUnit.Measure(JCUnit.POINTS);
        this.info.descender = new JCUnit.Measure(JCUnit.POINTS);
        this.info.leading = new JCUnit.Measure(JCUnit.POINTS);
        this.info.height = new JCUnit.Measure(JCUnit.POINTS);
        this.info.embedAscent = new JCUnit.Measure(JCUnit.POINTS);
        this.info.embedDescent = new JCUnit.Measure(JCUnit.POINTS);
        this.pasteFloats();
        this.info.currentTab = null;
        this.info.tabSymbol = null;
        this.info.tabIndex = -1;
        this.info.tabUsed = false;
    }

    private void computeLineBounds(JCTextStyle jCTextStyle, boolean bl) {
        this.info.lineBegin.assign(this.info.leftOfColumn);
        this.info.lineEnd.assign(this.info.rightOfColumn);
        this.info.lineEnd.subtract(jCTextStyle.getRightIndent());
        if (bl) {
            this.info.lineBegin.add(jCTextStyle.getParagraphIndent());
            this.info.firstLine = true;
        } else {
            this.info.lineBegin.add(jCTextStyle.getLeftIndent());
            this.info.firstLine = false;
        }
        if (!this.info.lineBegin.lessThan(this.info.lineEnd)) {
            this.info.lineBegin.assign(this.info.leftOfColumn);
            this.info.lineEnd.assign(this.info.rightOfColumn);
        }
    }

    public void newColumn(JCTextStyle jCTextStyle) throws EndOfFrameException {
        this.newColumn(jCTextStyle, true);
    }

    private void newColumn(JCTextStyle jCTextStyle, boolean bl) throws EndOfFrameException {
        Object object;
        JCUnit.Measure measure;
        JCUnit.Measure measure2;
        JCUnit.Point point;
        Render render;
        int n2;
        if (bl) {
            this.newLine(jCTextStyle);
        }
        JCUnit.Measure measure3 = this.info.insertion.getY();
        int n3 = this.info.currentLine.size();
        for (n2 = 0; n2 < n3; ++n2) {
            render = (Render)this.info.currentLine.get(n2);
            point = render.getLocation();
            measure2 = point.getX();
            measure2.subtract(this.info.leftOfColumn);
            measure = point.getY();
            measure.subtract(measure3);
            point.setX(measure2);
            point.setY(measure);
            if (!(render instanceof SymbolRender) || ((SymbolRender)(object = (SymbolRender)render)).getType() != 1) continue;
            ((SymbolRender)object).getLeaderStart().subtract(this.info.leftOfColumn);
            ((SymbolRender)object).getLeaderEnd().subtract(this.info.leftOfColumn);
        }
        if (this.info.currentColumn + 1 == this.columnCount) {
            object = new EndOfFrameException(this.info, "Frame end reached");
            this.info.currentLine.clear();
            throw object;
        }
        measure2 = this.info.insertion.getX();
        measure2.subtract(this.info.leftOfColumn);
        ++this.info.currentColumn;
        this.info.leftOfColumn.assign(this.columnWidth);
        this.info.leftOfColumn.add(this.columnSpace);
        this.info.leftOfColumn.multiply(this.info.currentColumn);
        this.info.leftOfColumn.add(this.margin.getLeft());
        this.info.rightOfColumn.assign(this.info.leftOfColumn);
        this.info.rightOfColumn.add(this.columnWidth);
        this.computeLineBounds(jCTextStyle, this.info.firstLine);
        this.info.insertion.setX(this.info.lineBegin);
        measure = this.getFirstLineOffset(jCTextStyle);
        measure.add(this.margin.getTop());
        measure2.add(this.info.leftOfColumn);
        this.info.insertion.setX(measure2);
        this.info.insertion.setY(measure);
        this.pasteFloats();
        measure3 = this.info.insertion.getY();
        n3 = this.info.currentLine.size();
        for (n2 = 0; n2 < n3; ++n2) {
            render = (Render)this.info.currentLine.get(n2);
            point = render.getLocation();
            measure2 = point.getX();
            measure2.add(this.info.leftOfColumn);
            measure = point.getY();
            measure.add(measure3);
            point.setX(measure2);
            point.setY(measure);
            if (!(render instanceof SymbolRender) || ((SymbolRender)(object = (SymbolRender)render)).getType() != 1) continue;
            ((SymbolRender)object).getLeaderStart().add(this.info.leftOfColumn);
            ((SymbolRender)object).getLeaderEnd().add(this.info.leftOfColumn);
        }
    }

    public JCUnit.Measure getFirstLineOffset(JCTextStyle jCTextStyle) {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(jCTextStyle.getFont());
        double d2 = jCTextStyle.getPointSize() - (double)fontMetrics.getAscent() - (double)fontMetrics.getDescent();
        if (d2 <= 0.0) {
            d2 = 1.0;
        }
        return new JCUnit.Measure(JCUnit.POINTS, d2);
    }

    public JCUnit.Point getInsertionPoint() {
        return this.info.insertion;
    }

    public void setInsertionPoint(JCUnit.Point point) {
        if (point == null) {
            return;
        }
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        if (!point.getY().equals(this.info.insertion.getY()) && this.info.currentLine.size() > 0) {
            JCTextStyle jCTextStyle = this.info.currentTextStyle;
            if (jCTextStyle == null) {
                jCTextStyle = JCTextStyle.DEFAULT_TEXT;
            }
            this.doLineBreak(jCTextStyle, false);
        }
        this.info.insertion = (JCUnit.Point)point.clone();
        this.info.firstLine = false;
    }

    public JCUnit.Measure getCurrentAscender() {
        return this.info.ascender;
    }

    public JCUnit.Measure getCurrentDescender() {
        return this.info.descender;
    }

    public JCUnit.Measure getCurrentBaseline() {
        JCUnit.Measure measure = this.info.insertion.getY();
        measure.add(this.info.ascender);
        return measure;
    }

    public int getCurrentColumn() {
        return this.info.currentColumn;
    }

    public JCFlowInfo getFlowInfo() {
        return this.info;
    }

    public void addFloats(List list) {
        this.info.floatList.addAll(list);
    }

    public void setCurrentLine(List list) throws EndOfFrameException {
        Graphics2D graphics2D = (Graphics2D)this.document.getPrinterGraphics();
        this.reflow(graphics2D, list);
        list.clear();
    }

    public void drawCircle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        ArcRender arcRender = new ArcRender(point, measure, 0.0, 360.0, jCDrawStyle);
        this.renderList.add(arcRender);
        JCUnit.Measure measure2 = jCDrawStyle.getDrawnWidth();
        measure2.divide(2.0);
        measure2.add(point.getY());
        measure2.add(measure);
        if (measure2.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure2);
        }
    }

    public void fillCircle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        ArcRender arcRender = new ArcRender(point, measure, 0.0, 360.0, jCDrawStyle);
        arcRender.setFilled(true);
        this.renderList.add(arcRender);
        JCUnit.Measure measure2 = jCDrawStyle.getDrawnWidth();
        measure2.divide(2.0);
        measure2.add(point.getY());
        measure2.add(measure);
        if (measure2.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure2);
        }
    }

    public void drawRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Dimension dimension) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        BoxRender boxRender = new BoxRender(point, dimension, jCDrawStyle);
        this.renderList.add(boxRender);
        JCUnit.Measure measure = jCDrawStyle.getDrawnWidth();
        measure.divide(2.0);
        measure.add(point.getY());
        measure.add(dimension.getHeight());
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void drawRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Point point2) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        BoxRender boxRender = new BoxRender(point, point2, jCDrawStyle);
        this.renderList.add(boxRender);
        JCUnit.Measure measure = point.getY();
        JCUnit.Measure measure2 = point2.getY();
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        if (measure.greaterThan(measure2)) {
            measure3.add(measure);
        } else {
            measure3.add(measure2);
        }
        if (measure3.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure3);
        }
    }

    public void fillRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Dimension dimension) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        BoxRender boxRender = new BoxRender(point, dimension, jCDrawStyle);
        boxRender.setFilled(true);
        this.renderList.add(boxRender);
        JCUnit.Measure measure = jCDrawStyle.getDrawnWidth();
        measure.divide(2.0);
        measure.add(point.getY());
        measure.add(dimension.getHeight());
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void fillRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Point point2) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        BoxRender boxRender = new BoxRender(point, point2, jCDrawStyle);
        boxRender.setFilled(true);
        this.renderList.add(boxRender);
        JCUnit.Measure measure = point.getY();
        JCUnit.Measure measure2 = point2.getY();
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        if (measure.greaterThan(measure2)) {
            measure3.add(measure);
        } else {
            measure3.add(measure2);
        }
        if (measure3.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure3);
        }
    }

    public void drawLine(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Point point2) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        LineRender lineRender = new LineRender(point, point2, jCDrawStyle);
        this.renderList.add(lineRender);
        JCUnit.Measure measure = point.getY();
        JCUnit.Measure measure2 = point2.getY();
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        if (measure.greaterThan(measure2)) {
            measure3.add(measure);
        } else {
            measure3.add(measure2);
        }
        if (measure3.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure3);
        }
    }

    public void drawLine(JCDrawStyle jCDrawStyle, List list) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n2 = list.size();
        JCUnit.Point[] pointArray = new JCUnit.Point[n2];
        JCUnit.Measure measure = new JCUnit.Measure();
        for (int i2 = 0; i2 < n2; ++i2) {
            JCUnit.Point point;
            pointArray[i2] = point = (JCUnit.Point)list.get(i2);
            JCUnit.Measure measure2 = point.getY();
            if (!measure2.greaterThan(measure)) continue;
            measure = measure2;
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void drawLine(JCDrawStyle jCDrawStyle, JCUnit.Point[] pointArray) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n2 = pointArray.length;
        JCUnit.Measure measure = new JCUnit.Measure();
        for (int i2 = 0; i2 < n2; ++i2) {
            JCUnit.Measure measure2 = pointArray[i2].getY();
            if (!measure2.greaterThan(measure)) continue;
            measure = measure2;
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void drawPolygon(JCDrawStyle jCDrawStyle, List list) {
        JCUnit.Point point;
        int n2 = 0;
        boolean bl = false;
        JCUnit.Point point2 = null;
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n3 = list.size();
        JCUnit.Point point3 = (JCUnit.Point)list.get(0);
        if (n3 > 1) {
            point2 = (JCUnit.Point)list.get(1);
        }
        if (!point3.equals(point = (JCUnit.Point)list.get(n3 - 1))) {
            bl = true;
            n2 = point2 != null ? 2 : 1;
        } else if (point2 != null) {
            n2 = 1;
        }
        JCUnit.Point[] pointArray = new JCUnit.Point[n3 + n2];
        JCUnit.Measure measure = new JCUnit.Measure();
        for (int i2 = 0; i2 < n3; ++i2) {
            JCUnit.Point point4;
            pointArray[i2] = point4 = (JCUnit.Point)list.get(i2);
            JCUnit.Measure measure2 = point4.getY();
            if (!measure2.greaterThan(measure)) continue;
            measure = measure2;
        }
        if (bl) {
            pointArray[n3] = (JCUnit.Point)point3.clone();
            if (point2 != null) {
                pointArray[n3 + 1] = (JCUnit.Point)point2.clone();
            }
        } else if (point2 != null) {
            pointArray[n3] = (JCUnit.Point)point2.clone();
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void drawPolygon(JCDrawStyle jCDrawStyle, JCUnit.Point[] pointArray) {
        boolean bl = false;
        JCUnit.Point[] pointArray2 = null;
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n2 = pointArray.length;
        JCUnit.Measure measure = new JCUnit.Measure();
        if (!pointArray[0].equals(pointArray[n2 - 1])) {
            bl = true;
            pointArray2 = new JCUnit.Point[++n2];
            pointArray2[n2 - 1] = (JCUnit.Point)pointArray[0].clone();
        }
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            JCUnit.Measure measure2;
            if (bl) {
                pointArray2[i2] = pointArray[i2];
            }
            if (!(measure2 = pointArray[i2].getY()).greaterThan(measure)) continue;
            measure = measure2;
        }
        if (bl) {
            pointArray = pointArray2;
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void fillPolygon(JCDrawStyle jCDrawStyle, List list) {
        JCUnit.Point point;
        boolean bl = false;
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n2 = list.size();
        JCUnit.Point point2 = (JCUnit.Point)list.get(0);
        if (!point2.equals(point = (JCUnit.Point)list.get(n2 - 1))) {
            ++n2;
            bl = true;
        }
        JCUnit.Point[] pointArray = new JCUnit.Point[n2];
        JCUnit.Measure measure = new JCUnit.Measure();
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            JCUnit.Point point3;
            pointArray[i2] = point3 = (JCUnit.Point)list.get(i2);
            JCUnit.Measure measure2 = point3.getY();
            if (!measure2.greaterThan(measure)) continue;
            measure = measure2;
        }
        if (bl) {
            pointArray[n2 - 1] = (JCUnit.Point)point2.clone();
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        lineRender.setFilled(true);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void fillPolygon(JCDrawStyle jCDrawStyle, JCUnit.Point[] pointArray) {
        boolean bl = false;
        JCUnit.Point[] pointArray2 = null;
        jCDrawStyle = jCDrawStyle.getImmutable();
        int n2 = pointArray.length;
        JCUnit.Measure measure = new JCUnit.Measure();
        if (!pointArray[0].equals(pointArray[n2 - 1])) {
            bl = true;
            pointArray2 = new JCUnit.Point[++n2];
            pointArray2[n2 - 1] = (JCUnit.Point)pointArray[0].clone();
        }
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            JCUnit.Measure measure2;
            if (bl) {
                pointArray2[i2] = pointArray[i2];
            }
            if (!(measure2 = pointArray[i2].getY()).greaterThan(measure)) continue;
            measure = measure2;
        }
        if (bl) {
            pointArray = pointArray2;
        }
        LineRender lineRender = new LineRender(pointArray, jCDrawStyle);
        lineRender.setFilled(true);
        this.renderList.add(lineRender);
        JCUnit.Measure measure3 = jCDrawStyle.getDrawnWidth();
        measure3.divide(2.0);
        measure.add(measure3);
        if (measure.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure);
        }
    }

    public void drawRoundedRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Dimension dimension, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        RoundRectRender roundRectRender = new RoundRectRender(point, dimension, measure, jCDrawStyle);
        this.renderList.add(roundRectRender);
        JCUnit.Measure measure2 = jCDrawStyle.getDrawnWidth();
        measure2.divide(2.0);
        measure2.add(point.getY());
        measure2.add(dimension.getHeight());
        if (measure2.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure2);
        }
    }

    public void drawRoundedRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Point point2, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        RoundRectRender roundRectRender = new RoundRectRender(point, point2, measure, jCDrawStyle);
        this.renderList.add(roundRectRender);
        JCUnit.Measure measure2 = point.getY();
        JCUnit.Measure measure3 = point2.getY();
        JCUnit.Measure measure4 = jCDrawStyle.getDrawnWidth();
        measure4.divide(2.0);
        if (measure2.greaterThan(measure3)) {
            measure4.add(measure2);
        } else {
            measure4.add(measure3);
        }
        if (measure4.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure4);
        }
    }

    public void fillRoundedRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Dimension dimension, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        RoundRectRender roundRectRender = new RoundRectRender(point, dimension, measure, jCDrawStyle);
        roundRectRender.setFilled(true);
        this.renderList.add(roundRectRender);
        JCUnit.Measure measure2 = jCDrawStyle.getDrawnWidth();
        measure2.divide(2.0);
        measure2.add(point.getY());
        measure2.add(dimension.getHeight());
        if (measure2.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure2);
        }
    }

    public void fillRoundedRectangle(JCDrawStyle jCDrawStyle, JCUnit.Point point, JCUnit.Point point2, JCUnit.Measure measure) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        RoundRectRender roundRectRender = new RoundRectRender(point, point2, measure, jCDrawStyle);
        roundRectRender.setFilled(true);
        this.renderList.add(roundRectRender);
        JCUnit.Measure measure2 = point.getY();
        JCUnit.Measure measure3 = point2.getY();
        JCUnit.Measure measure4 = jCDrawStyle.getDrawnWidth();
        measure4.divide(2.0);
        if (measure2.greaterThan(measure3)) {
            measure4.add(measure2);
        } else {
            measure4.add(measure3);
        }
        if (measure4.greaterThan(this.yExtent)) {
            this.yExtent.assign(measure4);
        }
    }

    public void complete() {
        if (this.info.currentLine.size() > 0) {
            JCTextStyle jCTextStyle = this.info.currentTextStyle;
            if (jCTextStyle == null) {
                jCTextStyle = JCTextStyle.DEFAULT_TEXT;
            }
            this.doLineBreak(jCTextStyle, false, true);
        }
        this.calcLayoutStatus();
        if (this.layoutStatus < 4) {
            this.updateLayoutStatus(this.document.getFlow(), this.page);
        } else {
            this.document.getFlow().fireFrameCompleted(this);
        }
    }

    public void calcLayoutStatus() {
        int n2 = 4;
        super.calcLayoutStatus();
        for (Render render : this.renderList) {
            int n3 = render.getLayoutStatus();
            if (!Render.isLayoutLower(n2, n3)) continue;
            n2 = n3;
        }
        if (Render.isLayoutLower(this.layoutStatus, n2)) {
            this.layoutStatus = n2;
        }
    }

    public void updateLayoutStatus(JCFlow jCFlow, JCPage jCPage) {
        int n2 = 4;
        int n3 = -1;
        if (this.layoutStatus == 4) {
            return;
        }
        super.updateLayoutStatus(jCFlow, jCPage);
        int n4 = this.renderList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            Cloneable cloneable;
            Render render = (Render)this.renderList.get(i2);
            if (render instanceof MacroRender) {
                MacroRender macroRender = (MacroRender)render;
                if (macroRender.getStatus() != 4) {
                    cloneable = macroRender.getSize().getWidth();
                    macroRender.evaluateMacro(jCFlow, jCPage);
                    JCUnit.Measure measure = macroRender.getSize().getWidth();
                    if (!measure.equals(cloneable)) {
                        measure.subtract((JCUnit.Measure)cloneable);
                        this.macroAdjustLine(macroRender, measure, n3);
                    }
                }
            } else if (render instanceof SymbolRender) {
                cloneable = (SymbolRender)render;
                if (((SymbolRender)cloneable).getType() == 3 || ((SymbolRender)cloneable).getType() == 2) {
                    n3 = i2;
                }
                render.setLayoutStatus(4);
            } else {
                render.setLayoutStatus(4);
            }
            int n5 = render.getLayoutStatus();
            if (!Render.isLayoutLower(n2, n5)) continue;
            n2 = n5;
        }
        if (Render.isLayoutLower(this.layoutStatus, n2)) {
            this.layoutStatus = n2;
        }
    }

    private void macroAdjustLine(MacroRender macroRender, JCUnit.Measure measure, int n2) {
        JCTextStyle jCTextStyle;
        SymbolRender symbolRender;
        Render render;
        int n3;
        int n4 = -1;
        int n5 = 0;
        int n6 = 2;
        int n7 = 1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n8 = this.renderList.size();
        for (n3 = n2 + 1; n3 < n8 && n4 == -1; ++n3) {
            render = (Render)this.renderList.get(n3);
            if (render instanceof SymbolRender) {
                symbolRender = (SymbolRender)render;
                if (symbolRender.getType() == 3 || symbolRender.getType() == 2) {
                    n4 = n3;
                    continue;
                }
                if (symbolRender.getType() != 1) continue;
                bl2 = true;
                if (bl) {
                    n7 = symbolRender.getAlignment();
                    n2 = n3;
                    bl3 = true;
                    continue;
                }
                n4 = n3;
                bl4 = true;
                continue;
            }
            if (macroRender == render) {
                bl = false;
                if (n7 == 4) {
                    n7 = 2;
                    n4 = n3 + 1;
                }
            } else if (n7 == 4 && n3 == n2 + 1) {
                n7 = 1;
                n2 = n3;
                bl3 = false;
            }
            ++n5;
        }
        if (bl2) {
            n6 = n7 == 3 ? 4 : (n7 == 2 ? 3 : 2);
        } else if (n4 == -1) {
            for (n3 = n8 - 1; n3 > n2; --n3) {
                render = (Render)this.renderList.get(n3);
                if (!(render instanceof StringRender) && !(render instanceof MacroRender)) continue;
                jCTextStyle = render instanceof StringRender ? ((StringRender)render).getStyle() : ((MacroRender)render).getStyle();
                n6 = jCTextStyle.getAlignment();
                n3 = n2;
            }
            n4 = n8;
        } else {
            jCTextStyle = ((SymbolRender)this.renderList.get(n4)).getStyle();
            n6 = jCTextStyle.getAlignment();
        }
        if (n6 == 5 && n5 == 1) {
            n6 = 4;
        }
        bl = true;
        switch (n6) {
            case 2: {
                JCUnit.Measure measure2;
                for (n3 = n2 + 1; n3 < n4; ++n3) {
                    render = (Render)this.renderList.get(n3);
                    if (bl) {
                        if (macroRender != render) continue;
                        bl = false;
                        continue;
                    }
                    JCUnit.Point point = render.getLocation();
                    measure2 = point.getX();
                    measure2.add(measure);
                    point.setX(measure2);
                }
                if (!bl4) break;
                symbolRender = (SymbolRender)this.renderList.get(n4);
                measure2 = symbolRender.getLeaderStart();
                measure2.add(measure);
                symbolRender.setLeaderStart(measure2);
                break;
            }
            case 3: {
                JCUnit.Measure measure3;
                for (n3 = n2 + 1; bl && n3 < n4; ++n3) {
                    render = (Render)this.renderList.get(n3);
                    if (!bl) continue;
                    JCUnit.Point point = render.getLocation();
                    measure3 = point.getX();
                    measure3.subtract(measure);
                    point.setX(measure3);
                    if (macroRender != render) continue;
                    bl = false;
                }
                if (!bl3) break;
                symbolRender = (SymbolRender)this.renderList.get(n2);
                measure3 = symbolRender.getLeaderEnd();
                measure3.subtract(measure);
                symbolRender.setLeaderEnd(measure3);
                break;
            }
            case 4: {
                JCUnit.Measure measure4;
                measure.divide(2.0);
                for (n3 = n2 + 1; n3 < n4; ++n3) {
                    JCUnit.Point point;
                    render = (Render)this.renderList.get(n3);
                    if (bl) {
                        point = render.getLocation();
                        measure4 = point.getX();
                        measure4.subtract(measure);
                        point.setX(measure4);
                        if (macroRender != render) continue;
                        bl = false;
                        continue;
                    }
                    point = render.getLocation();
                    measure4 = point.getX();
                    measure4.add(measure);
                    point.setX(measure4);
                }
                if (bl3) {
                    symbolRender = (SymbolRender)this.renderList.get(n2);
                    measure4 = symbolRender.getLeaderEnd();
                    measure4.subtract(measure);
                    symbolRender.setLeaderEnd(measure4);
                }
                if (!bl4) break;
                symbolRender = (SymbolRender)this.renderList.get(n4);
                measure4 = symbolRender.getLeaderStart();
                measure4.add(measure);
                symbolRender.setLeaderStart(measure4);
                break;
            }
            case 5: {
                JCUnit.Measure measure5 = new JCUnit.Measure(JCUnit.POINTS);
                JCUnit.Measure measure6 = (JCUnit.Measure)measure.clone();
                measure6.divide(n5 - 1);
                for (n3 = n2 + 1; n3 < n4; ++n3) {
                    render = (Render)this.renderList.get(n3);
                    JCUnit.Point point = render.getLocation();
                    JCUnit.Measure measure7 = point.getX();
                    measure7.subtract(measure5);
                    point.setX(measure7);
                    if (bl && macroRender == render) {
                        bl = false;
                        measure5.subtract(measure);
                    }
                    measure5.add(measure6);
                }
                break;
            }
        }
    }

    protected List getRenderList() {
        return this.renderList;
    }

    public Object clone() {
        JCFrame jCFrame;
        if (this.info.currentLine.size() > 0) {
            this.doLineBreak(this.info.currentTextStyle, false);
        }
        try {
            jCFrame = (JCFrame)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        jCFrame.info = new JCFlowInfo();
        jCFrame.frameList = new Vector();
        for (JCFrame jCFrame2 : this.frameList) {
            jCFrame.frameList.add((JCFrame)jCFrame2.clone());
        }
        jCFrame.renderList = new Vector();
        for (Render render : this.renderList) {
            if (render instanceof StringRender) {
                // empty if block
            }
            jCFrame.renderList.add(render.clone());
        }
        return jCFrame;
    }

    public void draw(Graphics2D graphics2D) {
        double d2;
        if (graphics2D instanceof Graphics2DBase) {
            ((Graphics2DBase)graphics2D).setFrameRoot();
            ((Graphics2DBase)graphics2D).updateContext();
        }
        if (this.color != null) {
            JCDrawStyle jCDrawStyle = new JCDrawStyle();
            jCDrawStyle.setFillForegroundColor(this.color);
            jCDrawStyle.makeImmutable();
            if (this.background == null) {
                this.background = new BoxRender(new JCUnit.Point(), this.size, jCDrawStyle);
                ((BoxRender)this.background).setFilled(true);
            }
            this.background.draw(graphics2D);
        }
        if (this.border != null && this.border.getForegroundColor() != null) {
            d2 = this.border.getDrawnWidth().getAs(JCUnit.POINTS);
            if (d2 <= 0.0) {
                d2 = 1.0;
            }
            double d3 = this.size.getWidth().getAs(JCUnit.POINTS);
            double d4 = this.size.getHeight().getAs(JCUnit.POINTS);
            double d5 = d2 / 2.0;
            double d6 = d3 / 2.0;
            double d7 = d4 / 2.0;
            double d8 = d2 >= d3 ? d3 : (d2 > d6 ? d3 - d5 : d3 - d2);
            double d9 = d2 >= d4 ? d4 : (d2 > d7 ? d4 - d5 : d4 - d2);
            JCUnit.Dimension dimension = new JCUnit.Dimension(JCUnit.POINTS, d8, d9);
            double d10 = d2 >= d3 ? 0.0 : (d2 > d6 ? Math.floor(d5) : d5);
            double d11 = d2 >= d4 ? 0.0 : (d2 > d7 ? Math.floor(d5) : d5);
            JCUnit.Point point = new JCUnit.Point(JCUnit.POINTS, d10, d11);
            BoxRender boxRender = new BoxRender(point, dimension, this.border);
            boxRender.draw(graphics2D);
        }
        int n2 = this.renderList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Render render = (Render)this.renderList.get(i2);
            render.draw(graphics2D);
        }
        if (graphics2D instanceof Markup) {
            return;
        }
        for (JCFrame jCFrame : this.frameList) {
            d2 = this.size.getWidth().getAs(JCUnit.POINTS);
            double d12 = this.size.getHeight().getAs(JCUnit.POINTS);
            JCUnit.Point point = jCFrame.getLocation();
            double d13 = point.getX().getAs(JCUnit.POINTS);
            double d14 = point.getY().getAs(JCUnit.POINTS);
            JCUnit.Dimension dimension = jCFrame.getSize();
            double d15 = dimension.getWidth().getAs(JCUnit.POINTS);
            double d16 = dimension.getHeight().getAs(JCUnit.POINTS);
            if (d13 > d2 || d13 + d15 < 0.0 || d14 > d12 || d14 + d16 < 0.0) continue;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d13, d14, d15, d16);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, d2, d12);
            Rectangle2D.Double double_3 = this.clipToFrame(double_2, double_);
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            if (graphics2D2 instanceof Graphics2DBase) {
                ((Graphics2DBase)graphics2D2).setFrameRoot();
            }
            graphics2D2.setClip(double_3);
            graphics2D2.translate(d13, d14);
            double_2.x -= d13;
            double_2.y -= d14;
            JCUnit.Margins margins = jCFrame.getClipMask();
            if (margins != null) {
                d13 = margins.getLeft().getAs(JCUnit.POINTS);
                d14 = margins.getTop().getAs(JCUnit.POINTS);
                d15 = margins.getRight().getAs(JCUnit.POINTS);
                d16 = margins.getBottom().getAs(JCUnit.POINTS);
                double_ = new Rectangle2D.Double(d13, d14, d15, d16);
                double_3 = this.clipToFrame(double_2, double_);
                graphics2D2.setClip(double_3);
            }
            jCFrame.draw(graphics2D2);
            graphics2D2.dispose();
        }
    }

    private Rectangle2D.Double clipToFrame(Rectangle2D.Double double_, Rectangle2D.Double double_2) {
        Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        if (double_2.x < double_.x) {
            double_3.x = double_.x;
            double_3.width = double_2.width + double_2.x - double_.x;
        } else {
            double_3.x = double_2.x;
            double_3.width = double_2.width;
        }
        if (double_2.y < double_.y) {
            double_3.y = double_.y;
            double_3.height = double_2.height + double_2.y - double_.y;
        } else {
            double_3.y = double_2.y;
            double_3.height = double_2.height;
        }
        if (double_3.x + double_3.width > double_.x + double_.width) {
            double_3.width = double_.x + double_.width - double_3.x;
        }
        if (double_3.y + double_3.height > double_.height) {
            double_3.height = double_.y + double_.height - double_3.y;
        }
        return double_3;
    }

    private void computeColumnWidth() {
        JCUnit.Measure measure = this.size.getWidth();
        measure.subtract(this.margin.getLeft());
        measure.subtract(this.margin.getRight());
        if (measure.isNegative()) {
            throw new IllegalArgumentException("Printable space would be < 0");
        }
        if (this.columnCount > 1) {
            JCUnit.Measure measure2 = (JCUnit.Measure)this.columnSpace.clone();
            measure2.multiply(this.columnCount - 1);
            measure.subtract(measure2);
            measure.divide(this.columnCount);
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Column widths would be < 0");
            }
        }
        this.columnWidth.assign(measure);
    }

    private void reflow(Graphics2D graphics2D, List list) throws EndOfFrameException {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Render render = (Render)list.get(i2);
            if (render instanceof SymbolRender) {
                int n3 = ((SymbolRender)render).getType();
                this.info.currentTextStyle = ((SymbolRender)render).getStyle();
                if (n3 == 1) {
                    this.tab(this.info.currentTextStyle);
                    continue;
                }
                if (n3 != 3 && n3 != 2) continue;
                this.newLine(this.info.currentTextStyle);
                continue;
            }
            if (render instanceof StringRender) {
                this.info.currentTextStyle = ((StringRender)render).getStyle();
            }
            if (render instanceof MacroRender) {
                ((MacroRender)render).evaluateMacro(null, this.page);
            }
            try {
                this.flowPrint(graphics2D, render, false);
                continue;
            }
            catch (EndOfFrameException endOfFrameException) {
                ++i2;
                while (i2 < n2) {
                    endOfFrameException.currentLine.add(list.get(i2++));
                }
                throw endOfFrameException;
            }
        }
    }

    private boolean isInfoInitialised() {
        return this.info.lineEnd.distance != -1.0;
    }

    protected void initialiseInfo() {
        this.initialiseInfo(true);
    }

    protected void initialiseInfo(boolean bl) {
        JCTextStyle jCTextStyle = this.info.currentTextStyle == null ? JCTextStyle.DEFAULT_TEXT : this.info.currentTextStyle;
        this.info.leftOfColumn.assign(this.margin.getLeft());
        this.info.rightOfColumn.assign(this.info.leftOfColumn);
        this.info.rightOfColumn.add(this.columnWidth);
        this.info.insertion = new JCUnit.Point(this.info.leftOfColumn.units);
        this.computeLineBounds(jCTextStyle, bl);
        this.info.insertion.setX(this.info.lineBegin);
        JCUnit.Measure measure = this.getFirstLineOffset(jCTextStyle);
        measure.add(this.margin.getTop());
        this.info.insertion.setY(measure);
    }

    private void flowPrint(Graphics2D graphics2D, Render render, boolean bl) throws EndOfFrameException {
        Cloneable cloneable;
        int n2;
        JCUnit.Measure measure;
        JCTextStyle jCTextStyle;
        double d2 = 0.0;
        double d3 = 0.0;
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        JCUnit.Measure measure2 = render.getSize().getWidth();
        JCUnit.Measure measure3 = this.size.getHeight();
        measure3.subtract(this.margin.getBottom());
        if (render instanceof StringRender) {
            jCTextStyle = ((StringRender)render).getStyle();
            measure = ((StringRender)render).getTrimWidth(graphics2D);
        } else {
            jCTextStyle = this.info.currentTextStyle;
            if (jCTextStyle == null) {
                jCTextStyle = JCTextStyle.DEFAULT_TEXT;
            }
            measure = measure2;
        }
        if (this.info.currentLine.size() == 0 && this.info.firstLine) {
            this.computeLineBounds(jCTextStyle, this.info.firstLine);
            this.info.insertion.setX(this.info.lineBegin);
        }
        JCUnit.Measure measure4 = new JCUnit.Measure();
        if (this.info.currentTab != null) {
            n2 = this.info.currentTab.getTabAlignment();
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    measure4.assign(this.info.tabSymbol.getLeaderEnd());
                    measure4.subtract(this.info.tabSymbol.getLeaderStart());
                    if (!measure4.isZero()) break;
                    n2 = 1;
                    break;
                }
                case 4: {
                    measure4.assign(this.info.tabSymbol.getLeaderEnd());
                    measure4.subtract(this.info.tabSymbol.getLeaderStart());
                    if (render instanceof StringRender && ((StringRender)render).hasDecimal() && measure4.greaterThan((JCUnit.Measure)(cloneable = ((StringRender)render).getDecimalPosition()))) {
                        measure4 = cloneable;
                    }
                    bl = true;
                }
            }
        } else {
            n2 = 1;
        }
        JCUnit.Measure measure5 = (JCUnit.Measure)this.info.lineEnd.clone();
        measure5.subtract(this.info.insertion.getX());
        JCUnit.Measure measure6 = (JCUnit.Measure)measure5.clone();
        measure6.add(measure4);
        if (measure6.isZero() || measure6.isNegative()) {
            measure6.distance = 0.0;
        }
        if (!measure.greaterThan(measure6) || bl) {
            JCUnit.Measure measure7;
            JCUnit.Measure measure8;
            JCUnit.Point point;
            double d4;
            double d5;
            double d6;
            Object object;
            cloneable = new JCUnit.Measure(JCUnit.POINTS, jCTextStyle.getPointSize());
            if (this.info.lineSpacing.lessThan((JCUnit.Measure)cloneable) || this.info.currentLine.size() == 0) {
                this.info.lineSpacing = cloneable;
            }
            if (render instanceof StringRender || render instanceof MacroRender) {
                double d7;
                Object object2;
                Font font = jCTextStyle.getFont();
                object = graphics2D.getFontMetrics(font);
                String string = render instanceof MacroRender ? ((MacroRender)render).getText() : ((StringRender)render).getText();
                if (jCTextStyle.getBaselineOffset() == 1) {
                    d2 = ((FontMetrics)object).getAscent();
                    d3 = ((FontMetrics)object).getDescent();
                    if (jCTextStyle.getUnderlining() == 2) {
                        object2 = ((FontMetrics)object).getLineMetrics(string, graphics2D);
                        double d8 = ((LineMetrics)object2).getUnderlineOffset();
                        if ((d8 += (double)((LineMetrics)object2).getUnderlineThickness()) > d3) {
                            d3 = d8;
                        }
                    }
                    d7 = 0.0;
                } else {
                    Font font2 = FontBase.deriveFont(font, (float)((double)FontBase.getSize2D(font) * jCTextStyle.getSubscriptRatio()));
                    FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
                    font2 = fontMetrics.getFont();
                    FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                    object2 = FontBase.createGlyphVector(font2, fontRenderContext, "x");
                    GlyphVector glyphVector = FontBase.createGlyphVector(font2, fontRenderContext, string);
                    Rectangle2D rectangle2D = ((GlyphVector)object2).getLogicalBounds();
                    Rectangle2D rectangle2D2 = glyphVector.getLogicalBounds();
                    double d9 = -rectangle2D.getY();
                    double d10 = -rectangle2D2.getY();
                    double d11 = rectangle2D2.getHeight() + rectangle2D2.getY();
                    if (jCTextStyle.getBaselineOffset() == 3) {
                        d2 = d9 + d10;
                        d7 = d9;
                    } else {
                        d2 = fontMetrics.getAscent();
                        d7 = d9 - (double)fontMetrics.getAscent();
                    }
                    d3 = d11 - d7;
                    if ((double)((FontMetrics)object).getAscent() > this.info.ascender.getAs(JCUnit.POINTS)) {
                        this.info.ascender = new JCUnit.Measure(JCUnit.POINTS, ((FontMetrics)object).getAscent());
                    }
                    if ((double)((FontMetrics)object).getDescent() > this.info.descender.getAs(JCUnit.POINTS)) {
                        this.info.descender = new JCUnit.Measure(JCUnit.POINTS, ((FontMetrics)object).getDescent());
                    }
                }
                double d12 = ((FontMetrics)object).getLeading();
                d12 = jCTextStyle.getPointSize() - (double)((FontMetrics)object).getAscent() - (double)((FontMetrics)object).getDescent();
                JCUnit.Measure measure9 = new JCUnit.Measure(JCUnit.POINTS, d12);
                if (measure9.greaterThan(this.info.leading)) {
                    this.info.leading = measure9;
                }
                if (d2 + d3 + d12 > this.info.lineSpacing.getAs(JCUnit.POINTS) && jCTextStyle.getBaselineOffset() == 1) {
                    this.info.lineSpacing = new JCUnit.Measure(JCUnit.POINTS, d2 + d3 + d12);
                }
                d6 = this.info.descender.getAs(JCUnit.POINTS);
                d5 = this.info.embedDescent.getAs(JCUnit.POINTS);
                if (d3 > d6) {
                    this.info.descender = new JCUnit.Measure(JCUnit.POINTS, d3);
                } else {
                    d3 = d6 > d5 ? d6 : d5;
                }
                d4 = this.info.ascender.getAs(JCUnit.POINTS);
                double d13 = this.info.embedAscent.getAs(JCUnit.POINTS);
                if (d2 > d4) {
                    this.info.ascender = new JCUnit.Measure(JCUnit.POINTS, d2);
                    if (d2 > d13) {
                        this.pushLineDown(d2 - d4, d3 - d6, true);
                    }
                } else {
                    d2 = d4 > d13 ? d4 : d13;
                }
                if (d2 + d3 + d12 > this.info.height.getAs(JCUnit.POINTS)) {
                    this.info.height.assign(this.info.ascender);
                    this.info.height.add(this.info.descender);
                    this.info.height.add(new JCUnit.Measure(JCUnit.POINTS, d12));
                }
                point = render.getLocation();
                measure8 = new JCUnit.Measure(JCUnit.POINTS, d2 - d7);
                measure8.add(this.info.insertion.getY());
                point.setY(measure8);
            } else {
                double d14 = render.getSize().getHeight().getAs(JCUnit.POINTS);
                int n3 = render instanceof Embedable ? ((Embedable)((Object)render)).getVerticalAlignment() : 3;
                d2 = this.computeAscent(d14, n3);
                d3 = d14 - d2;
                if (!this.isVariable(n3)) {
                    d6 = this.info.descender.getAs(JCUnit.POINTS);
                    if (d3 > d6) {
                        this.info.descender = new JCUnit.Measure(JCUnit.POINTS, d3);
                    }
                    if (d2 > (d5 = this.info.ascender.getAs(JCUnit.POINTS))) {
                        this.info.ascender = new JCUnit.Measure(JCUnit.POINTS, d2);
                        this.pushLineDown(d2 - d5, d3 - d6, true);
                    }
                    measure8 = new JCUnit.Measure(JCUnit.POINTS, -d2);
                    if (this.info.ascender.greaterThan(this.info.embedAscent)) {
                        measure8.add(this.info.ascender);
                    } else {
                        measure8.add(this.info.embedAscent);
                    }
                } else {
                    d6 = this.info.embedAscent.getAs(JCUnit.POINTS);
                    d5 = this.info.embedDescent.getAs(JCUnit.POINTS);
                    if (d2 > d6) {
                        this.info.embedAscent = new JCUnit.Measure(JCUnit.POINTS, d2);
                        if (this.info.embedAscent.greaterThan(this.info.ascender)) {
                            d4 = this.info.ascender.getAs(JCUnit.POINTS);
                            if (d4 > (d6 = this.info.ascender.getAs(JCUnit.POINTS))) {
                                d6 = d4;
                            }
                            this.pushLineDown(d2 - d6, 0.0, false);
                        }
                    }
                    if (d3 > d5) {
                        this.info.embedDescent = new JCUnit.Measure(JCUnit.POINTS, d3);
                    }
                    measure8 = new JCUnit.Measure(JCUnit.POINTS, -d2);
                    if (this.info.ascender.greaterThan(this.info.embedAscent)) {
                        measure8.add(this.info.ascender);
                    } else {
                        measure8.add(this.info.embedAscent);
                    }
                }
                point = render.getLocation();
                measure8.add(this.info.insertion.getY());
                point.setY(measure8);
            }
            if (this.info.ascender.greaterThan(this.info.embedAscent)) {
                this.info.height.assign(this.info.ascender);
            } else {
                this.info.height.assign(this.info.embedAscent);
            }
            if (this.info.descender.greaterThan(this.info.embedDescent)) {
                this.info.height.add(this.info.descender);
            } else {
                this.info.height.add(this.info.embedDescent);
            }
            if (this.info.height.greaterThan(this.info.lineSpacing)) {
                this.info.lineSpacing.assign(this.info.height);
            }
            point = render.getLocation();
            if (n2 == 1) {
                measure7 = this.info.insertion.getX();
                point.setX(measure7);
                measure7.add(measure2);
            } else if (n2 == 3) {
                JCUnit.Measure measure10;
                JCUnit.Measure measure11 = (JCUnit.Measure)measure2.clone();
                measure11.divide(2.0);
                if (measure11.greaterThan(measure4)) {
                    measure10 = measure4;
                    measure11.multiply(2.0);
                    measure11.subtract(measure4);
                    this.info.currentTab = null;
                } else if (measure11.greaterThan(measure5)) {
                    measure10 = (JCUnit.Measure)measure2.clone();
                    measure10.subtract(measure5);
                    measure11 = measure5;
                } else {
                    measure10 = measure11;
                }
                for (int i2 = this.info.tabIndex; i2 < this.info.currentLine.size(); ++i2) {
                    Render render2 = (Render)this.info.currentLine.get(i2);
                    JCUnit.Point point2 = render2.getLocation();
                    measure7 = point2.getX();
                    measure7.subtract(measure10);
                    point2.setX(measure7);
                }
                measure7 = this.info.tabSymbol.getLeaderEnd();
                measure7.subtract(measure10);
                this.info.tabSymbol.setLeaderEnd(measure7);
                measure7 = this.info.insertion.getX();
                measure7.subtract(measure10);
                point.setX(measure7);
                if (this.info.currentTab == null) {
                    this.info.tabIndex = -1;
                }
                measure7.add(measure2);
            } else if (n2 == 2) {
                JCUnit.Measure measure12;
                JCUnit.Measure measure13 = new JCUnit.Measure();
                if (measure2.greaterThan(measure4)) {
                    measure12 = measure4;
                    measure13.assign(measure2);
                    measure13.subtract(measure4);
                    this.info.currentTab = null;
                } else {
                    measure12 = measure2;
                }
                for (int i3 = this.info.tabIndex; i3 < this.info.currentLine.size(); ++i3) {
                    Render render3 = (Render)this.info.currentLine.get(i3);
                    JCUnit.Point point3 = render3.getLocation();
                    measure7 = point3.getX();
                    measure7.subtract(measure12);
                    point3.setX(measure7);
                }
                measure7 = this.info.tabSymbol.getLeaderEnd();
                measure7.subtract(measure12);
                this.info.tabSymbol.setLeaderEnd(measure7);
                measure7 = this.info.insertion.getX();
                measure7.subtract(measure12);
                point.setX(measure7);
                if (this.info.currentTab == null) {
                    this.info.tabIndex = -1;
                }
                measure7.add(measure2);
            } else {
                boolean bl2 = false;
                if (render instanceof StringRender) {
                    bl2 = ((StringRender)render).hasDecimal();
                }
                JCUnit.Measure measure14 = new JCUnit.Measure();
                Object object3 = bl2 ? (((JCUnit.Measure)(object = ((StringRender)render).getDecimalPosition())).greaterThan(measure4) ? measure4 : object) : (measure2.greaterThan(measure4) ? measure4 : measure2);
                measure14.assign(measure2);
                measure14.subtract((JCUnit.Measure)object3);
                measure7 = this.info.tabSymbol.getLeaderEnd();
                measure7.subtract((JCUnit.Measure)object3);
                this.info.tabSymbol.setLeaderEnd(measure7);
                measure7 = this.info.insertion.getX();
                measure7.subtract((JCUnit.Measure)object3);
                point.setX(measure7);
                this.info.currentTab = null;
                this.info.tabIndex = -1;
                measure7.add(measure2);
            }
            this.info.currentLine.add(render);
            this.info.insertion.setX(measure7);
            measure8 = this.info.insertion.getY();
            measure8.add(this.info.height);
            if (measure8.greaterThan(measure3)) {
                this.newColumn(jCTextStyle, false);
            }
            if (measure7.greaterThan(this.info.lineEnd)) {
                this.doLineBreak(jCTextStyle, false);
            }
        } else if (render.isAtomic()) {
            if (this.info.insertion.getX().greaterThan(this.info.lineBegin)) {
                this.doLineBreak(jCTextStyle, false);
                this.flowPrint(graphics2D, render, false);
            } else {
                this.flowPrint(graphics2D, render, true);
            }
        } else {
            Object object;
            Render render4 = ((Splitable)((Object)render)).splitBefore(graphics2D, measure6);
            Render render5 = ((Splitable)((Object)render)).splitAfter(graphics2D, measure6);
            if (render4.getSize().width == 0.0) {
                object = (JCUnit.Measure)this.info.lineEnd.clone();
                ((JCUnit.Measure)object).subtract(this.info.lineBegin);
                cloneable = measure2.greaterThan((JCUnit.Measure)object) ? ((Splitable)((Object)render)).splitBefore(graphics2D, (JCUnit.Measure)object) : render;
                if (((Render)cloneable).getSize().width == 0.0 || this.info.currentLine.size() == 0) {
                    Render render6 = ((Splitable)((Object)render)).forceSplit(graphics2D, measure6);
                    if (render6.getSize().width <= measure6.getAs(JCUnit.POINTS) || this.info.currentLine.size() == 0) {
                        render4 = render6;
                        bl = true;
                        render5 = ((Splitable)((Object)render)).splitAfter(graphics2D, measure6);
                    }
                }
            }
            if (render4.getSize().width > 0.0) {
                try {
                    this.flowPrint(graphics2D, render4, bl);
                }
                catch (EndOfFrameException endOfFrameException) {
                    object = endOfFrameException.getCurrentLine();
                    int n4 = object.size() - 1;
                    Render render7 = (Render)object.get(n4);
                    ((StringRender)render7).unsplit(graphics2D, render5);
                    throw endOfFrameException;
                }
            }
            if (this.info.insertion.getX().greaterThan(this.info.lineBegin)) {
                this.doLineBreak(jCTextStyle, false);
            }
            if (render5.getSize().width > 0.0) {
                this.flowPrint(graphics2D, render5, false);
            }
        }
        if (this.info.currentTextStyle == null || render instanceof StringRender) {
            this.info.currentTextStyle = jCTextStyle;
        }
    }

    private void pushLineDown(double d2, double d3, boolean bl) {
        double d4;
        double d5;
        double d6;
        int n2;
        Render render;
        int n3;
        int n4 = this.info.currentLine.size();
        if (bl) {
            double d7 = 0.0;
            double d8 = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                render = (Render)this.info.currentLine.get(n3);
                if (!(render instanceof Embedable) || !this.isVariable(n2 = ((Embedable)((Object)render)).getVerticalAlignment())) continue;
                d6 = render.getSize().getHeight().getAs(JCUnit.POINTS);
                d5 = this.computeAscent(d6, n2);
                d4 = d6 - d5;
                if (d5 > d7) {
                    d7 = d5;
                }
                if (!(d4 > d8)) continue;
                d8 = d4;
            }
            double d9 = this.info.embedAscent.getAs(JCUnit.POINTS);
            double d10 = d9 - d7;
            this.info.embedAscent = new JCUnit.Measure(JCUnit.POINTS, d7);
            this.info.embedDescent = new JCUnit.Measure(JCUnit.POINTS, d8);
            d2 -= d10;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            JCUnit.Point point;
            JCUnit.Measure measure;
            render = (Render)this.info.currentLine.get(n3);
            if (render instanceof Embedable && bl && this.isVariable(n2 = ((Embedable)((Object)render)).getVerticalAlignment())) {
                d6 = render.getSize().getHeight().getAs(JCUnit.POINTS);
                d5 = this.computeAscent(d6, n2);
                d4 = d6 - d5;
                measure = this.info.insertion.getY();
                if (this.info.ascender.greaterThan(this.info.embedAscent)) {
                    measure.add(this.info.ascender);
                } else {
                    measure.add(this.info.embedAscent);
                }
                measure.subtract(new JCUnit.Measure(JCUnit.POINTS, d5));
                point = render.getLocation();
                point.setY(measure);
                continue;
            }
            point = render.getLocation();
            measure = point.getY();
            measure.add(new JCUnit.Measure(JCUnit.POINTS, d2));
            point.setY(measure);
        }
    }

    private boolean isVariable(int n2) {
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    private double computeAscent(double d2, int n2) {
        double d3;
        switch (n2) {
            case 1: {
                d3 = d2;
                break;
            }
            case 2: {
                d3 = 0.0;
                break;
            }
            case 3: {
                d3 = d2 / 2.0;
                break;
            }
            case 4: {
                double d4 = this.info.ascender.getAs(JCUnit.POINTS) / 2.0;
                d3 = d4 + d2 / 2.0;
                break;
            }
            case 5: {
                double d5 = (this.info.ascender.getAs(JCUnit.POINTS) - this.info.descender.getAs(JCUnit.POINTS)) / 2.0;
                d3 = d5 + d2 / 2.0;
                break;
            }
            case 6: {
                d3 = this.info.ascender.getAs(JCUnit.POINTS);
                break;
            }
            case 7: {
                d3 = d2 - this.info.descender.getAs(JCUnit.POINTS);
                break;
            }
            default: {
                d3 = -1.0;
            }
        }
        return d3;
    }

    private void pasteFloats() {
        if (this.info.floatList.size() == 0) {
            return;
        }
        if (this.info.currentTextStyle == null) {
            this.info.currentTextStyle = JCTextStyle.DEFAULT_TEXT;
        }
        if (!this.isInfoInitialised()) {
            this.initialiseInfo();
        }
        Floatable floatable = (Floatable)this.info.floatList.firstElement();
        JCUnit.Dimension dimension = floatable.getSize();
        JCUnit.Measure measure = this.size.getHeight();
        measure.subtract(this.margin.getBottom());
        if (this.info.insertion.getY().distance == 0.0) {
            this.info.insertion.setY(this.getFirstLineOffset(this.info.currentTextStyle));
        }
        measure.subtract(this.info.insertion.getY());
        while (dimension.getHeight().lessThan(measure)) {
            JCUnit.Point point = floatable.getLocation();
            switch (floatable.getAlignment()) {
                case 1: 
                case 2: {
                    point.setX(this.info.leftOfColumn);
                    break;
                }
                case 3: {
                    JCUnit.Measure measure2 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                    measure2.subtract(dimension.getWidth());
                    point.setX(measure2);
                    break;
                }
                case 4: 
                case 5: {
                    JCUnit.Measure measure2 = (JCUnit.Measure)this.info.rightOfColumn.clone();
                    measure2.add(this.info.leftOfColumn);
                    measure2.subtract(dimension.getWidth());
                    measure2.divide(2.0);
                    point.setX(measure2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid alignment");
                }
            }
            JCUnit.Measure measure3 = this.info.insertion.getY();
            point.setY(measure3);
            this.info.floatList.remove(0);
            this.renderList.add(floatable);
            JCUnit.Measure measure4 = this.getFirstLineOffset(this.info.currentTextStyle);
            measure4.add(dimension.getHeight());
            measure.subtract(measure4);
            measure3.add(measure4);
            this.info.insertion.setY(measure3);
            if (this.info.floatList.size() == 0) break;
            floatable = (Floatable)this.info.floatList.firstElement();
            dimension = floatable.getSize();
        }
    }
}

