/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.FontFileLookup;
import com.klg.jclass.page.TrueTypeFontProperties;
import com.klg.jclass.page.adobe.postscript.TTFParser;
import com.klg.jclass.page.resources.LocaleBundle;
import com.klg.jclass.page.ttf.TTFFontNames;
import com.klg.jclass.util.SettableListResourceBundle;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.Vector;

public class FontLibrary {
    public static final int AFM = 0;
    public static final int TTF = 1;
    public static final int ALL_FILE_TYPES = -100;
    public static final int PDF = 0;
    public static final int NUM_OUTPUT_TYPES = 1;
    public static Hashtable[] availableFonts = new Hashtable[]{new Hashtable(), new Hashtable()};
    public static Hashtable[] availableStockFonts = new Hashtable[]{new Hashtable(), new Hashtable()};
    public static ResourceBundle[] stockFontNameMapBundles = new ResourceBundle[1];
    protected static final String defaultUserFontBundleName = "user";
    protected static List[] userFontBundles = new List[]{new Vector(), new Vector()};
    protected static List userFontBundleLookups = new Vector();
    protected static Hashtable automaticFontNameMapTable = new Hashtable();
    public static Hashtable trueTypeFontProperties = new Hashtable();
    protected static boolean autoLoad = false;
    protected static FontLibrary fontLibraryInstance = null;
    protected static boolean suppressErrorMessages = true;

    public static void initFontLibrary() {
        if (fontLibraryInstance == null) {
            fontLibraryInstance = new FontLibrary();
            if (autoLoad) {
                FontLibrary.addFontPackage("C:\\WINNT\\Fonts");
                FontLibrary.addFontPackage("C:\\WINDOWS\\Fonts");
                FontLibrary.addFontPackage("/usr/share/fonts");
                FontLibrary.addFontPackage("/usr/lib/X11/fonts");
            }
        }
    }

    private FontLibrary() {
    }

    public static void setAutoLoad(boolean bl) {
        autoLoad = bl;
    }

    public static boolean isAutoLoad() {
        return autoLoad;
    }

    public static void setSuppressErrorMessages(boolean bl) {
        suppressErrorMessages = bl;
    }

    public static boolean getSuppressErrorMessages() {
        return suppressErrorMessages;
    }

    public static void addFontPackage(String string) {
        FontLibrary.initFontLibrary();
        FontLibrary.addFontPackage(string, true);
    }

    public static void addFontPackage(String string, boolean bl) {
        File[] fileArray;
        File file;
        block17: {
            SettableListResourceBundle[] settableListResourceBundleArray;
            Object object;
            FontLibrary.initFontLibrary();
            if (string == null) {
                throw new IllegalArgumentException("package path may not be null");
            }
            file = new File(string);
            File[] fileArray2 = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return FontLibrary.isAFMFile(string.trim());
                }
            });
            Vector<String> vector = new Vector<String>();
            for (int i2 = 0; fileArray2 != null && i2 < fileArray2.length; ++i2) {
                object = new FontFileLookup(0, fileArray2[i2].getPath(), 0);
                try {
                    String string2 = FontLibrary.addAFMToAvailableFonts((FontFileLookup)object);
                    if (string2 == null) continue;
                    vector.add(string2);
                    continue;
                }
                catch (IOException iOException) {
                    if (FontLibrary.getSuppressErrorMessages()) continue;
                    System.err.println(LocaleBundle.string("Warning: Error loading afm file ") + fileArray2[i2].getPath());
                    System.err.println("    (" + LocaleBundle.string("Exception:") + " " + iOException.getClass().getName() + " " + iOException.getMessage() + ")");
                }
            }
            File[] fileArray3 = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return FontLibrary.isTrueTypeFile(string.trim());
                }
            });
            object = new Vector();
            for (int i3 = 0; fileArray3 != null && i3 < fileArray3.length; ++i3) {
                fileArray = new FontFileLookup(0, fileArray3[i3].getPath(), 1);
                try {
                    settableListResourceBundleArray = FontLibrary.addTTFToAvailableFonts((FontFileLookup)fileArray);
                    if (settableListResourceBundleArray == null) continue;
                    ((Vector)object).addAll(settableListResourceBundleArray);
                    continue;
                }
                catch (IOException iOException) {
                    if (FontLibrary.getSuppressErrorMessages()) continue;
                    System.err.println(LocaleBundle.string("Warning: Error loading ttf file ") + fileArray3[i3].getPath());
                    System.err.println("    (" + LocaleBundle.string("Exception:") + " " + iOException.getClass().getName() + " " + iOException.getMessage() + ")");
                }
            }
            FontFileLookup fontFileLookup = new FontFileLookup(0, string, defaultUserFontBundleName, 2);
            if (userFontBundleLookups.contains(fontFileLookup)) {
                return;
            }
            try {
                fileArray = fontFileLookup.getResourceBundle();
                if (fileArray == null) {
                    return;
                }
                userFontBundleLookups.add(fontFileLookup);
                settableListResourceBundleArray = new SettableListResourceBundle[1];
                for (int i4 = 0; i4 < 1; ++i4) {
                    settableListResourceBundleArray[i4] = new SettableListResourceBundle();
                }
                Enumeration<String> enumeration = fileArray.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string3 = enumeration.nextElement();
                    String string4 = fileArray.getString(string3);
                    if (vector.contains(string4)) {
                        settableListResourceBundleArray[0].add(string3, string4);
                    }
                    if (!((Vector)object).contains(string4)) continue;
                    settableListResourceBundleArray[0].add(string3, string4);
                }
                for (int i5 = 0; i5 < 1; ++i5) {
                    userFontBundles[i5].add(settableListResourceBundleArray[i5]);
                }
            }
            catch (IOException iOException) {
                if (FontLibrary.getSuppressErrorMessages()) break block17;
                System.err.println(LocaleBundle.string("Warning: Error loading font name map file ") + string + "/" + defaultUserFontBundleName + ".properties");
                System.err.println("    (" + LocaleBundle.string("Exception:") + " " + iOException.getClass().getName() + " " + iOException.getMessage() + ")");
            }
        }
        if (bl) {
            fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            for (int i6 = 0; fileArray != null && i6 < fileArray.length; ++i6) {
                FontLibrary.addFontPackage(fileArray[i6].getAbsolutePath(), true);
            }
        }
    }

    public static void addFont(String string) throws IOException {
        FontLibrary.initFontLibrary();
        if (string == null) {
            throw new IllegalArgumentException("file location may not be null");
        }
        File file = new File(string);
        if (FontLibrary.isAFMFile(string)) {
            FontFileLookup fontFileLookup = new FontFileLookup(0, file.getPath(), 0);
            FontLibrary.addAFMToAvailableFonts(fontFileLookup);
        } else if (FontLibrary.isTrueTypeFile(string)) {
            FontFileLookup fontFileLookup = new FontFileLookup(0, file.getPath(), 1);
            FontLibrary.addTTFToAvailableFonts(fontFileLookup);
        }
    }

    public static void addFont(URL uRL, int n2) throws IOException {
        FontLibrary.initFontLibrary();
        if (uRL == null) {
            throw new IllegalArgumentException("font URL may not be null");
        }
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("font type must be either AFM or TTF");
        }
        if (n2 == 0) {
            FontFileLookup fontFileLookup = new FontFileLookup(2, uRL, 0);
            FontLibrary.addAFMToAvailableFonts(fontFileLookup);
        } else if (n2 == 1) {
            FontFileLookup fontFileLookup = new FontFileLookup(2, uRL, 1);
            FontLibrary.addTTFToAvailableFonts(fontFileLookup);
        }
    }

    public static void addRelativeFont(String string) throws IOException {
        FontLibrary.initFontLibrary();
        if (string == null) {
            throw new IllegalArgumentException("file location may not be null");
        }
        if (FontLibrary.isAFMFile(string)) {
            FontFileLookup fontFileLookup = new FontFileLookup(3, string, 0);
            FontLibrary.addAFMToAvailableFonts(fontFileLookup);
        } else if (FontLibrary.isTrueTypeFile(string)) {
            FontFileLookup fontFileLookup = new FontFileLookup(3, string, 1);
            FontLibrary.addTTFToAvailableFonts(fontFileLookup);
        }
    }

    protected static String addAFMToAvailableFonts(FontFileLookup fontFileLookup) throws IOException {
        if (availableFonts[0].contains(fontFileLookup)) {
            return null;
        }
        InputStream inputStream = fontFileLookup.openInputStream();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(inputStream));
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        streamTokenizer.nextToken();
        String string = "";
        while (streamTokenizer.ttype != -1) {
            if (streamTokenizer.sval != null && streamTokenizer.sval.equals("FontName")) {
                streamTokenizer.nextToken();
                string = streamTokenizer.sval;
                availableFonts[0].put(string, fontFileLookup);
                break;
            }
            streamTokenizer.nextToken();
        }
        inputStream.close();
        return string;
    }

    protected static List addTTFToAvailableFonts(FontFileLookup fontFileLookup) throws IOException {
        if (availableFonts[0].contains(fontFileLookup)) {
            return null;
        }
        TTFParser tTFParser = new TTFParser();
        List list = tTFParser.parseAllFontNames(fontFileLookup);
        Vector<String> vector = new Vector<String>(list.size());
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                TTFFontNames tTFFontNames = (TTFFontNames)list.get(i2);
                fontFileLookup.setTTFFontNames(tTFFontNames);
                vector.add(tTFFontNames.fontName);
                availableFonts[0].put(tTFFontNames.fontName, fontFileLookup);
                if (tTFFontNames.subFamilyName.equals("Bold")) {
                    automaticFontNameMapTable.put(tTFFontNames.familyName + "-Bold", tTFFontNames.fontName);
                    continue;
                }
                if (tTFFontNames.subFamilyName.equals("Bold Italic") || tTFFontNames.subFamilyName.equals("Bold Oblique")) {
                    automaticFontNameMapTable.put(tTFFontNames.familyName + "-BoldItalic", tTFFontNames.fontName);
                    continue;
                }
                if (tTFFontNames.subFamilyName.equals("Italic") || tTFFontNames.subFamilyName.equals("Oblique")) {
                    automaticFontNameMapTable.put(tTFFontNames.familyName + "-Italic", tTFFontNames.fontName);
                    continue;
                }
                automaticFontNameMapTable.put(tTFFontNames.familyName, tTFFontNames.fontName);
                automaticFontNameMapTable.put(tTFFontNames.fullName, tTFFontNames.fontName);
            }
        }
        return vector;
    }

    public static void addFontNameMap(String string, String string2) throws IOException {
        FontLibrary.addFontNameMap(string, string2, -100);
    }

    public static void addFontNameMap(String string, String string2, int n2) throws IOException {
        FontLibrary.initFontLibrary();
        if (string == null) {
            throw new IllegalArgumentException("location may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        FontFileLookup fontFileLookup = new FontFileLookup(0, string, string2, 2);
        FontLibrary.addFontNameMapBundle(fontFileLookup, n2);
    }

    protected static void addFontNameMapBundle(FontFileLookup fontFileLookup, int n2) throws IOException {
        if (userFontBundleLookups.contains(fontFileLookup)) {
            return;
        }
        ResourceBundle resourceBundle = fontFileLookup.getResourceBundle();
        if (resourceBundle == null) {
            return;
        }
        userFontBundleLookups.add(fontFileLookup);
        FontLibrary.addFontNameMap(resourceBundle, n2);
    }

    public static void addFontNameMap(URL uRL, String string) throws IOException {
        FontLibrary.addFontNameMap(uRL, string, -100);
    }

    public static void addFontNameMap(ResourceBundle resourceBundle, int n2) {
        if (resourceBundle != null) {
            if (n2 == 0) {
                userFontBundles[0].add(resourceBundle);
            } else if (n2 == 1 || n2 == -100) {
                userFontBundles[0].add(resourceBundle);
            }
        }
    }

    public static void addFontNameMap(URL uRL, String string, int n2) throws IOException {
        FontLibrary.initFontLibrary();
        if (uRL == null) {
            throw new IllegalArgumentException("location may not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        FontFileLookup fontFileLookup = new FontFileLookup(1, uRL, string, 2);
        FontLibrary.addFontNameMapBundle(fontFileLookup, n2);
    }

    public static void addFontNameMap(URL uRL) throws IOException {
        FontLibrary.addFontNameMap(uRL, -100);
    }

    public static void addFontNameMap(URL uRL, int n2) throws IOException {
        FontLibrary.initFontLibrary();
        if (uRL == null) {
            throw new IllegalArgumentException("location URL may not be null");
        }
        FontFileLookup fontFileLookup = new FontFileLookup(2, uRL, "", 2);
        FontLibrary.addFontNameMapBundle(fontFileLookup, n2);
    }

    public static void addRelativeFontNameMap(String string, String string2) throws IOException {
        FontLibrary.addRelativeFontNameMap(string, string2, -100);
    }

    public static void addRelativeFontNameMap(String string, String string2, int n2) throws IOException {
        FontLibrary.initFontLibrary();
        if (string == null) {
            throw new IllegalArgumentException("location may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        FontFileLookup fontFileLookup = new FontFileLookup(3, string, string2, 2);
        FontLibrary.addFontNameMapBundle(fontFileLookup, n2);
    }

    public static String lookupFontNameByUserAlias(String string, int n2) {
        String string2 = null;
        string2 = FontLibrary.lookupUserFontName(string, n2);
        if (string2 == null && (string2 = FontLibrary.lookupStockFontName(string, n2)) == null && (string2 = FontLibrary.lookupAutomaticFontName(string)) == null) {
            if (availableFonts[n2].containsKey(string) || availableStockFonts[n2].containsKey(string)) {
                string2 = string;
            } else if (availableFonts[n2].containsKey(string + "-Regular") || availableStockFonts[n2].containsKey(string + "-Regular")) {
                string2 = string + "-Regular";
            } else {
                String string3 = "Times-Roman";
                if (!FontLibrary.getSuppressErrorMessages()) {
                    System.err.println("Warning: font " + string + " not mapped, " + "substituting " + string3);
                }
                if ((string2 = FontLibrary.lookupUserFontName(string3, n2)) == null && (string2 = FontLibrary.lookupStockFontName(string3, n2)) == null) {
                    string2 = new String(string3);
                }
            }
        }
        return string2.trim();
    }

    public static String lookupStockFontName(String string, int n2) {
        FontLibrary.initFontLibrary();
        String string2 = null;
        if (stockFontNameMapBundles[n2] != null) {
            try {
                string2 = stockFontNameMapBundles[n2].getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (string.indexOf(32) >= 0) {
                    try {
                        string2 = stockFontNameMapBundles[n2].getString(string.replace(' ', '_'));
                    }
                    catch (MissingResourceException missingResourceException2) {
                        string2 = null;
                    }
                }
                string2 = null;
            }
        }
        return string2;
    }

    public static String lookupAutomaticFontName(String string) {
        FontLibrary.initFontLibrary();
        String string2 = null;
        if (automaticFontNameMapTable != null) {
            string2 = (String)automaticFontNameMapTable.get(string);
        }
        return string2;
    }

    public static String lookupUserFontName(String string, int n2) {
        FontLibrary.initFontLibrary();
        String string2 = null;
        if (userFontBundles[n2] != null) {
            for (int i2 = 0; i2 < userFontBundles[n2].size(); ++i2) {
                ResourceBundle resourceBundle = (ResourceBundle)userFontBundles[n2].get(i2);
                try {
                    string2 = resourceBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    if (string.indexOf(32) >= 0) {
                        try {
                            string2 = resourceBundle.getString(string.replace(' ', '_'));
                        }
                        catch (MissingResourceException missingResourceException2) {
                            string2 = null;
                        }
                    }
                    string2 = null;
                }
                if (string2 != null) break;
            }
        }
        return string2;
    }

    public static String[] getAvailableFontNames() {
        Object object;
        int n2;
        Object object2;
        FontLibrary.initFontLibrary();
        TreeSet<String> treeSet = new TreeSet<String>();
        int n3 = 0;
        ResourceBundle resourceBundle = stockFontNameMapBundles[n3];
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            boolean bl = true;
            for (n2 = n3 + 1; n2 < 1; ++n2) {
                object = stockFontNameMapBundles[n2];
                try {
                    ((ResourceBundle)object).getObject((String)object2);
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            String string = ((String)object2).replace('_', ' ');
            treeSet.add(string);
        }
        object2 = automaticFontNameMapTable.keys();
        while (object2.hasMoreElements()) {
            String string = (String)object2.nextElement();
            treeSet.add(string);
        }
        List list = userFontBundles[n3];
        for (n2 = 0; n2 < list.size(); ++n2) {
            resourceBundle = (ResourceBundle)list.get(n2);
            enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                boolean bl = true;
                for (int i2 = n3 + 1; i2 < 1 && bl; ++i2) {
                    List list2 = userFontBundles[i2];
                    boolean bl2 = false;
                    for (int i3 = 0; i3 < list2.size() && !bl2; ++i3) {
                        ResourceBundle resourceBundle2 = (ResourceBundle)list2.get(i3);
                        try {
                            resourceBundle2.getObject((String)object);
                            bl2 = true;
                            continue;
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                }
                if (!bl) continue;
                String string = ((String)object).replace('_', ' ');
                treeSet.add(string);
            }
        }
        String[] stringArray = new String[treeSet.size()];
        object = treeSet.iterator();
        int n4 = 0;
        while (object.hasNext()) {
            stringArray[n4] = (String)object.next();
            ++n4;
        }
        return stringArray;
    }

    public static String[] getAvailableFontNames(int n2) {
        Object object;
        Object object2;
        Object object3;
        FontLibrary.initFontLibrary();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        ResourceBundle resourceBundle = stockFontNameMapBundles[n2];
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            object3 = enumeration.nextElement();
            object2 = ((String)object3).replace('_', ' ');
            treeSet.add(object2);
        }
        object3 = automaticFontNameMapTable.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            treeSet.add(object2);
        }
        object2 = userFontBundles[n2];
        for (int i2 = 0; i2 < object2.size(); ++i2) {
            resourceBundle = (ResourceBundle)object2.get(i2);
            enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                String string = ((String)object).replace('_', ' ');
                treeSet.add(string);
            }
        }
        String[] stringArray = new String[treeSet.size()];
        object = treeSet.iterator();
        int n3 = 0;
        while (object.hasNext()) {
            stringArray[n3] = (String)object.next();
            ++n3;
        }
        return stringArray;
    }

    public static FontFileLookup lookupFontFile(String string, int n2) {
        FontFileLookup fontFileLookup = null;
        fontFileLookup = (FontFileLookup)availableFonts[n2].get(string);
        if (fontFileLookup == null) {
            fontFileLookup = (FontFileLookup)availableStockFonts[n2].get(string);
        }
        return fontFileLookup;
    }

    public static TrueTypeFontProperties getTrueTypeFontProperties(String string, int n2) {
        FontLibrary.initFontLibrary();
        String string2 = FontLibrary.lookupFontNameByUserAlias(string, n2);
        TrueTypeFontProperties trueTypeFontProperties = (TrueTypeFontProperties)FontLibrary.trueTypeFontProperties.get(string2);
        if (trueTypeFontProperties == null) {
            trueTypeFontProperties = new TrueTypeFontProperties();
            FontLibrary.trueTypeFontProperties.put(string2, trueTypeFontProperties);
        }
        return trueTypeFontProperties;
    }

    public static TrueTypeFontProperties lookupTrueTypeFontProperties(String string) {
        FontLibrary.initFontLibrary();
        TrueTypeFontProperties trueTypeFontProperties = (TrueTypeFontProperties)FontLibrary.trueTypeFontProperties.get(string);
        if (trueTypeFontProperties == null) {
            trueTypeFontProperties = new TrueTypeFontProperties();
            FontLibrary.trueTypeFontProperties.put(string, trueTypeFontProperties);
        }
        return trueTypeFontProperties;
    }

    public static boolean isAFMFile(String string) {
        return string.endsWith(".afm") || string.endsWith(".AFM");
    }

    public static boolean isTrueTypeFile(String string) {
        return string.endsWith(".ttf") || string.endsWith(".TTF") || string.endsWith(".ttc") || string.endsWith(".TTC");
    }

    public static List getTTFFontNames(String string) throws IOException {
        if (string == null) {
            return new Vector();
        }
        File file = new File(string);
        FontFileLookup fontFileLookup = new FontFileLookup(0, file.getPath(), 1);
        TTFParser tTFParser = new TTFParser();
        List list = tTFParser.parseFontNames(fontFileLookup);
        return list;
    }

    public static List getTTFFontNames(URL uRL) throws IOException {
        if (uRL == null) {
            return new Vector();
        }
        FontFileLookup fontFileLookup = new FontFileLookup(2, uRL, 1);
        TTFParser tTFParser = new TTFParser();
        List list = tTFParser.parseFontNames(fontFileLookup);
        return list;
    }
}

