/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.PrintGrid;
import com.klg.jclass.higrid.PrintGrid12;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.Walkable;
import java.awt.print.PageFormat;
import java.util.Vector;

class PrePrintWalk
implements Walkable {
    static final long serialVersionUID = 2182520562385955747L;
    private PrintGrid printGrid;
    private HiGrid grid;
    private int rowPageCount;
    private int printableHeight;
    private int printableWidth;
    private int height;
    private int width;
    private Vector rowNodeList;
    private boolean stop;

    public PrePrintWalk(PrintGrid12 printGrid12, HiGrid hiGrid, PageFormat pageFormat) {
        this.printGrid = printGrid12;
        this.grid = hiGrid;
        this.height = 0;
        this.width = 0;
        this.rowPageCount = 0;
        this.rowNodeList = null;
        if (hiGrid == null || printGrid12 == null) {
            this.stop = true;
            return;
        }
        this.printableHeight = (int)pageFormat.getImageableHeight();
        this.printableWidth = (int)pageFormat.getImageableWidth();
        this.stop = false;
    }

    public boolean getDownward() {
        return true;
    }

    public boolean done() {
        return this.stop;
    }

    public void next(RowNode rowNode) {
        this.width = Math.max(this.width, rowNode.getRowFormat().getTotalPrintWidth(this.grid, rowNode.getFormatNode(), this.printableWidth));
        int n2 = rowNode.getHeight();
        if (this.height + n2 > this.printableHeight) {
            ++this.rowPageCount;
            this.height = n2;
            if (this.rowNodeList != null) {
                this.rowNodeList.addElement(rowNode);
            }
        } else {
            this.height += n2;
        }
        if (this.rowNodeList == null) {
            this.rowNodeList = new Vector(10);
            this.rowNodeList.addElement(rowNode);
        }
    }

    public void previous(RowNode rowNode) {
    }

    public boolean find(RowNode rowNode) {
        return this.stop;
    }

    public int getColumnPages() {
        int n2 = 0;
        if (this.printableWidth != 0) {
            n2 = this.width / this.printableWidth;
            if (this.width % this.printableWidth > 0) {
                ++n2;
            }
        }
        return n2;
    }

    public int getRowPages() {
        int n2 = this.rowPageCount;
        if (this.height > 0) {
            ++n2;
        }
        return n2;
    }

    public int getPrintPages() {
        return this.getRowPages() * this.getColumnPages();
    }

    public Vector getRowNodeList() {
        return this.rowNodeList;
    }
}

