/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.TreeIterator;
import com.klg.jclass.higrid.AfterDetailsFormat;
import com.klg.jclass.higrid.BeforeDetailsFormat;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.CellStyle;
import com.klg.jclass.higrid.CellStyleModel;
import com.klg.jclass.higrid.FooterFormat;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridData;
import com.klg.jclass.higrid.HiGridEditStatusRenderer;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.HiGridFormatNodeEvent;
import com.klg.jclass.higrid.HiGridHeaderRenderer;
import com.klg.jclass.higrid.HiGridNodeRenderer;
import com.klg.jclass.higrid.HiGridUpdateEvent;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowFormat;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class FormatTree
extends DataSourceTreeModel {
    static final long serialVersionUID = 8410535555861981597L;
    protected static final int INDEX_RECORD = 0;
    protected static final int INDEX_FOOTER = 1;
    protected static final int INDEX_BEFORE_DETAILS = 2;
    protected static final int INDEX_AFTER_DETAILS = 3;
    protected static final int METADATA_ARRAY_SIZE = 4;
    private transient HiGrid grid;

    public FormatTree(HiGrid hiGrid) {
        super(DataSourceTreeModel.NullRoot);
        this.grid = hiGrid;
    }

    public void createFormatTreeFromDataModel(DataModel dataModel) {
        ((HiGridData)dataModel).createSummaryMetaTree();
        MetaDataModel[] metaDataModelArray = new MetaDataModel[]{(MetaDataModel)dataModel.getMetaDataTree().getRoot(), (MetaDataModel)((HiGridData)dataModel).getFooterMetaTree().getRoot(), (MetaDataModel)((HiGridData)dataModel).getBeforeDetailsMetaTree().getRoot(), (MetaDataModel)((HiGridData)dataModel).getAfterDetailsMetaTree().getRoot()};
        FormatNode formatNode = new FormatNode(0);
        this.setRoot(formatNode);
        this.createFormats(formatNode, metaDataModelArray);
        this.createFormatTreeFromNode(formatNode, metaDataModelArray, formatNode.getIndent());
        this.grid.fireHiGridUpdateEvent(new HiGridUpdateEvent(this.grid, 1));
    }

    protected void createFormatTreeFromNode(FormatNode formatNode, MetaDataModel[] metaDataModelArray, int n2) {
        MetaDataModel[] metaDataModelArray2 = new MetaDataModel[4];
        ++n2;
        TreeIterator treeIterator = ((DataSourceTreeNode)((Object)metaDataModelArray[0])).getIterator();
        TreeIterator treeIterator2 = ((DataSourceTreeNode)((Object)metaDataModelArray[1])).getIterator();
        TreeIterator treeIterator3 = ((DataSourceTreeNode)((Object)metaDataModelArray[2])).getIterator();
        TreeIterator treeIterator4 = ((DataSourceTreeNode)((Object)metaDataModelArray[3])).getIterator();
        while (treeIterator.hasMoreElements()) {
            metaDataModelArray2[0] = (MetaDataModel)treeIterator.get();
            metaDataModelArray2[1] = (MetaDataModel)treeIterator2.get();
            metaDataModelArray2[2] = (MetaDataModel)treeIterator3.get();
            metaDataModelArray2[3] = (MetaDataModel)treeIterator4.get();
            FormatNode formatNode2 = new FormatNode(n2);
            this.createFormats(formatNode2, metaDataModelArray2);
            formatNode.add(formatNode2);
            this.createFormatTreeFromNode(formatNode2, metaDataModelArray2, n2);
            treeIterator.nextElement();
            treeIterator2.nextElement();
            treeIterator3.nextElement();
            treeIterator4.nextElement();
        }
    }

    protected void resetRuntimeInfo() {
        this.resetRuntimeInfo((FormatNode)this.getRoot());
    }

    protected void resetRuntimeInfo(FormatNode formatNode) {
        if (formatNode == null) {
            return;
        }
        formatNode.resetRuntimeInfo();
        TreeIterator treeIterator = formatNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            FormatNode formatNode2 = (FormatNode)treeIterator.get();
            this.resetRuntimeInfo(formatNode2);
            treeIterator.nextElement();
        }
    }

    private int getStringWidth(FontMetrics fontMetrics, Font font, String string) {
        return fontMetrics.stringWidth(string) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
    }

    protected void createFormats(FormatNode formatNode, MetaDataModel[] metaDataModelArray) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        MetaDataModel metaDataModel = metaDataModelArray[0];
        this.grid.fireHiGridFormatNodeEvent(new HiGridFormatNodeEvent(this.grid, 1, formatNode, metaDataModel));
        int n2 = 0;
        try {
            n2 = metaDataModel.getColumnCount();
        }
        catch (Exception exception) {
            this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
        }
        HeaderFormat headerFormat = new HeaderFormat();
        headerFormat.createIndicatorFormats(this.grid);
        Vector<Object> vector = new Vector<Object>(n2);
        int n3 = 0;
        while (n3 < n2) {
            serializable = new CellFormat(this.grid.getHeaderCellStyle());
            ((CellFormat)serializable).setParent(headerFormat);
            String string = null;
            try {
                string = metaDataModel.getColumnIdentifier(n3);
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
            ((CellFormat)serializable).setName(string);
            object3 = null;
            try {
                object3 = metaDataModel.getColumnObject(string).getColumnLabel();
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
            ((CellFormat)serializable).setText((String)object3);
            ((CellFormat)serializable).setDefaultSize(this.grid, true);
            ((CellFormat)serializable).setCellRenderer(this.grid.lookupTable.getHeaderRenderer().getClass());
            vector.addElement(serializable);
            ++n3;
        }
        headerFormat.setMetaData(metaDataModel);
        headerFormat.setDataFormats(vector);
        formatNode.setHeaderFormat(headerFormat);
        serializable = new RecordFormat();
        ((RowFormat)serializable).createIndicatorFormats(this.grid);
        vector = new Vector(n2);
        int n4 = 0;
        while (n4 < n2) {
            object3 = new CellFormat(this.grid.getRecordCellStyle());
            ((CellFormat)object3).setParent((RowFormat)serializable);
            object2 = null;
            try {
                object2 = metaDataModel.getColumnIdentifier(n4);
                object = metaDataModel.getColumnObject((String)object2);
                ((CellFormat)object3).setEditable(true);
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
            ((CellFormat)object3).setName((String)object2);
            ((CellFormat)object3).setWidth(((CellFormat)headerFormat.getDataFormats().elementAt(n4)).getWidth());
            object = ((CellStyle)object3).getFont();
            FontMetrics fontMetrics = this.grid.getFontMetrics((Font)object);
            ((CellFormat)object3).setFont(fontMetrics, (Font)object);
            try {
                ((CellFormat)object3).setType(metaDataModel.getJavaColumnType((String)object2));
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
            ((CellFormat)object3).setCellRenderer(this.grid.lookupTable.getDefaultCellRenderer(((CellFormat)object3).getType()));
            ((CellFormat)object3).setCellEditor(this.grid.lookupTable.getDefaultCellEditor(((CellFormat)object3).getType()));
            vector.addElement(object3);
            ++n4;
        }
        ((RowFormat)serializable).setMetaData(metaDataModel);
        ((RowFormat)serializable).setDataFormats(vector);
        formatNode.setRecordFormat((RecordFormat)serializable);
        object3 = new FooterFormat();
        ((RowFormat)object3).setMetaData(metaDataModelArray[1]);
        formatNode.setFooterFormat((FooterFormat)object3);
        object2 = new BeforeDetailsFormat();
        ((RowFormat)object2).setMetaData(metaDataModelArray[2]);
        formatNode.setBeforeDetailsFormat((BeforeDetailsFormat)object2);
        object = new AfterDetailsFormat();
        ((RowFormat)object).setMetaData(metaDataModelArray[3]);
        formatNode.setAfterDetailsFormat((AfterDetailsFormat)object);
        this.grid.fireHiGridFormatNodeEvent(new HiGridFormatNodeEvent(this.grid, 2, formatNode, metaDataModel));
    }

    public void setSummaryFormat(RowFormat rowFormat, MetaDataModel metaDataModel) {
        this.setSummaryFormat(rowFormat, metaDataModel, this.grid.getRecordCellStyle());
    }

    public void setSummaryFormat(RowFormat rowFormat, MetaDataModel metaDataModel, CellStyleModel cellStyleModel) {
        int n2 = 0;
        try {
            n2 = metaDataModel.getColumnCount();
        }
        catch (Exception exception) {
            this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
        }
        rowFormat.createIndicatorFormats(this.grid);
        Vector<CellFormat> vector = new Vector<CellFormat>(n2);
        int n3 = 0;
        while (n3 < n2) {
            CellFormat cellFormat = new CellFormat(cellStyleModel);
            cellFormat.setParent(rowFormat);
            Font font = cellFormat.getFont();
            FontMetrics fontMetrics = this.grid.getFontMetrics(font);
            cellFormat.setFont(fontMetrics, font);
            String string = null;
            try {
                string = metaDataModel.getColumnIdentifier(n3);
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
            cellFormat.setName(string);
            cellFormat.setWidth(this.getStringWidth(fontMetrics, font, string) + cellFormat.getMarginInsets().left + cellFormat.getMarginInsets().right + cellFormat.getBorderInsets().left + cellFormat.getBorderInsets().right);
            try {
                cellFormat.setType(metaDataModel.getJavaColumnType(string));
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
            cellFormat.setEditable(false);
            cellFormat.setCellRenderer(this.grid.lookupTable.getDefaultCellRenderer(cellFormat.getType()));
            vector.addElement(cellFormat);
            ++n3;
        }
        rowFormat.setDataFormats(vector);
    }

    protected CellFormat findCellFormat(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (!cellFormat.getName().equals(string)) continue;
            return cellFormat;
        }
        return null;
    }

    public CellFormat searchRowFormat(String string, FormatNode formatNode, int n2) {
        if (formatNode == null) {
            return null;
        }
        CellFormat cellFormat = null;
        if (n2 == 0) {
            int n3 = 1;
            while (n3 <= 5) {
                cellFormat = this.findCellFormat(string, formatNode.getRowFormat(n3).getDataFormats());
                if (cellFormat == null) {
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            cellFormat = this.findCellFormat(string, formatNode.getRowFormat(n2).getDataFormats());
        }
        return cellFormat;
    }

    public CellFormat findCellFormat(String string, FormatNode formatNode, int n2) {
        if (formatNode == null && ((formatNode = (FormatNode)this.getRoot()) == null || (n2 < 1 || n2 > 5) && n2 != 0)) {
            return null;
        }
        Enumeration<TreeNode> enumeration = formatNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            FormatNode formatNode2 = (FormatNode)enumeration.nextElement();
            CellFormat cellFormat = this.searchRowFormat(string, formatNode2, n2);
            if (cellFormat == null) continue;
            return cellFormat;
        }
        return null;
    }

    public void resetAllNodeRenderers(HiGridNodeRenderer hiGridNodeRenderer) {
        this.resetAllRenderers(hiGridNodeRenderer.getClass(), -10);
    }

    public void resetAllEditStatusRenderers(HiGridEditStatusRenderer hiGridEditStatusRenderer) {
        this.resetAllRenderers(hiGridEditStatusRenderer.getClass(), -11);
    }

    protected void resetAllRenderers(Class clazz, int n2) {
        Enumeration<TreeNode> enumeration = ((FormatNode)this.getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            FormatNode formatNode = (FormatNode)enumeration.nextElement();
            int n3 = 1;
            while (n3 <= 5) {
                int n4 = this.grid.getIndicatorIndex(formatNode.getRowFormat(n3).getIndicatorFormats(), n2);
                if (n4 >= 0) {
                    CellFormat cellFormat = (CellFormat)formatNode.getRowFormat(n3).getIndicatorFormats().elementAt(n4);
                    cellFormat.setCellRenderer(clazz);
                }
                ++n3;
            }
        }
    }

    public void resetAllHeaderRenderers(HiGridHeaderRenderer hiGridHeaderRenderer) {
        Class<?> clazz = hiGridHeaderRenderer.getClass();
        Enumeration<TreeNode> enumeration = ((FormatNode)this.getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            FormatNode formatNode = (FormatNode)enumeration.nextElement();
            Enumeration enumeration2 = formatNode.getHeaderFormat().getDataFormats().elements();
            while (enumeration2.hasMoreElements()) {
                CellFormat cellFormat = (CellFormat)enumeration2.nextElement();
                cellFormat.setCellRenderer(clazz);
            }
        }
    }

    public void resetPlaf() {
        if (this.getRoot() == null || this.grid == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = ((FormatNode)this.getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            FormatNode formatNode = (FormatNode)enumeration.nextElement();
            int n2 = 1;
            while (n2 <= 5) {
                CellFormat cellFormat;
                RowFormat rowFormat = formatNode.getRowFormat(n2);
                CellStyleModel cellStyleModel = this.grid.getCellStyle(n2);
                Enumeration enumeration2 = rowFormat.getIndicatorFormats().elements();
                while (enumeration2.hasMoreElements()) {
                    cellFormat = (CellFormat)enumeration2.nextElement();
                    cellFormat.copyPlafFromCellStyle(this.grid.getHeaderCellStyle());
                    cellFormat.setSelectedBackground(cellFormat.getBackground());
                    cellFormat.setSelectedForeground(cellFormat.getForeground());
                }
                Enumeration enumeration3 = rowFormat.getDataFormats().elements();
                while (enumeration3.hasMoreElements()) {
                    cellFormat = (CellFormat)enumeration3.nextElement();
                    cellFormat.copyPlafFromCellStyle(cellStyleModel);
                }
                ++n2;
            }
        }
    }
}

