/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.FolderIcons;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;

public class FolderIconStyle
implements Serializable {
    static final long serialVersionUID = 6876423810461928052L;
    public static final int FOLDER_ICON_STYLE_USER_DEFINED = 0;
    public static final int FOLDER_ICON_STYLE_SHORTCUT = 1;
    public static final int FOLDER_ICON_STYLE_FOLDER = 2;
    public static final int FOLDER_ICON_STYLE_TRIANGLE = 3;
    public static final int FOLDER_ICON_STYLE_SMALL_LINE_3D = 4;
    public static final int FOLDER_ICON_STYLE_MEDIUM_LINE_3D = 5;
    public static final int FOLDER_ICON_STYLE_LARGE_LINE_3D = 6;
    public static final int FOLDER_ICON_STYLE_TURNER = 7;
    protected static final int FIRST_FOLDER_ICON_STYLE = 1;
    protected static final int LAST_FOLDER_ICON_STYLE = 7;
    protected static final int DEFAULT_FOLDER_ICON_STYLE = 1;
    private static final String[] shortcutOpenIcon = new String[]{".........", ".       .", ".       .", ".       .", ". ..... .", ".       .", ".       .", ".       .", "........."};
    private static final String[] shortcutClosedIcon = new String[]{".........", ".       .", ".   .   .", ".   .   .", ". ..... .", ".   .   .", ".   .   .", ".       .", "........."};
    private HiGrid grid = null;
    private int style;
    private transient Image[] folderIcons = null;

    public FolderIconStyle(HiGrid hiGrid) {
        this.grid = hiGrid;
        this.recreateIcons();
    }

    protected void recreateIcons() {
        if (this.folderIcons == null) {
            this.folderIcons = new Image[3];
            this.setStyle(1);
        }
    }

    protected int getMaximumHeight() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            Image image = this.getFolderIcon(n3);
            if (image != null) {
                n2 = Math.max(n2, image.getHeight(null));
            }
            ++n3;
        }
        return n2;
    }

    protected int getMaximumWidth() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            Image image = this.getFolderIcon(n3);
            if (image != null) {
                n2 = Math.max(n2, image.getWidth(null));
            }
            ++n3;
        }
        return n2;
    }

    protected int getStyle() {
        return this.style;
    }

    protected void validateGridNodeWidth() {
        int n2 = this.getMaximumWidth();
        if (n2 > this.grid.getNodeWidth()) {
            this.grid.setNodeWidth(n2);
        }
    }

    protected void setStyle(int n2) {
        if (n2 < 1 || n2 > 7) {
            n2 = 1;
        }
        JCIconCreator jCIconCreator = null;
        if (n2 == 1) {
            jCIconCreator = new JCIconCreator(9, 9);
            jCIconCreator.setColor('X', new Color(235, 235, 128));
            jCIconCreator.setColor('.', Color.black);
            jCIconCreator.setPixels(shortcutOpenIcon);
            this.setIcon(jCIconCreator.getIcon().getImage(), 1);
            jCIconCreator.clear();
            jCIconCreator.setPixels(shortcutClosedIcon);
            this.setIcon(jCIconCreator.getIcon().getImage(), 0);
            this.setIcon(null, 2);
        } else {
            FolderIcons folderIcons = new FolderIcons(this.grid, this);
            folderIcons.setStyle(n2);
        }
        this.style = n2;
        this.validateGridNodeWidth();
    }

    public Image getFolderIcon(int n2) {
        this.recreateIcons();
        return this.folderIcons[n2];
    }

    public void setFolderIcon(Image image, int n2) {
        this.recreateIcons();
        this.folderIcons[n2] = image;
        this.style = 0;
        this.validateGridNodeWidth();
    }

    protected void setIcon(Image image, int n2) {
        this.recreateIcons();
        this.folderIcons[n2] = image;
    }
}

