/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.Controller;
import com.klg.jclass.higrid.DefaultDataModelListener;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.HiGridExpansionEvent;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.PopupMenuList;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.RowTree;
import com.klg.jclass.util.swing.JCHTMLPane;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;

public class EditPopupMenu
extends JPopupMenu
implements ActionListener {
    static final long serialVersionUID = 8019952542645451744L;
    public static final int DEFAULT_SHORT_POPUPMENU_LIST = 0;
    public static final int DEFAULT_LONG_POPUPMENU_LIST = 1;
    public static final int POPUP_INSERT = 0;
    public static final int POPUP_APPEND = 1;
    public static final int POPUP_DELETE = 2;
    public static final int POPUP_DELETE_CURRENT = 3;
    public static final int POPUP_DELETE_SELECTED = 4;
    public static final int POPUP_CANCEL = 5;
    public static final int POPUP_CANCEL_CURRENT = 6;
    public static final int POPUP_CANCEL_SELECTED = 7;
    public static final int POPUP_CANCEL_ALL = 8;
    public static final int POPUP_REQUERY = 9;
    public static final int POPUP_REQUERY_RECORD = 10;
    public static final int POPUP_REQUERY_RECORD_AND_DETAILS = 11;
    public static final int POPUP_REQUERY_SELECTED = 12;
    public static final int POPUP_REQUERY_SELECTED_AND_DETAILS = 13;
    public static final int POPUP_REQUERY_TABLE = 14;
    public static final int POPUP_REQUERY_ALL = 15;
    public static final int POPUP_UPDATE = 16;
    public static final int POPUP_UPDATE_CURRENT = 17;
    public static final int POPUP_UPDATE_SELECTED = 18;
    public static final int POPUP_UPDATE_ALL = 19;
    public static final int POPUP_SELECT = 20;
    public static final int POPUP_SELECT_CURRENT = 21;
    public static final int POPUP_SELECT_ALL_IN_SAME_LEVEL = 22;
    public static final int POPUP_SELECT_ALL_IN_SAME_TABLE = 23;
    public static final int POPUP_SELECT_ALL = 24;
    public static final int POPUP_MOVE_TO_RECORD = 25;
    public static final int POPUP_MOVE_TO_RECORD_FIRST = 26;
    public static final int POPUP_MOVE_TO_RECORD_PREVIOUS = 27;
    public static final int POPUP_MOVE_TO_RECORD_NEXT = 28;
    public static final int POPUP_MOVE_TO_RECORD_LAST = 29;
    public static final int POPUP_MOVE_TO_TABLE_RECORD = 30;
    public static final int POPUP_MOVE_TO_TABLE_RECORD_FIRST = 31;
    public static final int POPUP_MOVE_TO_TABLE_RECORD_PREVIOUS = 32;
    public static final int POPUP_MOVE_TO_TABLE_RECORD_NEXT = 33;
    public static final int POPUP_MOVE_TO_TABLE_RECORD_LAST = 34;
    public static final int POPUP_MOVE_TO_PARENT = 35;
    public static final int POPUP_COLLAPSE_PARENT = 36;
    public static final int POPUP_PRINT = 37;
    public static final int POPUP_PRINT_AS_DISPLAYED = 38;
    public static final int POPUP_PRINT_AS_EXPANDED = 39;
    public static final int POPUP_PRINT_EXPAND_ALL = 40;
    public static final int POPUP_PRINT_PREVIEW = 41;
    public static final int POPUP_PRINT_PREVIEW_AS_DISPLAYED = 42;
    public static final int POPUP_PRINT_PREVIEW_AS_EXPANDED = 43;
    public static final int POPUP_PRINT_PREVIEW_EXPAND_ALL = 44;
    public static final int POPUP_TIPS = 45;
    public static final int POPUP_TIPS_KEYBOARD = 46;
    public static final int POPUP_TIPS_MOUSE = 47;
    public static final int POPUP_TIPS_MENU = 48;
    protected static final int NO_RECORDS_START_INDEX = 25;
    protected static final int NO_RECORDS_END_INDEX = 49;
    protected String[] commands = new String[]{"Insert", "Append", "Delete", "DeleteCurrent", "DeleteSelected", "Cancel", "CancelCurrent", "CancelSelected", "CancelAll", "Requery", "RequeryRecord", "RequeryRecordAndDetails", "RequerySelected", "RequerySelectedAndDetails", "RequeryTable", "RequeryAll", "Update", "UpdateCurrent", "UpdateSelected", "UpdateAll", "Select", "SelectCurrent", "SelectAllSameLevel", "SelectAllSameTable", "SelectAll", "MoveToGridRecord", "MoveToGridRecordFirst", "MoveToGridRecordPrevious", "MoveToGridRecordNext", "MoveToGridRecordLast", "MoveToTableRecord", "MoveToTableRecordFirst", "MoveToTableRecordPrevious", "MoveToTableRecordNext", "MoveToTableRecordLast", "MoveToParent", "CollapseParent", "Print", "PrintAsDisplayed", "PrintAsExpanded", "PrintExpandAll", "PrintPreview", "PrintPreviewAsDisplayed", "PrintPreviewAsExpanded", "PrintPreviewExpandAll", "tips", "tipsKeyboard", "tipsMouse", "tipsMenu"};
    protected Vector insertList;
    protected HiGrid grid;

    public EditPopupMenu(HiGrid hiGrid) {
        this.grid = hiGrid;
        if (!"tipsMenu".equals(this.getCommand(48))) {
            System.out.println("HiGrid : Error in EditPopupMenu command set.");
        }
        this.setDefaultMenuList(1);
    }

    public void dispose() {
        this.setInvoker(null);
        this.grid = null;
        this.insertList = null;
        this.removeAll();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.performAction(actionEvent);
    }

    public void setDefaultMenuList(int n2) {
        PopupMenuList popupMenuList = new PopupMenuList(this, this);
        popupMenuList.setMenu(n2);
    }

    public JMenuItem createMenu(int n2) {
        String string = this.getCommand(n2);
        if (string == null) {
            return null;
        }
        JMenu jMenu = new JMenu(LocaleBundle.string(string));
        if (jMenu != null) {
            jMenu.setActionCommand(string);
        }
        return jMenu;
    }

    public JMenuItem createMenuItem(int n2) {
        String string = this.getCommand(n2);
        if (string == null) {
            return null;
        }
        JMenuItem jMenuItem = new JMenuItem(LocaleBundle.string(string));
        if (jMenuItem != null) {
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(this);
        }
        return jMenuItem;
    }

    public String getCommand(int n2) {
        if (n2 >= 0 && n2 < this.commands.length) {
            return this.commands[n2];
        }
        return null;
    }

    protected int findMenuIndex(MenuElement[] menuElementArray, int n2) {
        int n3 = -1;
        int n4 = menuElementArray.length;
        String string = this.getCommand(n2);
        int n5 = 0;
        while (n5 < n4) {
            if (((JMenuItem)menuElementArray[n5]).getText().equals(string)) {
                n3 = n5;
                break;
            }
            ++n5;
        }
        return n3;
    }

    protected void buildDynamicSubMenu(JMenuItem jMenuItem, String string) {
        jMenuItem.removeAll();
        Enumeration enumeration = this.insertList.elements();
        while (enumeration.hasMoreElements()) {
            FormatNode formatNode = (FormatNode)enumeration.nextElement();
            JMenuItem jMenuItem2 = new JMenuItem(formatNode.getName());
            if (jMenuItem2 == null) continue;
            jMenuItem2.setActionCommand(string + " " + formatNode.toString());
            jMenuItem2.addActionListener(this);
            jMenuItem.add(jMenuItem2);
        }
    }

    public void show(int n2, int n3) {
        int n4;
        MenuElement[] menuElementArray = this.getSubElements();
        int n5 = this.findMenuIndex(menuElementArray, 0);
        int n6 = this.findMenuIndex(menuElementArray, 1);
        CellPosition cellPosition = this.grid.getCurrentCell();
        if (cellPosition != null && cellPosition.row != null) {
            this.insertList = this.grid.getRowTree().getNodeLevelList(cellPosition.row);
        } else if (cellPosition == null && this.grid.getDataModel() != null) {
            this.insertList = this.grid.getRowTree().getNodeLevelList(null);
        }
        if (this.insertList != null) {
            JMenuItem jMenuItem;
            if (n5 != -1) {
                jMenuItem = (JMenuItem)menuElementArray[n5];
                this.buildDynamicSubMenu(jMenuItem, "Insert");
            }
            if (n6 != -1) {
                jMenuItem = (JMenuItem)menuElementArray[n6];
                this.buildDynamicSubMenu(jMenuItem, "Append");
            }
        }
        boolean bl = this.grid.isEditable();
        if (this.insertList != null) {
            this.enableMenuItem(this, this.getCommand(0), bl);
            this.enableMenuItem(this, this.getCommand(1), bl);
        }
        if (cellPosition == null) {
            n4 = 25;
            while (n4 < 49) {
                this.enableMenuItem(this, this.getCommand(n4), false);
                ++n4;
            }
            this.enableMenuItem(this, this.getCommand(2), false);
            this.enableMenuItem(this, this.getCommand(5), false);
            this.enableMenuItem(this, this.getCommand(16), false);
            this.enableMenuItem(this, this.getCommand(20), false);
            this.enableMenuItem(this, this.getCommand(9), false);
        } else {
            n4 = 25;
            while (n4 < 49) {
                this.enableMenuItem(this, this.getCommand(n4), true);
                ++n4;
            }
            this.enableMenuItem(this, this.getCommand(9), true);
            this.enableMenuItem(this, this.getCommand(2), bl);
            this.enableMenuItem(this, this.getCommand(5), bl);
            this.enableMenuItem(this, this.getCommand(16), bl);
            boolean bl2 = !this.grid.getController().selectedRowNodes.isEmpty();
            this.enableMenuItem(this, this.getCommand(4), bl2);
            this.enableMenuItem(this, this.getCommand(7), bl2);
            this.enableMenuItem(this, this.getCommand(12), bl2);
            this.enableMenuItem(this, this.getCommand(13), bl2);
            this.enableMenuItem(this, this.getCommand(18), bl2);
            this.enableMenuItem(this, this.getCommand(20), this.grid.isAllowRowSelection());
            switch (this.grid.getRowSelectionMode()) {
                case 2: {
                    this.enableMenuItem(this, this.getCommand(24), false);
                    this.enableMenuItem(this, this.getCommand(22), false);
                    break;
                }
                case 1: {
                    this.enableMenuItem(this, this.getCommand(24), false);
                    this.enableMenuItem(this, this.getCommand(22), true);
                    break;
                }
                default: {
                    this.enableMenuItem(this, this.getCommand(24), true);
                    this.enableMenuItem(this, this.getCommand(22), true);
                }
            }
        }
        this.getComponent().setSize(this.getComponent().getPreferredSize());
        Point point = new Point(n2, n3);
        SwingUtilities.convertPointToScreen(point, this.grid.getGridArea());
        Rectangle rectangle = this.computePopupBounds(point.x, point.y, this.getWidth(), this.getHeight());
        point.setLocation(rectangle.x, rectangle.y);
        SwingUtilities.convertPointFromScreen(point, this.grid.getGridArea());
        super.show(this.grid.getGridArea(), point.x, point.y);
    }

    protected Rectangle computePopupBounds(int n2, int n3, int n4, int n5) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        Point point = new Point(n2, n3);
        Rectangle rectangle2 = new Rectangle(point.x, point.y, n4, n5);
        if (this.isRectangleContainingRectangle(rectangle, rectangle2)) {
            return rectangle2;
        }
        if (!this.isRectangleContainingRectangleFitRight(rectangle, rectangle2)) {
            rectangle2.x = rectangle.width - rectangle2.width;
        }
        if (!this.isRectangleContainingRectangleFitLeft(rectangle, rectangle2)) {
            rectangle2.x = rectangle.x;
        }
        if (!this.isRectangleContainingRectangleFitDown(rectangle, rectangle2)) {
            rectangle2.y -= rectangle2.height;
        }
        if (!this.isRectangleContainingRectangleFitUp(rectangle, rectangle2)) {
            rectangle2.y = rectangle.y;
        }
        return rectangle2;
    }

    private final boolean isRectangleContainingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    private final boolean isRectangleContainingRectangleFitLeft(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.x < rectangle2.x;
    }

    private final boolean isRectangleContainingRectangleFitRight(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x + rectangle2.width < rectangle.x + rectangle.width;
    }

    private final boolean isRectangleContainingRectangleFitDown(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    private final boolean isRectangleContainingRectangleFitUp(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.y < rectangle2.y;
    }

    public boolean enableMenuItem(Object object, String string, boolean bl) {
        MenuElement[] menuElementArray = object instanceof JPopupMenu ? ((JPopupMenu)object).getSubElements() : ((JMenu)object).getPopupMenu().getSubElements();
        int n2 = menuElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            JMenuItem jMenuItem;
            String string2;
            MenuElement menuElement = menuElementArray[n3];
            if (menuElement instanceof JMenu) {
                if (this.enableMenuItem(menuElement, string, bl)) {
                    return true;
                }
            } else if (menuElement instanceof JMenuItem && (string2 = (jMenuItem = (JMenuItem)menuElement).getActionCommand()).equals(string)) {
                jMenuItem.setEnabled(bl);
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void performAction(ActionEvent actionEvent) {
        this.performCommand(actionEvent.getActionCommand());
    }

    public void performCommand(int n2) {
        this.performCommand(this.getCommand(n2));
    }

    private void traverse(CellPosition cellPosition, int n2) {
        this.grid.getController().validateAndTraverse(cellPosition, n2, null);
    }

    protected void showTips(String string, String string2) {
        JDialog jDialog = new JDialog();
        jDialog.setTitle(LocaleBundle.string(string));
        jDialog.setModal(false);
        JCHTMLPane jCHTMLPane = new JCHTMLPane();
        jCHTMLPane.setText(LocaleBundle.string(string2));
        JScrollPane jScrollPane = new JScrollPane(jCHTMLPane);
        jDialog.getContentPane().add(jScrollPane);
        jDialog.pack();
        jDialog.setSize(600, 400);
        jDialog.setVisible(true);
    }

    public void performCommand(String string) {
        if (string == null) {
            return;
        }
        CellPosition cellPosition = this.grid.getCurrentCell();
        DataTableModel dataTableModel = null;
        long l2 = 0L;
        DataModel dataModel = this.grid.getDataModel();
        if (cellPosition != null && cellPosition.row != null) {
            dataTableModel = cellPosition.row.getDataTableModel();
            l2 = cellPosition.row.getBookmark();
        } else if (cellPosition == null && dataModel != null) {
            dataTableModel = (DataTableModel)dataModel.getDataTableTree().getRoot();
        }
        if (dataTableModel == null || dataModel == null) {
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        Enumeration enumeration = null;
        Vector vector = null;
        Controller controller = this.grid.getController();
        try {
            Object object;
            if (string.equals(this.getCommand(3))) {
                dataTableModel.deleteRow(this.grid.getDataModelListener(), l2);
                bl2 = true;
            } else if (string.equals(this.getCommand(4))) {
                boolean bl3 = this.grid.isBatched();
                this.grid.setBatched(true);
                vector = (Vector)controller.selectedRowNodes.clone();
                controller.resetRowSelection(false);
                try {
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        DataTableModel dataTableModel2;
                        object = (RowNode)enumeration.nextElement();
                        if (object == null || (dataTableModel2 = ((RowNode)object).getDataTableModel()) == null) continue;
                        dataTableModel2.deleteRow(this.grid.getDataModelListener(), ((RowNode)object).getBookmark());
                    }
                }
                catch (Exception exception) {
                    this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
                }
                this.grid.setBatched(bl3);
            } else if (string.equals(this.getCommand(6))) {
                controller.cancelCellEditing();
                dataTableModel.cancelRowChanges(this.grid.getDataModelListener(), l2);
                bl2 = true;
            } else if (string.equals(this.getCommand(7))) {
                l2 = cellPosition.row.getBookmark();
                vector = (Vector)controller.selectedRowNodes.clone();
                controller.resetRowSelection(false);
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    RowNode rowNode = (RowNode)enumeration.nextElement();
                    if (rowNode == null || (object = rowNode.getDataTableModel()) == null) continue;
                    object.cancelRowChanges(this.grid.getDataModelListener(), rowNode.getBookmark());
                    if (l2 != rowNode.getBookmark()) continue;
                    controller.cancelCellEditing();
                }
            } else if (string.equals(this.getCommand(8))) {
                controller.resetRowSelection(false);
                controller.cancelCellEditing();
                dataModel.cancelAll(this.grid.getDataModelListener());
            } else if (string.equals(this.getCommand(10))) {
                dataTableModel.requeryRow(this.grid.getDataModelListener(), l2);
                bl2 = true;
            } else if (string.equals(this.getCommand(12))) {
                vector = (Vector)controller.selectedRowNodes.clone();
                controller.resetRowSelection(false);
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    RowNode rowNode = (RowNode)enumeration.nextElement();
                    if (rowNode == null || (object = rowNode.getDataTableModel()) == null) continue;
                    object.requeryRow(this.grid.getDataModelListener(), rowNode.getBookmark());
                }
            } else if (string.equals(this.getCommand(11))) {
                dataTableModel.requeryRowAndDetails(this.grid.getDataModelListener(), l2);
                bl2 = true;
            } else if (string.equals(this.getCommand(13))) {
                vector = (Vector)controller.selectedRowNodes.clone();
                controller.resetRowSelection(false);
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    RowNode rowNode = (RowNode)enumeration.nextElement();
                    if (rowNode == null || (object = rowNode.getDataTableModel()) == null) continue;
                    object.requeryRowAndDetails(this.grid.getDataModelListener(), rowNode.getBookmark());
                }
            } else if (string.equals(this.getCommand(14))) {
                dataTableModel.requeryTable(this.grid.getDataModelListener());
                bl2 = true;
            } else if (string.equals(this.getCommand(15))) {
                dataModel.requeryAll(this.grid.getDataModelListener());
                bl2 = true;
            } else if (string.equals(this.getCommand(17))) {
                dataTableModel.commitRow(this.grid.getDataModelListener(), l2);
                bl2 = true;
            } else if (string.equals(this.getCommand(18))) {
                enumeration = controller.selectedRowNodes.elements();
                while (enumeration.hasMoreElements()) {
                    RowNode rowNode = (RowNode)enumeration.nextElement();
                    if (rowNode == null || (object = rowNode.getDataTableModel()) == null) continue;
                    object.commitRow(this.grid.getDataModelListener(), rowNode.getBookmark());
                }
                bl2 = true;
            } else if (string.equals(this.getCommand(19))) {
                controller.resetRowSelection(false);
                dataModel.updateAll(this.grid.getDataModelListener());
            } else if (string.equals(this.getCommand(21))) {
                controller.resetRowSelection();
                controller.doRowSelection(cellPosition.row, this.grid.getRowSelectionMode(), false);
            } else if (string.equals(this.getCommand(22))) {
                controller.doRowSelection(cellPosition.row, 1);
            } else if (string.equals(this.getCommand(23))) {
                controller.doRowSelection(cellPosition.row, 2);
            } else if (string.equals(this.getCommand(24))) {
                controller.doRowSelection(cellPosition.row, 0);
            } else if (string.equals(this.getCommand(26))) {
                CellPosition cellPosition2 = controller.goHome();
                this.traverse(cellPosition2, controller.getDesiredColumn());
                bl2 = true;
            } else if (string.equals(this.getCommand(27))) {
                CellPosition cellPosition3 = controller.goUp();
                this.traverse(cellPosition3, controller.getDesiredColumn());
                bl2 = true;
            } else if (string.equals(this.getCommand(28))) {
                CellPosition cellPosition4 = controller.goDown();
                this.traverse(cellPosition4, controller.getDesiredColumn());
                bl2 = true;
            } else if (string.equals(this.getCommand(29))) {
                CellPosition cellPosition5 = controller.goEnd();
                this.traverse(cellPosition5, controller.getDesiredColumn());
                bl2 = true;
            } else if (string.equals(this.getCommand(31))) {
                CellPosition cellPosition6 = controller.goLevelHome();
                this.traverse(cellPosition6, controller.getDesiredColumn());
                bl2 = true;
            } else if (string.equals(this.getCommand(32))) {
                CellPosition cellPosition7 = controller.goLevelUp();
                this.traverse(cellPosition7, controller.getDesiredColumn());
                bl2 = true;
            } else if (string.equals(this.getCommand(33))) {
                CellPosition cellPosition8 = controller.goLevelDown();
                this.traverse(cellPosition8, controller.getDesiredColumn());
                bl2 = true;
            } else if (string.equals(this.getCommand(34))) {
                CellPosition cellPosition9 = controller.goLevelEnd();
                this.traverse(cellPosition9, controller.getDesiredColumn());
                bl2 = true;
            } else if (string.equals(this.getCommand(35))) {
                CellPosition cellPosition10 = controller.goLevelParent();
                if (cellPosition10 != null && cellPosition.row != cellPosition10.row) {
                    this.traverse(cellPosition10, controller.getDesiredColumn());
                }
                bl2 = true;
            } else if (string.equals(this.getCommand(36))) {
                CellPosition cellPosition11 = controller.goLevelParent();
                if (cellPosition11 != null && cellPosition.row != cellPosition11.row) {
                    object = cellPosition11.row;
                    if (!this.grid.fireHiGridExpansionEvent(new HiGridExpansionEvent(this.grid, 2, (RowNode)object))) {
                        return;
                    }
                    this.traverse(cellPosition11, controller.getDesiredColumn());
                    if (((RowNode)object).getState() == 1) {
                        this.grid.refreshRowAndBelow((RowNode)object, 1);
                    }
                }
                bl2 = true;
            } else if (string.equals(this.getCommand(38))) {
                controller.resetRowSelection();
                this.grid.setPrintFormat(0);
                this.grid.print();
            } else if (string.equals(this.getCommand(39))) {
                controller.resetRowSelection();
                this.grid.setPrintFormat(1);
                this.grid.print();
            } else if (string.equals(this.getCommand(40))) {
                controller.resetRowSelection();
                this.grid.setPrintFormat(2);
                this.grid.print();
            } else if (string.equals(this.getCommand(42))) {
                controller.resetRowSelection();
                this.grid.setPrintFormat(0);
                this.grid.printPreview();
            } else if (string.equals(this.getCommand(43))) {
                controller.resetRowSelection();
                this.grid.setPrintFormat(1);
                this.grid.printPreview();
            } else if (string.equals(this.getCommand(44))) {
                controller.resetRowSelection();
                this.grid.setPrintFormat(2);
                this.grid.printPreview();
            } else if (string.equals(this.getCommand(46))) {
                this.showTips("tipsKeyboard", "tipsKeyboardText");
            } else if (string.equals(this.getCommand(47))) {
                this.showTips("tipsMouse", "tipsMouseText");
            } else if (string.equals(this.getCommand(48))) {
                this.showTips("tipsMenu", "tipsMenuText");
            } else {
                bl = false;
            }
            if (!bl && this.insertList != null) {
                enumeration = this.insertList.elements();
                while (enumeration.hasMoreElements()) {
                    boolean bl4;
                    FormatNode formatNode = (FormatNode)enumeration.nextElement();
                    object = formatNode.toString();
                    boolean bl5 = string.equals("Insert " + (String)object);
                    boolean bl6 = string.equals("Append " + (String)object);
                    if (!bl5 && !bl6) continue;
                    bl = true;
                    DataTableModel dataTableModel3 = null;
                    boolean bl7 = bl4 = cellPosition != null && cellPosition.row.getFormatNode() != formatNode;
                    if (!bl4) {
                        dataTableModel3 = dataTableModel;
                    } else {
                        RowTree rowTree = this.grid.getRowTree();
                        if (cellPosition.row.getState() == 0) {
                            if (!this.grid.fireHiGridExpansionEvent(new HiGridExpansionEvent(this.grid, 1, cellPosition.row))) {
                                return;
                            }
                            rowTree.openFolder(cellPosition.row);
                            DataModelListener dataModelListener = this.grid.getDataModelListener();
                            if (dataModelListener instanceof DefaultDataModelListener) {
                                ((DefaultDataModelListener)dataModelListener).setLastOpenedRowNode(cellPosition.row);
                            }
                        }
                        if ((dataTableModel3 = rowTree.getDataTableModel(formatNode, cellPosition.row)) == null) {
                            dataTableModel3 = dataTableModel.getTable(l2, formatNode.getRecordFormat().getMetaData());
                        }
                    }
                    if (dataTableModel3 != null) {
                        int n2 = bl4 ? (bl5 ? 0 : -1) : (cellPosition == null ? 0 : (bl5 ? dataTableModel3.getRowIndex(cellPosition.row.getBookmark()) : dataTableModel3.getRowIndex(cellPosition.row.getBookmark()) + 1));
                        dataTableModel3.addRow(this.grid.getDataModelListener(), dataTableModel3.createNewRow(), 2, n2);
                    }
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                controller.resetRowSelection();
            }
        }
        catch (Exception exception) {
            this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
        }
    }
}

