/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.DataModelAdapter;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.TreeIterator;
import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridData;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.HiGridInternalData;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.RowTree;
import com.klg.jclass.higrid.SortData;
import com.klg.jclass.higrid.SummaryRefreshWalk;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class DefaultDataModelListener
extends DataModelAdapter
implements Serializable {
    static final long serialVersionUID = 6484051278069816163L;
    private HiGrid grid = null;
    protected boolean refreshGrid = true;
    protected RowNode cellRowNode = null;
    protected RowNode lastOpenedRowNode = null;

    protected DefaultDataModelListener(HiGrid hiGrid) {
        this.grid = hiGrid;
        this.refreshGrid = true;
        this.setLastOpenedRowNode(null);
    }

    public void beforeInsertRow(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
    }

    public void beforeReset(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
    }

    public void beforeRequery(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
    }

    public void beforeEditCell(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
    }

    public void beforeDeleteRow(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
    }

    public void beforeCommitAll(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
    }

    public void beforeCancelAll(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
    }

    public void beforeCancelRowChanges(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
    }

    public void beforeCommitConditional(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        long l2 = dataModelEvent.getBookmark();
        RowNode rowNode = this.grid.getCurrentRowNode();
        if (rowNode != null && this.isAncestor(rowNode, l2) && !this.grid.getController().commitAndConvert()) {
            dataModelEvent.cancelProposedAction();
        }
    }

    public void beforeCommitRow(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        long l2 = dataModelEvent.getBookmark();
        RowNode rowNode = this.grid.getCurrentRowNode();
        if (rowNode != null && rowNode.getBookmark() == l2 && !this.grid.getController().commitAndConvert()) {
            dataModelEvent.cancelProposedAction();
        }
    }

    public void beforeMoveToCurrentRow(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        if (!this.grid.getController().validateCell(null, false)) {
            dataModelEvent.cancelProposedAction();
        }
    }

    public void beforeDeleteTable(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        if (!this.grid.getRowTree().parentFolderClosed(dataModelEvent.getTable())) {
            dataModelEvent.cancelProposedAction();
        }
    }

    public void afterChangeOfRowData(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        long l2 = dataModelEvent.getBookmark();
        this.grid.resetSortIndications(l2, false);
        RowTree rowTree = this.grid.getRowTree();
        RowNode rowNode = rowTree.findRecordRowNode(null, l2);
        if (rowNode != null) {
            if (rowNode.getState() == 2 && rowNode.getFormatNode().hasChildren()) {
                rowNode.setState((byte)0);
            }
            this.refreshRow(rowNode);
        }
    }

    public void afterInsertRow(DataModelEvent dataModelEvent) {
        DataSourceTreeNode dataSourceTreeNode;
        Serializable serializable;
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        long l2 = dataModelEvent.getBookmark();
        this.grid.resetSortIndications(l2, false);
        boolean bl = false;
        DataTableModel dataTableModel = dataModelEvent.getTable();
        RowTree rowTree = this.grid.getRowTree();
        RowNode rowNode = this.getLastOpenedRowNode();
        this.setLastOpenedRowNode(null);
        RowNode rowNode2 = rowTree.findFirstRowNode(null, dataTableModel);
        RowNode rowNode3 = null;
        CellPosition cellPosition = this.grid.getCurrentCell();
        if (cellPosition == null) {
            RowNode rowNode4;
            serializable = (RowNode)rowTree.getRoot();
            dataSourceTreeNode = (FormatNode)this.grid.getFormatTree().getRoot();
            if (((FormatNode)dataSourceTreeNode).getHeaderFormat().isShowing()) {
                rowNode4 = rowTree.createRowNode((FormatNode)dataSourceTreeNode, ((FormatNode)dataSourceTreeNode).getHeaderFormat(), dataTableModel, 0L);
                rowTree.addRowNode((RowNode)serializable, rowNode4, null);
                rowTree.addTotalNumberOfScrollableRows(rowNode4, (FormatNode)dataSourceTreeNode);
            }
            rowNode3 = rowTree.createRowNode((FormatNode)dataSourceTreeNode, ((FormatNode)dataSourceTreeNode).getRecordFormat(), dataTableModel, l2);
            rowTree.addRowNode((RowNode)serializable, rowNode3, null);
            rowNode3.setState((byte)2);
            rowTree.addTotalNumberOfScrollableRows(rowNode3, (FormatNode)dataSourceTreeNode);
            if (((FormatNode)dataSourceTreeNode).getFooterFormat().isShowing()) {
                rowNode4 = rowTree.createRowNode((FormatNode)dataSourceTreeNode, ((FormatNode)dataSourceTreeNode).getFooterFormat(), dataTableModel, 0L);
                rowTree.addRowNode((RowNode)serializable, rowNode4, null);
                rowTree.addTotalNumberOfScrollableRows(rowNode4, (FormatNode)dataSourceTreeNode);
            }
            bl = true;
        } else if (rowNode2 != null) {
            SortData sortData;
            DataSourceTreeNode dataSourceTreeNode2;
            int n2 = dataModelEvent.getRowIndex();
            dataSourceTreeNode = rowTree.findFirstRowNode(null, dataTableModel);
            RowNode rowNode5 = (RowNode)dataSourceTreeNode.getParent();
            DataSourceTreeNode dataSourceTreeNode3 = dataSourceTreeNode;
            while (n2 >= dataTableModel.getRowIndex(((RowNode)dataSourceTreeNode3).getBookmark())) {
                dataSourceTreeNode2 = (RowNode)dataSourceTreeNode3.getNextSibling();
                if (dataSourceTreeNode2 != null && ((RowNode)dataSourceTreeNode2).getDataTableModel() == dataTableModel) {
                    dataSourceTreeNode3 = (RowNode)dataSourceTreeNode3.getNextSibling();
                    continue;
                }
                dataSourceTreeNode3 = (RowNode)dataSourceTreeNode3.getNextSibling();
                break;
            }
            dataSourceTreeNode2 = rowNode2.getFormatNode();
            rowNode3 = rowTree.createRowNode((FormatNode)dataSourceTreeNode2, ((FormatNode)dataSourceTreeNode2).getRecordFormat(), dataTableModel, l2);
            rowTree.addRowNode(rowNode5, rowNode3, (RowNode)dataSourceTreeNode3);
            rowTree.addTotalNumberOfScrollableRows(rowNode3, (FormatNode)dataSourceTreeNode2);
            rowNode3.setState((byte)2);
            bl = true;
            HiGridInternalData hiGridInternalData = (HiGridInternalData)dataTableModel.getInternalData(this.grid);
            if (hiGridInternalData != null && (sortData = hiGridInternalData.getSortData()) != null) {
                this.grid.sortDataTable(rowNode3, sortData.getColumnName(), sortData.getDirection(), false);
            }
        } else {
            serializable = rowTree.findRecordRowNode(null, dataTableModel.getParentBookmark());
            if (serializable != null) {
                if (!((DataSourceTreeNode)serializable).hasChildren()) {
                    try {
                        rowTree.setSortTable(false);
                        rowTree.createRuntimeChildren((RowNode)serializable);
                        rowTree.setSortTable(true);
                    }
                    catch (Exception exception) {
                        this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
                    }
                    rowTree.addTotalNumberOfScrollableRows(rowTree.getNumberOfScrollableRows((RowNode)serializable, true));
                    rowTree.addRepeatHeader((RowNode)serializable);
                    ((RowNode)serializable).setState((byte)1);
                } else {
                    rowTree.setSortTable(false);
                    dataSourceTreeNode = rowTree.createRuntimeChildren((RowNode)serializable, dataTableModel);
                    rowTree.setSortTable(true);
                    if (dataSourceTreeNode != null) {
                        rowTree.addTotalNumberOfScrollableRows(rowTree.getNumberOfScrollableRows((RowNode)serializable, (FormatNode)dataSourceTreeNode, true));
                    }
                }
                rowNode3 = rowTree.findRecordRowNode((RowNode)serializable, l2);
                if (rowNode3 != null) {
                    rowNode3.setState((byte)2);
                }
                bl = true;
            }
        }
        if (bl && dataModelEvent.getOriginator() == this.grid.getDataModelListener()) {
            rowTree.setGridAreaRows();
            serializable = new CellPosition(rowNode3, rowNode3.getRowFormat().getFirstVisibleCell());
            this.grid.getHorizontalScrollbar().setValue(0);
            if (!this.grid.getController().validateAndTraverse((CellPosition)serializable, ((CellPosition)serializable).columnIndex, null)) {
                try {
                    dataTableModel.cancelRowChanges(this, l2);
                }
                catch (Exception exception) {
                    this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
                }
                if (rowNode != null) {
                    rowTree.closeFolder(rowNode);
                } else {
                    rowTree.setGridAreaRows();
                }
            }
        }
        if (bl) {
            this.refresh();
        }
    }

    public void afterDeleteRow(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        long l2 = dataModelEvent.getBookmark();
        RowTree rowTree = this.grid.getRowTree();
        RowNode rowNode = rowTree.findRecordRowNode(null, l2);
        if (rowNode != null) {
            this.cellRowNode = this.moveCurrentCell(rowNode, false);
            if (rowNode.getState() == 1) {
                rowTree.closeFolder(rowNode);
            }
            FormatNode formatNode = rowNode.getFormatNode();
            RowNode rowNode2 = rowTree.findPreviousRecordRowNode(rowNode, formatNode);
            RowNode rowNode3 = rowTree.findNextRecordRowNode(rowNode, formatNode);
            if (rowNode2 != null && rowNode3 == null) {
                rowTree.removeRepeatHeader(rowNode2);
            }
            RowNode rowNode4 = (RowNode)rowNode.getParent();
            rowTree.subtractTotalNumberOfScrollableRows(rowNode, formatNode);
            rowNode4.remove(rowNode);
            boolean bl = false;
            if (rowTree.findRecordRowNode(rowNode4, formatNode) == null) {
                TreeIterator treeIterator = rowNode4.getIterator();
                while (treeIterator.hasMoreElements()) {
                    RowNode rowNode5 = (RowNode)treeIterator.get();
                    if (rowNode5.getFormatNode() == formatNode) {
                        rowTree.subtractTotalNumberOfScrollableRows(rowNode5, formatNode);
                        rowNode4.remove(rowNode5);
                    } else {
                        bl = true;
                    }
                    treeIterator.nextElement();
                }
                if (!bl) {
                    if (rowNode4.getState() != 2) {
                        rowNode4.setState((byte)2);
                    }
                    rowTree.removeRepeatHeader(rowNode4);
                }
            }
            rowTree.setTopRow(this.grid.getVerticalScrollbar().getValue());
            ((HiGridData)this.grid.getDataModel()).resetSummaryDataTables(this.grid, true);
            this.refresh();
        }
    }

    public void afterReset(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        this.grid.resetRunTimeGrid();
        this.refresh();
    }

    public void afterMoveToCurrentRow(DataModelEvent dataModelEvent) {
        RowNode rowNode;
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        long l2 = dataModelEvent.getBookmark();
        CellPosition cellPosition = this.grid.getCurrentCell();
        if (cellPosition != null && cellPosition.row != null && cellPosition.row.getBookmark() != l2 && (rowNode = this.grid.getRowTree().findRecordRowNode(null, l2)) != null && rowNode != cellPosition.row && !this.grid.getController().isTraversing()) {
            this.grid.getController().repositionCurrentCell(rowNode, true, false);
        }
        if (this.grid.isScrollOnMoveEvent()) {
            this.grid.getController().makeCellEditorVisible();
        }
    }

    public void afterRequeryRowAndDetails(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        long l2 = dataModelEvent.getBookmark();
        this.grid.resetSortIndications(l2, true);
        RowTree rowTree = this.grid.getRowTree();
        RowNode rowNode = null;
        RowNode rowNode2 = rowTree.findRecordRowNode(null, l2);
        if (rowNode2 != null) {
            boolean bl;
            boolean bl2 = bl = rowNode2.getState() == 1;
            if (bl) {
                rowNode = this.moveCurrentCell(rowNode2, true);
                rowTree.closeFolder(rowNode2);
            }
            rowNode2.removeAllChildren();
            if (bl) {
                rowTree.openFolder(rowNode2);
            }
            rowTree.setTopRow(this.grid.getVerticalScrollbar().getValue());
            this.refresh();
        }
    }

    public void afterRequeryTable(DataModelEvent dataModelEvent) {
        Serializable serializable;
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        long l2 = dataModelEvent.getBookmark();
        this.grid.resetSortIndications(l2, false);
        RowNode rowNode = this.grid.getCurrentRowNode();
        DataTableModel dataTableModel = dataModelEvent.getTable();
        if (rowNode == null || dataTableModel == null) {
            return;
        }
        RowTree rowTree = this.grid.getRowTree();
        RowNode rowNode2 = rowNode;
        RowNode rowNode3 = rowNode;
        FormatNode formatNode = rowNode.getFormatNode();
        while ((rowNode = (RowNode)rowNode.getPreviousSibling()) != null && rowNode.getFormatNode() == formatNode) {
            rowNode3 = rowNode;
        }
        int n2 = rowTree.createRuntimeChildren((RowNode)rowNode2.getParent(), formatNode, dataTableModel, true, rowNode3);
        if (n2 == 0) {
            this.cellRowNode = rowTree.findPreviousRecordRowNode(rowNode3, null);
        } else {
            this.cellRowNode = rowTree.findPreviousRecordRowNode(rowNode3, formatNode);
            serializable = this.grid.getController().goLevelHome(this.cellRowNode);
            this.cellRowNode = ((CellPosition)serializable).row;
        }
        if (this.cellRowNode != null) {
            this.grid.getController().repositionCurrentCell(this.cellRowNode, true, true);
            this.cellRowNode = null;
        } else {
            this.grid.getController().setCurrentCell(null);
        }
        rowNode = rowNode3;
        while (rowNode != null) {
            if (rowNode != null) {
                boolean bl;
                boolean bl2 = bl = rowNode.getState() == 1;
                if (bl) {
                    rowTree.closeFolder(rowNode);
                }
                rowNode.removeAllChildren();
            }
            serializable = rowNode;
            rowNode = (RowNode)rowNode.getNextSibling();
            ((RowNode)((DefaultMutableTreeNode)serializable).getParent()).remove((MutableTreeNode)((Object)serializable));
            if (rowNode == null || rowNode.getFormatNode() != formatNode) break;
        }
        rowTree.setTopRow(this.grid.getVerticalScrollbar().getValue());
        this.refresh();
    }

    public void beginEvents(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        this.refreshGrid = false;
    }

    public void endEvents(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        long l2 = dataModelEvent.getBookmark();
        this.refreshGrid = true;
        this.refresh();
    }

    public void originatorNavigateRow(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
        if (this.cellRowNode != null) {
            this.grid.getController().repositionCurrentCell(this.cellRowNode, true, true);
            this.cellRowNode = null;
        }
    }

    public void initialize(DataModelEvent dataModelEvent) {
        if (this.grid == null || dataModelEvent == null) {
            return;
        }
    }

    protected RowNode getLastOpenedRowNode() {
        return this.lastOpenedRowNode;
    }

    protected void setLastOpenedRowNode(RowNode rowNode) {
        this.lastOpenedRowNode = rowNode;
    }

    protected void refreshRow(RowNode rowNode) {
        this.grid.getController().initializeEditor();
        this.grid.refreshRowWithoutEditor(rowNode);
        ((HiGridData)this.grid.getDataModel()).resetSummaryDataTables(this.grid, false);
        SummaryRefreshWalk summaryRefreshWalk = new SummaryRefreshWalk(this.grid, this.grid.getGridArea().getSize().height);
        this.grid.getRowTree().walk(this.grid.getRowTree().getTopRowNode(), summaryRefreshWalk);
    }

    protected void refresh() {
        if (this.refreshGrid) {
            ((HiGridData)this.grid.getDataModel()).resetSummaryDataTables(this.grid, false);
            this.grid.refresh();
        }
    }

    protected boolean updateEditStatus(long l2) {
        RowTree rowTree = this.grid.getRowTree();
        RowNode rowNode = rowTree.findRecordRowNode(null, l2);
        if (rowNode != null) {
            this.grid.refreshEditStatus(rowNode);
            return true;
        }
        return false;
    }

    protected RowNode moveCurrentCell(RowNode rowNode, boolean bl) {
        FormatNode formatNode;
        CellPosition cellPosition = this.grid.getCurrentCell();
        RowNode rowNode2 = null;
        if (cellPosition == null || cellPosition.row == null) {
            return rowNode2;
        }
        if (bl) {
            if (cellPosition.row.isChildOf(rowNode)) {
                rowNode2 = rowNode;
            }
            return rowNode2;
        }
        if (cellPosition.row != rowNode && !cellPosition.row.isChildOf(rowNode)) {
            return rowNode2;
        }
        RowTree rowTree = this.grid.getRowTree();
        RowNode rowNode3 = rowTree.findNextRecordRowNode(rowNode, formatNode = rowNode.getFormatNode());
        if (rowNode3 == null) {
            rowNode3 = rowTree.findPreviousRecordRowNode(rowNode, formatNode);
        }
        if (rowNode3 == null && (rowNode3 = rowTree.findNextRecordRowNode(rowNode, null)) == null) {
            rowNode3 = rowTree.findPreviousRecordRowNode(rowNode, null);
        }
        if (rowNode3 == null && (rowNode3 = (RowNode)rowNode.getParent()) == (RowNode)rowTree.getRoot()) {
            rowNode3 = null;
        }
        if (rowNode3 != null) {
            rowNode2 = rowNode3;
        }
        if (rowNode2 == null) {
            this.grid.getController().setCurrentCell(null);
        }
        return rowNode2;
    }

    protected boolean isAncestor(RowNode rowNode, long l2) {
        if (rowNode.getBookmark() == l2) {
            return true;
        }
        Vector vector = new Vector();
        rowNode.getDataTableModel().getAncestors(vector);
        int n2 = 0;
        while (n2 < vector.size()) {
            if (l2 == (Long)vector.elementAt(n2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

