/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge.property.xml;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.io.JCParseException;
import com.klg.jclass.util.io.LoadProperties;
import com.klg.jclass.util.property.PropertyAccessModel;
import com.klg.jclass.util.property.xml.LocalizedPropertyHandler;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import com.klg.jclass.util.xml.JCXMLDTDResolver;
import com.klg.jclass.util.xml.JCXMLErrorPrinter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GaugeHandler
extends LocalizedPropertyHandler {
    protected PropertyAccessModel pam = null;
    protected StringBuffer sb = null;
    protected String prefix = null;
    protected String attName = null;
    protected String attValue = null;
    protected LinkedList<String> prefixList = null;
    protected boolean inBorder = false;
    protected boolean inTitledBorder = false;
    protected boolean inCompoundBorder = false;
    protected boolean inLinearRange = false;
    protected int fillStyleCount = 0;
    protected Stack<CompoundBorder> compoundBorderStack = null;
    protected Color color = null;
    protected Font font = null;
    protected Border savedBorder = null;
    protected Insets insets = null;
    protected boolean inExternalCode = false;
    protected int externalCodeCount = 0;
    protected int needleCount = 1;
    protected int indicatorCount = 1;
    protected int tickCount = 1;
    protected int rangeCount = 1;
    protected int labelCount = 1;
    protected int indicatorRangeCount = 0;
    protected int legendColumnCount = 0;
    protected boolean inValues = false;
    protected boolean haveScale = false;
    protected boolean haveCenter = false;
    protected ArrayList<String> gaugeAreaComponents = new ArrayList();
    protected ArrayList<String> scaleComponents = new ArrayList();

    public GaugeHandler(PropertyAccessModel propertyAccessModel) {
        this.pam = propertyAccessModel;
        this.localeHandler = propertyAccessModel.getLoadProperties().getLocaleHandler();
    }

    public void addPrefix(String string) {
        this.prefixList.addLast(this.prefix);
        this.prefix = this.prefix + string;
    }

    public void setPrefix(String string) {
        this.prefixList.addLast(this.prefix);
        this.prefix = string;
    }

    public void popPrefix() {
        this.prefix = this.prefixList.removeLast();
    }

    public void addBackForePrefix(Attributes attributes, String string) {
        this.addPrefix(this.getBackForeString(attributes) + string);
    }

    protected String getBackForeString(Attributes attributes) {
        String string = "";
        if (attributes == null) {
            return string;
        }
        int n2 = attributes.getIndex("isBackground");
        if (n2 > -1) {
            this.attValue = attributes.getValue(n2);
            boolean bl = JCTypeConverter.toBoolean(this.attValue, true);
            string = bl ? "back." : "fore.";
        }
        return string;
    }

    public void startDocument() throws SAXException {
        this.prefixList = new LinkedList();
        this.prefix = "";
    }

    public void endDocument() throws SAXException {
        this.prefixList = null;
        this.prefix = null;
        this.attName = null;
        this.attValue = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("circular-gauge")) {
            this.attName = "gaugeType";
            this.attValue = "circular-gauge";
            this.pam.setProperty(this.attName, this.attValue);
            this.addPrefix("circular-gauge.");
            this.handleAttribute(attributes, "gaugeType");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "height");
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "antiAliasing");
            this.handleAttribute(attributes, "snapToValue");
        } else if (string3.equals("circular-scale")) {
            if (!this.haveScale) {
                this.addPrefix("circular-scale.");
                this.handleAttribute(attributes, "direction");
                this.handleAttribute(attributes, "startAngle");
                this.handleAttribute(attributes, "stopAngle");
                this.handleAttribute(attributes, "paintCompleteBackground");
                this.handleAttribute(attributes, "zoomFactor");
                this.handleAttribute(attributes, "max");
                this.handleAttribute(attributes, "min");
                this.handleAttribute(attributes, "background");
                this.handleAttribute(attributes, "visible");
                this.handleAttribute(attributes, "opaque");
                this.handleAttribute(attributes, "allSpaceUsed");
                this.gaugeAreaComponents.add(this.prefix);
            }
        } else if (string3.equals("empty-border") || string3.equals("bevel-border") || string3.equals("etched-border") || string3.equals("line-border") || string3.equals("matte-border") || string3.equals("titled-border")) {
            this.handleBorder(string3, attributes, true);
        } else if (string3.equals("compound-border")) {
            this.handleCompoundBorder(true);
        } else if (string3.equals("insets")) {
            this.handleInsets(attributes);
        } else if (string3.equals("center")) {
            if (!this.haveCenter) {
                this.addPrefix("center.");
                this.handleAttribute(attributes, "radius");
                this.handleAttribute(attributes, "background");
                this.handleAttribute(attributes, "opaque");
                this.handleAttribute(attributes, "visible");
                this.gaugeAreaComponents.add(this.prefix);
            }
            this.haveCenter = true;
        } else if (string3.equals("linear-gauge")) {
            this.attName = "gaugeType";
            this.attValue = "linear-gauge";
            this.pam.setProperty(this.attName, this.attValue);
            this.addPrefix("linear-gauge.");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "height");
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "paintCompleteBackground");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "antiAliasing");
            this.handleAttribute(attributes, "snapToValue");
        } else if (string3.equals("linear-scale")) {
            if (!this.haveScale) {
                this.addPrefix("linear-scale.");
                this.handleAttribute(attributes, "direction");
                this.handleAttribute(attributes, "zoomFactor");
                this.handleAttribute(attributes, "logarithmic");
                this.handleAttribute(attributes, "max");
                this.handleAttribute(attributes, "min");
                this.handleAttribute(attributes, "orientation");
                this.handleAttribute(attributes, "background");
                this.handleAttribute(attributes, "visible");
                this.handleAttribute(attributes, "opaque");
                this.gaugeAreaComponents.add(this.prefix);
            }
        } else if (string3.equals("indicator-gauge")) {
            this.attName = "gaugeType";
            this.attValue = "indicator-gauge";
            this.pam.setProperty(this.attName, this.attValue);
            this.addPrefix("indicator-gauge.");
            this.handleAttribute(attributes, "blinkInterval");
            this.handleAttribute(attributes, "padding");
            this.handleAttribute(attributes, "baseValue");
            this.handleAttribute(attributes, "value");
            this.handleAttribute(attributes, "textValueDisplayed");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "height");
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "antiAliasing");
        } else if (string3.equals("indicator-gauge-panel")) {
            this.attName = "gaugeType";
            this.attValue = "indicator-gauge-panel";
            this.pam.setProperty(this.attName, this.attValue);
            this.addPrefix("indicator-gauge-panel.");
            this.handleAttribute(attributes, "direction");
            this.handleAttribute(attributes, "orientation");
            this.handleAttribute(attributes, "padding");
            this.handleAttribute(attributes, "valueType");
            this.handleAttribute(attributes, "numGauges");
            this.handleAttribute(attributes, "baseValue");
            this.handleAttribute(attributes, "value");
            this.handleAttribute(attributes, "textValueDisplayed");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "height");
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "antiAliasing");
        } else if (string3.equals("graph")) {
            this.attName = "gaugeType";
            this.attValue = "graph";
            this.pam.setProperty(this.attName, this.attValue);
            this.addPrefix("graph.");
            this.handleAttribute(attributes, "direction");
            this.handleAttribute(attributes, "pixelsPerValue");
            this.handleAttribute(attributes, "maxValue");
            this.handleAttribute(attributes, "minValue");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "height");
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "antiAliasing");
        } else if (string3.equals("line-style")) {
            this.addPrefix("line-style.");
            this.handleAttribute(attributes, "color");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "join");
            this.handleAttribute(attributes, "cap");
        } else if (string3.equals("line-style")) {
            this.addPrefix("line-style.");
            this.handleAttribute(attributes, "color");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "join");
            this.handleAttribute(attributes, "cap");
        } else if (string3.equals("header")) {
            this.addPrefix("header.");
            this.handleAttribute(attributes, "text");
            this.handleAttribute(attributes, "horizontalAlignment");
            this.handleAttribute(attributes, "verticalAlignment");
            this.handleAttribute(attributes, "horizontalTextPosition");
            this.handleAttribute(attributes, "verticalTextPosition");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "background");
        } else if (string3.equals("footer")) {
            this.addPrefix("footer.");
            this.handleAttribute(attributes, "text");
            this.handleAttribute(attributes, "horizontalAlignment");
            this.handleAttribute(attributes, "verticalAlignment");
            this.handleAttribute(attributes, "horizontalTextPosition");
            this.handleAttribute(attributes, "verticalTextPosition");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "background");
        } else if (string3.equals("legend")) {
            this.addPrefix("legend.");
            this.handleAttribute(attributes, "type");
            this.handleAttribute(attributes, "anchor");
            this.handleAttribute(attributes, "orientation");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "itemTextToolTipEnabled");
            this.handleAttribute(attributes, "useEllipsisWhenTruncating");
        } else if (string3.equals("layout-hints")) {
            this.addPrefix("layout-hints.");
            this.handleAttribute(attributes, "x");
            this.handleAttribute(attributes, "y");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "height");
        } else if (string3.equals("gauge-area")) {
            this.addPrefix("gauge-area.");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "background");
        } else if (string3.equals("multi-col")) {
            this.handleAttribute(attributes, "numRows");
            this.handleAttribute(attributes, "numColumns");
        } else if (string3.equals("legend-column")) {
            this.addPrefix("legend-column" + this.legendColumnCount++ + ".");
            this.handleAttribute(attributes, "column");
            this.handleAttribute(attributes, "maxItemTextWidth");
            this.handleAttribute(attributes, "itemTextAlignment");
            this.handleAttribute(attributes, "truncateMode");
        } else if (string3.equals("needle")) {
            this.addPrefix("needle" + this.needleCount++ + ".");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "style");
            this.handleAttribute(attributes, "value");
            this.handleAttribute(attributes, "innerExtent");
            this.handleAttribute(attributes, "outerExtent");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "color");
            this.handleAttribute(attributes, "interactionType");
            this.handleAttribute(attributes, "visible");
            this.gaugeAreaComponents.add(this.prefix);
        } else if (string3.equals("indicator")) {
            this.addPrefix("indicator" + this.indicatorCount++ + ".");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "style");
            this.handleAttribute(attributes, "value");
            this.handleAttribute(attributes, "innerExtent");
            this.handleAttribute(attributes, "outerExtent");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "color");
            this.handleAttribute(attributes, "visible");
            this.gaugeAreaComponents.add(this.prefix);
        } else if (string3.equals("tick")) {
            this.addPrefix("tick" + this.tickCount++ + ".");
            if (!this.haveScale) {
                this.handleAttribute(attributes, "name");
                this.handleAttribute(attributes, "automatic");
                this.handleAttribute(attributes, "startValue");
                this.handleAttribute(attributes, "stopValue");
                this.handleAttribute(attributes, "incrementValue");
                this.handleAttribute(attributes, "precisionUseDefault");
                this.handleAttribute(attributes, "precision");
                this.handleAttribute(attributes, "width");
                this.handleAttribute(attributes, "reversed");
                this.handleAttribute(attributes, "drawLabels");
                this.handleAttribute(attributes, "drawTicks");
                this.handleAttribute(attributes, "minorLogTicksDrawn");
                this.handleAttribute(attributes, "labelExtent");
                this.handleAttribute(attributes, "innerExtent");
                this.handleAttribute(attributes, "outerExtent");
                this.handleAttribute(attributes, "color");
                this.handleAttribute(attributes, "style");
                this.handleAttribute(attributes, "fontColor");
                this.scaleComponents.add(this.prefix);
            }
        } else if (string3.equals("circular-range")) {
            this.addPrefix("circular-range" + this.rangeCount++ + ".");
            if (!this.haveScale) {
                this.handleAttribute(attributes, "name");
                this.handleAttribute(attributes, "background");
                this.handleAttribute(attributes, "innerExtent");
                this.handleAttribute(attributes, "outerExtent");
                this.handleAttribute(attributes, "startValue");
                this.handleAttribute(attributes, "stopValue");
                this.handleAttribute(attributes, "visible");
                this.scaleComponents.add(this.prefix);
            }
        } else if (string3.equals("linear-range")) {
            this.inLinearRange = true;
            this.fillStyleCount = 0;
            this.addPrefix("linear-range" + this.rangeCount++ + ".");
            if (!this.haveScale) {
                this.handleAttribute(attributes, "name");
                this.handleAttribute(attributes, "background");
                this.handleAttribute(attributes, "foreground");
                this.handleAttribute(attributes, "foregroundCoverage");
                this.handleAttribute(attributes, "maskOrientation");
                this.handleAttribute(attributes, "innerExtent");
                this.handleAttribute(attributes, "outerExtent");
                this.handleAttribute(attributes, "startValue");
                this.handleAttribute(attributes, "stopValue");
                this.handleAttribute(attributes, "visible");
                this.scaleComponents.add(this.prefix);
            }
        } else if (string3.equals("label")) {
            this.addPrefix("label" + this.labelCount++ + ".");
            this.handleAttribute(attributes, "text");
            this.handleAttribute(attributes, "horizontalAlignment");
            this.handleAttribute(attributes, "verticalAlignment");
            this.handleAttribute(attributes, "horizontalTextPosition");
            this.handleAttribute(attributes, "verticalTextPosition");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "background");
            this.gaugeAreaComponents.add(this.prefix);
        } else if (string3.equals("font")) {
            this.handleFont(attributes);
        } else if (string3.equals("linear-constraint")) {
            this.addPrefix("linear-constraint.");
            this.handleAttribute(attributes, "extent");
            this.handleAttribute(attributes, "position");
        } else if (string3.equals("radial-constraint")) {
            this.addPrefix("radial-constraint.");
            this.handleAttribute(attributes, "extent");
            this.handleAttribute(attributes, "angle");
        } else if (string3.equals("image-map-info")) {
            this.addPrefix("image-map-info.");
            this.handleAttribute(attributes, "url");
            this.handleAttribute(attributes, "extra");
        } else if (string3.equals("image-file")) {
            this.addBackForePrefix(attributes, "image.");
            this.handleAttribute(attributes, "fileName");
            this.handleAttribute(attributes, "fileAccess");
            this.handleAttribute(attributes, "imageScaled");
        } else if (string3.equals("image-position")) {
            this.addPrefix("imagePosition.");
            this.handleAttribute(attributes, "x");
            this.handleAttribute(attributes, "y");
        } else if (string3.equals("external-java-code")) {
            this.addPrefix("external-java-code" + this.externalCodeCount + ".");
            this.handleAttribute(attributes, "class");
            this.inExternalCode = true;
            ++this.externalCodeCount;
        } else if (string3.equals("base-gauge")) {
            this.addPrefix("base-gauge.");
            this.handleAttribute(attributes, "padding");
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "visible");
        } else if (string3.equals("indicator-range")) {
            this.addPrefix("indicator-range" + this.indicatorRangeCount++ + ".");
            this.handleAttribute(attributes, "value");
            this.handleAttribute(attributes, "displayType");
            this.handleAttribute(attributes, "displayValue");
            this.handleAttribute(attributes, "text");
            this.handleAttribute(attributes, "toolTip");
        } else if (string3.equals("icon")) {
            this.addPrefix("icon.");
            this.handleAttribute(attributes, "shape");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "imageScaled");
        } else if (string3.equals("values") || string3.equals("dash-array")) {
            this.inValues = true;
        } else if (string3.equals("fill-style")) {
            String string4 = this.inLinearRange ? this.getBackForeString(attributes) : "";
            this.attName = this.prefix + string4 + "hasFillStyle";
            this.attValue = "true";
            this.pam.setProperty(this.attName, this.attValue);
            if (this.inLinearRange) {
                this.addBackForePrefix(attributes, "fill.");
            } else {
                this.addPrefix("fill.");
            }
            this.handleAttribute(attributes, "pattern");
            this.handleAttribute(attributes, "color");
            this.handleAttribute(attributes, "image");
            this.handleAttribute(attributes, "imageLayoutHint");
            this.handleAttribute(attributes, "fillOrientation");
            this.handleAttribute(attributes, "background");
        } else if (string3.equals("gradient")) {
            this.addPrefix("gradient.");
            this.handleAttribute(attributes, "color2");
            this.handleAttribute(attributes, "ribbonSize");
            this.handleAttribute(attributes, "style");
        } else if (string3.equals("value")) {
            // empty if block
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("circular-gauge") || string3.equals("linear-gauge")) {
            this.pam.setPropertyObject(this.prefix, this.gaugeAreaComponents);
            this.handleExternalCodeCount();
            this.popPrefix();
        } else if (string3.equals("circular-scale") || string3.equals("linear-scale")) {
            if (!this.haveScale) {
                this.pam.setPropertyObject(this.prefix, this.scaleComponents);
                this.popPrefix();
            }
            this.haveScale = true;
        } else if (string3.equals("font")) {
            if (!this.inTitledBorder) {
                this.popPrefix();
            }
        } else if (string3.equals("linear-range")) {
            this.popPrefix();
            this.inLinearRange = false;
        } else if (string3.equals("center") || string3.equals("header") || string3.equals("footer") || string3.equals("label") || string3.equals("linear-constraint") || string3.equals("radial-constraint") || string3.equals("label") || string3.equals("legend-column") || string3.equals("needle") || string3.equals("indicator") || string3.equals("tick") || string3.equals("circular-range") || string3.equals("layout-hints") || string3.equals("image-file") || string3.equals("gauge-area") || string3.equals("base-gauge") || string3.equals("indicator-range") || string3.equals("graph") || string3.equals("line-style") || string3.equals("icon") || string3.equals("image-map-info") || string3.equals("fill-style") || string3.equals("image-position") || string3.equals("gradient")) {
            this.popPrefix();
        } else if (string3.equals("external-java-code")) {
            this.pam.setProperty(this.prefix + "userData", this.sb == null ? "" : this.sb.toString().trim());
            this.inExternalCode = false;
            this.popPrefix();
        } else if (string3.equals("empty-border") || string3.equals("bevel-border") || string3.equals("etched-border") || string3.equals("line-border") || string3.equals("matte-border") || string3.equals("titled-border")) {
            this.handleBorder(string3, null, false);
        } else if (string3.equals("compound-border")) {
            this.handleCompoundBorder(false);
        } else if (string3.equals("indicator-gauge") || string3.equals("indicator-gauge-panel")) {
            this.handleIndicatorRangeCount();
            this.handleExternalCodeCount();
            this.popPrefix();
        } else if (string3.equals("legend")) {
            this.pam.setProperty(this.prefix + "legendColumnCount", "" + this.legendColumnCount);
            this.popPrefix();
        } else if (string3.equals("values") || string3.equals("dash-array")) {
            if (this.sb.lastIndexOf(",") == this.sb.length() - 1) {
                this.sb.deleteCharAt(this.sb.lastIndexOf(","));
            }
            this.pam.setProperty(this.prefix + string3, this.sb == null ? "" : this.sb.toString().trim());
            this.inValues = false;
        } else if (string3.equals("value")) {
            this.sb.append(",");
            return;
        }
        this.sb = null;
    }

    protected void handleIndicatorRangeCount() {
        this.pam.setProperty(this.prefix + "indicatorRangeCount", "" + this.indicatorRangeCount);
    }

    protected void handleExternalCodeCount() {
        this.pam.setProperty(this.prefix + "externalCodeCount", "" + this.externalCodeCount);
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        String string = new String(cArray, n2, n3);
        string = this.localizeString(string);
        if (this.inValues) {
            string = string.trim();
        }
        if (this.sb == null) {
            this.sb = new StringBuffer(string);
        } else {
            this.sb.append(string);
        }
    }

    protected void handleAttribute(Attributes attributes, String string) {
        this.handleAttribute(attributes, string, string);
    }

    protected void handleAttribute(Attributes attributes, String string, String string2) {
        if (attributes == null || this.pam == null) {
            return;
        }
        int n2 = attributes.getIndex(string);
        if (n2 > -1) {
            this.attName = this.prefix + string2;
            this.attValue = this.localizeString(attributes.getValue(n2));
            this.pam.setProperty(this.attName, this.attValue);
        }
    }

    protected void handleBorder(String string, Attributes attributes, boolean bl) {
        if (string == null || bl && attributes == null || this.pam == null) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (string.equals("titled-border")) {
            bl2 = true;
        } else if (string.equals("bevel-border")) {
            bl3 = true;
        } else if (string.equals("etched-border")) {
            bl4 = true;
        } else if (string.equals("line-border")) {
            bl5 = true;
        } else if (string.equals("matte-border")) {
            bl6 = true;
        } else if (string.equals("empty-border")) {
            bl7 = true;
        }
        Border border = null;
        if (bl) {
            if (bl2) {
                this.inTitledBorder = true;
            } else {
                this.inBorder = true;
            }
            if (bl3 || bl4) {
                Object object;
                int n2 = bl3 ? 1 : 1;
                int n3 = attributes.getIndex("type");
                if (n3 > -1) {
                    object = attributes.getValue(n3);
                    n2 = ((String)object).equalsIgnoreCase("raised") ? (bl3 ? 0 : 0) : (bl3 ? 1 : 1);
                }
                object = null;
                n3 = attributes.getIndex("highlightColor");
                if (n3 > -1) {
                    object = JCSwingTypeConverter.toColor(attributes.getValue(n3));
                }
                Color color = null;
                n3 = attributes.getIndex("shadowColor");
                if (n3 > -1) {
                    color = JCSwingTypeConverter.toColor(attributes.getValue(n3));
                }
                if (bl3) {
                    boolean bl8 = false;
                    n3 = attributes.getIndex("soft");
                    if (n3 > -1) {
                        bl8 = JCTypeConverter.toBoolean(attributes.getValue(n3), false);
                    }
                    border = object != null && color != null ? (bl8 ? new SoftBevelBorder(n2, (Color)object, color) : new BevelBorder(n2, (Color)object, color)) : (bl8 ? new SoftBevelBorder(n2) : new BevelBorder(n2));
                } else {
                    border = new EtchedBorder(n2, (Color)object, color);
                }
            } else if (bl5) {
                int n4 = attributes.getIndex("color");
                if (n4 > -1) {
                    this.color = JCSwingTypeConverter.toColor(attributes.getValue(n4), Color.black);
                }
                int n5 = 1;
                n4 = attributes.getIndex("thickness");
                if (n4 > -1) {
                    n5 = JCTypeConverter.toInt(attributes.getValue(n4), 1);
                }
                boolean bl9 = false;
                n4 = attributes.getIndex("roundedCorners");
                if (n4 > -1) {
                    bl9 = JCTypeConverter.toBoolean(attributes.getValue(n4), false);
                }
                border = new LineBorder(this.color, n5, bl9);
            } else if (bl6) {
                this.color = Color.black;
                int n6 = attributes.getIndex("color");
                if (n6 > -1) {
                    this.color = JCSwingTypeConverter.toColor(attributes.getValue(n6), Color.black);
                }
            } else if (bl2) {
                Object[] objectArray;
                String string2 = null;
                int n7 = attributes.getIndex("title");
                if (n7 > -1) {
                    string2 = this.localizeString(attributes.getValue(n7));
                }
                int n8 = 0;
                n7 = attributes.getIndex("titlePosition");
                if (n7 > -1) {
                    String[] stringArray = JCSwingTypeConverter.positionStrings;
                    objectArray = JCSwingTypeConverter.positionValues;
                    n8 = JCTypeConverter.toEnum(attributes.getValue(n7), stringArray, objectArray, n8);
                }
                int n9 = 0;
                n7 = attributes.getIndex("titleJustification");
                if (n7 > -1) {
                    objectArray = JCSwingTypeConverter.justificationStrings;
                    int[] nArray = JCSwingTypeConverter.justificationValues;
                    n9 = JCTypeConverter.toEnum(attributes.getValue(n7), (String[])objectArray, nArray, n9);
                }
                this.color = null;
                n7 = attributes.getIndex("color");
                if (n7 > -1) {
                    this.color = JCSwingTypeConverter.toColor(attributes.getValue(n7));
                }
                this.savedBorder = new TitledBorder(null, string2, n9, n8, null, this.color);
            }
        } else {
            if (bl6) {
                if (this.insets == null) {
                    this.insets = new Insets(0, 0, 0, 0);
                }
                border = BorderFactory.createMatteBorder(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right, this.color);
            } else if (bl7) {
                if (this.insets == null) {
                    this.insets = new Insets(0, 0, 0, 0);
                }
                border = new EmptyBorder(this.insets);
            } else if (bl2) {
                if (this.font != null && this.savedBorder instanceof TitledBorder) {
                    TitledBorder titledBorder = (TitledBorder)this.savedBorder;
                    titledBorder.setTitleFont(this.font);
                }
                this.font = null;
                border = this.savedBorder;
                this.savedBorder = null;
                this.inTitledBorder = false;
            }
            if (!bl2) {
                this.inBorder = false;
                this.insets = null;
                this.color = null;
            }
        }
        if (border != null) {
            if (this.inTitledBorder) {
                if (this.savedBorder instanceof TitledBorder) {
                    TitledBorder titledBorder = (TitledBorder)this.savedBorder;
                    titledBorder.setBorder(border);
                }
            } else if (this.inCompoundBorder) {
                this.addToCompoundBorder(border);
            } else {
                this.attName = this.prefix + "border";
                this.pam.setPropertyObject(this.attName, border);
            }
        }
    }

    protected void handleCompoundBorder(boolean bl) {
        if (bl) {
            this.inCompoundBorder = true;
            if (this.compoundBorderStack == null) {
                this.compoundBorderStack = new Stack();
            }
            this.compoundBorderStack.push(new CompoundBorder());
        } else {
            CompoundBorder compoundBorder = this.compoundBorderStack.pop();
            if (this.compoundBorderStack.size() > 0) {
                this.addToCompoundBorder(compoundBorder);
            } else {
                this.attName = this.prefix + "border";
                this.pam.setPropertyObject(this.attName, compoundBorder);
                this.inCompoundBorder = false;
                this.compoundBorderStack = null;
            }
        }
    }

    protected void addToCompoundBorder(Border border) {
        CompoundBorder compoundBorder = this.compoundBorderStack.pop();
        CompoundBorder compoundBorder2 = compoundBorder.getOutsideBorder() == null ? new CompoundBorder(border, null) : (compoundBorder.getInsideBorder() == null ? new CompoundBorder(compoundBorder.getOutsideBorder(), border) : compoundBorder);
        this.compoundBorderStack.push(compoundBorder2);
    }

    protected void handleFont(Attributes attributes) {
        if (this.inTitledBorder) {
            String string = "serif";
            int n2 = attributes.getIndex("name");
            if (n2 > -1) {
                string = attributes.getValue(n2);
            }
            int n3 = 0;
            n2 = attributes.getIndex("style");
            if (n2 > -1) {
                n3 = JCSwingTypeConverter.toFontStyle(attributes.getValue(n2));
            }
            int n4 = 10;
            n2 = attributes.getIndex("size");
            if (n2 > -1) {
                n4 = JCTypeConverter.toInt(attributes.getValue(n2), n4);
            }
            this.font = new Font(string, n3, n4);
        } else {
            this.addPrefix("font.");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "style");
            this.handleAttribute(attributes, "size");
        }
    }

    protected void handleInsets(Attributes attributes) {
        if (attributes == null || this.pam == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = attributes.getIndex("left");
        if (n6 > -1) {
            n2 = JCTypeConverter.toInt(attributes.getValue(n6), n2);
        }
        if ((n6 = attributes.getIndex("right")) > -1) {
            n3 = JCTypeConverter.toInt(attributes.getValue(n6), n3);
        }
        if ((n6 = attributes.getIndex("top")) > -1) {
            n4 = JCTypeConverter.toInt(attributes.getValue(n6), n4);
        }
        if ((n6 = attributes.getIndex("bottom")) > -1) {
            n5 = JCTypeConverter.toInt(attributes.getValue(n6), n5);
        }
        this.insets = new Insets(n4, n2, n5, n3);
        if (!this.inBorder) {
            this.attName = this.prefix + "insets";
            this.pam.setPropertyObject(this.attName, this.insets);
            this.insets = null;
        }
    }

    public static void parseXMLSource(PropertyAccessModel propertyAccessModel, InputSource inputSource, boolean bl) throws IOException {
        if (propertyAccessModel == null || inputSource == null) {
            return;
        }
        GaugeHandler gaugeHandler = new GaugeHandler(propertyAccessModel);
        LoadProperties loadProperties = propertyAccessModel.getLoadProperties();
        if (inputSource.getSystemId() == null) {
            if (loadProperties != null) {
                inputSource.setSystemId(loadProperties.getLocalEntitySystemId());
            } else {
                inputSource.setSystemId("");
            }
        }
        ClassLoader classLoader = null;
        boolean bl2 = JCEnvironment.isWebSphere();
        if (bl2) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(bl);
        try {
            ErrorHandler errorHandler;
            Object object;
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (bl2) {
                object = sAXParser.getClass().getClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)object);
            }
            object = sAXParser.getXMLReader();
            object.setContentHandler(gaugeHandler);
            ErrorHandler errorHandler2 = errorHandler = loadProperties == null ? null : loadProperties.getXmlErrorHandler();
            if (errorHandler == null) {
                errorHandler = new JCXMLErrorPrinter();
            }
            object.setErrorHandler(errorHandler);
            object.setEntityResolver(new JCXMLDTDResolver("JCGauge.dtd", gaugeHandler.getClass()));
            object.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new JCParseException(sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JCParseException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
        finally {
            if (bl2) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }
}

