/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge.property;

import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.property.PropertySaveFactory;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.io.JCIOException;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.property.PropertyPersistorModel;
import com.klg.jclass.util.property.PropertySaveModel;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.UIResource;

public class ComponentPropertySave
implements PropertySaveModel {
    protected Component component = null;
    protected Component defaultComponent = null;
    protected Font defaultFont = new Font("serif", 0, 10);

    public void setSource(Object object) {
        if (object instanceof Component) {
            this.component = (Component)object;
        }
    }

    public void setDefault(Object object) {
        if (object instanceof Component) {
            this.defaultComponent = (Component)object;
        }
    }

    public boolean checkProperties(PropertyPersistorModel propertyPersistorModel) {
        return true;
    }

    public void saveProperties(PropertyPersistorModel propertyPersistorModel, String string, int n2) throws JCIOException {
        this.writeBackgroundAndOpaque(propertyPersistorModel, string, n2);
        this.writeForeground(propertyPersistorModel, string, n2);
        this.writeVisible(propertyPersistorModel, string, n2);
    }

    protected void writeBackgroundAndOpaque(PropertyPersistorModel propertyPersistorModel, String string, int n2) {
        boolean bl;
        Color color = this.component.getBackground();
        boolean bl2 = this.component.isOpaque();
        boolean bl3 = color != null && !(color instanceof UIResource) && !color.equals(this.defaultComponent.getBackground());
        boolean bl4 = bl = bl2 != this.defaultComponent.isOpaque();
        if (bl3 || bl) {
            propertyPersistorModel.writeProperty(string, "background", n2, JCSwingTypeConverter.fromColor(color));
            propertyPersistorModel.writeProperty(string, "opaque", n2, bl2);
        }
    }

    protected void writeForeground(PropertyPersistorModel propertyPersistorModel, String string, int n2) {
        Color color = this.component.getForeground();
        if (color != null && !color.equals(this.defaultComponent.getForeground())) {
            ComponentPropertySave.writeUI(propertyPersistorModel, string, "foreground", n2, JCSwingTypeConverter.fromColor(color));
        }
    }

    protected void writeVisible(PropertyPersistorModel propertyPersistorModel, String string, int n2) {
        boolean bl;
        boolean bl2 = this.component.isVisible();
        if (bl2 != (bl = this.defaultComponent.isVisible())) {
            propertyPersistorModel.writeProperty(string, "visible", n2, bl2);
        }
    }

    protected boolean checkFont(Font font) {
        if (font == null) {
            return false;
        }
        String string = font.getName();
        return string != null && !string.equals(this.defaultFont.getName()) || font.getStyle() != this.defaultFont.getStyle() || font.getSize() != this.defaultFont.getSize();
    }

    protected void writeFont(PropertyPersistorModel propertyPersistorModel, Font font, int n2, boolean bl) {
        if (font == null) {
            return;
        }
        if (bl && !this.checkFont(font)) {
            return;
        }
        int n3 = propertyPersistorModel.writeBegin("font", n2);
        String string = font.getName();
        if (string != null && !string.equals(this.defaultFont.getName())) {
            propertyPersistorModel.writeProperty("font", "name", n3, font.getName());
        }
        if (font.getStyle() != this.defaultFont.getStyle()) {
            propertyPersistorModel.writeProperty("font", "style", n3, JCSwingTypeConverter.fromFontStyleToXML(font));
        }
        if (font.getSize() != this.defaultFont.getSize()) {
            propertyPersistorModel.writeProperty("font", "size", n3, "" + font.getSize());
        }
        propertyPersistorModel.writeEnd(null, n2, true, false);
    }

    public static void writeInsets(PropertyPersistorModel propertyPersistorModel, String string, int n2, Insets insets) {
        int n3 = propertyPersistorModel.writeBegin("insets", n2);
        propertyPersistorModel.writeProperty(string, "left", n3, new Integer(insets.left));
        propertyPersistorModel.writeProperty(string, "right", n3, new Integer(insets.right));
        propertyPersistorModel.writeProperty(string, "top", n3, new Integer(insets.top));
        propertyPersistorModel.writeProperty(string, "bottom", n3, new Integer(insets.bottom));
        propertyPersistorModel.writeEnd(null, n2, true, false);
    }

    public void writeBorder(PropertyPersistorModel propertyPersistorModel, String string, int n2) {
        this.writeBorder(propertyPersistorModel, string, n2, ((JComponent)this.component).getBorder());
    }

    public void writeBorder(PropertyPersistorModel propertyPersistorModel, String string, int n2, Border border) {
        if (border == null || border instanceof UIResource) {
            return;
        }
        if (propertyPersistorModel.getType().equals("HTML")) {
            String string2 = JCSwingTypeConverter.fromBorder(border, this.component);
            if (string2 != null) {
                propertyPersistorModel.writeProperty(string, "border", n2, string2);
            }
        } else {
            int n3 = PropertySaveFactory.tabIncrement;
            if (border instanceof MatteBorder) {
                MatteBorder matteBorder = (MatteBorder)border;
                int n4 = propertyPersistorModel.writeBegin("matte-border", n2);
                Color color = matteBorder.getMatteColor();
                if (color == null) {
                    color = Color.black;
                }
                propertyPersistorModel.writeProperty(string, "color", n4, JCSwingTypeConverter.fromColor(color));
                propertyPersistorModel.writeEnd(null, n2, true, true);
                ComponentPropertySave.writeInsets(propertyPersistorModel, string, n2 + n3, matteBorder.getBorderInsets(this.component));
                propertyPersistorModel.writeEnd("matte-border", n2, true, false);
            } else if (border instanceof EmptyBorder) {
                EmptyBorder emptyBorder = (EmptyBorder)border;
                propertyPersistorModel.writeBegin("empty-border", n2);
                propertyPersistorModel.writeEnd(null, n2, true, true);
                ComponentPropertySave.writeInsets(propertyPersistorModel, string, n2 + n3, emptyBorder.getBorderInsets(this.component));
                propertyPersistorModel.writeEnd("empty-border", n2, true, false);
            } else if (border instanceof BevelBorder || border instanceof SoftBevelBorder) {
                BevelBorder bevelBorder = (BevelBorder)border;
                int n5 = propertyPersistorModel.writeBegin("bevel-border", n2);
                Boolean bl = bevelBorder instanceof SoftBevelBorder ? Boolean.TRUE : Boolean.FALSE;
                propertyPersistorModel.writeProperty(string, "soft", n5, bl);
                String string3 = bevelBorder.getBevelType() == 0 ? "Raised" : "Lowered";
                propertyPersistorModel.writeProperty(string, "type", n5, string3);
                Color color = bevelBorder.getHighlightInnerColor();
                Color color2 = bevelBorder.getShadowOuterColor();
                if (color != null || color2 != null) {
                    if (color == null) {
                        color = bevelBorder.getHighlightInnerColor(this.component);
                    }
                    propertyPersistorModel.writeProperty(string, "highlightColor", n5, JCSwingTypeConverter.fromColor(color));
                    if (color2 == null) {
                        color2 = bevelBorder.getShadowOuterColor(this.component);
                    }
                    propertyPersistorModel.writeProperty(string, "shadowColor", n5, JCSwingTypeConverter.fromColor(color2));
                }
                propertyPersistorModel.writeEnd(null, n2, true, false);
            } else if (border instanceof EtchedBorder) {
                Color color;
                EtchedBorder etchedBorder = (EtchedBorder)border;
                int n6 = propertyPersistorModel.writeBegin("etched-border", n2);
                String string4 = etchedBorder.getEtchType() == 0 ? "Raised" : "Lowered";
                propertyPersistorModel.writeProperty(string, "type", n6, string4);
                Color color3 = etchedBorder.getHighlightColor();
                if (color3 != null) {
                    propertyPersistorModel.writeProperty(string, "highlightColor", n6, JCSwingTypeConverter.fromColor(color3));
                }
                if ((color = etchedBorder.getShadowColor()) != null) {
                    propertyPersistorModel.writeProperty(string, "shadowColor", n6, JCSwingTypeConverter.fromColor(color));
                }
                propertyPersistorModel.writeEnd(null, n2, true, false);
            } else if (border instanceof LineBorder) {
                boolean bl;
                LineBorder lineBorder = (LineBorder)border;
                int n7 = propertyPersistorModel.writeBegin("line-border", n2);
                Color color = lineBorder.getLineColor();
                if (color == null) {
                    color = Color.black;
                }
                propertyPersistorModel.writeProperty(string, "color", n7, JCSwingTypeConverter.fromColor(color));
                if (lineBorder.getThickness() > 1) {
                    propertyPersistorModel.writeProperty(string, "thickness", n7, new Integer(lineBorder.getThickness()));
                }
                if (bl = lineBorder.getRoundedCorners()) {
                    propertyPersistorModel.writeProperty(string, "roundedCorners", n7, bl);
                }
                propertyPersistorModel.writeEnd(null, n2, true, false);
            } else if (border instanceof TitledBorder) {
                boolean bl;
                Object object;
                TitledBorder titledBorder = (TitledBorder)border;
                String string5 = titledBorder.getTitle();
                if (string5 == null || string5.length() == 0) {
                    return;
                }
                int n8 = propertyPersistorModel.writeBegin("titled-border", n2);
                propertyPersistorModel.writeProperty(string, "title", n8, propertyPersistorModel.expandText(string5));
                TitledBorder titledBorder2 = new TitledBorder("default");
                int n9 = titledBorder.getTitlePosition();
                String[] stringArray = JCSwingTypeConverter.positionStrings;
                int[] nArray = JCSwingTypeConverter.positionValues;
                if (n9 != 0 && n9 != titledBorder2.getTitlePosition()) {
                    String string6 = JCTypeConverter.fromEnum(n9, stringArray, nArray);
                    propertyPersistorModel.writeProperty(string, "titlePosition", n8, string6);
                }
                int n10 = titledBorder.getTitleJustification();
                stringArray = JCSwingTypeConverter.justificationStrings;
                nArray = JCSwingTypeConverter.justificationValues;
                if (n10 != 0 && n10 != titledBorder2.getTitleJustification()) {
                    object = JCTypeConverter.fromEnum(n10, stringArray, nArray);
                    propertyPersistorModel.writeProperty(string, "titleJustification", n8, object);
                }
                Color color = titledBorder.getTitleColor();
                ComponentPropertySave.writeUI(propertyPersistorModel, string, "color", n8, JCSwingTypeConverter.fromColor(color));
                object = titledBorder.getTitleFont();
                boolean bl2 = object != null && !(object instanceof UIResource);
                Border border2 = titledBorder.getBorder();
                boolean bl3 = !(border2 instanceof CompoundBorder) && !(border2 instanceof TitledBorder);
                boolean bl4 = bl = border2 != null && !(border2 instanceof UIResource) && bl3;
                if (!bl3 && propertyPersistorModel.getPrintErrors()) {
                    System.err.println("Gauge XML output: Unsupported border within TitledBorder.  It cannot be a CompoundBorder or another TitledBorder.");
                }
                if (bl2 || bl) {
                    propertyPersistorModel.writeEnd(null, n2, true, true);
                    if (bl2) {
                        this.writeFont(propertyPersistorModel, (Font)object, n2 + n3, false);
                    }
                    if (bl) {
                        this.writeBorder(propertyPersistorModel, string, n2 + n3, border2);
                    }
                    propertyPersistorModel.writeEnd("titled-border", n2, true, false);
                } else {
                    propertyPersistorModel.writeEnd(null, n2, true, false);
                }
            } else if (border instanceof CompoundBorder) {
                CompoundBorder compoundBorder = (CompoundBorder)border;
                Border border3 = compoundBorder.getOutsideBorder();
                Border border4 = compoundBorder.getInsideBorder();
                if (border3 == null && border4 == null) {
                    return;
                }
                if (border3 == null) {
                    this.writeBorder(propertyPersistorModel, string, n2, border4);
                    return;
                }
                if (border4 == null) {
                    this.writeBorder(propertyPersistorModel, string, n2, border3);
                    return;
                }
                propertyPersistorModel.writeBegin("compound-border", n2);
                propertyPersistorModel.writeEnd(null, n2, true, true);
                this.writeBorder(propertyPersistorModel, string, n2 + n3, border3);
                this.writeBorder(propertyPersistorModel, string, n2 + n3, border4);
                propertyPersistorModel.writeEnd("compound-border", n2, true, false);
            }
        }
    }

    protected static void writeUI(PropertyPersistorModel propertyPersistorModel, String string, String string2, int n2, Object object) {
        if (object == null || object instanceof UIResource) {
            return;
        }
        propertyPersistorModel.writeProperty(string, string2, n2, object);
    }

    public boolean checkLayoutHints(JCGauge jCGauge, JComponent jComponent) {
        Rectangle rectangle = jCGauge.getLayoutHints(jComponent);
        if (rectangle == null) {
            return false;
        }
        return rectangle.x != Integer.MAX_VALUE || rectangle.y != Integer.MAX_VALUE || rectangle.width != Integer.MAX_VALUE || rectangle.height != Integer.MAX_VALUE;
    }

    public void writeLayoutHints(PropertyPersistorModel propertyPersistorModel, JCGauge jCGauge, JComponent jComponent, String string, int n2) {
        if (!this.checkLayoutHints(jCGauge, jComponent)) {
            return;
        }
        Rectangle rectangle = jCGauge.getLayoutHints(jComponent);
        if (rectangle != null) {
            int n3 = propertyPersistorModel.writeBegin("layout-hints", n2);
            if (rectangle.x != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "x", n3, new Integer(rectangle.x));
            }
            if (rectangle.y != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "y", n3, new Integer(rectangle.y));
            }
            if (rectangle.width != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "width", n3, new Integer(rectangle.width));
            }
            if (rectangle.height != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "height", n3, new Integer(rectangle.height));
            }
            propertyPersistorModel.writeEnd(null, n2, true, false);
        }
    }

    protected void writeWidthHeight(PropertyPersistorModel propertyPersistorModel, String string, int n2) {
        Dimension dimension = this.component.getSize();
        Dimension dimension2 = this.defaultComponent.getSize();
        if (dimension.width != dimension2.width) {
            propertyPersistorModel.writeProperty(string, "width", n2, new Integer(dimension.width));
        }
        if (dimension.height != dimension2.height) {
            propertyPersistorModel.writeProperty(string, "height", n2, new Integer(dimension.height));
        }
    }

    protected boolean checkImageFileProperties(PortableImage portableImage) {
        String string;
        return portableImage != null && portableImage.getOutputProperties() != null && (string = portableImage.getOutputProperties().getPropertyName()) != null && string.length() > 0;
    }

    protected void writeImageFileProperties(PortableImage portableImage, PropertyPersistorModel propertyPersistorModel, int n2, String string, boolean bl) {
        String string2;
        if (portableImage == null || string == null) {
            return;
        }
        OutputProperties outputProperties = portableImage.getOutputProperties();
        if (outputProperties != null && (string2 = outputProperties.getPropertyName()) != null && string2.length() > 0) {
            boolean bl2;
            int n3 = propertyPersistorModel.writeBegin("image-file", n2);
            propertyPersistorModel.writeProperty(string + "image.", "fileName", n3, string2);
            int n4 = outputProperties.getFileAccess();
            if (n4 != 0) {
                String string3 = outputProperties.getFileAccessStringFromEnum(n4, false);
                propertyPersistorModel.writeProperty(string + "image.", "fileAccess", n3, string3);
            }
            if (!(bl2 = portableImage.isImageScaled())) {
                propertyPersistorModel.writeProperty(string + "image.", "imageScaled", n3, Boolean.toString(bl2));
            }
            if (!bl) {
                propertyPersistorModel.writeProperty(string + "image.", "isBackground", n3, Boolean.toString(bl));
            }
            propertyPersistorModel.writeEnd(null, n2, true, false);
        }
    }
}

