/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge.indicator;

import com.klg.jclass.gauge.AccessibleValueState;
import com.klg.jclass.gauge.indicator.AccessibleIndicatorGaugeRole;
import com.klg.jclass.gauge.indicator.IconController;
import com.klg.jclass.gauge.indicator.JCBaseIndicatorGauge;
import com.klg.jclass.gauge.indicator.JCIndicatorIcon;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.ServerRenderer;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.style.JCFillStyle;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.AncestorListener;

public class JCIndicatorGaugePanel
extends JPanel
implements IconController,
ServerRenderable,
ActionListener,
RenderProperties,
Serializable {
    protected JCListenerList valueListeners = null;
    protected String[] rangeToolTips = null;
    protected String[] rangeText = null;
    protected Object[] rangeDisplays = null;
    protected Object[] rangeValues = null;
    protected Object baseValue = null;
    public static final int VALUE_BINARY = 0;
    public static final int VALUE_DECIMAL = 1;
    public static final int VALUE_MAGNITUDE_UNICHROME = 2;
    public static final int VALUE_MAGNITUDE_MULTICHROME = 3;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final int DIRECTION_FORWARD = 0;
    public static final int DIRECTION_BACKWARD = 1;
    protected int numGauges = 1;
    protected PortableImage image = null;
    protected JCFillStyle fillStyle = null;
    protected int valueType = 0;
    protected int direction = 0;
    protected int orientation = 0;
    protected JCBaseIndicatorGauge gauge = null;
    private Object value = null;
    protected int padding = 1;
    protected boolean textValueDisplayed = false;
    public static final Integer[] DECIMAL_VALUES = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    protected JCBaseIndicatorGauge[] gauges = null;
    protected transient Graphics prevSetGraphics;
    protected Timer t = null;
    protected int blinkInterval = 0;
    protected boolean blink = false;
    protected int antiAliasing = 0;

    public JCIndicatorGaugePanel(int n2) {
        this(n2, new JCBaseIndicatorGauge());
    }

    public JCIndicatorGaugePanel(int n2, JCBaseIndicatorGauge jCBaseIndicatorGauge) {
        if (n2 < 0) {
            String string = LocaleBundle.string("The number of gauges must non-negative.");
            throw new IllegalArgumentException(string);
        }
        this.numGauges = n2;
        this.gauge = jCBaseIndicatorGauge == null ? new JCBaseIndicatorGauge() : jCBaseIndicatorGauge;
        this.gauges = new JCBaseIndicatorGauge[n2];
        this.rangeValues = new Object[]{0, 1};
        this.rangeDisplays = new Color[]{Color.black, Color.white};
        this.baseValue = 0;
        this.populateGauges();
    }

    public void setIconShape(int n2) {
        this.gauge.getIcon().setShape(n2);
        this.populateGauges();
    }

    public int getIconShape() {
        return this.gauge.getIcon().getShape();
    }

    public void setIconFont(Font font) {
        this.gauge.getIcon().setFont(font);
        this.populateGauges();
    }

    public Font getIconFont() {
        return this.gauge.getIcon().getFont();
    }

    public void setIconForeground(Color color) {
        this.gauge.getIcon().setForeground(color);
        this.populateGauges();
    }

    public Color getIconForeground() {
        return this.gauge.getIcon().getForeground();
    }

    public void setIconImageScaled(boolean bl) {
        this.gauge.getIcon().setImageScaled(bl);
        this.populateGauges();
    }

    public boolean isIconImageScaled() {
        return this.gauge.getIcon().isImageScaled();
    }

    protected void configureLayout() {
        if (this.orientation == 0) {
            this.setLayout(new GridLayout(1, this.numGauges, this.padding, this.padding));
        } else {
            this.setLayout(new GridLayout(this.numGauges, 1, this.padding, this.padding));
        }
        if (this.getBorder() == null) {
            this.setBorder(BorderFactory.createEmptyBorder(this.padding, this.padding, this.padding, this.padding));
        }
    }

    protected void populateGauges() {
        this.removeAll();
        this.destroyGauges();
        this.configureLayout();
        for (int i2 = 0; i2 < this.numGauges; ++i2) {
            try {
                this.gauges[i2] = (JCBaseIndicatorGauge)this.gauge.clone();
                this.gauges[i2].index = i2;
                this.add(this.gauges[i2]);
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        this.resetGauges();
    }

    protected void destroyGauges() {
        for (int i2 = 0; i2 < this.gauges.length; ++i2) {
            if (this.gauges[i2] == null) continue;
            this.gauges[i2].removeAllListeners();
            this.gauges[i2] = null;
        }
    }

    public int getNumGauges() {
        return this.numGauges;
    }

    public void setNumGauges(int n2) {
        if (n2 < 0) {
            String string = LocaleBundle.string("The number of gauges must non-negative.");
            throw new IllegalArgumentException(string);
        }
        this.numGauges = n2;
        this.gauges = new JCBaseIndicatorGauge[n2];
        this.populateGauges();
    }

    public PortableImage getPortableImage() {
        return this.image;
    }

    public void setPortableImage(PortableImage portableImage) {
        this.image = portableImage;
    }

    public Image getImage() {
        if (this.image == null) {
            return null;
        }
        return this.image.getImage();
    }

    public void setImage(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && (imageIcon = new ImageIcon(uRL)).getImageLoadStatus() == 8) {
            this.setImage(imageIcon.getImage());
        }
    }

    public void setImage(Image image) {
        if (this.image == null) {
            this.image = new PortableImage(image);
        } else {
            this.image.setImage(image);
        }
    }

    public boolean isImageScaled() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.isImageScaled();
    }

    public void setImageScaled(boolean bl) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setImageScaled(bl);
    }

    public OutputProperties getImageOutputProperties() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.getOutputProperties();
    }

    public void setImageOutputProperties(OutputProperties outputProperties) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setOutputProperties(outputProperties);
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle != null) {
            this.fillStyle.parent = null;
        }
        this.fillStyle = jCFillStyle;
        if (this.fillStyle != null) {
            this.fillStyle.parent = this;
        }
        this.populateGauges();
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int n2) {
        if (n2 < 0 || n2 > 3) {
            String string = LocaleBundle.string("ValueType must be one of VALUE_BINARY, VALUE_DECIMAL, VALUE_MAGNITUDE_UNICHROME, VALUE_MAGITUDE_MULTICHROME.");
            throw new IllegalArgumentException(string);
        }
        this.valueType = n2;
        this.populateGauges();
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n2) {
        if (n2 < 0 || n2 > 1) {
            String string = LocaleBundle.string("Direction must be one of DIRECTION_FORWARD or DIRECTION_BACKWARD.");
            throw new IllegalArgumentException(string);
        }
        this.direction = n2;
        this.populateGauges();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n2) {
        if (n2 < 0 || n2 > 1) {
            String string = LocaleBundle.string("Orientation must be one of ORIENTATION_HORIZONTAL or ORIENTATION_VERTICAL.");
            throw new IllegalArgumentException(string);
        }
        this.orientation = n2;
        this.populateGauges();
    }

    public JCBaseIndicatorGauge getGauge() {
        return this.gauge;
    }

    public void setGauge(JCBaseIndicatorGauge jCBaseIndicatorGauge) {
        if (jCBaseIndicatorGauge == null) {
            jCBaseIndicatorGauge = new JCBaseIndicatorGauge();
        }
        this.gauge = jCBaseIndicatorGauge;
        this.populateGauges();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (this.checkValidity(object)) {
            JCValueEvent jCValueEvent = new JCValueEvent(this, this.value, object);
            this.fireValueChangingEvent(jCValueEvent);
            if (jCValueEvent.getAllowChange()) {
                this.value = jCValueEvent.getNewValue();
                this.resetGauges();
            }
            this.fireValueChangedEvent(jCValueEvent);
        }
    }

    public void addMouseListenerToGauges(MouseListener mouseListener) {
        this.gauge.addMouseListener(mouseListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addMouseListener(mouseListener);
        }
    }

    public void removeMouseListenerFromGauges(MouseListener mouseListener) {
        this.gauge.removeMouseListener(mouseListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeMouseListener(mouseListener);
        }
    }

    public void addComponentListenerToGauges(ComponentListener componentListener) {
        this.gauge.addComponentListener(componentListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addComponentListener(componentListener);
        }
    }

    public void removeComponentListenerFromGauges(ComponentListener componentListener) {
        this.gauge.removeComponentListener(componentListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeComponentListener(componentListener);
        }
    }

    public void addAncestorListenerToGauges(AncestorListener ancestorListener) {
        this.gauge.addAncestorListener(ancestorListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addAncestorListener(ancestorListener);
        }
    }

    public void removeAncestorListenerFromGauges(AncestorListener ancestorListener) {
        this.gauge.removeAncestorListener(ancestorListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeAncestorListener(ancestorListener);
        }
    }

    public void addContainerListenerToGauges(ContainerListener containerListener) {
        this.gauge.addContainerListener(containerListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addContainerListener(containerListener);
        }
    }

    public void removeContainerListenerFromGauges(ContainerListener containerListener) {
        this.gauge.removeContainerListener(containerListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeContainerListener(containerListener);
        }
    }

    public void addFocusListenerToGauges(FocusListener focusListener) {
        this.gauge.addFocusListener(focusListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addFocusListener(focusListener);
        }
    }

    public void removeFocusListenerFromGauges(FocusListener focusListener) {
        this.gauge.removeFocusListener(focusListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeFocusListener(focusListener);
        }
    }

    public void addHierarchyBoundsListenerToGauges(HierarchyBoundsListener hierarchyBoundsListener) {
        this.gauge.addHierarchyBoundsListener(hierarchyBoundsListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addHierarchyBoundsListener(hierarchyBoundsListener);
        }
    }

    public void removeHierarchyBoundsListenerFromGauges(HierarchyBoundsListener hierarchyBoundsListener) {
        this.gauge.removeHierarchyBoundsListener(hierarchyBoundsListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeHierarchyBoundsListener(hierarchyBoundsListener);
        }
    }

    public void addHierarchyListenerToGauges(HierarchyListener hierarchyListener) {
        this.gauge.addHierarchyListener(hierarchyListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addHierarchyListener(hierarchyListener);
        }
    }

    public void removeHierarchyListenerFromGauges(HierarchyListener hierarchyListener) {
        this.gauge.removeHierarchyListener(hierarchyListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeHierarchyListener(hierarchyListener);
        }
    }

    public void addInputMethodListenerToGauges(InputMethodListener inputMethodListener) {
        this.gauge.addInputMethodListener(inputMethodListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addInputMethodListener(inputMethodListener);
        }
    }

    public void removeInputMethodListenerFromGauges(InputMethodListener inputMethodListener) {
        this.gauge.removeInputMethodListener(inputMethodListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeInputMethodListener(inputMethodListener);
        }
    }

    public void addKeyListenerToGauges(KeyListener keyListener) {
        this.gauge.addKeyListener(keyListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addKeyListener(keyListener);
        }
    }

    public void removeKeyListenerFromGauges(KeyListener keyListener) {
        this.gauge.removeKeyListener(keyListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeKeyListener(keyListener);
        }
    }

    public void addMouseMotionListenerToGauges(MouseMotionListener mouseMotionListener) {
        this.gauge.addMouseMotionListener(mouseMotionListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addMouseMotionListener(mouseMotionListener);
        }
    }

    public void removeMouseMotionListenerFromGauges(MouseMotionListener mouseMotionListener) {
        this.gauge.removeMouseMotionListener(mouseMotionListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeMouseMotionListener(mouseMotionListener);
        }
    }

    public void addMouseWheelListenerToGauges(MouseWheelListener mouseWheelListener) {
        this.gauge.addMouseWheelListener(mouseWheelListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addMouseWheelListener(mouseWheelListener);
        }
    }

    public void removeMouseWheelListenerFromGauges(MouseWheelListener mouseWheelListener) {
        this.gauge.removeMouseWheelListener(mouseWheelListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeMouseWheelListener(mouseWheelListener);
        }
    }

    public void addPropertyChangeListenerToGauges(PropertyChangeListener propertyChangeListener) {
        this.gauge.addPropertyChangeListener(propertyChangeListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListenerFromGauges(PropertyChangeListener propertyChangeListener) {
        this.gauge.removePropertyChangeListener(propertyChangeListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addVetoableChangeListenerToGauges(VetoableChangeListener vetoableChangeListener) {
        this.gauge.addVetoableChangeListener(vetoableChangeListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void removeVetoableChangeListenerFromGauges(VetoableChangeListener vetoableChangeListener) {
        this.gauge.removeVetoableChangeListener(vetoableChangeListener);
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    protected boolean checkValidity(Object object) {
        if (object == null) {
            return false;
        }
        int n2 = this.compareValue(object, this.getEffectiveBaseValue());
        return n2 >= 0;
    }

    protected int compareValue(Object object, Object object2) {
        if (!(object instanceof Number) || !(object instanceof Comparable)) {
            String string = LocaleBundle.string("Value must be an instance ofNumber and implement Comparable");
            throw new IllegalArgumentException(string);
        }
        int n2 = ((Comparable)object).compareTo(object2);
        return n2;
    }

    protected void resetGauges() {
        if (this.value == null) {
            return;
        }
        Object object = this.getEffectiveBaseValue();
        if (this.compareValue(this.value, object) < 0) {
            this.value = object;
        }
        if (this.valueType == 0) {
            this.resetBinaryGauges();
        } else if (this.valueType == 1) {
            this.resetDecimalGauges();
        } else if (this.valueType == 3) {
            this.resetMultichromeGauges();
        } else if (this.valueType == 2) {
            this.resetUnichromeGauges();
        }
        this.revalidate();
        this.repaint();
    }

    protected void resetUnichromeGauges() {
        block6: {
            int n2 = this.determineRangeIndex(this.value);
            if (!(this.value instanceof Number)) break block6;
            if (this.direction == 1) {
                int n3 = (Integer)this.value - (Integer)this.baseValue;
                for (int i2 = 0; i2 < this.numGauges; ++i2) {
                    if (i2 < n3) {
                        this.setIconProperties(i2, n2);
                        continue;
                    }
                    n2 = this.determineRangeIndex(this.baseValue);
                    this.setIconProperties(i2, n2);
                }
            } else {
                for (int i3 = this.numGauges - 1; i3 >= 0; --i3) {
                    int n4 = this.numGauges - ((Integer)this.value - (Integer)this.baseValue);
                    if (i3 >= n4) {
                        this.setIconProperties(i3, n2);
                        continue;
                    }
                    n2 = this.determineRangeIndex(this.baseValue);
                    this.setIconProperties(i3, n2);
                }
            }
        }
    }

    protected void setIconProperties(int n2, int n3) {
        int n4;
        Object object;
        JCIndicatorIcon jCIndicatorIcon = this.gauges[n2].getIcon();
        if (this.textValueDisplayed) {
            object = this.getValue().toString();
            if (this.valueType > 1) {
                jCIndicatorIcon.setText("" + (String)object);
            } else {
                if (this.valueType == 0 && this.value instanceof Integer) {
                    object = Integer.toBinaryString((Integer)this.value);
                }
                n4 = ((String)object).length();
                if (this.direction == 1) {
                    StringBuffer stringBuffer = new StringBuffer((String)object);
                    stringBuffer.reverse();
                    if (n4 > n2) {
                        jCIndicatorIcon.setText("" + stringBuffer.charAt(n2));
                    } else if (this.valueType == 0) {
                        jCIndicatorIcon.setText("0");
                    }
                } else if (this.numGauges > n4) {
                    int n5 = this.numGauges - n4;
                    if (n5 <= n2) {
                        jCIndicatorIcon.setText("" + ((String)object).charAt(n2 - n5));
                    } else if (this.valueType == 0) {
                        jCIndicatorIcon.setText("0");
                    }
                } else {
                    int n6 = n4 - this.numGauges;
                    if (n4 > n2 + n6) {
                        jCIndicatorIcon.setText("" + ((String)object).charAt(n2 + n6));
                    }
                }
            }
        } else if (this.rangeText != null) {
            if (this.rangeText.length > n3) {
                jCIndicatorIcon.setText(this.rangeText[n3]);
            } else {
                jCIndicatorIcon.setText(this.rangeText[this.rangeText.length - 1]);
            }
        } else {
            jCIndicatorIcon.setText("");
        }
        object = null;
        if (this.rangeDisplays != null) {
            object = this.rangeDisplays.length > n3 ? this.rangeDisplays[n3] : this.rangeDisplays[this.rangeDisplays.length - 1];
        }
        if (object == null) {
            return;
        }
        if (object instanceof Color) {
            jCIndicatorIcon.setColor((Color)object);
            jCIndicatorIcon.setPortableImage(null);
        } else if (object instanceof URL) {
            jCIndicatorIcon.setColor(null);
            jCIndicatorIcon.setPortableImage(new PortableImage((URL)object, jCIndicatorIcon.isImageScaled()));
        } else if (object instanceof PortableImage) {
            jCIndicatorIcon.setColor(null);
            jCIndicatorIcon.setPortableImage((PortableImage)object);
        }
        if (this.rangeToolTips != null) {
            n4 = this.rangeToolTips.length;
            if (n4 > n3) {
                this.gauges[n2].setToolTipText(this.rangeToolTips[n3]);
            } else {
                this.gauges[n2].setToolTipText(this.rangeToolTips[n4 - 1]);
            }
        } else if (this.textValueDisplayed) {
            this.gauges[n2].setToolTipText(jCIndicatorIcon.getText());
        } else if (this.rangeText != null) {
            if (this.rangeText.length > n3) {
                this.gauges[n2].setToolTipText(this.rangeText[n3]);
            } else {
                this.gauges[n2].setToolTipText(this.rangeText[this.rangeText.length - 1]);
            }
        } else {
            this.gauges[n2].setToolTipText(object.toString());
        }
    }

    protected void resetMultichromeGauges() {
        block7: {
            if (!(this.value instanceof Number)) break block7;
            int n2 = (Integer)this.baseValue;
            if (this.direction == 1) {
                int n3 = (Integer)this.value - n2;
                for (int i2 = 0; i2 < this.numGauges; ++i2) {
                    int n4 = this.determineRangeIndex(n2 + i2 + 1);
                    if (i2 < n3) {
                        this.setIconProperties(i2, n4);
                        continue;
                    }
                    n4 = this.determineRangeIndex(this.baseValue);
                    this.setIconProperties(i2, n4);
                }
            } else {
                int n5 = 0;
                for (int i3 = this.numGauges - 1; i3 >= 0; --i3) {
                    int n6 = this.numGauges - ((Integer)this.value - n2);
                    int n7 = this.determineRangeIndex(n5 + 1 + n2);
                    if (i3 >= n6) {
                        this.setIconProperties(i3, n7);
                    } else {
                        n7 = this.determineRangeIndex(this.baseValue);
                        this.setIconProperties(i3, n7);
                    }
                    ++n5;
                }
            }
        }
    }

    protected void resetDecimalGauges() {
        String string = null;
        if (this.value instanceof Number) {
            string = this.value.toString();
        } else if (this.value instanceof String) {
            string = (String)this.value;
        }
        this.resetNonMagnitudinalGauges(string);
    }

    protected void resetBinaryGauges() {
        String string;
        if (this.value instanceof Integer) {
            string = Integer.toBinaryString((Integer)this.value);
        } else if (this.value instanceof String) {
            string = (String)this.value;
        } else {
            String string2 = LocaleBundle.string("Only Longs or Integers can be values for valueType VALUE_BINARY");
            throw new IllegalArgumentException(string2);
        }
        this.resetNonMagnitudinalGauges(string);
    }

    private void resetNonMagnitudinalGauges(String string) {
        if (this.direction == 1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer = stringBuffer.reverse();
            while (stringBuffer.length() < this.numGauges) {
                stringBuffer.append("0");
            }
            string = stringBuffer.toString();
            for (int i2 = 0; i2 < this.numGauges; ++i2) {
                Integer n2 = null;
                if (i2 < string.length()) {
                    n2 = new Integer(string.substring(i2, i2 + 1));
                }
                int n3 = this.determineRangeIndex(n2);
                this.setIconProperties(i2, n3);
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (stringBuffer.length() < this.numGauges) {
                stringBuffer.insert(0, "0");
            }
            string = stringBuffer.toString();
            int n4 = this.numGauges - 1;
            if (string.length() > this.numGauges) {
                n4 = string.length() - 1;
            }
            for (int i3 = this.numGauges - 1; i3 >= 0; --i3) {
                Integer n5 = null;
                if (i3 < string.length()) {
                    n5 = new Integer(string.substring(n4, n4-- + 1));
                }
                int n6 = this.determineRangeIndex(n5);
                this.setIconProperties(i3, n6);
            }
        }
    }

    protected int determineRangeIndex(Object object) {
        if (object instanceof Comparable) {
            for (int i2 = 0; i2 < this.rangeValues.length; ++i2) {
                int n2 = this.compareValue(object, this.rangeValues[i2]);
                if (n2 > 0) continue;
                return i2;
            }
        }
        return this.rangeValues.length;
    }

    public void addValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.add(this.valueListeners, jCValueListener);
    }

    public void removeValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.remove(this.valueListeners, jCValueListener);
    }

    protected void fireValueChangedEvent(JCValueEvent jCValueEvent) {
        Enumeration<Object> enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            ((JCValueListener)enumeration.nextElement()).valueChanged(jCValueEvent);
        }
    }

    protected void fireValueChangingEvent(JCValueEvent jCValueEvent) {
        Enumeration<Object> enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            ((JCValueListener)enumeration.nextElement()).valueChanging(jCValueEvent);
        }
    }

    public void setRangeToolTips(String[] stringArray) {
        this.rangeToolTips = stringArray;
        this.resetGauges();
    }

    public String[] getRangeToolTips() {
        return this.rangeToolTips;
    }

    public void setRangeText(String[] stringArray) {
        this.rangeText = stringArray;
        this.resetGauges();
    }

    public String[] getRangeText() {
        return this.rangeText;
    }

    public Object[] getRangeDisplays() {
        return this.rangeDisplays;
    }

    public void setRangeDisplays(Object[] objectArray) {
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (object == null || object instanceof Color || object instanceof URL || object instanceof PortableImage) continue;
                String string = LocaleBundle.string("RangeDisplay entries must be either a Color, URL, or PortableImage object.");
                throw new IllegalArgumentException(string);
            }
        }
        this.rangeDisplays = objectArray;
        this.resetGauges();
    }

    public void setRangeValues(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            String string = LocaleBundle.string("Range value array must have at least one element.");
            throw new IllegalArgumentException(string);
        }
        for (Object object : objectArray) {
            if (this.checkValidity(object)) continue;
            String string = LocaleBundle.string("Range values must be non-null and greater than the base value.");
            throw new IllegalArgumentException(string);
        }
        this.rangeValues = objectArray;
        this.resetGauges();
    }

    public Object[] getRangeValues() {
        return this.rangeValues;
    }

    public void setBaseValue(Object object) {
        Object object2;
        if (object == null) {
            object = 0;
        }
        this.baseValue = object;
        if (this.value != null && this.compareValue(this.value, object2 = this.getEffectiveBaseValue()) < 0) {
            this.value = object2;
        }
        this.resetGauges();
    }

    public Object getBaseValue() {
        return this.baseValue;
    }

    protected Object getEffectiveBaseValue() {
        if (this.valueType == 3 || this.valueType == 2) {
            return this.baseValue;
        }
        return 0;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int n2) {
        if (n2 < 0) {
            String string = LocaleBundle.string("Padding cannot be negative");
            throw new IllegalArgumentException(string);
        }
        this.padding = n2;
        this.populateGauges();
    }

    public void setTextValueDisplayed(boolean bl) {
        this.textValueDisplayed = bl;
        this.resetGauges();
    }

    public boolean isTextValueDisplayed() {
        return this.textValueDisplayed;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = GraphicsUtil.setAntiAliasing(graphics2D, this.antiAliasing);
        super.paint(graphics2D);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isOpaque()) {
            ImageIcon imageIcon;
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(0, 0);
            Color color = this.getBackground();
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            }
            Insets insets = this.getInsets();
            int n2 = Math.max(0, rectangle.width - insets.left - insets.right);
            int n3 = Math.max(0, rectangle.height - insets.top - insets.bottom);
            rectangle = new Rectangle(insets.left, insets.top, n2, n3);
            if (this.fillStyle != null) {
                this.fillStyle.updateAnchorRect(rectangle);
                this.fillStyle.fillRect((Graphics)graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.fillStyle.updateAnchorRect(null);
            }
            if (this.image != null && this.image.getImage() != null && (imageIcon = new ImageIcon(this.image.getImage())).getImageLoadStatus() == 8) {
                Image image = imageIcon.getImage();
                if (this.image.isImageScaled()) {
                    graphics2D.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
                } else {
                    int n4 = imageIcon.getIconWidth();
                    int n5 = imageIcon.getIconHeight();
                    if (n4 > 0 && n5 > 0) {
                        int n6 = rectangle.x - (n4 - rectangle.width) / 2;
                        int n7 = rectangle.y - (n5 - rectangle.height) / 2;
                        graphics2D.drawImage(image, n6, n7, n4, n5, this);
                    }
                }
            }
        }
    }

    public int getAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(int n2) {
        this.antiAliasing = n2;
    }

    public void setUsingDoublePixels(boolean bl) {
    }

    public boolean isUsingDoublePixels() {
        return false;
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }

    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    public void serverPaint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = GraphicsUtil.setAntiAliasing(graphics2D, this.antiAliasing);
        ServerRenderer.paintComponent(graphics2D, this);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIndicatorGaugePanel();
        }
        return this.accessibleContext;
    }

    public int getBlinkInterval() {
        return this.blinkInterval;
    }

    public void setBlinkInterval(int n2) {
        this.stopBlinking();
        if (n2 < 0) {
            String string = LocaleBundle.string("Blink Interval must be positive");
            throw new IllegalArgumentException(string);
        }
        this.blinkInterval = n2;
        if (n2 > 0) {
            this.t = new Timer(n2, this);
        }
    }

    public void startBlinking() {
        if (this.t != null) {
            this.t.start();
        }
    }

    public void stopBlinking() {
        if (this.t != null) {
            this.t.stop();
            this.blink = false;
            this.repaint();
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.blink = !this.blink;
        for (JCBaseIndicatorGauge jCBaseIndicatorGauge : this.gauges) {
            jCBaseIndicatorGauge.blink = this.blink;
        }
        this.repaint();
    }

    public static void main(String[] stringArray) {
        JCBaseIndicatorGauge jCBaseIndicatorGauge = new JCBaseIndicatorGauge(1);
        jCBaseIndicatorGauge.setBackground(new Color(126, 135, 0));
        jCBaseIndicatorGauge.setPadding(5);
        jCBaseIndicatorGauge.getIcon().setForeground(new Color(177, 0, 177));
        jCBaseIndicatorGauge.getIcon().setFont(new Font("Dialog", 1, 18));
        final JCIndicatorGaugePanel jCIndicatorGaugePanel = new JCIndicatorGaugePanel(6, jCBaseIndicatorGauge);
        jCIndicatorGaugePanel.setAntiAliasing(1);
        jCIndicatorGaugePanel.setPadding(5);
        jCIndicatorGaugePanel.setBackground(Color.cyan);
        jCIndicatorGaugePanel.setImage(jCBaseIndicatorGauge.getClass().getResource("pict0360.jpg"));
        Integer n2 = 7;
        jCIndicatorGaugePanel.setValue(n2);
        jCIndicatorGaugePanel.setRangeDisplays(new Color[]{Color.black, Color.darkGray, Color.blue, Color.magenta, Color.green, Color.yellow, Color.orange, Color.red, Color.pink, Color.gray});
        jCIndicatorGaugePanel.setRangeValues(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                jCIndicatorGaugePanel.setValue(3);
            }
        };
        jCIndicatorGaugePanel.addMouseListenerToGauges(mouseAdapter);
        jCIndicatorGaugePanel.setBaseValue(new Integer(0));
        jCIndicatorGaugePanel.setBlinkInterval(1000);
        System.out.println(jCIndicatorGaugePanel.getValue());
        jCIndicatorGaugePanel.setRangeText(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
        jCIndicatorGaugePanel.setOrientation(0);
        jCIndicatorGaugePanel.setDirection(0);
        jCIndicatorGaugePanel.setValueType(1);
        JFrame jFrame = new JFrame();
        jFrame.setSize(new Dimension(400, 400));
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jCIndicatorGaugePanel, "Center");
        jFrame.setVisible(true);
    }

    protected class AccessibleIndicatorGaugePanel
    extends JComponent.AccessibleJComponent {
        protected AccessibleIndicatorGaugePanel() {
            super(JCIndicatorGaugePanel.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleIndicatorGaugeRole.INDICATOR_GAUGE_PANEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(new AccessibleValueState("value = ", JCIndicatorGaugePanel.this.value.toString()));
            return accessibleStateSet;
        }
    }
}

