/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge.indicator;

import com.klg.jclass.gauge.indicator.JCIndicatorIcon;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.style.JCFillStyle;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.AncestorListener;

public class JCBaseIndicatorGauge
extends JComponent
implements Accessible,
ComponentListener,
Cloneable,
Serializable {
    protected JCIndicatorIcon icon = null;
    protected int padding = 1;
    protected PortableImage image = null;
    protected JCFillStyle fillStyle = null;
    protected boolean blink = false;
    protected int index = -1;

    public JCBaseIndicatorGauge(int n2) {
        this.icon = new JCIndicatorIcon(n2, this);
        this.calculateIconBounds();
        this.addComponentListener(this);
        this.setOpaque(true);
    }

    public JCBaseIndicatorGauge() {
        this(0);
    }

    public JCIndicatorIcon getIcon() {
        return this.icon;
    }

    public void setIcon(JCIndicatorIcon jCIndicatorIcon) {
        this.icon = jCIndicatorIcon;
    }

    public PortableImage getPortableImage() {
        return this.image;
    }

    public void setPortableImage(PortableImage portableImage) {
        this.image = portableImage;
    }

    public Image getImage() {
        if (this.image == null) {
            return null;
        }
        return this.image.getImage();
    }

    public void setImage(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && (imageIcon = new ImageIcon(uRL)).getImageLoadStatus() == 8) {
            this.setImage(imageIcon.getImage());
        }
    }

    public void setImage(Image image) {
        if (this.image == null) {
            this.image = new PortableImage(image);
        } else {
            this.image.setImage(image);
        }
    }

    public boolean isImageScaled() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.isImageScaled();
    }

    public void setImageScaled(boolean bl) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setImageScaled(bl);
    }

    public OutputProperties getImageOutputProperties() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.getOutputProperties();
    }

    public void setImageOutputProperties(OutputProperties outputProperties) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setOutputProperties(outputProperties);
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle != null) {
            this.fillStyle.parent = null;
        }
        this.fillStyle = jCFillStyle;
        if (this.fillStyle != null) {
            this.fillStyle.parent = this;
        }
    }

    public int getIndex() {
        return this.index;
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
        if (renderProperties != null) {
            object = GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
        }
        if (this.isOpaque()) {
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(0, 0);
            Color color = this.getBackground();
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            }
            if (this.fillStyle != null) {
                Insets insets = this.getInsets();
                int n2 = Math.max(0, rectangle.width - insets.left - insets.right);
                int n3 = Math.max(0, rectangle.height - insets.top - insets.bottom);
                Rectangle rectangle2 = new Rectangle(insets.left, insets.top, n2, n3);
                this.fillStyle.updateAnchorRect(rectangle2);
                this.fillStyle.fillRect((Graphics)graphics2D, insets.left, insets.top, n2, n3);
                this.fillStyle.updateAnchorRect(null);
            }
            this.drawImage(graphics2D, this.image, rectangle, this.getInsets());
        }
        this.icon.paint(graphics2D, this.blink);
        if (renderProperties != null && object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int n2) {
        if (n2 < 0) {
            String string = LocaleBundle.string("Padding cannot be negative");
            throw new IllegalArgumentException(string);
        }
        this.padding = n2;
        this.calculateIconBounds();
    }

    protected void calculateIconBounds() {
        this.resetIconBounds();
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.resetIconBounds();
    }

    public void resetIconBounds() {
        Insets insets = this.getInsets();
        this.icon.setBounds(new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom)));
    }

    protected void drawImage(Graphics graphics, PortableImage portableImage, Rectangle rectangle, Insets insets) {
        ImageIcon imageIcon;
        if (portableImage != null && portableImage.getImage() != null && (imageIcon = new ImageIcon(portableImage.getImage())).getImageLoadStatus() == 8) {
            Image image = imageIcon.getImage();
            if (insets != null) {
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
            }
            if (portableImage.isImageScaled()) {
                graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
            } else {
                int n2 = imageIcon.getIconWidth();
                int n3 = imageIcon.getIconHeight();
                if (n2 > 0 && n3 > 0) {
                    int n4 = rectangle.x - (n2 - rectangle.width) / 2;
                    int n5 = rectangle.y - (n3 - rectangle.height) / 2;
                    graphics.drawImage(image, n4, n5, n2, n3, this);
                }
            }
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.calculateIconBounds();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void removeAllListeners() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        EventListener[] eventListenerArray = mouseListenerArray;
        int n13 = eventListenerArray.length;
        for (n12 = 0; n12 < n13; ++n12) {
            MouseListener mouseListener = eventListenerArray[n12];
            this.removeMouseListener(mouseListener);
        }
        EventListener[] eventListenerArray2 = eventListenerArray = this.getComponentListeners();
        n12 = eventListenerArray2.length;
        for (n11 = 0; n11 < n12; ++n11) {
            EventListener eventListener = eventListenerArray2[n11];
            this.removeComponentListener((ComponentListener)eventListener);
        }
        EventListener[] eventListenerArray3 = eventListenerArray2 = this.getAncestorListeners();
        n11 = eventListenerArray3.length;
        for (n10 = 0; n10 < n11; ++n10) {
            EventListener eventListener = eventListenerArray3[n10];
            this.removeAncestorListener((AncestorListener)eventListener);
        }
        EventListener[] eventListenerArray4 = eventListenerArray3 = this.getContainerListeners();
        n10 = eventListenerArray4.length;
        for (n9 = 0; n9 < n10; ++n9) {
            EventListener eventListener = eventListenerArray4[n9];
            this.removeContainerListener((ContainerListener)eventListener);
        }
        EventListener[] eventListenerArray5 = eventListenerArray4 = this.getFocusListeners();
        n9 = eventListenerArray5.length;
        for (n8 = 0; n8 < n9; ++n8) {
            EventListener eventListener = eventListenerArray5[n8];
            this.removeFocusListener((FocusListener)eventListener);
        }
        EventListener[] eventListenerArray6 = eventListenerArray5 = this.getHierarchyBoundsListeners();
        n8 = eventListenerArray6.length;
        for (n7 = 0; n7 < n8; ++n7) {
            EventListener eventListener = eventListenerArray6[n7];
            this.removeHierarchyBoundsListener((HierarchyBoundsListener)eventListener);
        }
        EventListener[] eventListenerArray7 = eventListenerArray6 = this.getHierarchyListeners();
        n7 = eventListenerArray7.length;
        for (n6 = 0; n6 < n7; ++n6) {
            EventListener eventListener = eventListenerArray7[n6];
            this.removeHierarchyListener((HierarchyListener)eventListener);
        }
        EventListener[] eventListenerArray8 = eventListenerArray7 = this.getInputMethodListeners();
        n6 = eventListenerArray8.length;
        for (n5 = 0; n5 < n6; ++n5) {
            EventListener eventListener = eventListenerArray8[n5];
            this.removeInputMethodListener((InputMethodListener)eventListener);
        }
        EventListener[] eventListenerArray9 = eventListenerArray8 = this.getKeyListeners();
        n5 = eventListenerArray9.length;
        for (n4 = 0; n4 < n5; ++n4) {
            EventListener eventListener = eventListenerArray9[n4];
            this.removeKeyListener((KeyListener)eventListener);
        }
        EventListener[] eventListenerArray10 = eventListenerArray9 = this.getMouseMotionListeners();
        n4 = eventListenerArray10.length;
        for (n3 = 0; n3 < n4; ++n3) {
            EventListener eventListener = eventListenerArray10[n3];
            this.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        EventListener[] eventListenerArray11 = eventListenerArray10 = this.getMouseWheelListeners();
        n3 = eventListenerArray11.length;
        for (n2 = 0; n2 < n3; ++n2) {
            EventListener eventListener = eventListenerArray11[n2];
            this.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        EventListener[] eventListenerArray12 = eventListenerArray11 = this.getPropertyChangeListeners();
        n2 = eventListenerArray12.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventListener eventListener = eventListenerArray12[i2];
            this.removePropertyChangeListener((PropertyChangeListener)eventListener);
        }
        for (EventListener eventListener : eventListenerArray12 = this.getVetoableChangeListeners()) {
            this.removeVetoableChangeListener((VetoableChangeListener)eventListener);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        JCFillStyle jCFillStyle;
        JCBaseIndicatorGauge jCBaseIndicatorGauge = new JCBaseIndicatorGauge();
        jCBaseIndicatorGauge.setPreferredSize(this.getPreferredSize());
        jCBaseIndicatorGauge.setMinimumSize(this.getMinimumSize());
        jCBaseIndicatorGauge.setMaximumSize(this.getMaximumSize());
        jCBaseIndicatorGauge.setSize(this.getSize());
        JCIndicatorIcon jCIndicatorIcon = (JCIndicatorIcon)this.getIcon().clone();
        jCIndicatorIcon.parent = jCBaseIndicatorGauge;
        jCBaseIndicatorGauge.setIcon(jCIndicatorIcon);
        if (this.image != null) {
            jCBaseIndicatorGauge.setPortableImage((PortableImage)this.image.clone());
        }
        if ((jCFillStyle = this.getFillStyle()) != null) {
            jCFillStyle = (JCFillStyle)jCFillStyle.clone();
            jCBaseIndicatorGauge.setFillStyle(jCFillStyle);
        }
        jCBaseIndicatorGauge.setPadding(this.padding);
        jCBaseIndicatorGauge.setBackground(this.getBackground());
        jCBaseIndicatorGauge.setBorder(this.getBorder());
        jCBaseIndicatorGauge.setOpaque(this.isOpaque());
        jCBaseIndicatorGauge.setVisible(this.isVisible());
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        EventListener[] eventListenerArray = mouseListenerArray;
        int n13 = eventListenerArray.length;
        for (n12 = 0; n12 < n13; ++n12) {
            MouseListener mouseListener = eventListenerArray[n12];
            jCBaseIndicatorGauge.addMouseListener(mouseListener);
        }
        EventListener[] eventListenerArray2 = eventListenerArray = this.getComponentListeners();
        n12 = eventListenerArray2.length;
        for (n11 = 0; n11 < n12; ++n11) {
            EventListener eventListener = eventListenerArray2[n11];
            jCBaseIndicatorGauge.addComponentListener((ComponentListener)eventListener);
        }
        EventListener[] eventListenerArray3 = eventListenerArray2 = this.getAncestorListeners();
        n11 = eventListenerArray3.length;
        for (n10 = 0; n10 < n11; ++n10) {
            EventListener eventListener = eventListenerArray3[n10];
            jCBaseIndicatorGauge.addAncestorListener((AncestorListener)eventListener);
        }
        EventListener[] eventListenerArray4 = eventListenerArray3 = this.getContainerListeners();
        n10 = eventListenerArray4.length;
        for (n9 = 0; n9 < n10; ++n9) {
            EventListener eventListener = eventListenerArray4[n9];
            jCBaseIndicatorGauge.addContainerListener((ContainerListener)eventListener);
        }
        EventListener[] eventListenerArray5 = eventListenerArray4 = this.getFocusListeners();
        n9 = eventListenerArray5.length;
        for (n8 = 0; n8 < n9; ++n8) {
            EventListener eventListener = eventListenerArray5[n8];
            jCBaseIndicatorGauge.addFocusListener((FocusListener)eventListener);
        }
        EventListener[] eventListenerArray6 = eventListenerArray5 = this.getHierarchyBoundsListeners();
        n8 = eventListenerArray6.length;
        for (n7 = 0; n7 < n8; ++n7) {
            EventListener eventListener = eventListenerArray6[n7];
            jCBaseIndicatorGauge.addHierarchyBoundsListener((HierarchyBoundsListener)eventListener);
        }
        EventListener[] eventListenerArray7 = eventListenerArray6 = this.getHierarchyListeners();
        n7 = eventListenerArray7.length;
        for (n6 = 0; n6 < n7; ++n6) {
            EventListener eventListener = eventListenerArray7[n6];
            jCBaseIndicatorGauge.addHierarchyListener((HierarchyListener)eventListener);
        }
        EventListener[] eventListenerArray8 = eventListenerArray7 = this.getInputMethodListeners();
        n6 = eventListenerArray8.length;
        for (n5 = 0; n5 < n6; ++n5) {
            EventListener eventListener = eventListenerArray8[n5];
            jCBaseIndicatorGauge.addInputMethodListener((InputMethodListener)eventListener);
        }
        EventListener[] eventListenerArray9 = eventListenerArray8 = this.getKeyListeners();
        n5 = eventListenerArray9.length;
        for (n4 = 0; n4 < n5; ++n4) {
            EventListener eventListener = eventListenerArray9[n4];
            jCBaseIndicatorGauge.addKeyListener((KeyListener)eventListener);
        }
        EventListener[] eventListenerArray10 = eventListenerArray9 = this.getMouseMotionListeners();
        n4 = eventListenerArray10.length;
        for (n3 = 0; n3 < n4; ++n3) {
            EventListener eventListener = eventListenerArray10[n3];
            jCBaseIndicatorGauge.addMouseMotionListener((MouseMotionListener)eventListener);
        }
        EventListener[] eventListenerArray11 = eventListenerArray10 = this.getMouseWheelListeners();
        n3 = eventListenerArray11.length;
        for (n2 = 0; n2 < n3; ++n2) {
            EventListener eventListener = eventListenerArray11[n2];
            jCBaseIndicatorGauge.addMouseWheelListener((MouseWheelListener)eventListener);
        }
        EventListener[] eventListenerArray12 = eventListenerArray11 = this.getPropertyChangeListeners();
        n2 = eventListenerArray12.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventListener eventListener = eventListenerArray12[i2];
            jCBaseIndicatorGauge.addPropertyChangeListener((PropertyChangeListener)eventListener);
        }
        for (EventListener eventListener : eventListenerArray12 = this.getVetoableChangeListeners()) {
            jCBaseIndicatorGauge.addVetoableChangeListener((VetoableChangeListener)eventListener);
        }
        return jCBaseIndicatorGauge;
    }

    public static void main(String[] stringArray) {
        JCBaseIndicatorGauge jCBaseIndicatorGauge = new JCBaseIndicatorGauge(1);
        jCBaseIndicatorGauge.setPadding(20);
        jCBaseIndicatorGauge.getIcon().setColor(Color.red);
        URL uRL = jCBaseIndicatorGauge.getClass().getResource("pict0360.jpg");
        jCBaseIndicatorGauge.getIcon().setPortableImage(new PortableImage(uRL, false));
        jCBaseIndicatorGauge.setBackground(Color.orange);
        Font font = new Font("Dialog", 1, 18);
        jCBaseIndicatorGauge.getIcon().setFont(font);
        jCBaseIndicatorGauge.getIcon().setForeground(Color.black);
        jCBaseIndicatorGauge.getIcon().setText("Hi, Mom and dad");
        jCBaseIndicatorGauge.setOpaque(true);
        jCBaseIndicatorGauge.setPreferredSize(new Dimension(300, 300));
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(new JLabel("How do you like me now?"));
        try {
            container.add((JCBaseIndicatorGauge)jCBaseIndicatorGauge.clone());
            container.add(jCBaseIndicatorGauge);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        jFrame.pack();
        jCBaseIndicatorGauge.setSize(new Dimension(200, 200));
        jFrame.setVisible(true);
    }
}

