/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge.graph;

import com.klg.jclass.gauge.graph.ScaleProvider;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.JCNumberUtil;

public class ScaleProviderAdaptor
implements ScaleProvider {
    private static final double DEFAULT_MIN = Double.MAX_VALUE;
    private static final double DEFAULT_MAX = -1.7976931348623157E308;
    protected double max = -1.7976931348623157E308;
    protected double min = Double.MAX_VALUE;
    protected double inc = 0.0;
    protected boolean isAtDefault = true;

    public ScaleProviderAdaptor() {
    }

    public ScaleProviderAdaptor(double d2, double d3) {
        this(d2, d3, 0.0);
    }

    public ScaleProviderAdaptor(double d2, double d3, double d4) {
        if (d2 > d3) {
            String string = LocaleBundle.string("The scale minimum must be less than the maximum.");
            throw new IllegalArgumentException(string);
        }
        this.min = d2;
        this.max = d3;
        this.inc = d4;
    }

    public void hit(Number number) {
        this.hit(number.doubleValue());
    }

    public void hit(double d2) {
        boolean bl = false;
        if (d2 > this.max) {
            this.incMax(d2);
            bl = true;
        }
        if (d2 < this.min) {
            this.incMin(d2);
            bl = true;
        }
        if (bl) {
            this.adjustBounds(true);
        }
        this.isAtDefault = false;
    }

    public double getIncrement() {
        return this.inc;
    }

    public void setIncrement(double d2) {
        if (d2 < 0.0) {
            String string = LocaleBundle.string("The increment must be non-negative.");
            throw new IllegalArgumentException(string);
        }
        this.inc = d2;
    }

    public double getMaximum() {
        return this.max;
    }

    public void setMaximum(double d2) {
        if (this.isAtDefault()) {
            this.min = d2;
            this.max = d2;
            this.adjustBounds(false);
            this.isAtDefault = false;
            return;
        }
        if (d2 < this.min) {
            String string = LocaleBundle.string("The scale minimum must be less than the maximum.");
            throw new IllegalArgumentException(string);
        }
        this.max = d2;
        if (this.min == this.max) {
            this.adjustBounds(false);
        }
    }

    public double getMinimum() {
        return this.min;
    }

    public void setMinimum(double d2) {
        if (this.isAtDefault()) {
            this.min = d2;
            this.max = d2;
            this.adjustBounds(true);
            this.isAtDefault = false;
            return;
        }
        if (d2 > this.max) {
            String string = LocaleBundle.string("The scale minimum must be less than the maximum.");
            throw new IllegalArgumentException(string);
        }
        this.min = d2;
        if (this.min == this.max) {
            this.adjustBounds(true);
        }
    }

    public boolean isAtDefault() {
        return this.isAtDefault;
    }

    public double getMean() {
        String string = LocaleBundle.string("This class does not support this method.");
        throw new UnsupportedOperationException(string);
    }

    public double getStdDev() {
        String string = LocaleBundle.string("This class does not support this method.");
        throw new UnsupportedOperationException(string);
    }

    protected void incMax(double d2) {
        this.max = this.inc > 0.0 ? this.inc * Math.ceil(d2 / this.inc) : d2;
    }

    protected void incMin(double d2) {
        this.min = this.inc > 0.0 ? this.inc * Math.floor(d2 / this.inc) : d2;
    }

    protected void adjustBounds(boolean bl) {
        int n2 = this.calcPrecision(this.min, this.max);
        this.min = JCNumberUtil.precFloor(n2, this.min);
        this.max = JCNumberUtil.precCeil(n2, this.max);
        if (this.max <= this.min) {
            int n3 = n2;
            do {
                double d2 = Math.pow(10.0, -n3);
                if (bl) {
                    this.max = this.min + d2;
                } else {
                    this.min = this.max - d2;
                }
                --n3;
            } while (this.max <= this.min);
        }
    }

    protected int calcPrecision(double d2, double d3) {
        int n2 = d3 <= d2 ? JCNumberUtil.nicePrecision(Math.abs(d3)) : JCNumberUtil.nicePrecision(d3 - d2);
        return n2;
    }
}

