/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge.graph;

import com.klg.jclass.gauge.graph.JCGraph;
import com.klg.jclass.gauge.property.PropertyLoadFactory;
import com.klg.jclass.gauge.property.PropertySaveFactory;
import com.klg.jclass.gauge.property.xml.JCXMLFileAccessor;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.io.LoadProperties;
import com.klg.jclass.util.property.PropertyLoadModel;
import com.klg.jclass.util.property.PropertySaveModel;
import com.klg.jclass.util.property.xml.JCXMLFilePersistor;
import com.klg.jclass.util.swing.JCExitFrame;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class JCGraphFactory {
    public static final int XML = 1;

    public static JCGraph updateGraph(JCGraph jCGraph, Object object, LoadProperties loadProperties, int n2) throws IOException {
        JCXMLFileAccessor jCXMLFileAccessor;
        if (!(object instanceof String || object instanceof URL || object instanceof InputStream || object instanceof Reader)) {
            throw new IllegalArgumentException("Bad input source.  Must be one of String, URL, InputStream, or Reader ");
        }
        if (loadProperties == null) {
            loadProperties = new LoadProperties();
        }
        switch (n2) {
            case 1: {
                jCXMLFileAccessor = new JCXMLFileAccessor(null, loadProperties);
                break;
            }
            default: {
                String string = LocaleBundle.string("Bad Input Type");
                throw new IllegalArgumentException(string);
            }
        }
        jCXMLFileAccessor.getProperties(object);
        if (jCGraph == null) {
            jCGraph = new JCGraph();
        }
        jCXMLFileAccessor.setComponent(jCGraph);
        PropertyLoadModel propertyLoadModel = PropertyLoadFactory.makeLoader(jCGraph, jCXMLFileAccessor);
        if (propertyLoadModel != null) {
            propertyLoadModel.loadProperties(jCXMLFileAccessor, null);
        }
        return jCGraph;
    }

    public static JCGraph makeGraph(Object object, LoadProperties loadProperties, int n2) throws IOException {
        return JCGraphFactory.updateGraph(null, object, loadProperties, n2);
    }

    public static void saveGraph(JCGraph jCGraph, Object object, int n2, boolean bl) throws IOException {
        JCXMLFilePersistor jCXMLFilePersistor;
        if (jCGraph == null) {
            return;
        }
        if (!(object instanceof String || object instanceof OutputStream || object instanceof Writer)) {
            throw new IllegalArgumentException("Bad outputTarget.  Must be one of String, OutputStream, or Writer.");
        }
        switch (n2) {
            case 1: {
                jCXMLFilePersistor = new JCXMLFilePersistor(object, (Object)jCGraph);
                break;
            }
            default: {
                String string = LocaleBundle.string("Bad Output Type");
                throw new IllegalArgumentException(string);
            }
        }
        jCXMLFilePersistor.setPrintErrors(bl);
        JCGraph jCGraph2 = new JCGraph();
        PropertySaveModel propertySaveModel = PropertySaveFactory.makeSaver(jCGraph, jCGraph2, PropertySaveFactory.getPackage(), jCXMLFilePersistor.getSubDirectory(), jCXMLFilePersistor.getType());
        if (propertySaveModel != null) {
            propertySaveModel.saveProperties(jCXMLFilePersistor, null, 0);
        }
        jCXMLFilePersistor.dispose();
    }

    public static void main(String[] stringArray) {
        JCGraph jCGraph = null;
        int n2 = 1;
        try {
            jCGraph = new JCGraph();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        Dimension dimension = new Dimension(jCGraph.getWidth(), jCGraph.getHeight());
        jCGraph.setMaxValue(4.0);
        jCGraph.addValues(new double[]{1.0, 2.4, 3.8, 2.2, 1.1, 3.4, 2.9, 2.7, 1.9});
        System.out.println(jCGraph.getMaxValue());
        jCGraph.setPreferredSize(dimension);
        JCExitFrame jCExitFrame = new JCExitFrame("Test");
        jCExitFrame.getContentPane().add(jCGraph);
        jCExitFrame.pack();
        jCExitFrame.setVisible(true);
        try {
            File file = new File("save.xml");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            System.out.println(file.getAbsolutePath());
            JCGraphFactory.saveGraph(jCGraph, fileOutputStream, n2, true);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

