/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.AccessibleGaugeRole;
import com.klg.jclass.gauge.AccessibleGaugeState;
import com.klg.jclass.gauge.AccessibleValueState;
import com.klg.jclass.gauge.GaugeUtil;
import com.klg.jclass.gauge.JCAbstractNeedle;
import com.klg.jclass.gauge.JCAbstractScale;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCGaugeArea;
import com.klg.jclass.gauge.JCGaugePickEvent;
import com.klg.jclass.gauge.JCIndicatorStyle;
import com.klg.jclass.gauge.JCLinearNeedle;
import com.klg.jclass.gauge.JCLinearScale;
import com.klg.jclass.gauge.JCLinearTick;
import com.klg.jclass.gauge.JCNeedle;
import com.klg.jclass.gauge.LinearConstraint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;

public class JCLinearGauge
extends JCGauge {
    public JCLinearGauge() {
        JCLinearScale jCLinearScale = new JCLinearScale(this);
        this.setScale(jCLinearScale, false);
        JCLinearNeedle jCLinearNeedle = new JCLinearNeedle(jCLinearScale);
        this.addNeedle(jCLinearNeedle);
        JCLinearTick jCLinearTick = new JCLinearTick(jCLinearScale);
        this.addTick(jCLinearTick);
        this.gaugeArea.add(jCLinearScale);
        this.setPreferredSize(new Dimension(200, 100));
    }

    public JCLinearGauge(boolean bl) {
        if (bl) {
            JCLinearScale jCLinearScale = new JCLinearScale(this);
            this.setScale(jCLinearScale);
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.getBounds();
        rectangle.setLocation(0, 0);
        if (this.isOpaque()) {
            Serializable serializable;
            Color color = this.getBackground();
            if (color != null) {
                serializable = graphics2D.getColor();
                if (serializable != null && !graphics2D.getColor().equals(color)) {
                    graphics2D.setColor(color);
                }
                graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            }
            if (this.fillStyle != null) {
                serializable = this.getInsets();
                int n2 = Math.max(0, rectangle.width - ((Insets)serializable).left - ((Insets)serializable).right);
                int n3 = Math.max(0, rectangle.height - ((Insets)serializable).top - ((Insets)serializable).bottom);
                Rectangle rectangle2 = new Rectangle(((Insets)serializable).left, ((Insets)serializable).top, n2, n3);
                this.fillStyle.updateAnchorRect(rectangle2);
                this.fillStyle.fillRect((Graphics)graphics2D, ((Insets)serializable).left, ((Insets)serializable).top, n2, n3);
                this.fillStyle.updateAnchorRect(null);
            }
            this.drawImage(graphics2D, this.image, rectangle);
        }
    }

    public JCLinearScale getLinearScale() {
        return (JCLinearScale)this.getScale();
    }

    public void setScale(JCLinearScale jCLinearScale, boolean bl) {
        if (this.scale != null) {
            this.gaugeArea.remove((Component)((Object)this.scale));
        }
        this.scale = jCLinearScale;
        if (bl) {
            this.gaugeArea.add(jCLinearScale);
        }
        this.setIndicatorScales(jCLinearScale);
        this.setNeedleScales(jCLinearScale);
    }

    public void setScale(JCLinearScale jCLinearScale) {
        this.setScale(jCLinearScale, true);
    }

    public void addLabel(JComponent jComponent, LinearConstraint linearConstraint) {
        this.labels.addElement(jComponent);
        this.constraints.addElement(linearConstraint);
        this.getGaugeArea().add(jComponent, linearConstraint, 0);
    }

    public void addLabel(JComponent jComponent, LinearConstraint linearConstraint, int n2) {
        this.labels.addElement(jComponent);
        this.constraints.addElement(linearConstraint);
        this.getGaugeArea().add(jComponent, linearConstraint, n2);
    }

    public void removeLabel(JComponent jComponent) {
        if (this.labels.contains(jComponent)) {
            int n2 = this.labels.indexOf(jComponent);
            this.constraints.removeElementAt(n2);
            this.labels.removeElement(jComponent);
            this.getGaugeArea().remove(jComponent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        if (jCGaugePickEvent != null) {
            JCLinearNeedle jCLinearNeedle;
            this.sendPickEvent(jCGaugePickEvent);
            if (jCGaugePickEvent.getComponent() instanceof JCGaugeArea && (jCLinearNeedle = this.getClosestNeedle(jCGaugePickEvent, JCAbstractNeedle.InteractionType.CLICK)) != null) {
                jCLinearNeedle.setValue(jCGaugePickEvent.getValue());
                this.redraw();
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        if (jCGaugePickEvent != null) {
            this.sendPickEvent(jCGaugePickEvent);
            if (jCGaugePickEvent.getComponent() instanceof JCGaugeArea) {
                double d2;
                if (this.draggedNeedle == null) {
                    this.draggedNeedle = this.getClosestNeedle(jCGaugePickEvent, JCAbstractNeedle.InteractionType.DRAG);
                }
                if (this.draggedNeedle != null && (d2 = jCGaugePickEvent.getValue()) != this.draggedNeedle.getValue()) {
                    this.draggedNeedle.setValue(d2);
                    this.redraw();
                }
            }
        }
    }

    public JCLinearNeedle getClosestNeedle(JCGaugePickEvent jCGaugePickEvent, JCAbstractNeedle.InteractionType interactionType) {
        JCLinearNeedle jCLinearNeedle = null;
        double d2 = this.valueToPosition(jCGaugePickEvent.getValue());
        for (JCNeedle jCNeedle : this.needles) {
            JCLinearNeedle jCLinearNeedle2 = (JCLinearNeedle)jCNeedle;
            JCAbstractNeedle.InteractionType interactionType2 = jCLinearNeedle2.getInteractionType();
            if (interactionType2 != JCAbstractNeedle.InteractionType.CLICK_DRAG && interactionType2 != interactionType) continue;
            if (jCLinearNeedle == null) {
                jCLinearNeedle = jCLinearNeedle2;
                continue;
            }
            double d3 = this.valueToPosition(jCLinearNeedle2.getValue());
            double d4 = this.valueToPosition(jCLinearNeedle.getValue());
            double d5 = Math.abs(d2 - d3);
            double d6 = Math.abs(d2 - d4);
            if (!(d6 > d5)) continue;
            jCLinearNeedle = jCLinearNeedle2;
        }
        return jCLinearNeedle;
    }

    protected double valueToPosition(double d2) {
        JCLinearScale jCLinearScale = this.getLinearScale();
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        boolean bl = orientation == JCLinearScale.Orientation.VERTICAL;
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        boolean bl2 = direction.equals(JCAbstractScale.Direction.BACKWARD);
        Rectangle2D rectangle2D = jCLinearScale.getScaleSize();
        double d3 = bl ? rectangle2D.getY() : rectangle2D.getX();
        double d4 = bl ? rectangle2D.getY() + rectangle2D.getHeight() : rectangle2D.getX() + rectangle2D.getWidth();
        double d5 = jCLinearScale.isLogarithmic() ? GaugeUtil.valueToPositionLog(d2, jCLinearScale.getMin(), jCLinearScale.getMax(), d3, d4, bl, bl2) : GaugeUtil.valueToPositionDouble(d2, jCLinearScale.getMin(), jCLinearScale.getMax(), d3, d4);
        return d5;
    }

    public void redraw() {
        if (this.getRepaintEnabled()) {
            this.repaint();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleGauge();
        }
        return this.accessibleContext;
    }

    protected class AccessibleGauge
    extends JComponent.AccessibleJComponent {
        protected AccessibleGauge() {
            super(JCLinearGauge.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleGaugeRole.GAUGE;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            JCLinearScale jCLinearScale = JCLinearGauge.this.getLinearScale();
            if (jCLinearScale.getOrientation() == JCLinearScale.Orientation.VERTICAL) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            if (jCLinearScale.getDirection() == JCAbstractScale.Direction.FORWARD) {
                accessibleStateSet.add(AccessibleGaugeState.FORWARD);
            } else {
                accessibleStateSet.add(AccessibleGaugeState.BACKWARD);
            }
            for (int i2 = 0; i2 < JCLinearGauge.this.getNeedles().size(); ++i2) {
                JCLinearNeedle jCLinearNeedle = (JCLinearNeedle)JCLinearGauge.this.getNeedles().get(i2);
                JCAbstractNeedle.InteractionType interactionType = jCLinearNeedle.getInteractionType();
                if (interactionType == JCAbstractNeedle.InteractionType.NONE) {
                    accessibleStateSet.add(AccessibleGaugeState.INTERACTION_NONE);
                } else if (interactionType == JCAbstractNeedle.InteractionType.DRAG) {
                    accessibleStateSet.add(AccessibleGaugeState.INTERACTION_DRAG);
                } else if (interactionType == JCAbstractNeedle.InteractionType.CLICK) {
                    accessibleStateSet.add(AccessibleGaugeState.INTERACTION_CLICK);
                } else if (interactionType == JCAbstractNeedle.InteractionType.CLICK_DRAG) {
                    accessibleStateSet.add(AccessibleGaugeState.INTERACTION_CLICK_DRAG);
                }
                accessibleStateSet.add(new AccessibleValueState("value = ", jCLinearNeedle.getValue()));
                JCIndicatorStyle jCIndicatorStyle = jCLinearNeedle.getIndicatorStyle();
                if (jCIndicatorStyle == JCIndicatorStyle.RECTANGLE) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_RECTANGLE);
                    continue;
                }
                if (jCIndicatorStyle == JCIndicatorStyle.CIRCLE) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_CIRCLE);
                    continue;
                }
                if (jCIndicatorStyle == JCIndicatorStyle.POINTER) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_POINTER);
                    continue;
                }
                if (jCIndicatorStyle == JCIndicatorStyle.TAILED_POINTER) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_TAILED_POINTER);
                    continue;
                }
                if (jCIndicatorStyle == JCIndicatorStyle.ARROW) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_ARROW);
                    continue;
                }
                if (jCIndicatorStyle == JCIndicatorStyle.TAILED_ARROW) {
                    accessibleStateSet.add(AccessibleGaugeState.NEEDLE_TAILED_ARROW);
                    continue;
                }
                if (jCIndicatorStyle != JCIndicatorStyle.TRIANGLE) continue;
                accessibleStateSet.add(AccessibleGaugeState.NEEDLE_TRIANGLE);
            }
            return accessibleStateSet;
        }
    }
}

