/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.GaugeUtil;
import com.klg.jclass.gauge.JCAbstractRange;
import com.klg.jclass.gauge.JCAbstractScale;
import com.klg.jclass.gauge.JCCircularGauge;
import com.klg.jclass.gauge.JCCircularScale;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.label.JCLabel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class JCCircularRange
extends JCAbstractRange
implements Serializable {
    static final long serialVersionUID = -3498488049576531605L;

    public JCCircularRange(JCCircularScale jCCircularScale) {
        super(jCCircularScale);
    }

    public JCCircularRange(Color color, JCCircularScale jCCircularScale, double d2, double d3, double d4, double d5) {
        super(color, jCCircularScale, d2, d3, d4, d5);
    }

    public void setForeground(Color color) {
        this.setBackground(color);
    }

    public Color getForeground() {
        return this.getBackground();
    }

    public JCCircularScale getCircularScale() {
        return (JCCircularScale)this.getScale();
    }

    public Dimension getPreferredSize() {
        return this.getCircularScale().getPreferredSize();
    }

    public void paintComponent(Graphics graphics) {
        double d2;
        boolean bl;
        JCCircularScale jCCircularScale = this.getCircularScale();
        double d3 = jCCircularScale.getMin();
        double d4 = jCCircularScale.getMax();
        double d5 = jCCircularScale.getRadius();
        double d6 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d7 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d8 = GaugeUtil.clamp(this.startValue, d3, d4);
        double d9 = GaugeUtil.clamp(this.stopValue, d3, d4);
        Color color = this.getBackground();
        boolean bl2 = bl = this.image != null && this.image.getImage() != null;
        if (!this.isVisible() || d3 >= d4 || this.innerExtent >= this.outerExtent || d8 >= d9 || color == null && !bl) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
        if (renderProperties != null) {
            object = GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
        }
        if (jCCircularScale.getDirection().equals(JCAbstractScale.Direction.BACKWARD)) {
            d2 = d8;
            d8 = d9;
            d9 = d2;
            d9 = d4 - d9 + d3;
            d8 = d4 - d8 + d3;
        }
        d2 = GaugeUtil.valueToAngle(d8, d3, d4, d6, d7);
        double d10 = GaugeUtil.valueToAngle(d9, d3, d4, d6, d7);
        JCCircularGauge jCCircularGauge = jCCircularScale.getCircularGauge();
        Rectangle2D.Double double_ = jCCircularGauge.getArcBounds();
        double d11 = this.innerExtent * d5;
        double d12 = this.outerExtent * d5;
        if (d2 >= d10) {
            d10 += 360.0;
        }
        double d13 = double_.x + d5;
        double d14 = double_.y + d5;
        double d15 = d13 - d12;
        double d16 = d14 - d12;
        double d17 = 2.0 * d12;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d15, d16, d17, d17);
        Rectangle2D.Double double_3 = jCCircularGauge.getArcDrawingBounds(double_2);
        double d18 = d12 - d11;
        graphics2D.setStroke(new BasicStroke((float)d18, 0, 0));
        double d19 = d15 + d18 / 2.0;
        double d20 = d16 + d18 / 2.0;
        double d21 = d17 - d18;
        Arc2D.Double double_4 = new Arc2D.Double(d19, d20, d21, d21, d2, d10 - d2, 0);
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.draw(double_4);
        }
        if (this.fillStyle != null) {
            Color color2 = this.fillStyle.getBackground();
            if (this.fillStyle.getPattern() == 11 && color2 != null) {
                graphics2D.setColor(color2);
                graphics2D.draw(double_4);
            }
            this.fillStyle.updateAnchorRect(double_3);
            this.fillStyle.updateGraphics(graphics2D);
            graphics2D.draw(double_4);
            this.fillStyle.updateAnchorRect(null);
        }
        if (bl) {
            GaugeUtil.drawImage(graphics2D, this.image, double_3, double_4, false);
        }
        if (renderProperties != null && object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public void redraw() {
        JCGauge jCGauge = this.getCircularScale().getGauge();
        if (jCGauge != null && jCGauge.getRepaintEnabled()) {
            jCGauge.repaint();
        }
    }

    protected void drawImage(Graphics graphics, PortableImage portableImage, Rectangle rectangle) {
        if (portableImage == null || portableImage.getImage() == null) {
            return;
        }
        JCLabel jCLabel = new JCLabel();
        Image image = portableImage.getImage();
        if (portableImage.isImageScaled()) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, jCLabel);
        } else {
            int n2 = image.getWidth(jCLabel);
            int n3 = image.getHeight(jCLabel);
            if (n2 > 0 && n3 > 0) {
                int n4 = rectangle.x - (n2 - rectangle.width) / 2;
                int n5 = rectangle.y - (n3 - rectangle.height) / 2;
                graphics.drawImage(image, n4, n5, n2, n3, jCLabel);
            }
        }
    }
}

