/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.GaugeUtil;
import com.klg.jclass.gauge.JCCircularGauge;
import com.klg.jclass.gauge.JCCircularScale;
import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.graphics.JCFont;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.style.JCFillStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class JCCenter
extends JComponent
implements Serializable {
    static final long serialVersionUID = -1082954384206749087L;
    protected JCCircularScale scale;
    protected PortableImage image;
    protected double radius = 0.1;
    protected ImageMapInfo imageMapInfo = null;
    protected JCFillStyle fillStyle = null;

    public JCCenter(JCCircularScale jCCircularScale) {
        this.scale = jCCircularScale;
        this.setOpaque(true);
        this.setBackground(Color.black);
    }

    public JCCenter(JCCircularScale jCCircularScale, Color color, double d2) {
        this.scale = jCCircularScale;
        this.radius = d2;
        this.setOpaque(true);
        this.setBackground(color);
    }

    public JCCenter(JCCircularScale jCCircularScale, Color color, Image image) {
        this.scale = jCCircularScale;
        if (image != null) {
            JCFillStyle jCFillStyle = new JCFillStyle(color, 11);
            jCFillStyle.setImage(image);
            jCFillStyle.setImageLayoutHint(0);
            jCFillStyle.setFillOrientation(5);
            this.fillStyle = jCFillStyle;
        }
        this.setOpaque(true);
        this.setBackground(color);
    }

    public void setForeground(Color color) {
        this.setBackground(color);
    }

    public Color getForeground() {
        return this.getBackground();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
    }

    public void paintComponent(Graphics graphics) {
        double d2;
        Serializable serializable;
        if (!this.isVisible() || this.scale == null || this.scale.getMin() >= this.scale.getMax() || this.radius <= 0.0 && this.image == null) {
            return;
        }
        boolean bl = this.image != null && this.image.getImage() != null;
        Color color = this.getBackground();
        if (color == null && !bl && this.fillStyle == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
        if (renderProperties != null) {
            GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
        }
        double d3 = GaugeUtil.normalizeAngle(this.scale.getStartAngle());
        double d4 = GaugeUtil.normalizeAngle(this.scale.getStopAngle());
        if (this.scale.getPaintCompleteBackground()) {
            serializable = (JCCircularGauge)this.scale.getGauge();
            d3 = serializable.getGaugeType().getStartAngle();
            d2 = serializable.getGaugeType().getSweepAngle();
        } else {
            if (d3 >= d4) {
                d4 += 360.0;
            }
            d2 = GaugeUtil.arcAngle(d3, d4);
        }
        serializable = this.getBounds();
        double d5 = ((Rectangle)serializable).width;
        double d6 = ((Rectangle)serializable).height;
        Arc2D.Double double_ = new Arc2D.Double(0.0, 0.0, d5, d6, d3, d2, 2);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, d5, d6);
        if (this.fillStyle != null) {
            this.fillStyle.updateAnchorRect(double_2);
            this.fillStyle.fillArc((Graphics)graphics2D, 0.0, 0.0, d5, d6, d3, d2);
            this.fillStyle.updateAnchorRect(null);
        } else if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(double_);
        }
        if (bl) {
            GaugeUtil.drawImage(graphics2D, this.image, double_2, double_, true);
        }
        graphics2D.dispose();
    }

    public Dimension getPreferredSize() {
        int n2 = (int)(this.scale.getRadius() * this.radius) * 2;
        return new Dimension(n2, n2);
    }

    public JCCircularScale getScale() {
        return this.scale;
    }

    public void setRadius(double d2) {
        if (d2 <= 0.0) {
            d2 = 0.0;
        }
        this.radius = d2;
        this.revalidate();
        this.redraw();
    }

    public double getRadius() {
        return this.radius;
    }

    public PortableImage getPortableImage() {
        return this.image;
    }

    public void setPortableImage(PortableImage portableImage) {
        this.image = portableImage;
        this.redraw();
    }

    public Image getImage() {
        if (this.image == null) {
            return null;
        }
        return this.image.getImage();
    }

    public void setImage(Image image) {
        if (this.image == null) {
            this.image = new PortableImage(image);
        } else {
            this.image.setImage(image);
        }
        this.redraw();
    }

    public void setImage(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && (imageIcon = new ImageIcon(uRL)).getImageLoadStatus() == 8) {
            this.setImage(imageIcon.getImage());
        }
    }

    public boolean isImageScaled() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.isImageScaled();
    }

    public void setImageScaled(boolean bl) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setImageScaled(bl);
        this.redraw();
    }

    public OutputProperties getImageOutputProperties() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.getOutputProperties();
    }

    public void setImageOutputProperties(OutputProperties outputProperties) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setOutputProperties(outputProperties);
    }

    public boolean getScaleImage() {
        return this.isImageScaled();
    }

    public void setScaleImage(boolean bl) {
        this.setImageScaled(bl);
    }

    public void redraw() {
        JCGauge jCGauge = this.scale.getGauge();
        if (jCGauge.getRepaintEnabled()) {
            jCGauge.repaint();
        }
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        this.fillStyle = jCFillStyle;
    }

    public FontMetrics getFontMetrics(Font font) {
        JCFont jCFont;
        JCFontMetrics jCFontMetrics;
        if (font instanceof JCFont && (jCFontMetrics = (jCFont = (JCFont)((Object)font)).getJCFontMetrics()) != null) {
            return jCFontMetrics.getEncoderFontMetrics();
        }
        return super.getFontMetrics(font);
    }
}

