/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCRange;
import com.klg.jclass.gauge.JCScale;
import com.klg.jclass.gauge.JCTick;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.graphics.JCFont;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.label.JCLabel;
import com.klg.jclass.util.style.JCFillStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCAbstractScale
extends JComponent
implements JCScale {
    static final long serialVersionUID = -1015210021570456430L;
    protected JCGauge gauge;
    protected Direction direction = Direction.FORWARD;
    protected double min = 0.0;
    protected double max = 100.0;
    protected double zoomFactor = 1.0;
    protected Vector<JCTick> ticks = new Vector();
    protected Vector<JCRange> ranges = new Vector();
    protected PortableImage image = null;
    protected ImageMapInfo imageMapInfo = null;
    protected JCFillStyle fillStyle = null;

    public JCAbstractScale(JCGauge jCGauge) {
        this.setLayout(new GridLayout(1, 1));
        this.setOpaque(true);
        this.gauge = jCGauge;
    }

    public JCAbstractScale(JCGauge jCGauge, double d2, double d3) {
        this.setLayout(new GridLayout(1, 1));
        this.setOpaque(true);
        this.gauge = jCGauge;
        this.min = d2;
        this.max = d3;
    }

    public JCAbstractScale(JCGauge jCGauge, Direction direction, double d2, double d3, Color color) {
        this.gauge = jCGauge;
        this.setLayout(new GridLayout(1, 1));
        this.setOpaque(true);
        this.setBackground(color);
        this.direction = direction;
        this.min = d2;
        this.max = d3;
    }

    @Override
    public JCGauge getGauge() {
        return this.gauge;
    }

    @Override
    public void setForeground(Color color) {
        this.setBackground(color);
    }

    @Override
    public Color getForeground() {
        return this.getBackground();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.redraw();
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(Direction direction) {
        if (direction != null) {
            this.direction = direction;
        }
        this.redraw();
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public void setMax(double d2) {
        this.max = d2;
        this.redraw();
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public void setMin(double d2) {
        this.min = d2;
        this.redraw();
    }

    @Override
    public double getExtent() {
        return this.getZoomFactor();
    }

    @Override
    public void setExtent(double d2) {
        this.setZoomFactor(d2);
    }

    @Override
    public double getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public void setZoomFactor(double d2) {
        if (d2 > 1.0) {
            d2 = 1.0;
        } else if (d2 < 0.0) {
            d2 = 0.0;
        }
        this.zoomFactor = d2;
        this.redraw();
    }

    @Override
    public Vector<JCTick> getTicks() {
        return this.ticks;
    }

    @Override
    public void addTick(JCTick jCTick) {
        this.addTick(jCTick, 0);
    }

    @Override
    public void addTick(JCTick jCTick, int n2) {
        this.ticks.addElement(jCTick);
        this.add((Component)((Object)jCTick), n2);
    }

    @Override
    public void removeTick(JCTick jCTick) {
        if (this.ticks.contains(jCTick)) {
            this.ticks.removeElement(jCTick);
            this.remove((Component)((Object)jCTick));
        }
    }

    @Override
    public Vector<JCRange> getRanges() {
        return this.ranges;
    }

    @Override
    public void addRange(JCRange jCRange) {
        this.addRange(jCRange, -1);
    }

    @Override
    public void addRange(JCRange jCRange, int n2) {
        this.ranges.addElement(jCRange);
        this.add((Component)((Object)jCRange), n2);
    }

    @Override
    public void removeRange(JCRange jCRange) {
        if (this.ranges.contains(jCRange)) {
            this.ranges.removeElement(jCRange);
            this.remove((Component)((Object)jCRange));
        }
    }

    @Override
    public boolean inBounds(double d2) {
        return d2 >= this.getMin() && d2 <= this.getMax();
    }

    public PortableImage getPortableImage() {
        return this.image;
    }

    public void setPortableImage(PortableImage portableImage) {
        this.image = portableImage;
        this.redraw();
    }

    public Image getImage() {
        if (this.image == null) {
            return null;
        }
        return this.image.getImage();
    }

    public void setImage(Image image) {
        if (this.image == null) {
            this.image = new PortableImage(image);
        } else {
            this.image.setImage(image);
        }
        this.redraw();
    }

    public void setImage(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && (imageIcon = new ImageIcon(uRL)).getImageLoadStatus() == 8) {
            this.setImage(imageIcon.getImage());
        }
    }

    public boolean isImageScaled() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.isImageScaled();
    }

    public void setImageScaled(boolean bl) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setImageScaled(bl);
        this.redraw();
    }

    public OutputProperties getImageOutputProperties() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.getOutputProperties();
    }

    public void setImageOutputProperties(OutputProperties outputProperties) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setOutputProperties(outputProperties);
    }

    protected void drawImage(Graphics graphics, PortableImage portableImage, Rectangle2D rectangle2D) {
        if (portableImage == null || portableImage.getImage() == null) {
            return;
        }
        JCLabel jCLabel = new JCLabel();
        Image image = portableImage.getImage();
        if (portableImage.isImageScaled()) {
            graphics.drawImage(image, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), jCLabel);
        } else {
            int n2 = image.getWidth(jCLabel);
            int n3 = image.getHeight(jCLabel);
            if (n2 > 0 && n3 > 0) {
                double d2 = rectangle2D.getX() - ((double)n2 - rectangle2D.getWidth()) / 2.0;
                double d3 = rectangle2D.getY() - ((double)n3 - rectangle2D.getHeight()) / 2.0;
                graphics.drawImage(image, (int)d2, (int)d3, n2, n3, jCLabel);
            }
        }
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        if (this.gauge != null && !this.gauge.inServerPaint) {
            super.paintChildren(graphics);
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        JCFont jCFont;
        JCFontMetrics jCFontMetrics;
        if (font instanceof JCFont && (jCFontMetrics = (jCFont = (JCFont)((Object)font)).getJCFontMetrics()) != null) {
            return jCFontMetrics.getEncoderFontMetrics();
        }
        return super.getFontMetrics(font);
    }

    public void redraw() {
    }

    @Override
    public abstract double pick(Point var1);

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        this.fillStyle = jCFillStyle;
    }

    public static class Direction
    implements Serializable {
        public static final Direction BACKWARD = new Direction("backward");
        public static final Direction CLOCKWISE = new Direction("clockwise");
        public static final Direction FORWARD = new Direction("forward");
        public static final Direction COUNTERCLOCKWISE = new Direction("counterclockwise");
        String string;

        private Direction(String string) {
            this.string = string;
        }

        public boolean equals(Direction direction) {
            boolean bl = direction.string.equals(this.string);
            if (!bl) {
                if (direction.string.equals(Direction.BACKWARD.string) && this.string.equals(Direction.CLOCKWISE.string)) {
                    bl = true;
                } else if (direction.string.equals(Direction.CLOCKWISE.string) && this.string.equals(Direction.BACKWARD.string)) {
                    bl = true;
                } else if (direction.string.equals(Direction.FORWARD.string) && this.string.equals(Direction.COUNTERCLOCKWISE.string)) {
                    bl = true;
                } else if (direction.string.equals(Direction.COUNTERCLOCKWISE.string) && this.string.equals(Direction.FORWARD.string)) {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

