/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.gauge;

import com.klg.jclass.gauge.JCGauge;
import com.klg.jclass.gauge.JCGaugeLegendEntry;
import com.klg.jclass.gauge.JCRange;
import com.klg.jclass.gauge.JCScale;
import com.klg.jclass.gauge.resources.LocaleBundle;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.graphics.JCFont;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.io.PortableImage;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.style.JCFillStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class JCAbstractRange
extends JComponent
implements JCRange,
JCGaugeLegendEntry,
Serializable {
    protected JCScale scale;
    protected double innerExtent = 0.0;
    protected double outerExtent = 1.0;
    protected double startValue = 0.0;
    protected double stopValue = 0.0;
    protected String rangeName = null;
    protected boolean visibleInLegend = true;
    protected static int rangeCounter = 0;
    protected PortableImage image = null;
    protected ImageMapInfo imageMapInfo = null;
    protected JCFillStyle fillStyle = null;

    public JCAbstractRange(JCScale jCScale) {
        if (jCScale == null) {
            String string = LocaleBundle.string("Range must have non-null scale");
            throw new IllegalArgumentException(string);
        }
        this.scale = jCScale;
        this.rangeName = "Range " + rangeCounter++;
        this.startValue = jCScale.getMin();
        this.stopValue = jCScale.getMax();
    }

    public JCAbstractRange(Color color, JCScale jCScale, double d2, double d3, double d4, double d5) {
        this(jCScale);
        this.setBackground(color);
        this.innerExtent = d2;
        this.outerExtent = d3;
        this.startValue = d4;
        this.stopValue = d5;
    }

    public JCScale getScale() {
        return this.scale;
    }

    public double getInnerExtent() {
        return this.innerExtent;
    }

    public void setInnerExtent(double d2) {
        if (this.innerExtent == d2) {
            return;
        }
        this.innerExtent = d2;
        this.redraw();
    }

    public double getOuterExtent() {
        return this.outerExtent;
    }

    public void setOuterExtent(double d2) {
        if (this.outerExtent == d2) {
            return;
        }
        this.outerExtent = d2;
        this.redraw();
    }

    public double getStartValue() {
        return this.startValue;
    }

    public void setStartValue(double d2) {
        if (this.startValue == d2) {
            return;
        }
        this.startValue = d2;
        this.redraw();
    }

    public double getStopValue() {
        return this.stopValue;
    }

    public void setStopValue(double d2) {
        if (this.stopValue == d2) {
            return;
        }
        this.stopValue = d2;
        this.redraw();
    }

    public String getRangeName() {
        return this.rangeName;
    }

    public void setRangeName(String string) {
        if (this.rangeName != null && this.rangeName.equals(string)) {
            return;
        }
        this.rangeName = string;
        JCGauge jCGauge = this.scale.getGauge();
        if (jCGauge != null) {
            JCLegend jCLegend = jCGauge.getLegend();
            jCLegend.invalidate();
        }
        this.redraw();
    }

    public String getLegendLabel() {
        return this.getRangeName();
    }

    public Color getLegendColor() {
        Color color = this.getBackground();
        return color == null ? Color.black : color;
    }

    public JCFillStyle getLegendFillStyle() {
        return this.fillStyle;
    }

    public boolean isVisibleInLegend() {
        return this.visibleInLegend;
    }

    public void setVisibleInLegend(boolean bl) {
        if (this.visibleInLegend == bl) {
            return;
        }
        this.visibleInLegend = bl;
        JCGauge jCGauge = this.scale.getGauge();
        if (jCGauge != null) {
            JCLegend jCLegend = jCGauge.getLegend();
            jCLegend.invalidate();
        }
        this.redraw();
    }

    public PortableImage getPortableImage() {
        return this.image;
    }

    public void setPortableImage(PortableImage portableImage) {
        this.image = portableImage;
        this.redraw();
    }

    public Image getImage() {
        if (this.image == null) {
            return null;
        }
        return this.image.getImage();
    }

    public void setImage(Image image) {
        if (this.image == null) {
            this.image = new PortableImage(image);
        } else {
            this.image.setImage(image);
        }
        this.redraw();
    }

    public void setImage(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && (imageIcon = new ImageIcon(uRL)).getImageLoadStatus() == 8) {
            this.setImage(imageIcon.getImage());
        }
    }

    public boolean isImageScaled() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.isImageScaled();
    }

    public void setImageScaled(boolean bl) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setImageScaled(bl);
        this.redraw();
    }

    public OutputProperties getImageOutputProperties() {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        return this.image.getOutputProperties();
    }

    public void setImageOutputProperties(OutputProperties outputProperties) {
        if (this.image == null) {
            this.image = new PortableImage();
        }
        this.image.setOutputProperties(outputProperties);
    }

    public void redraw() {
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        this.fillStyle = jCFillStyle;
    }

    public FontMetrics getFontMetrics(Font font) {
        JCFont jCFont;
        JCFontMetrics jCFontMetrics;
        if (font instanceof JCFont && (jCFontMetrics = (jCFont = (JCFont)((Object)font)).getJCFontMetrics()) != null) {
            return jCFontMetrics.getEncoderFontMetrics();
        }
        return super.getFontMetrics(font);
    }
}

