/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.plaf;

import com.klg.jclass.field.JCPopupField;
import com.klg.jclass.field.validate.PopupFieldEditor;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.swing.JCPopupEvent;
import com.klg.jclass.util.swing.JCPopupListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

public class FieldPopup
extends BasicComboPopup
implements Serializable {
    protected PopupFieldEditor popup = null;
    protected JCPopupField pf;
    protected PopupListener popupListener = null;

    public FieldPopup(JComboBox jComboBox, PopupFieldEditor popupFieldEditor) {
        super(jComboBox);
        this.pf = (JCPopupField)jComboBox;
        this.setPopupFieldEditor(popupFieldEditor);
    }

    public void setPopupFieldEditor(PopupFieldEditor popupFieldEditor) {
        if (popupFieldEditor == null) {
            return;
        }
        if (this.popup != null) {
            this.remove(this.popup.getEditorComponent());
        }
        this.add(popupFieldEditor.getEditorComponent());
        this.popup = popupFieldEditor;
        this.popup.removePopupListener(this.popupListener);
        this.popupListener = new PopupListener();
        this.popup.addPopupListener(this.popupListener);
        JComponent jComponent = this.popup.getEditorComponent();
        this.setRequestFocusEnabledOnTree(jComponent, false);
    }

    protected void setRequestFocusEnabledOnTree(Component component, boolean bl) {
        if (component == null) {
            return;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setRequestFocusEnabled(bl);
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                this.setRequestFocusEnabledOnTree(componentArray[i2], bl);
            }
        }
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setRequestFocusEnabled(false);
    }

    public void show() {
        if (this.popup == null || this.popup.getEditorComponent() == null) {
            return;
        }
        Object object = this.pf.getValue();
        if (object != null) {
            this.popup.setValue(object);
        }
        Dimension dimension = this.comboBox.getSize();
        dimension.setSize(dimension.width, 200);
        JComponent jComponent = this.popup.getEditorComponent();
        jComponent.setSize(jComponent.getPreferredSize());
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, jComponent.getWidth(), jComponent.getHeight());
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.show(this.comboBox, rectangle.x, rectangle.y);
    }

    protected Rectangle computePopupBounds(int n2, int n3, int n4, int n5) {
        Cloneable cloneable;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point point = new Point();
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        GraphicsConfiguration graphicsConfiguration = this.comboBox.getGraphicsConfiguration();
        Rectangle rectangle = GraphicsUtil.getScreenBounds(this.comboBox);
        if (graphicsConfiguration != null) {
            cloneable = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle.width -= cloneable.left + cloneable.right;
            rectangle.height -= cloneable.top + cloneable.bottom;
            rectangle.x += point.x + cloneable.left;
            rectangle.y += point.y + cloneable.top;
        } else {
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        cloneable = new Rectangle(n2, n3, n4, n5);
        if (this.isRectangleContainingRectangle(rectangle, (Rectangle)cloneable)) {
            return cloneable;
        }
        Insets insets = this.getInsets();
        if (!this.isRectangleContainingRectangleFitRight(rectangle, (Rectangle)cloneable)) {
            ((Rectangle)cloneable).x += rectangle.x + rectangle.width - (((Rectangle)cloneable).width + insets.left + insets.right);
        }
        if (!this.isRectangleContainingRectangleFitLeft(rectangle, (Rectangle)cloneable)) {
            ((Rectangle)cloneable).x = rectangle.x;
        }
        if (!this.isRectangleContainingRectangleFitDown(rectangle, (Rectangle)cloneable)) {
            ((Rectangle)cloneable).y = -(((Rectangle)cloneable).height + insets.top + insets.bottom);
        }
        return cloneable;
    }

    public final boolean isRectangleContainingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public final boolean isRectangleContainingRectangleFitLeft(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.x < 0;
    }

    public final boolean isRectangleContainingRectangleFitRight(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x + rectangle2.width < rectangle.x + rectangle.width;
    }

    public final boolean isRectangleContainingRectangleFitDown(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public void hide() {
        super.hide();
    }

    class PopupListener
    implements JCPopupListener,
    Serializable {
        PopupListener() {
        }

        public void commit(JCPopupEvent jCPopupEvent) {
            FieldPopup.this.hide();
        }
    }
}

