/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.beans;

import com.klg.jclass.field.DataPropertiesRegistry;
import com.klg.jclass.field.JCPopupField;
import com.klg.jclass.field.beans.AbstractValidatorEditor;
import com.klg.jclass.field.beans.BigDecimalValidatorEditor;
import com.klg.jclass.field.beans.ByteValidatorEditor;
import com.klg.jclass.field.beans.DataPropertiesEditor;
import com.klg.jclass.field.beans.DateTimeValidatorEditor;
import com.klg.jclass.field.beans.DateValidatorEditor;
import com.klg.jclass.field.beans.DoubleValidatorEditor;
import com.klg.jclass.field.beans.FloatValidatorEditor;
import com.klg.jclass.field.beans.IPAddressValidatorEditor;
import com.klg.jclass.field.beans.IntegerValidatorEditor;
import com.klg.jclass.field.beans.LongValidatorEditor;
import com.klg.jclass.field.beans.ShortValidatorEditor;
import com.klg.jclass.field.beans.StringValidatorEditor;
import com.klg.jclass.field.beans.TabValuePage;
import com.klg.jclass.field.beans.TimeValidatorEditor;
import com.klg.jclass.field.validate.AbstractValidator;
import com.klg.jclass.field.validate.JCBigDecimalValidator;
import com.klg.jclass.field.validate.JCByteValidator;
import com.klg.jclass.field.validate.JCDateTimeValidator;
import com.klg.jclass.field.validate.JCDateValidator;
import com.klg.jclass.field.validate.JCDoubleValidator;
import com.klg.jclass.field.validate.JCFloatValidator;
import com.klg.jclass.field.validate.JCIPAddressValidator;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.field.validate.JCLongValidator;
import com.klg.jclass.field.validate.JCShortValidator;
import com.klg.jclass.field.validate.JCStringValidator;
import com.klg.jclass.field.validate.JCTimeValidator;
import com.klg.jclass.util.JCIPAddress;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TabTypePage
extends JPanel
implements ListSelectionListener,
ChangeListener {
    protected static String BYTE_VALIDATOR = "byte";
    protected static String DOUBLE_VALIDATOR = "double";
    protected static String FLOAT_VALIDATOR = "float";
    protected static String INTEGER_VALIDATOR = "integer";
    protected static String LONG_VALIDATOR = "long";
    protected static String SHORT_VALIDATOR = "short";
    protected static String STRING_VALIDATOR = "string";
    protected static String BIGDECIMAL_VALIDATOR = "bigdecimal";
    protected static String IPADDRESS_VALIDATOR = "ipaddress";
    protected static String DATETIME_VALIDATOR = "datetime";
    protected static String DATE_VALIDATOR = "date";
    protected static String TIME_VALIDATOR = "time";
    protected static String[][] list_vals = new String[][]{{"com.klg.jclass.util.JCIPAddress", IPADDRESS_VALIDATOR}, {"java.lang.Byte", BYTE_VALIDATOR}, {"java.lang.Double", DOUBLE_VALIDATOR}, {"java.lang.Float", FLOAT_VALIDATOR}, {"java.lang.Integer", INTEGER_VALIDATOR}, {"java.lang.Long", LONG_VALIDATOR}, {"java.lang.Short", SHORT_VALIDATOR}, {"java.lang.String", STRING_VALIDATOR}, {"java.math.BigDecimal", BIGDECIMAL_VALIDATOR}, {"java.util.Calendar", DATETIME_VALIDATOR}, {"java.util.Date", DATETIME_VALIDATOR}, {"java.sql.Date", DATE_VALIDATOR}, {"java.sql.Time", TIME_VALIDATOR}, {"java.sql.Timestamp", DATETIME_VALIDATOR}};
    protected JList type_list;
    protected JTabbedPane tabPane;
    protected AbstractValidatorEditor validatorPage = null;
    protected JCValueModel valueModel = null;
    protected DataPropertiesRegistry registry;
    protected DataPropertiesEditor de;
    protected TabValuePage tabValuePage;
    protected String validator_text = null;

    public TabTypePage(DataPropertiesEditor dataPropertiesEditor) {
        this.de = dataPropertiesEditor;
        this.setLayout(new BorderLayout());
        String[] stringArray = new String[list_vals.length];
        for (int i2 = 0; i2 < list_vals.length; ++i2) {
            stringArray[i2] = list_vals[i2][0];
        }
        this.type_list = new JList<String>(stringArray);
        this.type_list.setBorder(new LineBorder(Color.black));
        this.type_list.addListSelectionListener(this);
        this.type_list.setVisibleRowCount(15);
        this.add("West", this.type_list);
        this.tabPane = new JTabbedPane();
        this.add("Center", this.tabPane);
        this.tabPane.addChangeListener(this);
        this.createTabPages();
        this.registry = new DataPropertiesRegistry();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.tabPane.getSelectedComponent() == this.tabValuePage) {
            this.de.setHelpText("TypeHelp");
        } else if (this.validator_text != null) {
            this.de.setHelpText(this.validator_text);
        }
        this.tabPane.validate();
    }

    public void setProperties(JCValueModel jCValueModel) {
        this.valueModel = jCValueModel;
        if (jCValueModel != null) {
            int n2 = jCValueModel.getClass().getName().indexOf("db");
            if (n2 > 0) {
                this.type_list.setEnabled(false);
                this.tabPane.setEnabledAt(this.tabPane.indexOfTab("Value"), false);
                this.tabPane.setSelectedIndex(this.tabPane.indexOfTab("Validator"));
            } else {
                this.type_list.setEnabled(true);
                this.tabPane.setEnabledAt(this.tabPane.indexOfTab("Value"), true);
            }
        }
        if (this.tabValuePage != null) {
            this.tabValuePage.setProperties(jCValueModel);
        }
    }

    protected void createTabPages() {
        this.tabPane.addTab("Value", new JPanel());
        this.tabPane.addTab("Validator", new JPanel());
        this.tabPane.setEnabledAt(this.tabPane.indexOfTab("Value"), false);
        this.tabPane.setEnabledAt(this.tabPane.indexOfTab("Validator"), false);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n2 = this.type_list.getSelectedIndex();
        this.de.commitButton.setEnabled(true);
        if (n2 < 0 || n2 > list_vals.length) {
            return;
        }
        if (this.valueModel == null || this.valueModel.getValueClass() == null || !this.valueModel.getValueClass().getName().equals(list_vals[n2][0])) {
            this.valueModel = this.getValueModel(list_vals[n2][0]);
        }
        this.createValidatorPage(list_vals[n2][1]);
        this.tabPane.setEnabledAt(this.tabPane.indexOfTab("Value"), true);
        this.tabPane.setEnabledAt(this.tabPane.indexOfTab("Validator"), true);
        if (n2 >= 9) {
            this.tabValuePage = new TabValuePage(true);
            this.tabPane.setComponentAt(this.tabPane.indexOfTab("Value"), this.tabValuePage);
        } else {
            this.tabValuePage = new TabValuePage(false);
            this.tabPane.setComponentAt(this.tabPane.indexOfTab("Value"), this.tabValuePage);
        }
        this.tabValuePage.type = list_vals[n2][0];
        if (this.tabPane.getSelectedIndex() == 1) {
            this.de.setHelpText(this.validator_text);
        }
    }

    public JCValueModel getValueModel(String string) {
        JCValueModel jCValueModel = null;
        if (this.valueModel != null && this.valueModel.getClass().getName().indexOf("db") > 0) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Cannot find class \"" + string + "\"");
        }
        if (clazz != null && DataPropertiesRegistry.isRegistered(clazz)) {
            jCValueModel = DataPropertiesRegistry.createValueModel(clazz);
        }
        return jCValueModel;
    }

    protected void createValidatorPage(String string) {
        AbstractValidatorEditor abstractValidatorEditor = null;
        AbstractValidator abstractValidator = null;
        if (string.equals(BYTE_VALIDATOR)) {
            abstractValidatorEditor = new ByteValidatorEditor();
            abstractValidator = new JCByteValidator();
            this.validator_text = "ByteValidatorHelp";
        } else if (string.equals(INTEGER_VALIDATOR)) {
            abstractValidatorEditor = new IntegerValidatorEditor();
            abstractValidator = new JCIntegerValidator();
            this.validator_text = "IntegerValidatorHelp";
        } else if (string.equals(SHORT_VALIDATOR)) {
            abstractValidatorEditor = new ShortValidatorEditor();
            abstractValidator = new JCShortValidator();
            this.validator_text = "ShortValidatorHelp";
        } else if (string.equals(LONG_VALIDATOR)) {
            abstractValidatorEditor = new LongValidatorEditor();
            abstractValidator = new JCLongValidator();
            this.validator_text = "LongValidatorHelp";
        } else if (string.equals(DOUBLE_VALIDATOR)) {
            abstractValidatorEditor = new DoubleValidatorEditor();
            abstractValidator = new JCDoubleValidator();
            this.validator_text = "DoubleValidatorHelp";
        } else if (string.equals(FLOAT_VALIDATOR)) {
            abstractValidatorEditor = new FloatValidatorEditor();
            abstractValidator = new JCFloatValidator();
            this.validator_text = "FloatValidatorHelp";
        } else if (string.equals(BIGDECIMAL_VALIDATOR)) {
            abstractValidatorEditor = new BigDecimalValidatorEditor();
            abstractValidator = new JCBigDecimalValidator();
            this.validator_text = "BigDecimalValidatorHelp";
        } else if (string.equals(STRING_VALIDATOR)) {
            abstractValidatorEditor = new StringValidatorEditor();
            abstractValidator = new JCStringValidator();
            this.validator_text = "StringValidatorHelp";
        } else if (string.equals(IPADDRESS_VALIDATOR)) {
            abstractValidatorEditor = new IPAddressValidatorEditor();
            abstractValidator = new JCIPAddressValidator();
            this.validator_text = "IPAddressValidatorHelp";
        } else if (string.equals(DATE_VALIDATOR)) {
            abstractValidatorEditor = new DateValidatorEditor();
            abstractValidator = new JCDateValidator();
            this.validator_text = "DateValidatorHelp";
        } else if (string.equals(TIME_VALIDATOR)) {
            abstractValidatorEditor = new TimeValidatorEditor();
            abstractValidator = new JCTimeValidator();
            this.validator_text = "TimeValidatorHelp";
        } else if (string.equals(DATETIME_VALIDATOR)) {
            abstractValidatorEditor = new DateTimeValidatorEditor();
            abstractValidator = new JCDateTimeValidator();
            this.validator_text = "DateTimeValidatorHelp";
        }
        if (abstractValidatorEditor != null) {
            if (abstractValidator != null) {
                ((AbstractValidatorEditor)abstractValidatorEditor).setProperties(abstractValidator);
            }
            this.tabPane.setComponentAt(this.tabPane.indexOfTab("Validator"), abstractValidatorEditor);
            this.validatorPage = abstractValidatorEditor;
            this.tabPane.validate();
        }
    }

    public Object getValue() {
        Object object = null;
        if (this.tabValuePage.isCalendar) {
            object = ((JCPopupField)this.tabValuePage.value).getValue();
        } else {
            String string = ((JTextField)this.tabValuePage.value).getText();
            if (string == null || string.length() == 0) {
                return object;
            }
            if (this.tabValuePage.type.equals("java.lang.Byte")) {
                object = new Byte(string);
            } else if (this.tabValuePage.type.equals("java.lang.Double")) {
                object = new Double(string);
            } else if (this.tabValuePage.type.equals("java.lang.Float")) {
                object = new Float(string);
            } else if (this.tabValuePage.type.equals("java.lang.Integer")) {
                object = new Integer(string);
            } else if (this.tabValuePage.type.equals("java.lang.Long")) {
                object = new Long(string);
            } else if (this.tabValuePage.type.equals("java.lang.Short")) {
                object = new Short(string);
            } else if (this.tabValuePage.type.equals("com.klg.jclass.util.JCIPAddress")) {
                object = new JCIPAddress(string);
            } else if (this.tabValuePage.type.equals("java.lang.String")) {
                object = string;
            } else if (this.tabValuePage.type.equals("java.math.BigDecimal")) {
                object = new BigDecimal(string);
            }
        }
        return object;
    }

    public String getInitString() {
        String string;
        String string2 = "";
        if (this.validatorPage == null) {
            return "null, null";
        }
        string2 = this.validatorPage.getInitString() + ", ";
        if (this.valueModel.getClass().getName().indexOf("db") > 0) {
            string2 = string2 + "null";
            return string2;
        }
        string2 = string2 + "new " + this.valueModel.getClass().getName() + "(";
        String string3 = this.tabValuePage.type + ".class";
        if (this.tabValuePage.isCalendar) {
            Calendar calendar = (Calendar)((JCPopupField)this.tabValuePage.value).getValue();
            if (calendar == null) {
                string = "null";
            } else {
                int n2 = calendar.get(1);
                int n3 = calendar.get(2);
                int n4 = calendar.get(5);
                int n5 = calendar.get(10);
                int n6 = calendar.get(12);
                int n7 = calendar.get(13);
                string = "new java.util.GregorianCalendar(" + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ", " + n6 + ", " + n7 + ")";
            }
        } else {
            string = ((JTextField)this.tabValuePage.value).getText();
            string = string == null || string.length() == 0 ? "null" : "new " + this.tabValuePage.type + "(\"" + string + "\")";
        }
        string2 = string2 + string3 + ", " + string + ")";
        return string2;
    }
}

