/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field;

import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.Field;
import com.klg.jclass.field.JCFieldComponent;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCVersion;
import com.klg.jclass.field.validate.AbstractValidator;
import com.klg.jclass.field.validate.JCValidator;
import com.klg.jclass.util.swing.AbstractSpinBox;
import com.klg.jclass.util.swing.JCSpinBoxEditor;
import com.klg.jclass.util.swing.JCSpinBoxRenderer;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class JCSpinField
extends AbstractSpinBox
implements JCFieldComponent {
    protected Field field;
    protected JTextField text;
    protected boolean required = true;
    public static final String version = JCVersion.getVersionString();

    public JCSpinField() {
        this.setEditor(new FieldEditor());
        this.setRenderer(new FieldRenderer());
        this.text = (JTextField)this.editor.getEditorComponent();
        this.createField(null);
    }

    public JCSpinField(Class clazz) {
        this();
        this.field.setClass(clazz);
    }

    public JCSpinField(Class clazz, JCValidator jCValidator) {
        this();
        this.field.setValidator(jCValidator);
        this.field.setClass(clazz);
    }

    public JCSpinField(JCValueModel jCValueModel) {
        this();
        this.field.setValueModel(jCValueModel);
    }

    public JCSpinField(JCValueModel jCValueModel, JCValidator jCValidator) {
        this();
        this.field.setValidator(jCValidator);
        this.field.setValueModel(jCValueModel);
    }

    public DataProperties getDataProperties() {
        return this.field.getDataProperties();
    }

    public void setDataProperties(DataProperties dataProperties) {
        this.field.setDataProperties(dataProperties);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.field != null) {
            this.field.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.field != null) {
            this.field.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addValueListener(JCValueListener jCValueListener) {
        this.field.addValueListener(jCValueListener);
    }

    public void removeValueListener(JCValueListener jCValueListener) {
        this.field.removeValueListener(jCValueListener);
    }

    protected void createField(JCValidator jCValidator) {
        this.field = new Field(this, jCValidator);
    }

    public String getAbout() {
        return version;
    }

    public synchronized void setAbout(String string) {
    }

    protected int preferredHeightOfView() {
        int n2;
        if (this.isEditable()) {
            n2 = this.editor.getEditorComponent().getPreferredSize().height;
        } else {
            if (this.getValue() == null) {
                this.setValue(this.doSpin(true));
            }
            Insets insets = this.renderPanel.getInsets();
            Component component = this.renderer.getComponent(this, this.getValue());
            Dimension dimension = component.getPreferredSize();
            n2 = dimension.height + insets.top + insets.bottom;
        }
        return n2;
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        if (this.getValue() == null) {
            this.setValue(this.doSpin(true));
        }
    }

    public void addNotify() {
        super.addNotify();
        this.field.addNotify();
    }

    public void setBackground(Color color) {
        if (this.field == null || this.field.internalBackgroundChange) {
            super.setBackground(color);
        } else {
            this.field.validBackground = color;
            if (this.field.getState() != 3) {
                super.setBackground(color);
            }
        }
    }

    public void setForeground(Color color) {
        if (this.field == null || this.field.internalForegroundChange) {
            super.setForeground(color);
        } else {
            this.field.validForeground = color;
            if (this.field.getState() != 3) {
                super.setForeground(color);
            }
        }
    }

    protected void checkArrowButtons() {
        if (this.field == null || this.getValidator() == null) {
            this.setArrowEnabled(this.upArrow, false);
            this.setArrowEnabled(this.downArrow, false);
            return;
        }
        JCValidator jCValidator = this.field.getValidator();
        int n2 = this.field.getState() == 3 || this.field.getValue() == null ? jCValidator.calculateSpinability(jCValidator.getDefaultValue()) : jCValidator.calculateSpinability(this.field.getValue());
        if (this.upArrow != null) {
            this.setArrowEnabled(this.upArrow, (n2 & 1) != 0);
        }
        if (this.downArrow != null) {
            this.setArrowEnabled(this.downArrow, (n2 & 2) != 0);
        }
    }

    protected Object doSpin(boolean bl) {
        Object object;
        int n2;
        JCValidator jCValidator = this.getValidator();
        if (jCValidator == null) {
            return null;
        }
        this.field.commitEdit();
        Object object2 = this.field.getValue();
        if (object2 == null || !jCValidator.validate(object2)) {
            object2 = jCValidator.getDefaultValue();
        }
        if ((n2 = ((AbstractValidator)jCValidator).getSpinPolicy()) == 1) {
            jCValidator.inferSubField(this.text.getSelectionStart(), this.text.getSelectionEnd());
        }
        if ((object = bl ? jCValidator.spinUp(object2) : jCValidator.spinDown(object2)) != null) {
            this.field.setStateValid();
        }
        return object;
    }

    protected Object spinUp() {
        return this.doSpin(true);
    }

    protected Object spinDown() {
        return this.doSpin(false);
    }

    protected void processFocusLost(FocusEvent focusEvent) {
    }

    public Object getValue() {
        return this.field.getValue();
    }

    public void setValue(Object object) {
        this.field.setValue(object);
    }

    public JCValueModel getValueModel() {
        if (this.field != null) {
            return this.field.getValueModel();
        }
        return null;
    }

    public void setValueModel(JCValueModel jCValueModel) {
        if (this.field != null) {
            this.field.setValueModel(jCValueModel);
        }
    }

    public JCValidator getValidator() {
        return this.field.getValidator();
    }

    public void setValidator(JCValidator jCValidator) {
        this.field.setValidator(jCValidator);
    }

    public JCInvalidInfo getInvalidInfo() {
        return this.field.getInvalidInfo();
    }

    public void setInvalidInfo(JCInvalidInfo jCInvalidInfo) {
        this.field.setInvalidInfo(jCInvalidInfo);
    }

    public int getState() {
        return this.field.getState();
    }

    public boolean getSelectOnEnter() {
        return this.field.getSelectOnEnter();
    }

    public void setSelectOnEnter(boolean bl) {
        this.field.setSelectOnEnter(bl);
    }

    public void commitEdit() {
        this.field.commitEdit();
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.field != null) {
            Serializable serializable;
            JCValidator jCValidator = this.getValidator();
            if (jCValidator instanceof AbstractValidator) {
                serializable = (AbstractValidator)jCValidator;
                ((AbstractValidator)serializable).setLocale(locale);
            }
            if ((serializable = this.getValueModel()) != null) {
                this.field.setValue(serializable.getValue());
            }
        }
    }

    class FieldRenderer
    extends JLabel
    implements JCSpinBoxRenderer {
        public FieldRenderer() {
            this.setOpaque(true);
        }

        public Component getComponent(AbstractSpinBox abstractSpinBox, Object object) {
            if (JCSpinField.this.field != null && JCSpinField.this.getValidator() != null) {
                this.setText(JCSpinField.this.getValidator().format(object));
            }
            return this;
        }
    }

    class FieldEditor
    extends JTextField
    implements JCSpinBoxEditor {
        FieldEditor() {
        }

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object object) {
            JCSpinField.this.field.setValue(object);
        }

        public Object getItem() {
            return JCSpinField.this.field.getValue();
        }
    }
}

