/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.ReadOnlyBinding;
import com.klg.jclass.datasource.VirtualColumnModel;
import com.klg.jclass.util.JCListenerList;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class Binding
extends ReadOnlyBinding {
    static final long serialVersionUID = -1517190061360439012L;
    protected EventListener eventListener = new EventListener();

    public Binding(DataModel dataModel) {
        super(dataModel);
        this.dataModel.addDataModelListener(this.eventListener);
    }

    public Binding(Binding binding) {
        this(binding.getDataModel());
    }

    public boolean isColumnEditable(String string) {
        try {
            ColumnModel columnModel = this.metaDataModel.getColumnObject(string);
            return columnModel != null && !(columnModel instanceof VirtualColumnModel) && !columnModel.isReadOnly();
        }
        catch (DataModelException dataModelException) {
            return false;
        }
    }

    public boolean isColumnEditable(int n2) {
        return this.isColumnEditable(this.getColumnIdentifier(n2));
    }

    public void deleteRows(DataModelListener dataModelListener, int n2, int n3) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        Vector<Long> vector = new Vector<Long>(n3);
        int n4 = n2;
        while (n4 < n2 + n3) {
            vector.addElement(new Long(dataTableModel.getRowIdentifier(n4)));
            ++n4;
        }
        int n5 = 0;
        while (n5 < vector.size()) {
            dataTableModel.deleteRow(dataModelListener, ((Long)vector.elementAt(n5)).intValue());
            ++n5;
        }
    }

    public void deleteRow(DataModelListener dataModelListener, int n2) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        dataTableModel.deleteRow(dataModelListener, dataTableModel.getRowIdentifier(n2));
    }

    public void deleteCurrentRow(DataModelListener dataModelListener) throws DataModelException {
        this.deleteRow(dataModelListener, this.getCurrentRowIndex());
    }

    public void addRow(DataModelListener dataModelListener) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        dataTableModel.addRow(dataModelListener);
    }

    public void cancelRowChanges(DataModelListener dataModelListener, int n2) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        dataTableModel.cancelRowChanges(dataModelListener, dataTableModel.getRowIdentifier(n2));
    }

    public void cancelCurrentRowChanges(DataModelListener dataModelListener) throws DataModelException {
        this.cancelRowChanges(dataModelListener, this.getCurrentRowIndex());
    }

    public void cancelAll(DataModelListener dataModelListener) throws DataModelException {
        this.dataModel.cancelAll(dataModelListener);
    }

    public void commitRow(DataModelListener dataModelListener, int n2) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        dataTableModel.commitRow(dataModelListener, dataTableModel.getRowIdentifier(n2));
    }

    public void commitCurrentRow(DataModelListener dataModelListener) throws DataModelException {
        this.commitRow(dataModelListener, this.getCurrentRowIndex());
    }

    public void commitAll(DataModelListener dataModelListener) throws DataModelException {
        this.dataModel.updateAll(dataModelListener);
    }

    public void setCell(DataModelListener dataModelListener, int n2, int n3, Object object) throws DataModelException {
        long l2;
        String string = this.metaDataModel.getColumnIdentifier(n3);
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        Object object2 = dataTableModel.getResultData(l2 = dataTableModel.getRowIdentifier(n2), string);
        if (object2 == object || object2 == null && object instanceof String && ((String)object).length() == 0 || object2 != null && object2.equals(object)) {
            return;
        }
        this.getCurrentDataTableModel(dataModelListener).updateCell(dataModelListener, l2, string, object);
    }

    public void setCurrentCell(DataModelListener dataModelListener, String string, Object object) throws DataModelException {
        this.setCell(dataModelListener, this.getCurrentRowIndex(), this.metaDataModel.getColumnIndex(string), object);
    }

    public boolean isRowModified(int n2) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(this.eventListener);
        return dataTableModel.getRowStatus(dataTableModel.getRowIdentifier(n2)) != 4;
    }

    public boolean isCurrentRowModified() throws DataModelException {
        return this.isRowModified(this.getCurrentRowIndex());
    }

    public int getRowStatus(int n2) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(this.eventListener);
        return dataTableModel.getRowStatus(dataTableModel.getRowIdentifier(n2));
    }

    public int getCurrentRowStatus() throws DataModelException {
        return this.getRowStatus(this.getCurrentRowIndex());
    }

    public void requeryLevel(DataModelListener dataModelListener) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        if (dataTableModel == null) {
            this.dataModel.requeryAll(dataModelListener);
        } else {
            long l2 = dataTableModel.getParentBookmark();
            if (l2 == -1L) {
                this.dataModel.requeryAll(dataModelListener);
            } else {
                MetaDataModel metaDataModel = (MetaDataModel)this.metaDataModel.getParent();
                DataTableModel dataTableModel2 = this.getCurrentDataTableModel(dataModelListener);
                dataTableModel2.requeryRowAndDetails(dataModelListener, l2);
            }
        }
    }

    public void moveToBestRowAfterDelete(DataModelListener dataModelListener, DataModelEvent dataModelEvent) throws DataModelException {
        int n2 = dataModelEvent.getTable().getRowCount();
        if (n2 > 0) {
            int n3 = dataModelEvent.getRowIndex();
            this.dataModel.moveToRow(dataModelListener, dataModelEvent.getTable(), dataModelEvent.getTable().getRowIdentifier(n3 < 0 ? 0 : (n3 == n2 ? --n3 : n3)));
        } else {
            DataTableModel dataTableModel = (DataTableModel)((Object)((TreeNode)((Object)dataModelEvent.getTable())).getParent());
            if (dataTableModel != null) {
                this.dataModel.moveToRow(dataModelListener, dataTableModel, dataModelEvent.getTable().getParentBookmark());
            }
        }
    }

    protected class EventListener
    implements DataModelListener,
    Serializable {
        final long serialVersionUID = 7619120133353473409L;

        protected EventListener() {
        }

        public void afterReset(DataModelEvent dataModelEvent) {
            Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
            while (enumeration.hasMoreElements()) {
                DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                dataModelListener.initialize(dataModelEvent);
            }
        }

        public void afterMoveToCurrentRow(DataModelEvent dataModelEvent) {
            Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
            while (enumeration.hasMoreElements()) {
                DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                dataModelListener.afterMoveToCurrentRow(dataModelEvent);
            }
        }

        public void afterRequeryRowAndDetails(DataModelEvent dataModelEvent) {
            if (Binding.this.isOutDataOrOurAncestors(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.afterRequeryRowAndDetails(dataModelEvent);
                }
            }
        }

        public void afterRequeryTable(DataModelEvent dataModelEvent) {
            if (Binding.this.isOutDataOrOurAncestors(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.afterRequeryTable(dataModelEvent);
                }
            }
        }

        public void afterChangeOfRowData(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.afterChangeOfRowData(dataModelEvent);
                }
            }
        }

        public void afterInsertRow(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.afterInsertRow(dataModelEvent);
                }
            }
        }

        public void afterDeleteRow(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.afterDeleteRow(dataModelEvent);
                }
            }
        }

        public void beginEvents(DataModelEvent dataModelEvent) {
        }

        public void endEvents(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.endEvents(dataModelEvent);
                }
            }
        }

        public void initialize(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.initialize(dataModelEvent);
                }
            }
        }

        public void beforeInsertRow(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.beforeInsertRow(dataModelEvent);
                }
            }
        }

        public void beforeReset(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.beforeReset(dataModelEvent);
                }
            }
        }

        public void beforeRequery(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.beforeRequery(dataModelEvent);
                }
            }
        }

        public void beforeEditCell(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.beforeEditCell(dataModelEvent);
                }
            }
        }

        public void beforeDeleteRow(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.beforeDeleteRow(dataModelEvent);
                }
            }
        }

        public void beforeCommitAll(DataModelEvent dataModelEvent) {
            Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
            while (enumeration.hasMoreElements()) {
                DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                dataModelListener.beforeCommitAll(dataModelEvent);
            }
        }

        public void beforeCancelAll(DataModelEvent dataModelEvent) {
            Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
            while (enumeration.hasMoreElements()) {
                DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                dataModelListener.beforeCancelAll(dataModelEvent);
            }
        }

        public void beforeCancelRowChanges(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.beforeCancelRowChanges(dataModelEvent);
                }
            }
        }

        public void beforeCommitConditional(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.beforeCommitConditional(dataModelEvent);
                }
            }
        }

        public void beforeCommitRow(DataModelEvent dataModelEvent) {
            Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
            while (enumeration.hasMoreElements()) {
                DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                dataModelListener.beforeCommitRow(dataModelEvent);
            }
        }

        public void beforeMoveToCurrentRow(DataModelEvent dataModelEvent) {
            Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
            while (enumeration.hasMoreElements()) {
                DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                dataModelListener.beforeMoveToCurrentRow(dataModelEvent);
            }
        }

        public void beforeDeleteTable(DataModelEvent dataModelEvent) {
            DataTableModel dataTableModel = null;
            try {
                dataTableModel = Binding.this.getCurrentDataTableModel(this);
            }
            catch (DataModelException dataModelException) {
                // empty catch block
            }
            if (dataTableModel != null && dataTableModel.tableIsAncestor(dataModelEvent.getTable()) && dataModelEvent.isCancelable()) {
                dataModelEvent.cancelProposedAction();
                return;
            }
            Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
            while (enumeration.hasMoreElements()) {
                DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                dataModelListener.beforeDeleteTable(dataModelEvent);
            }
        }

        public void originatorNavigateRow(DataModelEvent dataModelEvent) {
            if (Binding.this.isOurData(dataModelEvent)) {
                Enumeration<Object> enumeration = JCListenerList.elements(Binding.this.listeners);
                while (enumeration.hasMoreElements()) {
                    DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                    dataModelListener.originatorNavigateRow(dataModelEvent);
                }
            }
        }
    }
}

