/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.property.xml;

import com.klg.jclass.chart3d.JCChart3dEnumMappings;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCGridColor;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.JCValueLabel;
import com.klg.jclass.chart3d.data.Base3dDataSource;
import com.klg.jclass.chart3d.data.Base3dGridDataSource;
import com.klg.jclass.chart3d.data.Base3dPointDataSource;
import com.klg.jclass.chart3d.data.XML3dDataHandler;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.io.JCIOException;
import com.klg.jclass.util.io.JCParseException;
import com.klg.jclass.util.io.LoadProperties;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.property.PropertyAccessModel;
import com.klg.jclass.util.property.xml.LocalizedPropertyHandler;
import com.klg.jclass.util.style.JCStyleEnumMappings;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import com.klg.jclass.util.xml.JCXMLDTDResolver;
import com.klg.jclass.util.xml.JCXMLErrorPrinter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Chart3dHandler
extends LocalizedPropertyHandler {
    protected XML3dDataHandler dataHandler = null;
    protected Base3dDataSource baseDS = null;
    protected PropertyAccessModel pam = null;
    protected StringBuffer sb = null;
    protected String prefix = null;
    protected boolean inData = false;
    protected boolean inExternalCode = false;
    protected boolean inAxis = false;
    protected boolean inBorder = false;
    protected boolean inTitledBorder = false;
    protected boolean inCompoundBorder = false;
    protected Stack<CompoundBorder> compoundBorderStack = null;
    protected Border savedBorder = null;
    protected Color color = null;
    protected Insets insets = null;
    protected LinkedList<String> prefixList = null;
    protected List<JCValueLabel> valueLabels = null;
    protected List<Double> levels = null;
    protected List<JCContourStyle> contourStyles = null;
    protected List<JCChart3dStyle> chart3dStyles = null;
    protected List<JCGridColor> gridColors = null;
    protected List<String> labels = null;
    protected List<List<String>> labelsList = null;
    protected JCValueLabel curValueLabel;
    protected double curLevel = 0.0;
    protected JCContourStyle contourStyle = null;
    protected JCChart3dStyle chart3dStyle = null;
    protected JCGridColor gridColor = null;
    protected JCLineStyle lineStyle = null;
    protected JCFillStyle fillStyle = null;
    protected JCSymbolStyle symbolStyle = null;
    protected int externalCodeCount = 0;
    protected String attName = null;
    protected String attValue = null;

    public Chart3dHandler(PropertyAccessModel propertyAccessModel) {
        this.pam = propertyAccessModel;
        this.localeHandler = propertyAccessModel.getLoadProperties().getLocaleHandler();
    }

    public Base3dDataSource getDataSource() {
        return this.baseDS;
    }

    public void setDataSource(Base3dDataSource base3dDataSource) {
        this.baseDS = base3dDataSource;
    }

    public void addPrefix(String string) {
        this.prefixList.addLast(this.prefix);
        this.prefix = this.prefix + string;
    }

    public void setPrefix(String string) {
        this.prefixList.addLast(this.prefix);
        this.prefix = string;
    }

    public void popPrefix() {
        this.prefix = this.prefixList.removeLast();
    }

    public void startDocument() throws SAXException {
        this.prefixList = new LinkedList();
        this.prefix = "";
    }

    public void endDocument() throws SAXException {
        this.prefixList = null;
        this.prefix = null;
        this.attName = null;
        this.attValue = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("grid-data") || string3.equals("data")) {
            if (this.baseDS == null) {
                this.baseDS = new Base3dGridDataSource(null, null, null, null);
            }
            this.dataHandler = new XML3dDataHandler(this.baseDS, this.localeHandler);
            this.inData = true;
        }
        if (string3.equals("point-data")) {
            if (this.baseDS == null) {
                this.baseDS = new Base3dPointDataSource();
            }
            this.dataHandler = new XML3dDataHandler(this.baseDS, this.localeHandler);
            this.inData = true;
        }
        if (this.inData) {
            this.dataHandler.handleStartElement(string, string2, string3, attributes);
            return;
        }
        if (string3.equals("chart3d")) {
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "height");
            this.handleAttribute(attributes, "antiAliasing");
        } else if (string3.equals("component")) {
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "font");
            this.handleAttribute(attributes, "visible");
        } else if (string3.equals("empty-border") || string3.equals("bevel-border") || string3.equals("etched-border") || string3.equals("line-border") || string3.equals("matte-border") || string3.equals("titled-border")) {
            this.handleBorder(string3, attributes, true);
        } else if (string3.equals("compound-border")) {
            this.handleCompoundBorder(true);
        } else if (string3.equals("insets")) {
            this.handleInsets(attributes);
        } else if (string3.equals("layout-hints")) {
            this.handleAttribute(attributes, "x");
            this.handleAttribute(attributes, "y");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "height");
        } else if (string3.equals("locale")) {
            this.addPrefix("locale.");
            this.handleAttribute(attributes, "language");
            this.handleAttribute(attributes, "country");
            this.handleAttribute(attributes, "variant");
        } else if (string3.equals("header")) {
            this.addPrefix("header.");
            this.handleAttribute(attributes, "text");
            this.handleAttribute(attributes, "horizontalAlignment");
            this.handleAttribute(attributes, "verticalAlignment");
            this.handleAttribute(attributes, "horizontalTextPosition");
            this.handleAttribute(attributes, "verticalTextPosition");
        } else if (string3.equals("footer")) {
            this.addPrefix("footer.");
            this.handleAttribute(attributes, "text");
            this.handleAttribute(attributes, "horizontalAlignment");
            this.handleAttribute(attributes, "verticalAlignment");
            this.handleAttribute(attributes, "horizontalTextPosition");
            this.handleAttribute(attributes, "verticalTextPosition");
        } else if (string3.equals("legend")) {
            this.addPrefix("legend.");
            this.handleAttribute(attributes, "type");
            this.handleAttribute(attributes, "anchor");
            this.handleAttribute(attributes, "orientation");
            this.handleAttribute(attributes, "itemTextToolTipEnabled");
            this.handleAttribute(attributes, "useEllipsisWhenTruncating");
            this.handleAttribute(attributes, "symbolRenderMode");
            this.handleAttribute(attributes, "marginGap");
            this.handleAttribute(attributes, "groupGap");
            this.handleAttribute(attributes, "horizontalItemGap");
            this.handleAttribute(attributes, "verticalItemGap");
            this.handleAttribute(attributes, "insideItemGap");
        } else if (string3.equals("labels-list")) {
            this.labelsList = new ArrayList<List<String>>();
        } else if (string3.equals("labels")) {
            this.labels = new ArrayList<String>();
        } else if (string3.equals("chart3d-area")) {
            this.addPrefix("chart3dArea.");
        } else if (string3.equals("plot-cube")) {
            this.addPrefix("plotCube.");
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "xScale");
            this.handleAttribute(attributes, "yScale");
            this.handleAttribute(attributes, "zScale");
        } else if (string3.equals("projection")) {
            int n2 = attributes.getIndex("type");
            String string4 = attributes.getValue(n2);
            string4 = string4.toLowerCase();
            this.attName = this.prefix + string4;
            this.attValue = "true";
            this.pam.setProperty(this.attName, this.attValue);
            this.addPrefix(string4 + ".");
            this.handleAttribute(attributes, "contoured");
            this.handleAttribute(attributes, "zoned");
        } else if (string3.equals("viewport")) {
            this.addPrefix("viewport.");
            this.handleAttribute(attributes, "scale");
            this.handleAttribute(attributes, "horizontalShift");
            this.handleAttribute(attributes, "verticalShift");
            this.handleAttribute(attributes, "previewMethod");
        } else if (string3.equals("view3d")) {
            this.addPrefix("view3d.");
            this.handleAttribute(attributes, "perspective");
            this.handleAttribute(attributes, "xRotation");
            this.handleAttribute(attributes, "yRotation");
            this.handleAttribute(attributes, "zRotation");
        } else if (string3.equals("surface")) {
            this.addPrefix("surface.");
            this.handleAttribute(attributes, "solid");
            this.handleAttribute(attributes, "xMeshShowing");
            this.handleAttribute(attributes, "yMeshShowing");
            this.handleAttribute(attributes, "xMeshFilter");
            this.handleAttribute(attributes, "yMeshFilter");
        } else if (string3.equals("bar")) {
            this.addPrefix("bar.");
            this.handleAttribute(attributes, "xFormat");
            this.handleAttribute(attributes, "yFormat");
            this.handleAttribute(attributes, "xSpacing");
            this.handleAttribute(attributes, "ySpacing");
        } else if (string3.equals("scatter")) {
            this.addPrefix("scatter.");
            this.handleAttribute(attributes, "dropLines");
        } else if (string3.equals("axis")) {
            this.inAxis = true;
            int n3 = attributes.getIndex("type");
            String string5 = attributes.getValue(n3);
            string5 = string5.toLowerCase();
            this.attName = this.prefix + string5;
            this.attValue = "true";
            this.pam.setProperty(this.attName, this.attValue);
            this.addPrefix(string5 + ".");
            this.handleAttribute(attributes, "showing");
            this.handleAttribute(attributes, "annotationMethod");
            this.handleAttribute(attributes, "annotationRotation");
            this.handleAttribute(attributes, "annoFont");
            this.handleAttribute(attributes, "annoFontCubeSize");
            this.handleAttribute(attributes, "title");
            this.handleAttribute(attributes, "titleFont");
            this.handleAttribute(attributes, "titleFontCubeSize");
            this.handleAttribute(attributes, "min");
            this.handleAttribute(attributes, "max");
            this.handleAttribute(attributes, "origin");
        } else if (string3.equals("formatter")) {
            this.addPrefix("formatter.");
            this.handleAttribute(attributes, "groupingUsed");
            this.handleAttribute(attributes, "numberLocalization");
            this.handleAttribute(attributes, "nFrac");
            this.handleAttribute(attributes, "decimalPadded");
        } else if (string3.equals("grid-lines")) {
            this.addPrefix("gridLines.");
            this.handleAttribute(attributes, "xyPlane");
            this.handleAttribute(attributes, "xzPlane");
            this.handleAttribute(attributes, "yzPlane");
        } else if (string3.equals("value-label")) {
            this.curValueLabel = new JCValueLabel();
            this.handleValueLabel(attributes);
        } else if (string3.equals("chart3d-data-view")) {
            this.addPrefix("chart3dDataView.");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "chartType");
        } else if (string3.equals("elevation-data")) {
            this.addPrefix("elevationData.");
        } else if (string3.equals("zone-data")) {
            this.addPrefix("zoneData.");
        } else if (string3.equals("elevation")) {
            this.addPrefix("elevation.");
            this.handleAttribute(attributes, "meshed");
            this.handleAttribute(attributes, "shaded");
            this.handleAttribute(attributes, "transparent");
            this.handleAttribute(attributes, "meshTopColor");
            this.handleAttribute(attributes, "meshBottomColor");
            this.handleAttribute(attributes, "shadedTopCOlor");
            this.handleAttribute(attributes, "shadedBottomColor");
        } else if (string3.equals("contour")) {
            this.addPrefix("contour.");
            this.handleAttribute(attributes, "contoured");
            this.handleAttribute(attributes, "zoned");
            this.handleAttribute(attributes, "zoneMethod");
        } else if (string3.equals("contour-levels")) {
            this.addPrefix("contourLevels.");
            this.handleAttribute(attributes, "numLevels");
        } else if (string3.equals("contour-style")) {
            this.contourStyle = new JCContourStyle();
        } else if (string3.equals("chart3d-style")) {
            this.chart3dStyle = new JCChart3dStyle();
        } else if (string3.equals("grid-color")) {
            this.gridColor = new JCGridColor();
            this.handleGridColor(attributes);
        } else if (string3.equals("grid-data-index")) {
            this.handleGridDataIndex(attributes);
        } else if (string3.equals("line-style")) {
            this.lineStyle = this.contourStyle != null ? this.contourStyle.getLineStyle() : (this.chart3dStyle != null ? this.chart3dStyle.getLineStyle() : new JCLineStyle(1, Color.black, 1));
            this.handleLineStyle(attributes);
        } else if (string3.equals("fill-style")) {
            this.fillStyle = this.contourStyle != null ? this.contourStyle.getFillStyle() : new JCFillStyle(Color.black, 1);
            this.handleFillStyle(attributes);
        } else if (string3.equals("symbol-style")) {
            this.symbolStyle = this.contourStyle != null ? this.contourStyle.getSymbolStyle() : (this.chart3dStyle != null ? this.chart3dStyle.getSymbolStyle() : new JCSymbolStyle("com.klg.jclass.chart3d.shape.Dot", Color.black, 6));
            this.handleSymbolStyle(attributes);
        } else if (string3.equals("chart3d-data-file")) {
            this.handleDataFile(attributes);
        } else if (string3.equals("image-file")) {
            if (this.fillStyle != null) {
                try {
                    this.handleImage(attributes);
                }
                catch (JCIOException jCIOException) {
                    throw new SAXException("Error loading image file", jCIOException);
                }
            } else {
                this.addPrefix("image.");
                this.handleAttribute(attributes, "fileName");
                this.handleAttribute(attributes, "fileAccess");
            }
        } else if (string3.equals("gradient")) {
            this.handleGradient(attributes);
        } else if (string3.equals("image-position")) {
            this.handleImagePosition(attributes);
        } else if (string3.equals("external-java-code")) {
            this.addPrefix("externalJavaCode" + this.externalCodeCount + ".");
            this.handleAttribute(attributes, "class");
            this.inExternalCode = true;
            ++this.externalCodeCount;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.inData) {
            this.dataHandler.handleEndElement(string, string2, string3);
            if (string3.equals("grid-data") || string3.equals("point-data") || string3.equals("data")) {
                this.pam.setPropertyObject(this.prefix + "data", this.baseDS);
                this.baseDS = null;
                this.dataHandler = null;
                this.inData = false;
            }
            return;
        }
        if (string3.equals("value-label")) {
            if (this.valueLabels == null) {
                this.valueLabels = new ArrayList<JCValueLabel>();
            }
            this.valueLabels.add(this.curValueLabel);
            this.curValueLabel = null;
        } else if (string3.equals("level")) {
            if (this.levels == null) {
                this.levels = new ArrayList<Double>();
            }
            this.curLevel = JCTypeConverter.toDouble(this.sb == null ? null : this.sb.toString(), 0.0);
            this.levels.add(new Double(this.curLevel));
        } else if (string3.equals("axis")) {
            this.handleValueLabels();
            this.popPrefix();
            this.inAxis = false;
        } else if (string3.equals("chart3d")) {
            this.attValue = "" + (this.externalCodeCount - 1);
            this.pam.setProperty("lastExternalJavaCodeIndex", this.attValue);
        } else if (string3.equals("external-java-code")) {
            this.pam.setProperty(this.prefix + "userData", this.sb == null ? "" : this.sb.toString().trim());
            this.inExternalCode = false;
            this.popPrefix();
        } else if (string3.equals("empty-border") || string3.equals("bevel-border") || string3.equals("etched-border") || string3.equals("line-border") || string3.equals("matte-border") || string3.equals("titled-border")) {
            this.handleBorder(string3, null, false);
        } else if (string3.equals("compound-border")) {
            this.handleCompoundBorder(false);
        } else if (string3.equals("labels-list")) {
            if (this.labelsList != null) {
                this.attName = this.prefix + "labelsList";
                this.pam.setPropertyObject(this.attName, this.labelsList);
                this.labelsList = null;
            }
        } else if (string3.equals("labels")) {
            if (this.labelsList != null) {
                this.labelsList.add(this.labels);
            }
            this.labels = null;
        } else if (string3.equals("label")) {
            this.labels.add(this.sb == null ? "" : this.sb.toString());
        } else if (string3.equals("contour")) {
            if (this.contourStyles != null) {
                this.attName = this.prefix + "contourStyles";
                this.pam.setPropertyObject(this.attName, this.contourStyles);
                this.contourStyles = null;
            }
            this.popPrefix();
        } else if (string3.equals("contour-levels")) {
            if (this.levels != null) {
                this.attName = this.prefix + "levels";
                double[] dArray = new double[this.levels.size()];
                int n2 = 0;
                for (Double d2 : this.levels) {
                    dArray[n2++] = d2;
                }
                this.pam.setPropertyObject(this.attName, dArray);
                this.levels = null;
            }
            this.popPrefix();
        } else if (string3.equals("contour-style")) {
            if (this.contourStyles == null) {
                this.contourStyles = new ArrayList<JCContourStyle>();
            }
            this.contourStyles.add(this.contourStyle);
            this.contourStyle = null;
        } else if (string3.equals("chart3d-style")) {
            if (this.chart3dStyles == null) {
                this.chart3dStyles = new ArrayList<JCChart3dStyle>();
            }
            this.chart3dStyles.add(this.chart3dStyle);
            this.chart3dStyle = null;
        } else if (string3.equals("line-style")) {
            if (this.contourStyle != null) {
                this.contourStyle.setLineStyle(this.lineStyle);
            } else if (this.chart3dStyle != null) {
                this.chart3dStyle.setLineStyle(this.lineStyle);
            } else {
                this.attName = this.prefix + "lineStyle";
                this.pam.setPropertyObject(this.attName, this.lineStyle);
            }
            this.lineStyle = null;
        } else if (string3.equals("fill-style")) {
            if (this.contourStyle != null) {
                this.contourStyle.setFillStyle(this.fillStyle);
            } else {
                this.attName = this.prefix + "fillStyle";
                this.pam.setPropertyObject(this.attName, this.fillStyle);
            }
            this.fillStyle = null;
        } else if (string3.equals("symbol-style")) {
            if (this.contourStyle != null) {
                this.contourStyle.setSymbolStyle(this.symbolStyle);
            } else if (this.chart3dStyle != null) {
                this.chart3dStyle.setSymbolStyle(this.symbolStyle);
            } else {
                this.attName = this.prefix + "symbolStyle";
                this.pam.setPropertyObject(this.attName, this.symbolStyle);
            }
            this.symbolStyle = null;
        } else if (string3.equals("grid-color")) {
            if (this.gridColors == null) {
                this.gridColors = new ArrayList<JCGridColor>();
            }
            this.gridColors.add(this.gridColor);
            this.gridColor = null;
        } else if (string3.equals("grid-colors")) {
            if (this.gridColors != null) {
                this.attName = this.prefix + "gridColors";
                this.pam.setPropertyObject(this.attName, this.gridColors);
                this.gridColors = null;
            }
        } else if (string3.equals("chart3d-data-view")) {
            if (this.chart3dStyles != null) {
                this.attName = this.prefix + "chart3dStyles";
                this.pam.setPropertyObject(this.attName, this.chart3dStyles);
                this.chart3dStyles = null;
            }
        } else if (string3.equals("header") || string3.equals("footer") || string3.equals("legend") || string3.equals("chart3d-area") || string3.equals("plot-cube") || string3.equals("projection") || string3.equals("viewport") || string3.equals("view3d") || string3.equals("surface") || string3.equals("bar") || string3.equals("scatter") || string3.equals("formatter") || string3.equals("grid-lines") || string3.equals("elevation-data") || string3.equals("zone-data") || string3.equals("elevation") || string3.equals("locale")) {
            this.popPrefix();
        }
        this.sb = null;
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.inData) {
            this.dataHandler.handleCharacters(cArray, n2, n3);
            return;
        }
        String string = new String(cArray, n2, n3);
        string = this.localizeString(string);
        if (this.sb == null) {
            this.sb = new StringBuffer(string);
        } else {
            this.sb.append(string);
        }
    }

    protected void handleAttribute(Attributes attributes, String string) {
        this.handleAttribute(attributes, string, string);
    }

    protected void handleAttribute(Attributes attributes, String string, String string2) {
        if (attributes == null || this.pam == null) {
            return;
        }
        int n2 = attributes.getIndex(string);
        if (n2 > -1) {
            this.attName = this.prefix + string2;
            this.attValue = this.localizeString(attributes.getValue(n2));
            this.pam.setProperty(this.attName, this.attValue);
        }
    }

    protected void handleDataFile(Attributes attributes) {
        if (attributes == null || this.pam == null) {
            return;
        }
        String string = null;
        int n2 = attributes.getIndex("fileName");
        if (n2 > -1) {
            string = attributes.getValue(n2);
        }
        if (string == null) {
            return;
        }
        this.attValue = string;
        this.attName = this.prefix + "dataFile";
        this.pam.setProperty(this.attName, this.attValue);
        n2 = attributes.getIndex("fileType");
        if (n2 > -1) {
            this.attValue = attributes.getValue(n2);
            this.attName = this.prefix + "dataFileType";
            this.pam.setProperty(this.attName, this.attValue);
        }
        if ((n2 = attributes.getIndex("fileAccess")) > -1) {
            this.attValue = attributes.getValue(n2);
            this.attName = this.prefix + "dataFileAccess";
            this.pam.setProperty(this.attName, this.attValue);
        }
        if ((n2 = attributes.getIndex("fileCharset")) > -1) {
            this.attValue = attributes.getValue(n2);
            this.attName = this.prefix + "dataFileCharset";
            this.pam.setProperty(this.attName, this.attValue);
        }
    }

    protected void handleValueLabel(Attributes attributes) {
        if (attributes == null || this.curValueLabel == null) {
            return;
        }
        double d2 = 0.0;
        int n2 = attributes.getIndex("value");
        if (n2 > -1) {
            d2 = JCTypeConverter.toDouble(attributes.getValue(n2), d2);
            this.curValueLabel.setValue(d2);
        }
        if ((n2 = attributes.getIndex("label")) > -1) {
            this.curValueLabel.setLabel(attributes.getValue(n2));
        }
        boolean bl = true;
        n2 = attributes.getIndex("labelDrawn");
        if (n2 > -1) {
            bl = JCTypeConverter.toBoolean(attributes.getValue(n2), bl);
            this.curValueLabel.setLabelDrawn(bl);
        }
        boolean bl2 = true;
        n2 = attributes.getIndex("tickDrawn");
        if (n2 > -1) {
            bl2 = JCTypeConverter.toBoolean(attributes.getValue(n2), bl2);
            this.curValueLabel.setTickDrawn(bl2);
        }
        boolean bl3 = false;
        n2 = attributes.getIndex("minorTick");
        if (n2 > -1) {
            bl3 = JCTypeConverter.toBoolean(attributes.getValue(n2), bl3);
            this.curValueLabel.setMinorTick(bl3);
        }
        Color color = null;
        n2 = attributes.getIndex("background");
        if (n2 > -1) {
            color = JCSwingTypeConverter.toColor(attributes.getValue(n2), color);
            this.curValueLabel.setBackground(color);
        }
        Color color2 = null;
        n2 = attributes.getIndex("foreground");
        if (n2 > -1) {
            color2 = JCSwingTypeConverter.toColor(attributes.getValue(n2), color2);
            this.curValueLabel.setForeground(color2);
        }
    }

    public void handleValueLabels() {
        if (this.valueLabels != null && this.valueLabels.size() > 0 && this.pam != null) {
            JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.valueLabels.size()];
            for (int i2 = 0; i2 < this.valueLabels.size(); ++i2) {
                jCValueLabelArray[i2] = this.valueLabels.get(i2);
            }
            this.pam.setPropertyObject(this.prefix + "valueLabels", jCValueLabelArray);
        }
        this.valueLabels = null;
    }

    protected void handleBorder(String string, Attributes attributes, boolean bl) {
        if (string == null || bl && attributes == null || this.pam == null) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (string.equals("titled-border")) {
            bl2 = true;
        } else if (string.equals("bevel-border")) {
            bl3 = true;
        } else if (string.equals("etched-border")) {
            bl4 = true;
        } else if (string.equals("line-border")) {
            bl5 = true;
        } else if (string.equals("matte-border")) {
            bl6 = true;
        } else if (string.equals("empty-border")) {
            bl7 = true;
        }
        Border border = null;
        if (bl) {
            if (bl2) {
                this.inTitledBorder = true;
            } else {
                this.inBorder = true;
            }
            if (bl3 || bl4) {
                Object object;
                int n2 = bl3 ? 1 : 1;
                int n3 = attributes.getIndex("type");
                if (n3 > -1) {
                    object = attributes.getValue(n3);
                    n2 = ((String)object).equalsIgnoreCase("raised") ? (bl3 ? 0 : 0) : (bl3 ? 1 : 1);
                }
                object = null;
                n3 = attributes.getIndex("highlightColor");
                if (n3 > -1) {
                    object = JCSwingTypeConverter.toColor(attributes.getValue(n3));
                }
                Color color = null;
                n3 = attributes.getIndex("shadowColor");
                if (n3 > -1) {
                    color = JCSwingTypeConverter.toColor(attributes.getValue(n3));
                }
                if (bl3) {
                    boolean bl8 = false;
                    n3 = attributes.getIndex("soft");
                    if (n3 > -1) {
                        bl8 = JCTypeConverter.toBoolean(attributes.getValue(n3), false);
                    }
                    border = object != null && color != null ? (bl8 ? new SoftBevelBorder(n2, (Color)object, color) : new BevelBorder(n2, (Color)object, color)) : (bl8 ? new SoftBevelBorder(n2) : new BevelBorder(n2));
                } else {
                    border = new EtchedBorder(n2, (Color)object, color);
                }
            } else if (bl5) {
                int n4 = attributes.getIndex("color");
                if (n4 > -1) {
                    this.color = JCSwingTypeConverter.toColor(attributes.getValue(n4), Color.black);
                }
                int n5 = 1;
                n4 = attributes.getIndex("thickness");
                if (n4 > -1) {
                    n5 = JCTypeConverter.toInt(attributes.getValue(n4), 1);
                }
                boolean bl9 = false;
                n4 = attributes.getIndex("roundedCorners");
                if (n4 > -1) {
                    bl9 = JCTypeConverter.toBoolean(attributes.getValue(n4), false);
                }
                border = new LineBorder(this.color, n5, bl9);
            } else if (bl2) {
                Object object;
                String string2 = null;
                int n6 = attributes.getIndex("title");
                if (n6 > -1) {
                    string2 = this.localizeString(attributes.getValue(n6));
                }
                int n7 = 0;
                n6 = attributes.getIndex("titlePosition");
                if (n6 > -1) {
                    n7 = JCTypeConverter.toEnum(attributes.getValue(n6), JCSwingTypeConverter.positionStrings, JCSwingTypeConverter.positionValues, n7);
                }
                int n8 = 0;
                n6 = attributes.getIndex("titleJustification");
                if (n6 > -1) {
                    object = JCSwingTypeConverter.justificationStrings;
                    int[] nArray = JCSwingTypeConverter.justificationValues;
                    n8 = JCTypeConverter.toEnum(attributes.getValue(n6), object, nArray, n8);
                }
                this.color = null;
                n6 = attributes.getIndex("color");
                if (n6 > -1) {
                    this.color = JCSwingTypeConverter.toColor(attributes.getValue(n6));
                }
                object = null;
                n6 = attributes.getIndex("font");
                if (n6 > -1) {
                    object = JCSwingTypeConverter.toFont(attributes.getValue(n6));
                }
                this.savedBorder = new TitledBorder(null, string2, n8, n7, (Font)object, this.color);
            } else if (bl6) {
                this.color = Color.black;
                int n9 = attributes.getIndex("color");
                if (n9 > -1) {
                    this.color = JCSwingTypeConverter.toColor(attributes.getValue(n9), Color.black);
                }
            }
        } else {
            if (bl6) {
                if (this.insets == null) {
                    this.insets = new Insets(0, 0, 0, 0);
                }
                border = BorderFactory.createMatteBorder(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right, this.color);
            } else if (bl7) {
                if (this.insets == null) {
                    this.insets = new Insets(0, 0, 0, 0);
                }
                border = new EmptyBorder(this.insets);
            } else if (bl2) {
                border = this.savedBorder;
                this.savedBorder = null;
                this.inTitledBorder = false;
            }
            if (!bl2) {
                this.inBorder = false;
                this.insets = null;
                this.color = null;
            }
        }
        if (border != null) {
            if (this.inTitledBorder) {
                if (this.savedBorder instanceof TitledBorder) {
                    TitledBorder titledBorder = (TitledBorder)this.savedBorder;
                    titledBorder.setBorder(border);
                }
            } else if (this.inCompoundBorder) {
                this.addToCompoundBorder(border);
            } else {
                this.attName = this.prefix + "border";
                this.pam.setPropertyObject(this.attName, border);
            }
        }
    }

    protected void handleCompoundBorder(boolean bl) {
        if (bl) {
            this.inCompoundBorder = true;
            if (this.compoundBorderStack == null) {
                this.compoundBorderStack = new Stack();
            }
            this.compoundBorderStack.push(new CompoundBorder());
        } else {
            CompoundBorder compoundBorder = this.compoundBorderStack.pop();
            if (this.compoundBorderStack.size() > 0) {
                this.addToCompoundBorder(compoundBorder);
            } else {
                this.attName = this.prefix + "border";
                this.pam.setPropertyObject(this.attName, compoundBorder);
                this.inCompoundBorder = false;
                this.compoundBorderStack = null;
            }
        }
    }

    protected void addToCompoundBorder(Border border) {
        CompoundBorder compoundBorder = this.compoundBorderStack.pop();
        CompoundBorder compoundBorder2 = compoundBorder.getOutsideBorder() == null ? new CompoundBorder(border, null) : (compoundBorder.getInsideBorder() == null ? new CompoundBorder(compoundBorder.getOutsideBorder(), border) : compoundBorder);
        this.compoundBorderStack.push(compoundBorder2);
    }

    protected void handleInsets(Attributes attributes) {
        if (attributes == null || this.pam == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = attributes.getIndex("left");
        if (n6 > -1) {
            n2 = JCTypeConverter.toInt(attributes.getValue(n6), n2);
        }
        if ((n6 = attributes.getIndex("right")) > -1) {
            n3 = JCTypeConverter.toInt(attributes.getValue(n6), n3);
        }
        if ((n6 = attributes.getIndex("top")) > -1) {
            n4 = JCTypeConverter.toInt(attributes.getValue(n6), n4);
        }
        if ((n6 = attributes.getIndex("bottom")) > -1) {
            n5 = JCTypeConverter.toInt(attributes.getValue(n6), n5);
        }
        this.insets = new Insets(n4, n2, n5, n3);
        if (!this.inBorder) {
            this.attName = this.prefix + "insets";
            this.pam.setPropertyObject(this.attName, this.insets);
            this.insets = null;
        }
    }

    protected void handleLineStyle(Attributes attributes) {
        int[] nArray;
        String[] stringArray;
        if (attributes == null || this.lineStyle == null) {
            return;
        }
        int n2 = attributes.getIndex("pattern");
        if (n2 > -1) {
            stringArray = JCChart3dEnumMappings.linePattern_strings;
            nArray = JCChart3dEnumMappings.linePattern_values;
            this.lineStyle.setPattern(JCTypeConverter.toEnum(attributes.getValue(n2), "linePattern", stringArray, nArray, this.lineStyle.getPattern()));
        }
        if ((n2 = attributes.getIndex("color")) > -1) {
            this.lineStyle.setColor(JCSwingTypeConverter.toColor(attributes.getValue(n2), this.lineStyle.getColor()));
        }
        if ((n2 = attributes.getIndex("width")) > -1) {
            this.lineStyle.setWidth(JCTypeConverter.toInt(attributes.getValue(n2), this.lineStyle.getWidth()));
        }
        if ((n2 = attributes.getIndex("join")) > -1) {
            stringArray = JCChart3dEnumMappings.lineJoin_strings;
            nArray = JCChart3dEnumMappings.lineJoin_values;
            this.lineStyle.setJoin(JCTypeConverter.toEnum(attributes.getValue(n2), "lineJoin", stringArray, nArray, this.lineStyle.getJoin()));
        }
        if ((n2 = attributes.getIndex("cap")) > -1) {
            stringArray = JCChart3dEnumMappings.lineCap_strings;
            nArray = JCChart3dEnumMappings.lineCap_values;
            this.lineStyle.setCap(JCTypeConverter.toEnum(attributes.getValue(n2), "lineCap", stringArray, nArray, this.lineStyle.getCap()));
        }
    }

    protected void handleFillStyle(Attributes attributes) {
        int n2;
        int[] nArray;
        Object object;
        if (attributes == null || this.fillStyle == null) {
            return;
        }
        int n3 = attributes.getIndex("pattern");
        if (n3 > -1) {
            object = JCChart3dEnumMappings.fillPattern_strings;
            nArray = JCChart3dEnumMappings.fillPattern_values;
            this.fillStyle.setPattern(JCTypeConverter.toEnum(attributes.getValue(n3), "fillPattern", object, nArray, this.fillStyle.getPattern()));
        }
        if ((n3 = attributes.getIndex("color")) > -1) {
            this.fillStyle.setColor(JCSwingTypeConverter.toColor(attributes.getValue(n3), this.fillStyle.getColor()));
        }
        if ((n3 = attributes.getIndex("imageLayoutHint")) > -1) {
            object = JCStyleEnumMappings.imageLayoutHint_strings;
            nArray = JCStyleEnumMappings.imageLayoutHint_values;
            n2 = JCTypeConverter.toEnum(attributes.getValue(n3), "imageLayoutHint", object, nArray, 0);
            this.fillStyle.setImageLayoutHint(n2);
        }
        if ((n3 = attributes.getIndex("fillOrientation")) > -1) {
            object = JCStyleEnumMappings.fillOrientation_strings;
            nArray = JCStyleEnumMappings.fillOrientation_values;
            n2 = JCTypeConverter.toEnum(attributes.getValue(n3), "fillOrientation", object, nArray, 1);
            this.fillStyle.setFillOrientation(n2);
        }
        if ((n3 = attributes.getIndex("background")) > -1) {
            object = JCSwingTypeConverter.toColor(attributes.getValue(n3), this.fillStyle.getBackground());
            this.fillStyle.setBackground((Color)object);
        }
    }

    protected void handleImage(Attributes attributes) throws JCIOException {
        URL uRL;
        boolean bl;
        block11: {
            if (attributes == null || this.pam == null || this.fillStyle == null) {
                return;
            }
            LoadProperties loadProperties = this.pam.getLoadProperties();
            if (loadProperties == null) {
                loadProperties = new LoadProperties();
            }
            OutputProperties outputProperties = new OutputProperties();
            String string = null;
            int n2 = attributes.getIndex("fileName");
            if (n2 > -1) {
                string = attributes.getValue(n2);
            }
            outputProperties.setPropertyName(string);
            String string2 = null;
            n2 = attributes.getIndex("fileAccess");
            if (n2 > -1 && (string2 = attributes.getValue(n2)) == null && string != null && (string.startsWith("http:") || string.startsWith("file:") || string.startsWith("data:"))) {
                string2 = "Url";
            }
            int n3 = loadProperties.getFileAccessEnumFromString(string2, false);
            outputProperties.setFileAccess(n3);
            this.fillStyle.setOutputProperties(outputProperties);
            if (string == null) {
                return;
            }
            bl = loadProperties.ignoreExternalResourceExceptions();
            uRL = null;
            try {
                uRL = loadProperties.getURLByAccessType(string, n3);
            }
            catch (MalformedURLException malformedURLException) {
                if (bl) break block11;
                throw new JCIOException(malformedURLException.getMessage(), malformedURLException);
            }
        }
        if (uRL != null) {
            ImageIcon imageIcon = null;
            imageIcon = new ImageIcon(uRL);
            if (imageIcon != null && imageIcon.getImageLoadStatus() == 8) {
                this.fillStyle.setImage(imageIcon.getImage());
            } else if (!bl) {
                throw new JCIOException("Image from URL " + uRL + " has incomplete load status!!!");
            }
        }
    }

    protected void handleGradient(Attributes attributes) {
        if (attributes == null || this.fillStyle == null) {
            return;
        }
        int n2 = attributes.getIndex("ribbonSize");
        if (n2 > -1) {
            int n3 = JCTypeConverter.toInt(attributes.getValue(n2), 10);
            this.fillStyle.setRibbonSize(Math.max(1, n3));
        }
        Color color = null;
        n2 = attributes.getIndex("color2");
        if (n2 > -1) {
            color = JCSwingTypeConverter.toColor(attributes.getValue(n2));
        }
        int n4 = 0;
        n2 = attributes.getIndex("style");
        if (n2 > -1) {
            String[] stringArray = JCStyleEnumMappings.gradientStyle_strings;
            int[] nArray = JCStyleEnumMappings.gradientStyle_values;
            n4 = JCTypeConverter.toEnum(attributes.getValue(n2), "gradientStyle", stringArray, nArray, this.fillStyle.getGradientStyle());
        }
        this.fillStyle.setGradientPaint(this.fillStyle.getColor(), color, n4);
    }

    protected void handleImagePosition(Attributes attributes) {
        if (attributes == null || this.fillStyle == null) {
            return;
        }
        String string = null;
        int n2 = attributes.getIndex("x");
        if (n2 > -1) {
            string = attributes.getValue(n2);
        }
        String string2 = null;
        n2 = attributes.getIndex("y");
        if (n2 > -1) {
            string2 = attributes.getValue(n2);
        }
        int n3 = JCTypeConverter.toInt(string, 0);
        int n4 = JCTypeConverter.toInt(string2, 0);
        this.fillStyle.setImagePosition(new Point(n3, n4));
    }

    protected void handleSymbolStyle(Attributes attributes) {
        Object object;
        if (attributes == null || this.symbolStyle == null) {
            return;
        }
        int n2 = attributes.getIndex("shape");
        if (n2 > -1) {
            object = JCChart3dEnumMappings.shape_strings;
            int[] nArray = JCChart3dEnumMappings.shape_indicies;
            int n3 = JCTypeConverter.toEnum(attributes.getValue(n2), "symbolShape", object, nArray, 0);
            this.symbolStyle.setShapeByIndex(n3);
        }
        if ((n2 = attributes.getIndex("color")) > -1) {
            object = JCSwingTypeConverter.toColor(attributes.getValue(n2), this.symbolStyle.getColor());
            this.symbolStyle.setColor((Color)object);
        }
        if ((n2 = attributes.getIndex("size")) > -1) {
            this.symbolStyle.setSize(JCTypeConverter.toInt(attributes.getValue(n2), this.symbolStyle.getSize()));
        }
    }

    protected void handleGridColor(Attributes attributes) {
        if (attributes == null || this.gridColor == null) {
            return;
        }
        int n2 = attributes.getIndex("color");
        if (n2 > -1) {
            Color color = JCSwingTypeConverter.toColor(attributes.getValue(n2), this.gridColor.getColor());
            this.gridColor.setColor(color);
        }
    }

    protected void handleGridDataIndex(Attributes attributes) {
        int n2;
        if (attributes == null || this.gridColor == null) {
            return;
        }
        JCData3dGridIndex jCData3dGridIndex = this.gridColor.getDataIndex();
        int n3 = attributes.getIndex("x");
        if (n3 > -1) {
            n2 = this.getGridIndexValue(attributes.getValue(n3));
            jCData3dGridIndex.setX(n2);
        }
        if ((n3 = attributes.getIndex("y")) > -1) {
            n2 = this.getGridIndexValue(attributes.getValue(n3));
            jCData3dGridIndex.setY(n2);
        }
    }

    protected int getGridIndexValue(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("all")) {
            return -100;
        }
        return JCTypeConverter.toInt(string, -1);
    }

    public static void parseXMLSource(PropertyAccessModel propertyAccessModel, InputSource inputSource, boolean bl) throws IOException {
        if (propertyAccessModel == null || inputSource == null) {
            return;
        }
        Chart3dHandler chart3dHandler = new Chart3dHandler(propertyAccessModel);
        LoadProperties loadProperties = propertyAccessModel.getLoadProperties();
        if (inputSource.getSystemId() == null) {
            if (loadProperties != null) {
                inputSource.setSystemId(loadProperties.getLocalEntitySystemId());
            } else {
                inputSource.setSystemId("");
            }
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(bl);
        try {
            ErrorHandler errorHandler;
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(chart3dHandler);
            ErrorHandler errorHandler2 = errorHandler = loadProperties == null ? null : loadProperties.getXmlErrorHandler();
            if (errorHandler == null) {
                errorHandler = new JCXMLErrorPrinter();
            }
            xMLReader.setErrorHandler(errorHandler);
            xMLReader.setEntityResolver(new JCXMLDTDResolver("JCChart3d.dtd", chart3dHandler.getClass()));
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new JCParseException(sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JCParseException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
    }
}

