/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.property;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataModel;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dGridDataModel;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.Chart3dPointDataModel;
import com.klg.jclass.chart3d.Chart3dPointSeries;
import com.klg.jclass.chart3d.HoleValueChart3dDataModel;
import com.klg.jclass.chart3d.JCChart3dEnumMappings;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCGridColor;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.LabelledChart3dDataModel;
import com.klg.jclass.chart3d.LabelledChart3dGridDataModel;
import com.klg.jclass.chart3d.LabelledChart3dPointDataModel;
import com.klg.jclass.chart3d.data.XML3dDataHandler;
import com.klg.jclass.chart3d.property.PropertySaveFactory;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.io.JCIOException;
import com.klg.jclass.util.io.OutputDataProperties;
import com.klg.jclass.util.property.PropertyPersistorModel;
import com.klg.jclass.util.property.PropertySaveModel;
import com.klg.jclass.util.property.xml.JCXMLFilePersistor;
import com.klg.jclass.util.property.xml.JCXMLStringPersistor;
import java.awt.Color;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import javax.vecmath.Point3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart3dDataViewPropertySave
implements PropertySaveModel {
    protected Chart3dDataView dataView = null;
    protected Chart3dDataView defaultDataView = null;

    @Override
    public void setSource(Object object) {
        if (object instanceof Chart3dDataView) {
            this.dataView = (Chart3dDataView)object;
        }
    }

    @Override
    public void setDefault(Object object) {
        if (object instanceof Chart3dDataView) {
            this.defaultDataView = (Chart3dDataView)object;
        }
    }

    @Override
    public boolean checkProperties(PropertyPersistorModel propertyPersistorModel) {
        return true;
    }

    @Override
    public void saveProperties(PropertyPersistorModel propertyPersistorModel, String string, int n2) throws JCIOException {
        Serializable serializable2;
        if (this.dataView == null || this.defaultDataView == null) {
            System.out.println("FAILURE: No dataview set");
            return;
        }
        if (!this.checkProperties(propertyPersistorModel)) {
            return;
        }
        int n3 = propertyPersistorModel.writeBegin("chart3d-data-view", n2);
        String string2 = this.dataView.getName();
        propertyPersistorModel.writeProperty(string, "name", n3, string2 == null ? "Legend" : string2);
        String[] stringArray = JCChart3dEnumMappings.chartType_xml_strings;
        int[] nArray = JCChart3dEnumMappings.chartType_values;
        int n4 = this.dataView.getChartType();
        if (n4 != this.defaultDataView.getChartType()) {
            propertyPersistorModel.writeProperty(string, "chartType", n3, JCTypeConverter.fromEnum(n4, stringArray, nArray));
        }
        propertyPersistorModel.writeEnd(null, n2, true, true);
        int n5 = n2 + PropertySaveFactory.tabIncrement;
        this.saveDataSource(propertyPersistorModel, string, n5, true);
        this.saveDataSource(propertyPersistorModel, string, n5, false);
        PropertySaveFactory.save(propertyPersistorModel, this.dataView.getElevation(), this.defaultDataView.getElevation(), string + "elevation.", n2);
        PropertySaveFactory.save(propertyPersistorModel, this.dataView.getContour(), this.defaultDataView.getContour(), string + "contour.", n2);
        List<JCGridColor> list = this.dataView.getGridColors();
        if (this.gridColorListOK(list)) {
            propertyPersistorModel.writeBegin("grid-colors", n5);
            propertyPersistorModel.writeEnd(null, n5, true, true);
            serializable2 = new JCGridColor();
            for (JCGridColor serializable3 : list) {
                if (!this.gridColorOK(serializable3)) continue;
                PropertySaveFactory.save(propertyPersistorModel, serializable3, serializable2, string + "gridColor.", n5);
            }
            propertyPersistorModel.writeEnd("grid-colors", n5, true, false);
        }
        serializable2 = new JCChart3dStyle(new JCLineStyle(1, Color.black, 1), new JCSymbolStyle(JCSymbolStyle.getDefaultShape(null), Color.orange, 6));
        Chart3dData chart3dData = this.dataView.getElevationData();
        if (chart3dData instanceof Chart3dGridData) {
            Chart3dGridData chart3dGridData = (Chart3dGridData)chart3dData;
            JCChart3dStyle jCChart3dStyle = chart3dGridData.getChartStyle();
            if (jCChart3dStyle != null) {
                PropertySaveFactory.save(propertyPersistorModel, jCChart3dStyle, serializable2, string + "chart3dStyle0.", n2);
            }
        } else if (chart3dData instanceof Chart3dPointData) {
            Chart3dPointData chart3dPointData = (Chart3dPointData)chart3dData;
            List<Chart3dPointSeries> list2 = chart3dPointData.getSeries();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Chart3dPointSeries chart3dPointSeries = list2.get(i2);
                if (chart3dPointSeries == null) continue;
                JCChart3dStyle jCChart3dStyle = chart3dPointSeries.getChartStyle();
                PropertySaveFactory.save(propertyPersistorModel, jCChart3dStyle, serializable2, string + "chart3dStyle" + i2 + ".", n2);
            }
        }
        propertyPersistorModel.writeEnd("chart3d-data-view", n2, true, false);
    }

    protected boolean gridColorListOK(List<JCGridColor> list) {
        if (list == null) {
            return false;
        }
        boolean bl = false;
        for (JCGridColor jCGridColor : list) {
            if (!this.gridColorOK(jCGridColor)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean gridColorOK(JCGridColor jCGridColor) {
        if (jCGridColor == null) {
            return false;
        }
        if (jCGridColor.getColor() == null) {
            return false;
        }
        JCData3dGridIndex jCData3dGridIndex = jCGridColor.getDataIndex();
        if (jCData3dGridIndex.getX() < 0 && jCData3dGridIndex.getX() != -100) {
            return false;
        }
        return jCData3dGridIndex.getY() >= 0 || jCData3dGridIndex.getY() == -100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDataSource(PropertyPersistorModel propertyPersistorModel, String string, int n2, boolean bl) throws JCIOException {
        String string2;
        String string3;
        int n3;
        String string4;
        OutputDataProperties outputDataProperties;
        Chart3dData chart3dData;
        if (bl) {
            chart3dData = this.dataView.getElevationData();
            outputDataProperties = this.dataView.getElevationDataOutputDataProperties();
            string4 = "elevation-data";
        } else {
            chart3dData = this.dataView.getZoneData();
            outputDataProperties = this.dataView.getZoneDataOutputDataProperties();
            string4 = "zone-data";
        }
        if (chart3dData == null || !chart3dData.isDataOK()) {
            return;
        }
        if (outputDataProperties == null) {
            outputDataProperties = new OutputDataProperties(null, null, null, 0);
        }
        if ((n3 = outputDataProperties.getSaveTypeAsEnum()) == 0) {
            return;
        }
        LabelledChart3dDataModel labelledChart3dDataModel = chart3dData instanceof Chart3dGridData ? new TempGridData((Chart3dGridData)chart3dData) : new TempPointData((Chart3dPointData)chart3dData);
        int n4 = PropertySaveFactory.tabIncrement;
        propertyPersistorModel.writeBegin(string4, n2);
        propertyPersistorModel.writeEnd(string4, n2, true, true);
        if (n3 == 1) {
            this.saveEmbededData(propertyPersistorModel, outputDataProperties, n2 + n4, (Chart3dDataModel)((Object)labelledChart3dDataModel));
            propertyPersistorModel.writeEnd(string4, n2, true, false);
            return;
        }
        if (n3 == 2) {
            if (!outputDataProperties.ignoreExternalResourceExceptions()) {
                throw new JCIOException("Saving data in text format not supported");
            }
            outputDataProperties.setSaveType(3);
        }
        String string5 = string3 = (string2 = outputDataProperties.getOutputFileName()) == null ? null : string2.trim();
        if (string3 != null && string3.length() > 0) {
            String string6 = ".xml";
            if (!string3.endsWith(string6)) {
                string3 = string3 + string6;
            }
            OutputStreamWriter outputStreamWriter = null;
            try {
                DataOutputStream dataOutputStream;
                block28: {
                    FileOutputStream fileOutputStream = new FileOutputStream(string3);
                    dataOutputStream = new DataOutputStream(fileOutputStream);
                    String string7 = outputDataProperties.getFileCharset();
                    if (string7 != null) {
                        try {
                            outputStreamWriter = new OutputStreamWriter((OutputStream)dataOutputStream, string7);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            if (!string7.equals("JISAutoDetect")) {
                                throw unsupportedEncodingException;
                            }
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            if (string7.equals("JISAutoDetect")) break block28;
                            throw unsupportedOperationException;
                        }
                    }
                }
                if (outputStreamWriter == null) {
                    outputStreamWriter = new OutputStreamWriter(dataOutputStream);
                }
                XML3dDataHandler.writeDataToXML(labelledChart3dDataModel, outputStreamWriter, 0, n4, true);
            }
            catch (IOException iOException) {
                if (!outputDataProperties.ignoreExternalResourceExceptions()) {
                    throw new JCIOException(iOException.getMessage(), iOException);
                }
            }
            finally {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        this.saveDataFileProperties(propertyPersistorModel, string, n2 + n4, outputDataProperties);
        propertyPersistorModel.writeEnd(string4, n2, true, false);
    }

    protected void saveEmbededData(PropertyPersistorModel propertyPersistorModel, OutputDataProperties outputDataProperties, int n2, Chart3dDataModel chart3dDataModel) throws JCIOException {
        block8: {
            int n3 = PropertySaveFactory.tabIncrement;
            try {
                if (propertyPersistorModel instanceof JCXMLFilePersistor) {
                    JCXMLFilePersistor jCXMLFilePersistor = (JCXMLFilePersistor)propertyPersistorModel;
                    Writer writer = jCXMLFilePersistor.getWriter();
                    if (writer != null) {
                        XML3dDataHandler.writeDataToXML(chart3dDataModel, writer, n2, n3, false);
                    } else {
                        OutputStream outputStream = jCXMLFilePersistor.getOutputStream();
                        if (outputStream != null) {
                            XML3dDataHandler.writeDataToXML(chart3dDataModel, outputStream, n2, n3, false);
                        }
                    }
                } else if (propertyPersistorModel instanceof JCXMLStringPersistor) {
                    JCXMLStringPersistor jCXMLStringPersistor = (JCXMLStringPersistor)propertyPersistorModel;
                    XML3dDataHandler.writeDataToXML(chart3dDataModel, jCXMLStringPersistor.getStringBuffer(), n2, n3, false);
                }
            }
            catch (IOException iOException) {
                if (outputDataProperties.ignoreExternalResourceExceptions()) break block8;
                throw new JCIOException(iOException.getMessage(), iOException);
            }
        }
    }

    protected void saveDataFileProperties(PropertyPersistorModel propertyPersistorModel, String string, int n2, OutputDataProperties outputDataProperties) {
        String string2 = propertyPersistorModel.expandText(outputDataProperties.getPropertyName());
        if (string2 != null) {
            int n3 = propertyPersistorModel.writeBegin("chart3d-data-file", n2 + PropertySaveFactory.tabIncrement);
            propertyPersistorModel.writeProperty(string, "fileName", n3, string2);
            propertyPersistorModel.writeProperty(string, "fileType", n3, outputDataProperties.getSaveType());
            String string3 = outputDataProperties.getFileAccessStringFromEnum(outputDataProperties.getFileAccess(), false);
            propertyPersistorModel.writeProperty(string, "fileAccess", n3, string3);
            String string4 = outputDataProperties.getFileCharset();
            if (!string4.equals("JISAutoDetect")) {
                propertyPersistorModel.writeProperty(string, "fileCharset", n3, string4);
            }
            propertyPersistorModel.writeEnd(null, n2, true, false);
        }
    }

    public class TempPointData
    implements Chart3dPointDataModel,
    LabelledChart3dPointDataModel,
    HoleValueChart3dDataModel {
        protected Chart3dPointData pointData = null;

        public TempPointData(Chart3dPointData chart3dPointData) {
            this.pointData = chart3dPointData;
        }

        public Point3d[][] getPoints() {
            List<Chart3dPointSeries> list = this.pointData.getSeries();
            if (list != null) {
                int n2 = list.size();
                Point3d[][] point3dArray = new Point3d[n2][];
                for (int i2 = 0; i2 < n2; ++i2) {
                    Chart3dPointSeries chart3dPointSeries = list.get(i2);
                    if (chart3dPointSeries == null) continue;
                    point3dArray[i2] = chart3dPointSeries.getPoints();
                }
                return point3dArray;
            }
            return null;
        }

        public int getNumSeries() {
            return this.pointData.getNumSeries();
        }

        public String[] getSeriesLabels() {
            List<Chart3dPointSeries> list = this.pointData.getSeries();
            if (list != null) {
                int n2 = list.size();
                String[] stringArray = new String[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    Chart3dPointSeries chart3dPointSeries = list.get(i2);
                    if (chart3dPointSeries == null) continue;
                    stringArray[i2] = chart3dPointSeries.getLabel();
                }
                return stringArray;
            }
            return null;
        }

        public String getDataSourceName() {
            return this.pointData.getName();
        }

        public double getHoleValue() {
            return this.pointData.getHoleValue();
        }
    }

    public class TempGridData
    implements Chart3dGridDataModel,
    LabelledChart3dGridDataModel,
    HoleValueChart3dDataModel {
        protected Chart3dGridData gridData = null;

        public TempGridData(Chart3dGridData chart3dGridData) {
            this.gridData = chart3dGridData;
        }

        public double[] getXGrid() {
            return this.gridData.getXGrid();
        }

        public double[] getYGrid() {
            return this.gridData.getYGrid();
        }

        public double[][] getZValues() {
            return this.gridData.getZValues();
        }

        public String[] getXLabels() {
            return this.gridData.getXLabels();
        }

        public String[] getYLabels() {
            return this.gridData.getYLabels();
        }

        public int getNumX() {
            return this.gridData.getNumX();
        }

        public int getNumY() {
            return this.gridData.getNumY();
        }

        public String getDataSourceName() {
            return this.gridData.getName();
        }

        public double getHoleValue() {
            return this.gridData.getHoleValue();
        }
    }
}

