/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.property;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataModel;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dGridDataModel;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.Chart3dPointSeries;
import com.klg.jclass.chart3d.JCChart3dEnumMappings;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.data.Base3dDataSource;
import com.klg.jclass.chart3d.data.JCData3dUtil;
import com.klg.jclass.chart3d.data.JCFile3dDataSource;
import com.klg.jclass.chart3d.property.PropertyLoadFactory;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.io.JCIOException;
import com.klg.jclass.util.io.LoadProperties;
import com.klg.jclass.util.io.OutputDataProperties;
import com.klg.jclass.util.property.FilePropertyAccessModel;
import com.klg.jclass.util.property.PropertyAccessModel;
import com.klg.jclass.util.property.PropertyLoadModel;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;

public class Chart3dDataViewPropertyLoad
implements PropertyLoadModel {
    protected Chart3dDataView dataView = null;

    public void setSource(Object object) {
        if (object instanceof Chart3dDataView) {
            this.dataView = (Chart3dDataView)object;
        }
    }

    public void loadProperties(PropertyAccessModel propertyAccessModel, String string) throws JCIOException {
        if (this.dataView == null) {
            System.out.println("FAILURE: No dataView set");
            return;
        }
        this.loadDataSource(propertyAccessModel, string + "elevationData.");
        this.loadDataSource(propertyAccessModel, string + "zoneData.");
        String string2 = propertyAccessModel.getProperty(string + "name");
        if (string2 != null) {
            this.dataView.setName(string2);
        }
        String[] stringArray = JCChart3dEnumMappings.chartType_xml_strings;
        int[] nArray = JCChart3dEnumMappings.chartType_values;
        string2 = propertyAccessModel.getProperty(string + "chartType");
        if (string2 != null) {
            int n2 = JCTypeConverter.toEnum(string2, "chartType", stringArray, nArray, this.dataView.getChartType());
            this.dataView.setChartType(n2);
        }
        PropertyLoadFactory.load(propertyAccessModel, this.dataView.getElevation(), string + "elevation.");
        PropertyLoadFactory.load(propertyAccessModel, this.dataView.getContour(), string + "contour.");
        Object object = propertyAccessModel.getPropertyObject(string + "gridColors");
        if (object != null) {
            this.dataView.setGridColors((List)object);
        }
        if ((object = propertyAccessModel.getPropertyObject(string + "chart3dStyles")) != null) {
            List list = (List)object;
            Chart3dData chart3dData = this.dataView.getElevationData();
            if (chart3dData instanceof Chart3dGridData) {
                Chart3dGridData chart3dGridData = (Chart3dGridData)chart3dData;
                if (list.size() > 0) {
                    chart3dGridData.setChartStyle((JCChart3dStyle)list.get(0));
                }
            } else if (chart3dData instanceof Chart3dPointData) {
                Chart3dPointData chart3dPointData = (Chart3dPointData)chart3dData;
                List<Chart3dPointSeries> list2 = chart3dPointData.getSeries();
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    Chart3dPointSeries chart3dPointSeries = list2.get(i2);
                    if (chart3dPointSeries == null || i2 >= list.size()) continue;
                    chart3dPointSeries.setChartStyle((JCChart3dStyle)list.get(i2));
                }
            }
        }
    }

    protected void loadDataSource(PropertyAccessModel propertyAccessModel, String string) throws JCIOException {
        boolean bl;
        String string2;
        String string3;
        OutputDataProperties outputDataProperties;
        LoadProperties loadProperties;
        Chart3dDataModel chart3dDataModel;
        block16: {
            chart3dDataModel = null;
            Object object = propertyAccessModel.getPropertyObject(string + "data");
            loadProperties = propertyAccessModel.getLoadProperties();
            outputDataProperties = new OutputDataProperties();
            string3 = "None";
            try {
                if (object == null) {
                    string2 = propertyAccessModel.getProperty(string + "dataFile");
                    if (string2 != null) {
                        string3 = propertyAccessModel.getProperty(string + "dataFileType");
                        if (string3 == null) {
                            string3 = "Xml";
                        } else if (!string3.equalsIgnoreCase("Xml")) {
                            string3 = "Text";
                        }
                        chart3dDataModel = this.getDataFromName(propertyAccessModel, string, string3.equalsIgnoreCase("Xml"), string2, outputDataProperties);
                    }
                } else {
                    if (object instanceof Chart3dDataModel) {
                        chart3dDataModel = (Chart3dDataModel)object;
                    }
                    string3 = "Embed";
                }
            }
            catch (JCIOException jCIOException) {
                if (loadProperties.ignoreExternalResourceExceptions()) break block16;
                throw jCIOException;
            }
        }
        outputDataProperties.setSaveType(string3);
        if (chart3dDataModel == null) {
            return;
        }
        string2 = string.substring(0, string.lastIndexOf("."));
        int n2 = string2.lastIndexOf(".");
        if (n2 >= 0) {
            string2 = string2.substring(n2 + 1);
        }
        boolean bl2 = bl = !string2.equals("zoneData");
        if (bl) {
            this.dataView.setElevationDataSource(chart3dDataModel);
            this.dataView.setElevationDataOutputDataProperties(outputDataProperties);
        } else if (chart3dDataModel instanceof Chart3dGridDataModel) {
            this.dataView.setZoneDataSource((Chart3dGridDataModel)chart3dDataModel);
            this.dataView.setZoneDataOutputDataProperties(outputDataProperties);
        } else if (!loadProperties.ignoreExternalResourceExceptions()) {
            throw new JCIOException("Zone data must be grid data");
        }
    }

    protected Chart3dDataModel getDataFromName(PropertyAccessModel propertyAccessModel, String string, boolean bl, String string2, OutputDataProperties outputDataProperties) throws JCIOException {
        String string3 = propertyAccessModel.getProperty(string + "dataFileCharset");
        string3 = string3 == null ? "JISAutoDetect" : string3;
        outputDataProperties.setFileCharset(string3);
        Base3dDataSource base3dDataSource = null;
        if (propertyAccessModel instanceof FilePropertyAccessModel) {
            FilePropertyAccessModel filePropertyAccessModel = (FilePropertyAccessModel)((Object)propertyAccessModel);
            InputStream inputStream = filePropertyAccessModel.getFilePropertyStream(string + "data", outputDataProperties);
            if (inputStream != null) {
                try {
                    Reader reader = JCFile3dDataSource.createReaderFromInputStream(inputStream, string3);
                    if (bl) {
                        LoadProperties loadProperties = propertyAccessModel.getLoadProperties();
                        base3dDataSource = JCData3dUtil.createXMLDataSource(reader, loadProperties, true, null);
                    } else {
                        base3dDataSource = JCFile3dDataSource.createDataSourceFromReader(reader);
                    }
                    inputStream.close();
                }
                catch (Exception exception) {
                    throw new JCIOException(exception.getMessage(), exception);
                }
            }
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                Reader reader = JCFile3dDataSource.createReaderFromInputStream(fileInputStream, string3);
                base3dDataSource = JCFile3dDataSource.createDataSourceFromReader(reader);
            }
            catch (Exception exception) {
                throw new JCIOException(exception.getMessage(), exception);
            }
            outputDataProperties.setPropertyName(string2);
            outputDataProperties.setFileAccess(1);
        }
        return base3dDataSource;
    }
}

