/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j2d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Draw;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.j2d.MapPick;
import java.awt.Point;
import java.awt.Rectangle;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

public class MapPickGrid
extends MapPick {
    public static final double T_EPSILON = 1.0E-10;

    public MapPickGrid() {
    }

    public MapPickGrid(Chart3dData chart3dData) {
        super(chart3dData);
    }

    protected boolean findClosestPoint(int n2, int n3, JCData3dGridIndex jCData3dGridIndex) {
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        if (chart3dGridData == null || !chart3dGridData.isDataOK() || jCData3dGridIndex == null) {
            return false;
        }
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        ScreenPoint[][] screenPointArray = this.getScreenPoints();
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        Rectangle rectangle = jCChart3dArea.getDrawingArea();
        double d2 = Double.MAX_VALUE;
        for (int i2 = gridLimits.getXOffset(); i2 <= gridLimits.getXLast(); ++i2) {
            for (int i3 = gridLimits.getYOffset(); i3 <= gridLimits.getYLast(); ++i3) {
                int n4;
                ScreenPoint screenPoint = screenPointArray[i2][i3];
                if (screenPoint.isHoleValue() || screenPoint.isHidden()) continue;
                int n5 = screenPoint.getXPixel();
                if (rectangle.contains(n5, n4 = screenPoint.getYPixel())) {
                    double d3 = this.calcDist(n2, n3, n5, n4);
                    if (!(d3 <= d2)) continue;
                    d2 = d3;
                    jCData3dGridIndex.setDistance(d3);
                    jCData3dGridIndex.setX(i2);
                    jCData3dGridIndex.setY(i3);
                    continue;
                }
                screenPoint.setHidden(true);
            }
        }
        return d2 != Double.MAX_VALUE;
    }

    public Point3d map(int n2, int n3) {
        if (!(this.data instanceof Chart3dGridData)) {
            return null;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        if (!chart3dGridData.isDataOK()) {
            return null;
        }
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        Point3d point3d = new Point3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        if (chart3dDataView.getChart3d().isProjection()) {
            GridLimits gridLimits = chart3dGridData.getGridLimits();
            double d2 = chart3dGridData.getX(gridLimits.getXOffset());
            double d3 = chart3dGridData.getX(gridLimits.getXLast());
            double d4 = chart3dGridData.getY(gridLimits.getYOffset());
            double d5 = chart3dGridData.getY(gridLimits.getYLast());
            Rectangle rectangle = this.interpolateXY(n2, n3, d2, d4, d3, d5, point3d);
            if (n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width && n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height) {
                int n4 = chart3dGridData.getPointIndex(point3d.x, chart3dGridData.getXGrid(), chart3dGridData.getNumX());
                int n5 = chart3dGridData.getPointIndex(point3d.y, chart3dGridData.getYGrid(), chart3dGridData.getNumY());
                if (n4 + 1 == chart3dGridData.getNumX()) {
                    --n4;
                }
                if (n5 + 1 == chart3dGridData.getNumY()) {
                    --n5;
                }
                point3d.z = !JCChart3dUtil.holeInFacet(chart3dGridData, n4, n5) ? JCChart3dUtil.biLinearInterp(chart3dGridData, n4, n5, point3d.x, point3d.y) : chart3dGridData.getHoleValue();
            } else {
                point3d.set(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            }
        } else {
            Transform transform = jCChart3dArea.getTransform();
            Point4d point4d = transform.computeEyePosition();
            Point4d point4d2 = new Point4d(n2, n3, 0.0, 1.0);
            Transform.transformPoint(transform.getInverseScreen(), point4d2);
            Transform.transformPoint(transform.getInverseRotation(), point4d2);
            Point4d point4d3 = new Point4d();
            Draw draw = chart3dDataView.getDraw();
            if (!(draw instanceof DrawGrid)) {
                return null;
            }
            DrawGrid drawGrid = (DrawGrid)draw;
            JCData3dGridIndex jCData3dGridIndex = new JCData3dGridIndex(chart3dDataView, -1, -1);
            boolean bl = drawGrid.gridSurfaceIntersect(point4d, point4d2, point4d3, jCData3dGridIndex);
            if (bl) {
                Transform.transformPoint(transform.getInverseAbsolute(), point4d3);
                point3d.project(point4d3);
            }
        }
        return point3d;
    }

    protected boolean gridPointSelect(int n2, int n3, JCData3dGridIndex jCData3dGridIndex) {
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        Transform transform = jCChart3dArea.getTransform();
        ScreenPoint[][] screenPointArray = this.getScreenPoints();
        Draw draw = chart3dDataView.getDraw();
        if (!(draw instanceof DrawGrid)) {
            return false;
        }
        DrawGrid drawGrid = (DrawGrid)draw;
        for (int i2 = gridLimits.getXOffset(); i2 <= gridLimits.getXLast(); ++i2) {
            for (int i3 = gridLimits.getYOffset(); i3 <= gridLimits.getYLast(); ++i3) {
                screenPointArray[i2][i3].setHidden(false);
            }
        }
        Point4d point4d = transform.computeEyePosition();
        Point4d point4d2 = new Point4d();
        JCData3dGridIndex jCData3dGridIndex2 = new JCData3dGridIndex();
        while (this.findClosestPoint(n2, n3, jCData3dGridIndex)) {
            int n4 = jCData3dGridIndex.getX();
            int n5 = jCData3dGridIndex.getY();
            Point4d point4d3 = drawGrid.findAbsolutePoint(chart3dGridData, transform.getAbsolute(), n4, n5);
            jCData3dGridIndex2.setDistance(Double.MAX_VALUE);
            boolean bl = drawGrid.gridSurfaceIntersect(point4d, point4d3, point4d2, jCData3dGridIndex2);
            double d2 = jCData3dGridIndex2.getDistance();
            if (bl && d2 >= 0.9999999999) {
                return true;
            }
            screenPointArray[n4][n5].setHidden(true);
        }
        return false;
    }

    public JCData3dIndex pick(int n2, int n3) {
        if (!(this.data instanceof Chart3dGridData)) {
            return null;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        if (!chart3dGridData.isDataOK()) {
            return null;
        }
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCData3dGridIndex jCData3dGridIndex = new JCData3dGridIndex(chart3dDataView, -1, -1);
        if (chart3dDataView.getChart3d().isProjection()) {
            this.findClosestPoint(n2, n3, jCData3dGridIndex);
        } else if (chart3dDataView.getChartType() == 1) {
            Transform transform = jCChart3dArea.getTransform();
            Point4d point4d = transform.computeEyePosition();
            Point4d point4d2 = new Point4d(n2, n3, 0.0, 1.0);
            Transform.transformPoint(transform.getInverseScreen(), point4d2);
            Transform.transformPoint(transform.getInverseRotation(), point4d2);
            Point4d point4d3 = new Point4d();
            Draw draw = chart3dDataView.getDraw();
            if (!(draw instanceof DrawGrid)) {
                return null;
            }
            DrawGrid drawGrid = (DrawGrid)draw;
            drawGrid.gridSurfaceIntersect(point4d, point4d2, point4d3, jCData3dGridIndex);
        } else if (!this.gridPointSelect(n2, n3, jCData3dGridIndex)) {
            jCData3dGridIndex.setX(-1);
            jCData3dGridIndex.setY(-1);
        }
        return jCData3dGridIndex;
    }

    public Point unpick(JCData3dIndex jCData3dIndex) {
        Point point = new Point(-1, -1);
        if (!(this.data instanceof Chart3dGridData) || !(jCData3dIndex instanceof JCData3dGridIndex)) {
            return point;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        JCData3dGridIndex jCData3dGridIndex = (JCData3dGridIndex)jCData3dIndex;
        if (!chart3dGridData.isDataOK()) {
            return point;
        }
        ScreenPoint[][] screenPointArray = this.getScreenPoints();
        int n2 = jCData3dGridIndex.getX();
        int n3 = jCData3dGridIndex.getY();
        if (n2 >= 0 && n2 < chart3dGridData.getNumX() && n3 >= 0 && n3 < chart3dGridData.getNumY()) {
            ScreenPoint screenPoint = screenPointArray[n2][n3];
            point.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
        }
        jCData3dIndex.setDistance(0.0);
        return point;
    }
}

