/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j2d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.Mapping;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.j2d.MapPickGrid;
import com.klg.jclass.chart3d.j2d.MapPickPoint;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

public class MapPick
implements Mapping,
Serializable {
    protected Chart3dData data = null;

    public MapPick() {
    }

    public MapPick(Chart3dData chart3dData) {
        this.data = chart3dData;
    }

    protected double calcDist(int n2, int n3, int n4, int n5) {
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        int n8 = n6 * n6 + n7 * n7;
        return Math.sqrt(n8);
    }

    protected Rectangle interpolateXY(int n2, int n3, double d2, double d3, double d4, double d5, Point3d point3d) {
        if (this.data == null || !this.data.isDataOK()) {
            return null;
        }
        JCChart3dArea jCChart3dArea = this.data.getDataView().getChart3d().getChart3dArea();
        Transform transform = jCChart3dArea.getTransform();
        Point4d point4d = new Point4d(d2, d3, 0.0, 1.0);
        Point4d point4d2 = new Point4d(d4, d5, 0.0, 1.0);
        Transform.transformPoint(transform.getView(), point4d);
        int n4 = (int)Math.round(point4d.x);
        int n5 = (int)Math.round(point4d.y);
        Transform.transformPoint(transform.getView(), point4d2);
        int n6 = (int)Math.round(point4d2.x);
        int n7 = (int)Math.round(point4d2.y);
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        point3d.x = (double)(n2 - n4) * d6 / (double)(n6 - n4) + d2;
        point3d.y = (double)(n5 - n3) * d7 / (double)(n5 - n7) + d3;
        return new Rectangle(Math.min(n4, n6), Math.min(n5, n7), Math.abs(n6 - n4), Math.abs(n7 - n5));
    }

    protected ScreenPoint[][] getScreenPoints() {
        if (this.data == null) {
            return null;
        }
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        if (screenPointArray == null) {
            this.data.precomputePoints();
            screenPointArray = this.data.getScreenPoints();
        }
        return screenPointArray;
    }

    public Point3d map(int n2, int n3) {
        return null;
    }

    public Point unmap(Point3d point3d) {
        if (this.data == null || !this.data.isDataOK()) {
            return null;
        }
        JCChart3dArea jCChart3dArea = this.data.getDataView().getChart3d().getChart3dArea();
        Transform transform = jCChart3dArea.getTransform();
        Point4d point4d = new Point4d(point3d.x, point3d.y, point3d.z, 1.0);
        Transform.transformPoint(transform.getView(), point4d);
        return new Point((int)Math.round(point4d.x), (int)Math.round(point4d.y));
    }

    public JCData3dIndex pick(int n2, int n3) {
        return null;
    }

    public Point unpick(JCData3dIndex jCData3dIndex) {
        return null;
    }

    public Chart3dData getData() {
        return this.data;
    }

    public Mapping createMapping(Chart3dData chart3dData) {
        if (chart3dData == null) {
            return null;
        }
        if (chart3dData instanceof Chart3dGridData) {
            return new MapPickGrid(chart3dData);
        }
        if (chart3dData instanceof Chart3dPointData) {
            return new MapPickPoint(chart3dData);
        }
        return null;
    }
}

