/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.data;

import com.klg.jclass.chart3d.data.Base3dDataSource;
import com.klg.jclass.chart3d.data.JCEditable3dGridDataSource;
import com.klg.jclass.chart3d.data.JCEditable3dPointDataSource;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import javax.vecmath.Point3d;

public class JCFile3dDataSource {
    protected static StreamTokenizer streamTokenizer = null;

    public static Base3dDataSource createDataSourceFromFile(String string) {
        Base3dDataSource base3dDataSource = null;
        try {
            FileReader fileReader = new FileReader(string);
            streamTokenizer = new StreamTokenizer(fileReader);
            base3dDataSource = JCFile3dDataSource.parseFile();
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return base3dDataSource;
    }

    public static Base3dDataSource createDataSourceFromInputStream(InputStream inputStream) {
        Reader reader;
        try {
            reader = JCFile3dDataSource.createReaderFromInputStream(inputStream, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return JCFile3dDataSource.createDataSourceFromReader(reader);
    }

    public static Base3dDataSource createDataSourceFromReader(Reader reader) {
        Base3dDataSource base3dDataSource = null;
        try {
            streamTokenizer = new StreamTokenizer(reader);
            base3dDataSource = JCFile3dDataSource.parseFile();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return base3dDataSource;
    }

    public static Reader createReaderFromInputStream(InputStream inputStream, String string) throws IOException {
        BufferedReader bufferedReader;
        if (string == null) {
            string = "JISAutoDetect";
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (string.equals("JISAutoDetect")) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
            throw unsupportedEncodingException;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (string.equals("JISAutoDetect")) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
            throw unsupportedOperationException;
        }
        return bufferedReader;
    }

    protected static Base3dDataSource parseFile() throws IOException {
        Base3dDataSource base3dDataSource = null;
        streamTokenizer.commentChar(35);
        streamTokenizer.parseNumbers();
        streamTokenizer.eolIsSignificant(false);
        while (JCFile3dDataSource.streamTokenizer.sval == null) {
            streamTokenizer.nextToken();
        }
        String string = JCFile3dDataSource.streamTokenizer.sval;
        if (string.equals("GRID")) {
            base3dDataSource = JCFile3dDataSource.parseGrid();
        } else if (string.equals("IGRID")) {
            base3dDataSource = JCFile3dDataSource.parseIGrid();
        } else if (string.equals("POINT")) {
            base3dDataSource = JCFile3dDataSource.parsePoint();
        } else {
            System.out.println("Unknown datatype");
        }
        return base3dDataSource;
    }

    protected static JCEditable3dPointDataSource parsePoint() throws IOException {
        while (JCFile3dDataSource.streamTokenizer.nval == 0.0) {
            streamTokenizer.nextToken();
        }
        int n2 = (int)JCFile3dDataSource.streamTokenizer.nval;
        Point3d[][] point3dArray = new Point3d[n2][];
        streamTokenizer.nextToken();
        String[] stringArray = null;
        if (JCFile3dDataSource.streamTokenizer.sval != null) {
            stringArray = new String[n2];
            int n3 = 0;
            while (JCFile3dDataSource.streamTokenizer.sval != null) {
                stringArray[n3++] = JCFile3dDataSource.streamTokenizer.sval;
                streamTokenizer.nextToken();
            }
        }
        double d2 = JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = (int)JCFile3dDataSource.streamTokenizer.nval;
            streamTokenizer.nextToken();
            Point3d[] point3dArray2 = new Point3d[n4];
            for (int i3 = 0; i3 < n4; ++i3) {
                Point3d point3d;
                double d3 = JCFile3dDataSource.streamTokenizer.nval;
                streamTokenizer.nextToken();
                double d4 = JCFile3dDataSource.streamTokenizer.nval;
                streamTokenizer.nextToken();
                double d5 = JCFile3dDataSource.streamTokenizer.nval;
                point3dArray2[i3] = point3d = new Point3d(d3, d4, d5);
                streamTokenizer.nextToken();
            }
            point3dArray[i2] = point3dArray2;
        }
        JCEditable3dPointDataSource jCEditable3dPointDataSource = new JCEditable3dPointDataSource(null, point3dArray);
        jCEditable3dPointDataSource.setHoleValue(d2);
        if (stringArray != null) {
            jCEditable3dPointDataSource.setSeriesLabels(stringArray);
        }
        return jCEditable3dPointDataSource;
    }

    protected static JCEditable3dGridDataSource parseGrid() throws IOException {
        int n2;
        while (JCFile3dDataSource.streamTokenizer.nval == 0.0) {
            streamTokenizer.nextToken();
        }
        int n3 = (int)JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        String[] stringArray = null;
        if (JCFile3dDataSource.streamTokenizer.sval != null) {
            stringArray = new String[n3];
            n2 = 0;
            while (JCFile3dDataSource.streamTokenizer.sval != null) {
                stringArray[n2++] = JCFile3dDataSource.streamTokenizer.sval;
                streamTokenizer.nextToken();
            }
        }
        n2 = (int)JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        String[] stringArray2 = null;
        if (JCFile3dDataSource.streamTokenizer.sval != null) {
            stringArray2 = new String[n2];
            int n4 = 0;
            while (JCFile3dDataSource.streamTokenizer.sval != null) {
                stringArray2[n4++] = JCFile3dDataSource.streamTokenizer.sval;
                streamTokenizer.nextToken();
            }
        }
        double d2 = JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        double d3 = JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        double d4 = JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        double d5 = JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        double d6 = JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        double[] dArray = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = d5 + (double)i2 * d3;
        }
        double[] dArray2 = new double[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            dArray2[i3] = d6 + (double)i3 * d4;
        }
        double[][] dArray3 = new double[n3][n2];
        for (int i4 = 0; i4 < n3; ++i4) {
            for (int i5 = 0; i5 < n2; ++i5) {
                dArray3[i4][i5] = JCFile3dDataSource.streamTokenizer.nval;
                streamTokenizer.nextToken();
            }
        }
        JCEditable3dGridDataSource jCEditable3dGridDataSource = new JCEditable3dGridDataSource(null, dArray, dArray2, dArray3);
        jCEditable3dGridDataSource.setHoleValue(d2);
        if (stringArray != null) {
            jCEditable3dGridDataSource.setXLabels(stringArray);
        }
        if (stringArray2 != null) {
            jCEditable3dGridDataSource.setYLabels(stringArray2);
        }
        return jCEditable3dGridDataSource;
    }

    protected static JCEditable3dGridDataSource parseIGrid() throws IOException {
        int n2;
        while (JCFile3dDataSource.streamTokenizer.nval == 0.0) {
            streamTokenizer.nextToken();
        }
        int n3 = (int)JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        String[] stringArray = null;
        if (JCFile3dDataSource.streamTokenizer.sval != null) {
            stringArray = new String[n3];
            n2 = 0;
            while (JCFile3dDataSource.streamTokenizer.sval != null) {
                stringArray[n2++] = JCFile3dDataSource.streamTokenizer.sval;
                streamTokenizer.nextToken();
            }
        }
        n2 = (int)JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        String[] stringArray2 = null;
        if (JCFile3dDataSource.streamTokenizer.sval != null) {
            stringArray2 = new String[n2];
            int n4 = 0;
            while (JCFile3dDataSource.streamTokenizer.sval != null) {
                stringArray2[n4++] = JCFile3dDataSource.streamTokenizer.sval;
                streamTokenizer.nextToken();
            }
        }
        double d2 = JCFile3dDataSource.streamTokenizer.nval;
        streamTokenizer.nextToken();
        double[] dArray = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = JCFile3dDataSource.streamTokenizer.nval;
            streamTokenizer.nextToken();
        }
        double[] dArray2 = new double[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            dArray2[i3] = JCFile3dDataSource.streamTokenizer.nval;
            streamTokenizer.nextToken();
        }
        double[][] dArray3 = new double[n3][n2];
        for (int i4 = 0; i4 < n3; ++i4) {
            for (int i5 = 0; i5 < n2; ++i5) {
                dArray3[i4][i5] = JCFile3dDataSource.streamTokenizer.nval;
                streamTokenizer.nextToken();
            }
        }
        JCEditable3dGridDataSource jCEditable3dGridDataSource = new JCEditable3dGridDataSource(null, dArray, dArray2, dArray3);
        jCEditable3dGridDataSource.setHoleValue(d2);
        if (stringArray != null) {
            jCEditable3dGridDataSource.setXLabels(stringArray);
        }
        if (stringArray2 != null) {
            jCEditable3dGridDataSource.setYLabels(stringArray2);
        }
        return jCEditable3dGridDataSource;
    }
}

