/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.data;

import com.klg.jclass.chart3d.Chart3dDataModel;
import com.klg.jclass.chart3d.Chart3dGridDataModel;
import com.klg.jclass.chart3d.HoleValueChart3dDataModel;
import com.klg.jclass.chart3d.data.Base3dDataSource;
import com.klg.jclass.chart3d.data.Base3dGridDataSource;
import com.klg.jclass.chart3d.data.XML3dDataHandler;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.io.JCParseException;
import com.klg.jclass.util.io.LoadProperties;
import com.klg.jclass.util.xml.JCXMLDTDResolver;
import com.klg.jclass.util.xml.JCXMLErrorPrinter;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import javax.swing.SwingConstants;
import javax.vecmath.Vector3d;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JCData3dUtil
implements SwingConstants {
    public static final int DATA_INTERPOLATE_LINEAR = 0;
    public static final int DATA_INTERPOLATE_CUBIC = 1;
    public static String DATA_DTD_NAME = "JCChart3dData.dtd";

    public static Chart3dGridDataModel createDataCopy(Chart3dGridDataModel chart3dGridDataModel) {
        Base3dGridDataSource base3dGridDataSource = new Base3dGridDataSource(null, chart3dGridDataModel.getXGrid(), chart3dGridDataModel.getYGrid(), chart3dGridDataModel.getZValues());
        return (Chart3dGridDataModel)base3dGridDataSource.clone();
    }

    public static void dataCopy(Chart3dGridDataModel chart3dGridDataModel, Chart3dGridDataModel chart3dGridDataModel2) {
        int n2;
        int n3 = JCData3dUtil.getSizeX(chart3dGridDataModel);
        int n4 = JCData3dUtil.getSizeY(chart3dGridDataModel);
        int n5 = JCData3dUtil.getSizeX(chart3dGridDataModel2);
        int n6 = JCData3dUtil.getSizeY(chart3dGridDataModel2);
        if (n3 != n5 || n4 != n6) {
            throw new IllegalArgumentException("X and Y array lengths in sourceand destination must match.");
        }
        double[] dArray = chart3dGridDataModel.getXGrid();
        double[] dArray2 = chart3dGridDataModel2.getXGrid();
        double[] dArray3 = chart3dGridDataModel.getYGrid();
        double[] dArray4 = chart3dGridDataModel2.getYGrid();
        double[][] dArray5 = chart3dGridDataModel.getZValues();
        double[][] dArray6 = chart3dGridDataModel2.getZValues();
        String string = "Z values array lengths must match";
        if (dArray5.length != dArray6.length) {
            throw new IllegalArgumentException(string);
        }
        for (n2 = 0; n2 < dArray5.length; ++n2) {
            if (dArray5[n2].length == dArray6[n2].length) continue;
            throw new IllegalArgumentException(string);
        }
        System.arraycopy(dArray, 0, dArray2, 0, n3);
        System.arraycopy(dArray3, 0, dArray4, 0, n4);
        for (n2 = 0; n2 < dArray5.length; ++n2) {
            int n7 = dArray5[n2].length;
            dArray6[n2] = new double[n7];
            System.arraycopy(dArray5[n2], 0, dArray6[n2], 0, n7);
        }
    }

    public static Chart3dGridDataModel createShadedDataModel(Chart3dGridDataModel chart3dGridDataModel, double d2, double d3, double d4, double d5) {
        Chart3dGridDataModel chart3dGridDataModel2;
        if (chart3dGridDataModel instanceof Base3dGridDataSource) {
            Object object = ((Base3dGridDataSource)chart3dGridDataModel).clone();
            chart3dGridDataModel2 = (Chart3dGridDataModel)object;
        } else {
            chart3dGridDataModel2 = JCData3dUtil.createDataCopy(chart3dGridDataModel);
        }
        JCData3dUtil.createShadedDataModel(chart3dGridDataModel, chart3dGridDataModel2, d2, d3, d4, d5);
        return chart3dGridDataModel2;
    }

    public static void createShadedDataModel(Chart3dGridDataModel chart3dGridDataModel, Chart3dGridDataModel chart3dGridDataModel2, double d2, double d3, double d4, double d5) {
        if (JCData3dUtil.getSizeX(chart3dGridDataModel) < 2 || JCData3dUtil.getSizeY(chart3dGridDataModel) < 2) {
            throw new IllegalArgumentException("Grid size must be atleast 2x2 to construct a shaded model.");
        }
        d3 = Math.toRadians(d3);
        d2 = Math.toRadians(d2);
        d4 = JCNumberUtil.clamp(d4, 0.0, 1.0);
        d5 = JCNumberUtil.clamp(d5, 0.0, 1.0);
        int n2 = JCData3dUtil.getSizeX(chart3dGridDataModel);
        int n3 = JCData3dUtil.getSizeY(chart3dGridDataModel);
        double d6 = Math.cos(d3);
        double d7 = Math.sin(d3);
        double d8 = d6 * Math.cos(d2);
        double d9 = d6 * Math.sin(d2);
        double d10 = 1.0 - d5;
        double d11 = JCData3dUtil.getHoleValue(chart3dGridDataModel);
        double d12 = JCData3dUtil.getHoleValue(chart3dGridDataModel2);
        double[] dArray = new double[n2 - 1];
        double[] dArray2 = new double[n3 - 1];
        Vector3d vector3d = new Vector3d(d9, d8, d7);
        Vector3d vector3d2 = new Vector3d();
        double[] dArray3 = chart3dGridDataModel.getXGrid();
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            dArray[i2] = dArray3[i2 + 1] - dArray3[i2];
        }
        double[] dArray4 = chart3dGridDataModel.getYGrid();
        for (int i3 = 0; i3 < n3 - 1; ++i3) {
            dArray2[i3] = dArray4[i3 + 1] - dArray4[i3];
        }
        double[][] dArray5 = chart3dGridDataModel.getZValues();
        double[][] dArray6 = chart3dGridDataModel2.getZValues();
        for (int i4 = 0; i4 < n2; ++i4) {
            int n4;
            int n5;
            if (i4 < n2 - 1) {
                n5 = i4;
                n4 = i4 + 1;
            } else {
                n5 = i4 - 1;
                n4 = i4;
            }
            for (int i5 = 0; i5 < n3; ++i5) {
                int n6;
                int n7;
                if (i5 < n3 - 1) {
                    n7 = i5;
                    n6 = i5 + 1;
                } else {
                    n7 = i5 - 1;
                    n6 = i5;
                }
                double d13 = dArray5[i4][n7] == d11 || dArray5[i4][n6] == d11 ? d11 : dArray5[i4][n6] - dArray5[i4][n7];
                double d14 = dArray5[n5][i5] == d11 || dArray5[n4][i5] == d11 ? d11 : dArray5[n4][i5] - dArray5[n5][i5];
                if (d14 == d11 || d13 == d11) {
                    dArray6[i4][i5] = d12;
                    continue;
                }
                double d15 = d5;
                if (d5 < 1.0) {
                    vector3d2.set(-dArray2[n7] * d14, -dArray[n5] * d13, dArray[n5] * dArray2[n7]);
                    if (vector3d2.dot(vector3d) > 0.0) {
                        vector3d2.scale(1.0 / vector3d2.length());
                        d15 += d10 * vector3d2.dot(vector3d);
                    }
                }
                dArray6[i4][i5] = d15 *= d4;
            }
        }
    }

    public static Chart3dGridDataModel createSmoothedDataModel(Chart3dGridDataModel chart3dGridDataModel, double d2) {
        Chart3dGridDataModel chart3dGridDataModel2;
        if (chart3dGridDataModel instanceof Base3dGridDataSource) {
            Object object = ((Base3dGridDataSource)chart3dGridDataModel).clone();
            chart3dGridDataModel2 = (Chart3dGridDataModel)object;
        } else {
            chart3dGridDataModel2 = JCData3dUtil.createDataCopy(chart3dGridDataModel);
        }
        JCData3dUtil.createSmoothedDataModel(chart3dGridDataModel, chart3dGridDataModel2, d2);
        return chart3dGridDataModel2;
    }

    public static void createSmoothedDataModel(Chart3dGridDataModel chart3dGridDataModel, Chart3dGridDataModel chart3dGridDataModel2, double d2) {
        int n2;
        int n3 = JCData3dUtil.getSizeX(chart3dGridDataModel);
        int n4 = JCData3dUtil.getSizeY(chart3dGridDataModel);
        if (n3 < 2 || n4 < 2) {
            throw new IllegalArgumentException("Grid size must be atleast 2x2 to construct a weighted average model.");
        }
        if ((d2 = JCNumberUtil.clamp(d2, 0.0, 1.0)) == 1.0) {
            JCData3dUtil.dataCopy(chart3dGridDataModel, chart3dGridDataModel2);
            return;
        }
        double d3 = JCData3dUtil.getHoleValue(chart3dGridDataModel);
        double d4 = JCData3dUtil.getHoleValue(chart3dGridDataModel2);
        double[] dArray = chart3dGridDataModel.getXGrid();
        double[] dArray2 = chart3dGridDataModel.getYGrid();
        double[] dArray3 = new double[n3 - 1];
        double[] dArray4 = new double[n4 - 1];
        double[] dArray5 = new double[9];
        double[] dArray6 = new double[9];
        double[][] dArray7 = chart3dGridDataModel.getZValues();
        double[][] dArray8 = chart3dGridDataModel2.getZValues();
        for (int i2 = 0; i2 < n3 - 1; ++i2) {
            double d5 = dArray[i2 + 1] - dArray[i2];
            dArray3[i2] = d5 * d5;
        }
        for (n2 = 0; n2 < n4 - 1; ++n2) {
            double d6 = dArray[n2 + 1] - dArray2[n2];
            dArray4[n2] = d6 * d6;
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i4 = 0; i4 < n4; ++i4) {
                if (dArray7[i3][i4] == d3) {
                    dArray8[i3][i4] = d4;
                    continue;
                }
                Arrays.fill(dArray5, 0.0);
                Arrays.fill(dArray6, 0.0);
                n2 = 0;
                if (i3 > 0) {
                    n2 |= 7;
                    dArray5[7] = dArray3[i3 - 1];
                    dArray6[7] = dArray7[i3 - 1][i4];
                }
                if (i3 < n3 - 1) {
                    n2 |= 3;
                    dArray5[3] = dArray3[i3 + 1];
                    dArray6[3] = dArray7[i3 + 1][i4];
                }
                if (i4 > 0) {
                    n2 |= 5;
                    dArray5[5] = dArray4[i4 - 1];
                    dArray6[5] = dArray7[i3][i4 - 1];
                }
                if (i4 < n4 - 1) {
                    n2 |= 1;
                    dArray5[1] = dArray3[i3 + 1];
                    dArray6[1] = dArray7[i3][i4 + 1];
                }
                if ((n2 | 2) == 0) {
                    dArray5[2] = dArray5[1] + dArray5[3];
                    dArray6[2] = dArray7[i3 + 1][i4 + 1];
                }
                if ((n2 | 8) == 0) {
                    dArray5[8] = dArray5[1] + dArray5[7];
                    dArray6[8] = dArray7[i3 - 1][i4 + 1];
                }
                if ((n2 | 4) == 0) {
                    dArray5[4] = dArray5[5] + dArray5[3];
                    dArray6[4] = dArray7[i3 + 1][i4 - 1];
                }
                if ((n2 | 6) == 0) {
                    dArray5[6] = dArray5[5] + dArray5[7];
                    dArray6[6] = dArray7[i3 - 1][i4 - 1];
                }
                dArray6[0] = dArray7[i3][i4];
                dArray8[i3][i4] = JCData3dUtil.computeInverseWeightedAverage(dArray6, dArray5, d2, 0, d3);
            }
        }
    }

    public static double computeInverseWeightedAverage(double[] dArray, double[] dArray2, double d2, int n2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 1.0 - d2;
        for (int i2 = dArray.length - 1; i2 >= 0; --i2) {
            if (i2 == n2) continue;
            d4 += dArray[i2];
        }
        double d7 = d6 / d4;
        for (int i3 = dArray.length - 1; i3 >= 0; --i3) {
            if (i3 == n2) {
                d5 += d2 * dArray[n2];
                continue;
            }
            if (dArray[i3] == d3) continue;
            d5 += (d4 - dArray[i3]) * dArray[i3] * d7;
        }
        return d5;
    }

    public static int findInsertionIndex(double d2, double[] dArray) {
        if (d2 <= dArray[0]) {
            if (d2 == dArray[0]) {
                return 1;
            }
            return -1;
        }
        int n2 = dArray.length - 1;
        if (d2 >= dArray[n2]) {
            if (d2 == dArray[n2]) {
                return n2;
            }
            return -1;
        }
        int n3 = Arrays.binarySearch(dArray, d2);
        if (n3 < 0) {
            n3 = -(n3 + 1);
        }
        return n3;
    }

    public static int findInsertionIndex(double d2, double[] dArray, int n2) {
        int n3 = JCData3dUtil.findInsertionIndex(d2, dArray);
        if (n3 >= n2) {
            n3 = -1;
        }
        return n3;
    }

    public static void createLinearSplineCoefficients(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2) {
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            dArray3[i2] = dArray2[i2];
            dArray4[i2] = (dArray2[i2 + 1] - dArray2[i2]) / (dArray[i2 + 1] - dArray[i2]);
        }
    }

    public static void createCubicSplineCoefficients(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, int n2) {
        double d2;
        int n3;
        dArray3[0] = dArray2[0];
        dArray4[0] = JCData3dUtil.estimateInitialSlopeOfCurve(dArray[0], dArray2[0], dArray[1], dArray2[1], dArray[2], dArray2[2]);
        dArray5[0] = 0.0;
        dArray6[0] = 1.0;
        dArray4[--n2] = JCData3dUtil.estimateInitialSlopeOfCurve(dArray[n2], dArray2[n2], dArray[n2 - 1], dArray2[n2 - 1], dArray[n2 - 2], dArray2[n2 - 2]);
        for (n3 = 1; n3 <= n2; ++n3) {
            dArray3[n3] = dArray2[n3];
            dArray5[n3] = dArray[n3] - dArray[n3 - 1];
            dArray6[n3] = (dArray2[n3] - dArray2[n3 - 1]) / dArray5[n3];
        }
        for (n3 = 1; n3 < n2; ++n3) {
            dArray4[n3] = 3.0 * (dArray5[n3] * dArray6[n3 + 1] + dArray5[n3 + 1] * dArray6[n3]);
            dArray6[n3] = 2.0 * (dArray5[n3] + dArray5[n3 + 1]);
        }
        for (n3 = 1; n3 < n2; ++n3) {
            d2 = -dArray5[n3 + 1] / dArray6[n3 - 1];
            int n4 = n3;
            dArray6[n4] = dArray6[n4] + d2 * dArray5[n3 - 1];
            int n5 = n3;
            dArray4[n5] = dArray4[n5] + d2 * dArray4[n3 - 1];
        }
        for (n3 = n2 - 1; n3 > 0; --n3) {
            dArray4[n3] = (dArray4[n3] - dArray5[n3] * dArray4[n3 + 1]) / dArray6[n3];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            d2 = dArray[n3 + 1] - dArray[n3];
            double d3 = (dArray2[n3 + 1] - dArray2[n3]) / d2;
            double d4 = dArray4[n3] + dArray4[n3 + 1] - 2.0 * d3;
            dArray5[n3] = (d3 - dArray4[n3] - d4) / d2;
            dArray6[n3] = d4 / (d2 * d2);
        }
    }

    public static double evaluateCubicSpline(double d2, double d3, double d4, double d5, double d6) {
        return d3 + d2 * (d4 + d2 * (d5 + d2 * d6));
    }

    public static double evaluateLinearSpline(double d2, double d3, double d4) {
        return d3 + d4 * d2;
    }

    public static double estimateInitialSlopeOfCurve(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = (d5 - d3) / (d4 - d2);
        double d9 = (d7 - d5) / (d6 - d4);
        double d10 = (d9 - d8) / (d6 - d2);
        return d8 + d10 * (d2 - d4);
    }

    public static Chart3dGridDataModel createLinearSampledDataModel(Chart3dGridDataModel chart3dGridDataModel, RectangularShape rectangularShape, int n2, int n3) {
        return JCData3dUtil.createSampledDataModel(chart3dGridDataModel, rectangularShape, n2, n3, 0);
    }

    public static Chart3dGridDataModel createLinearSampledDataModel(Chart3dGridDataModel chart3dGridDataModel, double[] dArray, double[] dArray2) {
        return JCData3dUtil.createSampledDataModel(chart3dGridDataModel, dArray, dArray2, 0);
    }

    public static Chart3dGridDataModel createCubicSampledDataModel(Chart3dGridDataModel chart3dGridDataModel, double[] dArray, double[] dArray2) {
        return JCData3dUtil.createSampledDataModel(chart3dGridDataModel, dArray, dArray2, 1);
    }

    public static Chart3dGridDataModel createCubicSampledDataModel(Chart3dGridDataModel chart3dGridDataModel, RectangularShape rectangularShape, int n2, int n3) {
        return JCData3dUtil.createSampledDataModel(chart3dGridDataModel, rectangularShape, n2, n3, 1);
    }

    private static Chart3dGridDataModel createSampledDataModel(Chart3dGridDataModel chart3dGridDataModel, RectangularShape rectangularShape, int n2, int n3, int n4) {
        int n5;
        double d2 = rectangularShape.getMinX();
        double d3 = rectangularShape.getMaxX();
        double d4 = rectangularShape.getMinY();
        double d5 = rectangularShape.getMaxY();
        double d6 = (d3 - d2) / (double)(n2 - 1);
        double d7 = (d5 - d4) / (double)(n3 - 1);
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n3];
        for (n5 = 0; n5 < n2; ++n5) {
            dArray[n5] = d2 + (double)n5 * d6;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            dArray2[n5] = d4 + (double)n5 * d7;
        }
        return JCData3dUtil.createSampledDataModel(chart3dGridDataModel, dArray, dArray2, n4);
    }

    private static Chart3dGridDataModel createSampledDataModel(Chart3dGridDataModel chart3dGridDataModel, double[] dArray, double[] dArray2, int n2) {
        if (JCData3dUtil.getSizeX(chart3dGridDataModel) < 2 || JCData3dUtil.getSizeY(chart3dGridDataModel) < 2) {
            throw new IllegalArgumentException("The source data must have atleast 2x2 data values to interpolate.");
        }
        if (dArray.length < 2 || dArray2.length < 2) {
            throw new IllegalArgumentException("Sample size must be atleast 2x2 to create a sampled data model.");
        }
        double d2 = JCData3dUtil.getHoleValue(chart3dGridDataModel);
        int n3 = JCData3dUtil.getSizeX(chart3dGridDataModel) == 2 ? 0 : n2;
        double[][] dArray3 = JCData3dUtil.createSampleData(chart3dGridDataModel.getXGrid(), chart3dGridDataModel.getYGrid(), chart3dGridDataModel.getZValues(), d2, false, dArray, n3);
        n3 = JCData3dUtil.getSizeY(chart3dGridDataModel) == 2 ? 0 : n2;
        double[][] dArray4 = JCData3dUtil.createSampleData(dArray, chart3dGridDataModel.getYGrid(), dArray3, d2, true, dArray2, n3);
        Base3dGridDataSource base3dGridDataSource = new Base3dGridDataSource(null, dArray, dArray2, dArray4);
        base3dGridDataSource.setHoleValue(d2);
        return base3dGridDataSource;
    }

    private static double[][] createSampleData(double[] dArray, double[] dArray2, double[][] dArray3, double d2, boolean bl, double[] dArray4, int n2) {
        boolean bl2 = n2 == 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray4.length;
        double[] dArray5 = bl ? dArray2 : dArray;
        double[] dArray6 = bl ? dArray : dArray2;
        double[] dArray7 = new double[dArray5.length];
        double[] dArray8 = new double[dArray5.length];
        double[] dArray9 = new double[dArray5.length];
        double[] dArray10 = new double[dArray5.length];
        double[] dArray11 = bl2 ? new double[dArray5.length] : null;
        double[] dArray12 = bl2 ? new double[dArray5.length] : null;
        double[][] dArray13 = bl ? new double[dArray.length][n5] : new double[n5][dArray2.length];
        int n6 = dArray5.length;
        int n7 = dArray6.length;
        for (int i2 = 0; i2 < n7; ++i2) {
            double d3;
            int n8;
            int n9 = 0;
            if (bl) {
                n3 = i2;
            } else {
                n4 = i2;
            }
            for (n8 = 0; n8 < n6; ++n8) {
                boolean bl3 = bl2 = n2 == 1;
                if (bl) {
                    n4 = n8;
                } else {
                    n3 = n8;
                }
                d3 = dArray3[n3][n4];
                if (d3 == d2) continue;
                dArray7[n9] = dArray5[n8];
                dArray8[n9] = d3;
                ++n9;
            }
            if (n9 > 2 && bl2) {
                JCData3dUtil.createCubicSplineCoefficients(dArray7, dArray8, dArray9, dArray10, dArray11, dArray12, n9);
            } else if (!bl2 && n9 >= 2 || n9 == 2) {
                bl2 = false;
                JCData3dUtil.createLinearSplineCoefficients(dArray7, dArray8, dArray9, dArray10, n9);
            }
            for (n8 = 0; n8 < n5; ++n8) {
                double d4;
                if (bl) {
                    n4 = n8;
                } else {
                    n3 = n8;
                }
                d3 = dArray4[n8];
                int n10 = JCData3dUtil.findInsertionIndex(d3, dArray5);
                if (n10 < 0) {
                    d4 = d2;
                } else if (bl && (dArray3[n3][n10 - 1] == d2 || dArray3[n3][n10] == d2)) {
                    d4 = d2;
                } else if (!(bl || dArray3[n10 - 1][n4] != d2 && dArray3[n10][n4] != d2)) {
                    d4 = d2;
                } else {
                    n10 = JCData3dUtil.findInsertionIndex(d3, dArray7, n9);
                    if (n10 < 0) {
                        d4 = d2;
                    } else {
                        d3 -= dArray7[--n10];
                        d4 = bl2 ? JCData3dUtil.evaluateCubicSpline(d3, dArray9[n10], dArray10[n10], dArray11[n10], dArray12[n10]) : JCData3dUtil.evaluateLinearSpline(d3, dArray9[n10], dArray10[n10]);
                    }
                }
                dArray13[n3][n4] = d4;
            }
        }
        return dArray13;
    }

    public static double getHoleValue(Chart3dDataModel chart3dDataModel) {
        if (chart3dDataModel instanceof HoleValueChart3dDataModel) {
            return ((HoleValueChart3dDataModel)((Object)chart3dDataModel)).getHoleValue();
        }
        return Double.MAX_VALUE;
    }

    public static int getSizeX(Chart3dGridDataModel chart3dGridDataModel) {
        if (chart3dGridDataModel.getXGrid() != null) {
            return chart3dGridDataModel.getXGrid().length;
        }
        return 0;
    }

    public static int getSizeY(Chart3dGridDataModel chart3dGridDataModel) {
        if (chart3dGridDataModel.getYGrid() != null) {
            return chart3dGridDataModel.getYGrid().length;
        }
        return 0;
    }

    public static Base3dDataSource createXMLDataSource(Object object, LoadProperties loadProperties, boolean bl, Base3dDataSource base3dDataSource) throws IOException {
        Object object2;
        if (object == null) {
            throw new JCParseException("Cannot parse null object");
        }
        InputSource inputSource = null;
        InputStream inputStream = null;
        boolean bl2 = false;
        if (object instanceof InputSource) {
            inputSource = (InputSource)object;
        }
        if (object instanceof File) {
            object2 = (File)object;
            inputStream = new FileInputStream((File)object2);
            bl2 = true;
            inputSource = new InputSource(inputStream);
        } else if (object instanceof String) {
            inputStream = new FileInputStream((String)object);
            bl2 = true;
            inputSource = new InputSource(inputStream);
        } else if (object instanceof URL) {
            inputStream = ((URL)object).openStream();
            bl2 = true;
            inputSource = new InputSource(inputStream);
        } else if (object instanceof InputStream) {
            inputSource = new InputSource((InputStream)object);
        } else if (object instanceof Reader) {
            inputSource = new InputSource((Reader)object);
        }
        if (inputSource == null) {
            throw new JCParseException("Input source is not one of InputSource, File, String, URL, InputStream, or Reader");
        }
        if (inputSource.getSystemId() == null) {
            if (loadProperties != null) {
                inputSource.setSystemId(loadProperties.getLocalEntitySystemId());
            } else {
                inputSource.setSystemId("");
            }
        }
        object2 = SAXParserFactory.newInstance();
        ((SAXParserFactory)object2).setValidating(bl);
        XML3dDataHandler xML3dDataHandler = new XML3dDataHandler(base3dDataSource);
        try {
            ErrorHandler errorHandler;
            SAXParser sAXParser = ((SAXParserFactory)object2).newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(xML3dDataHandler);
            ErrorHandler errorHandler2 = errorHandler = loadProperties == null ? null : loadProperties.getXmlErrorHandler();
            if (errorHandler == null) {
                errorHandler = new JCXMLErrorPrinter();
            }
            xMLReader.setErrorHandler(errorHandler);
            xMLReader.setEntityResolver(new JCXMLDTDResolver(DATA_DTD_NAME, xML3dDataHandler.getClass()));
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new JCParseException(sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JCParseException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
        finally {
            if (bl2) {
                inputStream.close();
            }
        }
        return xML3dDataHandler.getDataSource();
    }
}

