/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCView3d;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class View3dEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static final String nameKey = "View 3D";
    private boolean refreshing = false;
    private Container content;
    private JTextField perspectiveField;
    private JTextField xRotationField;
    private JTextField yRotationField;
    private JTextField zRotationField;

    public View3dEditor() {
        super(nameKey);
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = View3dEditor.getLocalizedString("Perspective");
            JLabel jLabel = new JLabel(string);
            this.perspectiveField = View3dEditor.createTextField(12, this, this);
            string = View3dEditor.getLocalizedString("X Rotation");
            JLabel jLabel2 = new JLabel(string);
            this.xRotationField = View3dEditor.createTextField(12, this, this);
            string = View3dEditor.getLocalizedString("Y Rotation");
            JLabel jLabel3 = new JLabel(string);
            this.yRotationField = View3dEditor.createTextField(12, this, this);
            string = View3dEditor.getLocalizedString("Z Rotation");
            JLabel jLabel4 = new JLabel(string);
            this.zRotationField = View3dEditor.createTextField(12, this, this);
            JPanel jPanel = new JPanel(new GridLayout(4, 0, 5, 5));
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            jPanel.add(jLabel3);
            jPanel.add(jLabel4);
            JPanel jPanel2 = new JPanel(new GridLayout(4, 0, 5, 5));
            jPanel2.add(this.perspectiveField);
            jPanel2.add(this.xRotationField);
            jPanel2.add(this.yRotationField);
            jPanel2.add(this.zRotationField);
            JPanel jPanel3 = View3dEditor.createPreferredSizePanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel3);
        }
        return this.content;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            JTextField[] jTextFieldArray = new JTextField[]{this.perspectiveField, this.xRotationField, this.yRotationField, this.zRotationField};
            for (int i2 = 0; i2 < 4; ++i2) {
                jTextFieldArray[i2].removeActionListener(this);
                jTextFieldArray[i2].removeFocusListener(this);
            }
            jTextFieldArray = null;
            this.perspectiveField = null;
            this.xRotationField = null;
            this.yRotationField = null;
            this.zRotationField = null;
            this.content = null;
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            JCView3d jCView3d = this.getChart().getChart3dArea().getView3d();
            this.perspectiveField.setText(String.valueOf(jCView3d.getPerspective()));
            this.xRotationField.setText(String.valueOf(jCView3d.getXRotation()));
            this.yRotationField.setText(String.valueOf(jCView3d.getYRotation()));
            this.zRotationField.setText(String.valueOf(jCView3d.getZRotation()));
            this.refreshing = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            Double d2 = View3dEditor.parseDoubleInput((JTextField)object);
            if (d2 == null) {
                this.refreshEditor();
                return;
            }
            double d3 = d2;
            JCView3d jCView3d = this.getChart().getChart3dArea().getView3d();
            if (object == this.perspectiveField) {
                jCView3d.setPerspective(d3);
            } else if (object == this.xRotationField) {
                jCView3d.setXRotation(d3);
            } else if (object == this.yRotationField) {
                jCView3d.setYRotation(d3);
            } else if (object == this.zRotationField) {
                jCView3d.setZRotation(d3);
            }
        }
    }
}

