/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCViewport;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PlotCubeViewportEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static String nameKey = "Viewport";
    private Container content;
    private JCheckBox isNormalizedCheckBox;
    private JTextField scaleField;
    private JTextField horizontalShiftField;
    private JTextField verticalShiftField;
    private JComboBox previewMethodComboBox;

    public PlotCubeViewportEditor() {
        super(nameKey);
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = PlotCubeViewportEditor.getLocalizedString("Normalized");
            this.isNormalizedCheckBox = PlotCubeViewportEditor.createCheckBox(string, this);
            string = PlotCubeViewportEditor.getLocalizedString("Scale");
            JLabel jLabel = new JLabel(string);
            this.scaleField = PlotCubeViewportEditor.createTextField(10, this, this);
            string = PlotCubeViewportEditor.getLocalizedString("Horizontal Shift");
            JLabel jLabel2 = new JLabel(string);
            this.horizontalShiftField = PlotCubeViewportEditor.createTextField(10, this, this);
            string = PlotCubeViewportEditor.getLocalizedString("Vertical Shift");
            JLabel jLabel3 = new JLabel(string);
            this.verticalShiftField = PlotCubeViewportEditor.createTextField(10, this, this);
            string = PlotCubeViewportEditor.getLocalizedString("Preview Method");
            JLabel jLabel4 = new JLabel(string);
            Object[] objectArray = new String[]{PlotCubeViewportEditor.getLocalizedString("Cube"), PlotCubeViewportEditor.getLocalizedString("Full")};
            this.previewMethodComboBox = PlotCubeViewportEditor.createComboBox(objectArray, this);
            JPanel jPanel = new JPanel(new GridLayout(5, 0, 5, 5));
            jPanel.add(this.isNormalizedCheckBox);
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            jPanel.add(jLabel3);
            jPanel.add(jLabel4);
            JPanel jPanel2 = new JPanel(new GridLayout(5, 0, 5, 5));
            jPanel2.add(new JPanel());
            jPanel2.add(this.scaleField);
            jPanel2.add(this.horizontalShiftField);
            jPanel2.add(this.verticalShiftField);
            jPanel2.add(this.previewMethodComboBox);
            JPanel jPanel3 = PlotCubeViewportEditor.createBorderPanel();
            jPanel3.setBorder(null);
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add(jPanel2);
            JPanel jPanel4 = PlotCubeViewportEditor.createPreferredSizePanel();
            jPanel4.add(jPanel3);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel4);
        }
        return this.content;
    }

    public void finalizeEditor() {
        this.content = null;
    }

    public void refreshEditor() {
        if (this.content != null) {
            JCViewport jCViewport = this.getChart().getChart3dArea().getViewport();
            this.isNormalizedCheckBox.setSelected(jCViewport.isNormalized());
            this.scaleField.setText(String.valueOf(jCViewport.getScale()));
            this.horizontalShiftField.setText(String.valueOf(jCViewport.getHorizontalShift()));
            this.verticalShiftField.setText(String.valueOf(jCViewport.getVerticalShift()));
            int n2 = 0;
            n2 = jCViewport.getPreviewMethod() == 1 ? 0 : 1;
            this.previewMethodComboBox.setSelectedIndex(n2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    private void handleChange(Object object) {
        JCViewport jCViewport = this.getChart().getChart3dArea().getViewport();
        if (object == this.isNormalizedCheckBox) {
            jCViewport.setNormalized(this.isNormalizedCheckBox.isSelected());
            return;
        }
        if (object == this.previewMethodComboBox) {
            if (this.previewMethodComboBox.getSelectedIndex() == 0) {
                jCViewport.setPreviewMethod(1);
            } else {
                jCViewport.setPreviewMethod(2);
            }
            return;
        }
        Double d2 = PlotCubeViewportEditor.parseDoubleInput((JTextField)object);
        if (d2 == null) {
            this.refreshEditor();
            return;
        }
        double d3 = d2;
        if (object == this.scaleField) {
            double d4 = JCChart3dUtil.clamp(d3, 0.03333333333333333, 30.0);
            jCViewport.setScale(d4);
            if (d4 != d3) {
                this.refreshEditor();
            }
        } else if (object == this.horizontalShiftField) {
            jCViewport.setHorizontalShift(d3);
        } else if (object == this.verticalShiftField) {
            jCViewport.setVerticalShift(d3);
        }
    }
}

