/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.ComboBoxEntry;
import com.klg.jclass.chart3d.customizer.DataViewEditor;
import com.klg.jclass.chart3d.customizer.MutableComboBoxEntry;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataViewGeneralEditor
extends Chart3dPropertyEditor
implements ActionListener {
    private static String nameKey = "General";
    private boolean refreshing;
    private Container content;
    private JComboBox chartTypeComboBox;
    private JComboBox zoneMethodComboBox;
    private JCheckBox isContouredCheckBox;
    private JCheckBox isZonedCheckBox;
    private JCheckBox isMeshedCheckBox;
    private JCheckBox isShadedCheckBox;
    private JCheckBox isTransparentCheckBox;
    private Object[] chartTypeModel;
    private Object[] zoneMethodModel;

    public DataViewGeneralEditor() {
        super(nameKey);
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = DataViewGeneralEditor.getLocalizedString("Chart Type");
            JLabel jLabel = new JLabel(string);
            this.chartTypeModel = new ComboBoxEntry[]{new ComboBoxEntry(2, DataViewGeneralEditor.getLocalizedString("Scatter")), new ComboBoxEntry(0, DataViewGeneralEditor.getLocalizedString("Surface")), new ComboBoxEntry(1, DataViewGeneralEditor.getLocalizedString("Bar"))};
            Arrays.sort(this.chartTypeModel);
            this.chartTypeComboBox = DataViewGeneralEditor.createComboBox(this.chartTypeModel, this);
            string = DataViewGeneralEditor.getLocalizedString("Zone Method");
            JLabel jLabel2 = new JLabel(string);
            this.zoneMethodModel = new ComboBoxEntry[]{new ComboBoxEntry(1, DataViewGeneralEditor.getLocalizedString("Contour")), new ComboBoxEntry(2, DataViewGeneralEditor.getLocalizedString("Cell Average")), new ComboBoxEntry(3, DataViewGeneralEditor.getLocalizedString("Cell Corner"))};
            Arrays.sort(this.zoneMethodModel);
            this.zoneMethodComboBox = DataViewGeneralEditor.createComboBox(this.zoneMethodModel, this);
            string = DataViewGeneralEditor.getLocalizedString("Contoured");
            this.isContouredCheckBox = DataViewGeneralEditor.createCheckBox(string, this);
            string = DataViewGeneralEditor.getLocalizedString("Zoned");
            this.isZonedCheckBox = DataViewGeneralEditor.createCheckBox(string, this);
            string = DataViewGeneralEditor.getLocalizedString("Meshed");
            this.isMeshedCheckBox = DataViewGeneralEditor.createCheckBox(string, this);
            string = DataViewGeneralEditor.getLocalizedString("Shaded");
            this.isShadedCheckBox = DataViewGeneralEditor.createCheckBox(string, this);
            string = DataViewGeneralEditor.getLocalizedString("Transparent");
            this.isTransparentCheckBox = DataViewGeneralEditor.createCheckBox(string, this);
            JPanel jPanel = new JPanel(new GridLayout(7, 0, 5, 5));
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            jPanel.add(this.isContouredCheckBox);
            jPanel.add(this.isZonedCheckBox);
            jPanel.add(this.isMeshedCheckBox);
            jPanel.add(this.isShadedCheckBox);
            jPanel.add(this.isTransparentCheckBox);
            JPanel jPanel2 = new JPanel(new GridLayout(7, 0, 5, 5));
            jPanel2.add(this.chartTypeComboBox);
            jPanel2.add(this.zoneMethodComboBox);
            JPanel jPanel3 = DataViewGeneralEditor.createBorderPanel();
            jPanel3.setBorder(null);
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add(jPanel2);
            JPanel jPanel4 = DataViewGeneralEditor.createPreferredSizePanel();
            jPanel4.add(jPanel3);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel4);
        }
        return this.content;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.chartTypeComboBox.removeActionListener(this);
            this.chartTypeComboBox = null;
            this.zoneMethodComboBox.removeActionListener(this);
            this.zoneMethodComboBox = null;
            this.isContouredCheckBox.removeActionListener(this);
            this.isContouredCheckBox = null;
            this.isZonedCheckBox.removeActionListener(this);
            this.isZonedCheckBox = null;
            this.isMeshedCheckBox.removeActionListener(this);
            this.isMeshedCheckBox = null;
            this.isShadedCheckBox.removeActionListener(this);
            this.isShadedCheckBox = null;
            this.isTransparentCheckBox.removeActionListener(this);
            this.isTransparentCheckBox = null;
            this.content = null;
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            MutableComboBoxEntry mutableComboBoxEntry = new MutableComboBoxEntry();
            mutableComboBoxEntry.setConstant(chart3dDataView.getChartType());
            this.chartTypeComboBox.setSelectedIndex(Arrays.binarySearch(this.chartTypeModel, mutableComboBoxEntry));
            mutableComboBoxEntry.setConstant(chart3dDataView.getContour().getZoneMethod());
            this.zoneMethodComboBox.setSelectedIndex(Arrays.binarySearch(this.zoneMethodModel, mutableComboBoxEntry));
            this.isContouredCheckBox.setSelected(chart3dDataView.getContour().isContoured());
            this.isZonedCheckBox.setSelected(chart3dDataView.getContour().isZoned());
            this.isMeshedCheckBox.setSelected(chart3dDataView.getElevation().isMeshed());
            this.isShadedCheckBox.setSelected(chart3dDataView.getElevation().isShaded());
            this.isTransparentCheckBox.setSelected(chart3dDataView.getElevation().isTransparent());
            this.refreshing = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            if (object == this.isMeshedCheckBox) {
                chart3dDataView.getElevation().setMeshed(this.isMeshedCheckBox.isSelected());
            } else if (object == this.isShadedCheckBox) {
                chart3dDataView.getElevation().setShaded(this.isShadedCheckBox.isSelected());
            } else if (object == this.isTransparentCheckBox) {
                chart3dDataView.getElevation().setTransparent(this.isTransparentCheckBox.isSelected());
            } else if (object == this.isContouredCheckBox) {
                chart3dDataView.getContour().setContoured(this.isContouredCheckBox.isSelected());
            } else if (object == this.isZonedCheckBox) {
                chart3dDataView.getContour().setZoned(this.isZonedCheckBox.isSelected());
            } else {
                JComboBox jComboBox = (JComboBox)object;
                int n2 = ((ComboBoxEntry)jComboBox.getSelectedItem()).getConstant();
                if (object == this.chartTypeComboBox) {
                    chart3dDataView.setChartType(n2);
                } else {
                    chart3dDataView.getContour().setZoneMethod(n2);
                }
            }
        }
    }
}

