/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.DataViewEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataViewContourStylesEditor
extends Chart3dPropertyEditor
implements ActionListener,
ListDataListener,
ListSelectionListener {
    private static String[] children = new String[]{"com.klg.jclass.chart3d.customizer.DataViewContourStyleLineStyleEditor", "com.klg.jclass.chart3d.customizer.DataViewContourStyleSymbolStyleEditor", "com.klg.jclass.chart3d.customizer.DataViewContourStyleFillStyleEditor"};
    private static final String nameKey = "Contour Styles";
    private static String style = Chart3dPropertyEditor.getLocalizedString("Style");
    private boolean refreshing = false;
    private Container content;
    private JList contourStylesList;
    private JButton addButton;
    private JButton removeButton;
    private JButton resetButton;
    private ContourStylesModel contourStylesModel;

    public DataViewContourStylesEditor() {
        super(nameKey, children);
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = DataViewContourStylesEditor.getLocalizedString("Add");
            this.addButton = DataViewContourStylesEditor.createButton(string, this);
            string = DataViewContourStylesEditor.getLocalizedString("Remove");
            this.removeButton = DataViewContourStylesEditor.createButton(string, this);
            string = DataViewContourStylesEditor.getLocalizedString("Reset Styles");
            this.resetButton = DataViewContourStylesEditor.createButton(string, this);
            this.contourStylesModel = new ContourStylesModel();
            this.contourStylesModel.addListDataListener(this);
            this.contourStylesList = new JList(this.contourStylesModel);
            this.contourStylesList.addListSelectionListener(this);
            this.contourStylesList.setPrototypeCellValue("XXXXXXXXXXXX");
            JScrollPane jScrollPane = new JScrollPane(this.contourStylesList);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setAlignmentX(0.0f);
            JPanel jPanel = DataViewContourStylesEditor.createPreferredSizePanel();
            jPanel.setLayout(new GridLayout(3, 0, 5, 5));
            jPanel.add(this.addButton);
            jPanel.add(this.removeButton);
            jPanel.add(this.resetButton);
            jPanel.setAlignmentX(0.0f);
            this.content = DataViewContourStylesEditor.createPreferredSizePanel();
            this.content.setLayout(new BoxLayout(this.content, 1));
            this.content.add(jScrollPane);
            this.content.add(Box.createVerticalStrut(5));
            this.content.add(jPanel);
            this.content.add(Box.createVerticalGlue());
        }
        return this.content;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.contourStylesList.removeListSelectionListener(this);
            this.contourStylesList = null;
            this.contourStylesModel.removeListDataListener(this);
            this.contourStylesModel = null;
            this.contourStylesList = null;
            this.addButton.removeActionListener(this);
            this.addButton = null;
            this.removeButton.removeActionListener(this);
            this.removeButton = null;
            this.resetButton.removeActionListener(this);
            this.resetButton = null;
            this.content = null;
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            JCContour jCContour = dataViewEditor.getSelectedDataView().getContour();
            this.contourStylesModel.setContourStyles(jCContour.getContourStyles());
            this.refreshing = false;
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.handleContourStyleChange();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.handleContourStyleChange();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.handleContourStyleChange();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.refreshing && !listSelectionEvent.getValueIsAdjusting()) {
            this.refreshEditorTree(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            JCContour jCContour = dataViewEditor.getSelectedDataView().getContour();
            Object object = actionEvent.getSource();
            if (object == this.addButton) {
                this.contourStylesModel.add(new JCContourStyle());
            } else if (object == this.removeButton) {
                if (this.getSel() != -1) {
                    this.contourStylesModel.remove(this.getSel());
                }
            } else if (object == this.resetButton) {
                jCContour.resetContourStyles();
            }
        }
    }

    private void handleContourStyleChange() {
        if (this.refreshing) {
            return;
        }
        DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
        JCContour jCContour = dataViewEditor.getSelectedDataView().getContour();
        if (jCContour != null) {
            jCContour.setContourStyles(this.contourStylesModel.getContourStyles());
        }
    }

    private int getSel() {
        return this.contourStylesList.getSelectedIndex();
    }

    protected JCLineStyle getSelectedLineStyle() {
        if (this.getSel() != -1) {
            return this.contourStylesModel.getContourStyleAt(this.getSel()).getLineStyle();
        }
        return null;
    }

    protected JCFillStyle getSelectedFillStyle() {
        if (this.getSel() != -1) {
            return this.contourStylesModel.getContourStyleAt(this.getSel()).getFillStyle();
        }
        return null;
    }

    protected JCSymbolStyle getSelectedSymbolStyle() {
        if (this.getSel() != -1) {
            return this.contourStylesModel.getContourStyleAt(this.getSel()).getSymbolStyle();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContourStylesModel
    extends AbstractListModel {
        private List<JCContourStyle> contourStyles;

        public void setContourStyles(List<JCContourStyle> list) {
            if (this.getSize() > 0) {
                this.fireIntervalRemoved(this, 0, this.getSize() - 1);
            }
            if (list == null) {
                return;
            }
            this.contourStyles = list;
            if (this.getSize() > 0) {
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        public List<JCContourStyle> getContourStyles() {
            return this.contourStyles;
        }

        @Override
        public Object getElementAt(int n2) {
            return this.toString(n2, this.contourStyles.get(n2));
        }

        public JCContourStyle getContourStyleAt(int n2) {
            return this.contourStyles.get(n2);
        }

        @Override
        public int getSize() {
            if (this.contourStyles == null) {
                return 0;
            }
            return this.contourStyles.size();
        }

        public void remove(int n2) {
            this.contourStyles.remove(n2);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public void add(JCContourStyle jCContourStyle) {
            this.contourStyles.add(jCContourStyle);
            this.fireIntervalAdded(this, this.getSize(), this.getSize());
        }

        private String toString(int n2, JCContourStyle jCContourStyle) {
            if (jCContourStyle == null) {
                return "";
            }
            return style + " " + n2;
        }
    }
}

