/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCBar;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.ComboBoxEntry;
import com.klg.jclass.chart3d.customizer.MutableComboBoxEntry;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ChartAreaBarEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static final String nameKey = "Bar";
    private boolean refreshing = false;
    private Container content;
    private JTextField xSpacingField;
    private JComboBox xFormatComboBox;
    private JTextField ySpacingField;
    private JComboBox yFormatComboBox;
    private Object[] formatModel;

    public ChartAreaBarEditor() {
        super(nameKey);
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = ChartAreaBarEditor.getLocalizedString("X Format");
            JLabel jLabel = new JLabel(string);
            string = ChartAreaBarEditor.getLocalizedString("Y Format");
            JLabel jLabel2 = new JLabel(string);
            string = ChartAreaBarEditor.getLocalizedString("X Spacing");
            JLabel jLabel3 = new JLabel(string);
            string = ChartAreaBarEditor.getLocalizedString("Y Spacing");
            JLabel jLabel4 = new JLabel(string);
            this.formatModel = new ComboBoxEntry[]{new ComboBoxEntry(1, ChartAreaBarEditor.getLocalizedString("Fixed")), new ComboBoxEntry(2, ChartAreaBarEditor.getLocalizedString("Histogram"))};
            Arrays.sort(this.formatModel);
            this.xFormatComboBox = ChartAreaBarEditor.createComboBox(this.formatModel, this);
            this.yFormatComboBox = ChartAreaBarEditor.createComboBox(this.formatModel, this);
            this.xSpacingField = ChartAreaBarEditor.createTextField(10, this, this);
            this.ySpacingField = ChartAreaBarEditor.createTextField(10, this, this);
            JPanel jPanel = new JPanel(new GridLayout(4, 0, 5, 5));
            jPanel.add(jLabel);
            jPanel.add(jLabel3);
            jPanel.add(jLabel2);
            jPanel.add(jLabel4);
            JPanel jPanel2 = new JPanel(new GridLayout(4, 0, 5, 5));
            jPanel2.add(this.xFormatComboBox);
            jPanel2.add(this.xSpacingField);
            jPanel2.add(this.yFormatComboBox);
            jPanel2.add(this.ySpacingField);
            JPanel jPanel3 = ChartAreaBarEditor.createBorderPanel();
            jPanel3.setBorder(null);
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add(jPanel2);
            JPanel jPanel4 = ChartAreaBarEditor.createPreferredSizePanel();
            jPanel4.add(jPanel3);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel4);
        }
        return this.content;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.xSpacingField.removeActionListener(this);
            this.xSpacingField.removeFocusListener(this);
            this.xSpacingField = null;
            this.xFormatComboBox.removeActionListener(this);
            this.xFormatComboBox = null;
            this.ySpacingField.removeActionListener(this);
            this.ySpacingField.removeFocusListener(this);
            this.ySpacingField = null;
            this.yFormatComboBox.removeActionListener(this);
            this.yFormatComboBox = null;
            this.content = null;
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            JCBar jCBar = this.getChart().getChart3dArea().getBar();
            MutableComboBoxEntry mutableComboBoxEntry = new MutableComboBoxEntry();
            mutableComboBoxEntry.setConstant(jCBar.getXFormat());
            this.xFormatComboBox.setSelectedIndex(Arrays.binarySearch(this.formatModel, mutableComboBoxEntry));
            mutableComboBoxEntry.setConstant(jCBar.getYFormat());
            this.yFormatComboBox.setSelectedIndex(Arrays.binarySearch(this.formatModel, mutableComboBoxEntry));
            this.xSpacingField.setText(String.valueOf(jCBar.getXSpacing()));
            this.ySpacingField.setText(String.valueOf(jCBar.getYSpacing()));
            this.refreshing = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            JCBar jCBar = this.getChart().getChart3dArea().getBar();
            if (object instanceof JComboBox) {
                Object object2 = ((JComboBox)object).getSelectedItem();
                int n2 = ((ComboBoxEntry)object2).getConstant();
                if (object == this.xFormatComboBox) {
                    jCBar.setXFormat(n2);
                } else {
                    jCBar.setYFormat(n2);
                }
            } else if (object instanceof JTextField) {
                Double d2 = ChartAreaBarEditor.parseDoubleInput((JTextField)object);
                if (d2 == null || d2 < 0.0) {
                    this.refreshEditor();
                    return;
                }
                if (object == this.xSpacingField) {
                    jCBar.setXSpacing(d2);
                } else {
                    jCBar.setYSpacing(d2);
                }
            }
        }
    }
}

