/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.PropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AxesEditor
extends Chart3dPropertyEditor
implements ListSelectionListener {
    private static String[] children = new String[]{"com.klg.jclass.chart3d.customizer.AxisGeneralEditor", "com.klg.jclass.chart3d.customizer.AxisLimitsEditor", "com.klg.jclass.chart3d.customizer.AxisGridLinesEditor", "com.klg.jclass.chart3d.customizer.AxisGridStyleEditor", "com.klg.jclass.chart3d.customizer.AxisValueLabelsEditor", "com.klg.jclass.chart3d.customizer.AxisTitleEditor", "com.klg.jclass.chart3d.customizer.AxisAnnoFontEditor"};
    private static final String nameKey = "Axes";
    private Container content;
    private JList axesList;

    public AxesEditor() {
        super(nameKey, children);
    }

    public AxesEditor(PropertyEditor propertyEditor) {
        super(nameKey, propertyEditor, children);
    }

    public Component getEditor() {
        if (this.content == null) {
            String[] stringArray = new String[]{AxesEditor.getLocalizedString("X Axis"), AxesEditor.getLocalizedString("Y Axis"), AxesEditor.getLocalizedString("Z Axis")};
            this.axesList = AxesEditor.createList(stringArray, this);
            this.axesList.setPrototypeCellValue("XXXXXXXX");
            JPanel jPanel = AxesEditor.createPreferredSizePanel();
            jPanel.setLayout(new GridLayout(0, 1, 5, 5));
            jPanel.add(this.axesList);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel);
        }
        return this.content;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.refreshEditorTree();
    }

    public JCAxis getSelectedAxis() {
        if (this.content != null) {
            JCChart3dArea jCChart3dArea = this.getChart().getChart3dArea();
            int n2 = this.axesList.getSelectedIndex();
            switch (n2) {
                case 0: {
                    return jCChart3dArea.getAxis(1);
                }
                case 1: {
                    return jCChart3dArea.getAxis(2);
                }
                case 2: {
                    return jCChart3dArea.getAxis(3);
                }
            }
        }
        return null;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.axesList.removeListSelectionListener(this);
            this.axesList = null;
            this.content = null;
        }
    }
}

