/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.beans;

import com.klg.jclass.chart3d.beans.JCChart3dBeanBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.JPanel;

public abstract class BaseEditor
extends JPanel
implements PropertyEditor {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Object valueObj = null;

    public BaseEditor() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.makePropertyPanel();
        if (jPanel != null) {
            this.add("Center", jPanel);
        }
    }

    protected abstract JPanel makePropertyPanel();

    public void setValue(Object object) {
        this.valueObj = object;
    }

    public Object getValue() {
        return this.valueObj;
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public String getAsText() {
        return "Click to edit...";
    }

    public String[] getTags() {
        return null;
    }

    public String getJavaInitializationString() {
        return "\"" + this.valueObj + "\"";
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 0);
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChart3dBeanBundle.string("Click to edit...");
        if (string == null) {
            string = "";
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n2);
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

