/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.Facet;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.GridRegion;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCSurface;
import com.klg.jclass.chart3d.ScreenPoint;
import java.awt.Graphics;
import java.io.Serializable;

public class ProcessGrid
implements Serializable {
    public static final int MAX_POINTS = 500;
    protected DrawGrid drawGrid = null;
    protected Facet facet = null;

    public ProcessGrid() {
    }

    public ProcessGrid(DrawGrid drawGrid) {
        this.drawGrid = drawGrid;
    }

    protected DrawGrid getDrawGrid() {
        return this.drawGrid;
    }

    protected void setDrawGrid(DrawGrid drawGrid) {
        this.drawGrid = drawGrid;
    }

    protected Facet getFacet() {
        return this.facet;
    }

    public void setFacet(Facet facet) {
        this.facet = facet;
    }

    public void processGridRegion(GridRegion gridRegion) {
        if (this.facet == null) {
            return;
        }
        int n2 = gridRegion.getXBegin();
        int n3 = gridRegion.getXLeft();
        int n4 = gridRegion.getXEye();
        int n5 = gridRegion.getXRight();
        int n6 = gridRegion.getXEnd();
        int n7 = gridRegion.getYBegin();
        int n8 = gridRegion.getYLeft();
        int n9 = gridRegion.getYEye();
        int n10 = gridRegion.getYRight();
        int n11 = gridRegion.getYEnd();
        this.processGrid(n6, n5, -1, n11, n10, -1, 6);
        this.processGrid(n6, n5, -1, n7, n8, 1, 7);
        this.processGrid(n2, n3, 1, n11, n10, -1, 8);
        this.processGrid(n2, n3, 1, n7, n8, 1, 9);
        if (n5 == n3 + 2) {
            this.processY(n4, n11, n10, -1, 2);
            this.processY(n4, n7, n8, 1, 3);
        }
        if (n10 == n8 + 2) {
            this.processX(n9, n6, n5, -1, 4);
            this.processX(n9, n2, n3, 1, 5);
            if (n5 == n3 + 2) {
                this.facet.processFacet(n4, n9, 1);
            }
        }
    }

    protected void processXY(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n4 > 0) {
            if (n7 > 0) {
                for (int i2 = n2; i2 <= n3; ++i2) {
                    for (int i3 = n5; i3 <= n6; ++i3) {
                        this.facet.processFacet(i2, i3, n8);
                    }
                }
            } else {
                for (int i4 = n2; i4 <= n3; ++i4) {
                    for (int i5 = n5; i5 >= n6; --i5) {
                        this.facet.processFacet(i4, i5, n8);
                    }
                }
            }
        } else if (n7 > 0) {
            for (int i6 = n2; i6 >= n3; --i6) {
                for (int i7 = n5; i7 <= n6; ++i7) {
                    this.facet.processFacet(i6, i7, n8);
                }
            }
        } else {
            for (int i8 = n2; i8 >= n3; --i8) {
                for (int i9 = n5; i9 >= n6; --i9) {
                    this.facet.processFacet(i8, i9, n8);
                }
            }
        }
    }

    protected void processYX(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n7 > 0) {
            if (n4 > 0) {
                for (int i2 = n5; i2 <= n6; ++i2) {
                    for (int i3 = n2; i3 <= n3; ++i3) {
                        this.facet.processFacet(i3, i2, n8);
                    }
                }
            } else {
                for (int i4 = n5; i4 <= n6; ++i4) {
                    for (int i5 = n2; i5 >= n3; --i5) {
                        this.facet.processFacet(i5, i4, n8);
                    }
                }
            }
        } else if (n4 > 0) {
            for (int i6 = n5; i6 >= n6; --i6) {
                for (int i7 = n2; i7 <= n3; ++i7) {
                    this.facet.processFacet(i7, i6, n8);
                }
            }
        } else {
            for (int i8 = n5; i8 >= n6; --i8) {
                for (int i9 = n2; i9 >= n3; --i9) {
                    this.facet.processFacet(i9, i8, n8);
                }
            }
        }
    }

    protected void processGrid(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        JCChart3dArea jCChart3dArea = chart3dGridData.getDataView().getChart3d().getChart3dArea();
        int n9 = jCChart3dArea.getTransform().getProcessingOrder() & 0xF;
        switch (n9) {
            case 4: 
            case 8: {
                this.processXY(n2, n3, n4, n5, n6, n7, n8);
                break;
            }
            default: {
                this.processYX(n2, n3, n4, n5, n6, n7, n8);
            }
        }
    }

    protected void processX(int n2, int n3, int n4, int n5, int n6) {
        if (n5 > 0) {
            for (int i2 = n3; i2 <= n4; ++i2) {
                this.facet.processFacet(i2, n2, n6);
            }
        } else {
            for (int i3 = n3; i3 >= n4; --i3) {
                this.facet.processFacet(i3, n2, n6);
            }
        }
    }

    protected void processY(int n2, int n3, int n4, int n5, int n6) {
        if (n5 > 0) {
            for (int i2 = n3; i2 <= n4; ++i2) {
                this.facet.processFacet(n2, i2, n6);
            }
        } else {
            for (int i3 = n3; i3 >= n4; --i3) {
                this.facet.processFacet(n2, i3, n6);
            }
        }
    }

    protected void flushLines(ScreenPoint[] screenPointArray, int n2, Graphics graphics) {
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            graphics.drawLine(screenPointArray[i2].getXPixel(), screenPointArray[i2].getYPixel(), screenPointArray[i2 + 1].getXPixel(), screenPointArray[i2 + 1].getYPixel());
        }
    }

    protected void drawFastMesh(Graphics graphics) {
        boolean bl;
        int n2;
        int n3;
        ScreenPoint[] screenPointArray = new ScreenPoint[500];
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        ScreenPoint[][] screenPointArray2 = chart3dGridData.getScreenPoints();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCSurface jCSurface = jCChart3dArea.getSurface();
        boolean[] blArray = jCSurface.getXMesh();
        boolean[] blArray2 = jCSurface.getYMesh();
        graphics.setColor(chart3dDataView.getElevation().getMeshBottomColor());
        int n4 = 0;
        if (jCSurface.isYMeshShowing()) {
            for (n3 = gridLimits.getXOffset(); n3 <= gridLimits.getXLast(); ++n3) {
                if (blArray2[n3]) {
                    for (n2 = gridLimits.getYOffset(); n2 <= gridLimits.getYLast(); ++n2) {
                        boolean bl2 = bl = screenPointArray2[n3][n2].isHoleValue() || (n3 == gridLimits.getXOffset() || screenPointArray2[n3 - 1][n2].isHoleValue()) && (n3 == gridLimits.getXLast() || screenPointArray2[n3 + 1][n2].isHoleValue());
                        if (bl) {
                            this.flushLines(screenPointArray, n4, graphics);
                            n4 = 0;
                            continue;
                        }
                        if (n4 == 500) {
                            this.flushLines(screenPointArray, n4, graphics);
                            n4 = 0;
                        }
                        screenPointArray[n4] = screenPointArray2[n3][n2];
                        ++n4;
                    }
                }
                this.flushLines(screenPointArray, n4, graphics);
                n4 = 0;
            }
        }
        if (jCSurface.isXMeshShowing()) {
            for (n3 = gridLimits.getYOffset(); n3 <= gridLimits.getYLast(); ++n3) {
                if (blArray[n3]) {
                    for (n2 = gridLimits.getXOffset(); n2 <= gridLimits.getXLast(); ++n2) {
                        boolean bl3 = bl = screenPointArray2[n2][n3].isHoleValue() || (n3 == gridLimits.getYOffset() || screenPointArray2[n2][n3 - 1].isHoleValue()) && (n3 == gridLimits.getYLast() || screenPointArray2[n2][n3 + 1].isHoleValue());
                        if (bl) {
                            this.flushLines(screenPointArray, n4, graphics);
                            n4 = 0;
                            continue;
                        }
                        if (n4 == 500) {
                            this.flushLines(screenPointArray, n4, graphics);
                            n4 = 0;
                        }
                        screenPointArray[n4] = screenPointArray2[n2][n3];
                        ++n4;
                    }
                }
                this.flushLines(screenPointArray, n4, graphics);
                n4 = 0;
            }
        }
    }
}

