/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.ParentTrackChange;
import com.klg.jclass.chart3d.resources.LocaleBundle;

public class JCViewport
extends ParentTrackChange {
    public static final int PREVIEW_CUBE = 1;
    public static final int PREVIEW_FULL = 2;
    public static final double MAX_VIEW_SCALE = 30.0;
    public static final double MIN_VIEW_SCALE = 0.03333333333333333;
    protected boolean normalized = true;
    protected double scale = 1.0;
    protected double horizontalShift = 0.0;
    protected double verticalShift = 0.0;
    protected int previewMethod = 1;
    static final long serialVersionUID = -5542417106751358122L;

    public JCViewport() {
    }

    public JCViewport(boolean bl, double d2, double d3, double d4) {
        this.normalized = bl;
        if (this.normalized) {
            this.scale = 1.0;
            this.horizontalShift = 0.0;
            this.verticalShift = 0.0;
        } else {
            this.scale = d2;
            this.horizontalShift = d3;
            this.verticalShift = d4;
            this.normalized = this.scale == 1.0 && this.horizontalShift == 0.0 && this.verticalShift == 0.0;
        }
    }

    public void setNormalized(boolean bl) {
        if (this.normalized == bl) {
            return;
        }
        if (bl) {
            this.scale = 1.0;
            this.horizontalShift = 0.0;
            this.verticalShift = 0.0;
        }
        this.normalized = bl;
        this.callParentSetChanged(true, 2);
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public void setScale(double d2) {
        if (this.scale == d2) {
            return;
        }
        this.scale = JCChart3dUtil.clamp(d2, 0.03333333333333333, 30.0);
        this.normalized = this.scale == 1.0 && this.horizontalShift == 0.0 && this.verticalShift == 0.0;
        this.callParentSetChanged(true, 2);
    }

    public double getScale() {
        return this.scale;
    }

    public void setHorizontalShift(double d2) {
        if (this.horizontalShift == d2) {
            return;
        }
        this.horizontalShift = d2;
        this.normalized = this.scale == 1.0 && this.horizontalShift == 0.0 && this.verticalShift == 0.0;
        this.callParentSetChanged(true, 2);
    }

    public double getHorizontalShift() {
        return this.horizontalShift;
    }

    public void setVerticalShift(double d2) {
        if (this.verticalShift == d2) {
            return;
        }
        this.verticalShift = d2;
        this.normalized = this.scale == 1.0 && this.horizontalShift == 0.0 && this.verticalShift == 0.0;
        this.callParentSetChanged(true, 2);
    }

    public double getVerticalShift() {
        return this.verticalShift;
    }

    public void setViewport(double d2, double d3, double d4) {
        this.scale = d2;
        this.horizontalShift = d3;
        this.verticalShift = d4;
        this.normalized = this.scale == 1.0 && this.horizontalShift == 0.0 && this.verticalShift == 0.0;
        this.callParentSetChanged(true, 2);
    }

    public void setPreviewMethod(int n2) {
        if (n2 < 1 && n2 > 2) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Should be one of PREVIEW_CUBE or PREVIEW_FULL."));
        }
        this.previewMethod = n2;
    }

    public int getPreviewMethod() {
        return this.previewMethod;
    }
}

