/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCBox;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.ParentTrackChange;
import com.klg.jclass.chart3d.Transform;
import javax.vecmath.Matrix4d;

public class JCSurface
extends ParentTrackChange {
    static final long serialVersionUID = -5542417106751358122L;
    public static final double PIXEL_SPREAD = 10.0;
    protected boolean solid = false;
    protected boolean xMeshShowing = true;
    protected boolean yMeshShowing = true;
    protected int xMeshFilter = 0;
    protected int yMeshFilter = 0;
    protected boolean[] xMesh = null;
    protected boolean[] yMesh = null;

    public JCSurface() {
    }

    public JCSurface(boolean bl, boolean bl2, boolean bl3, int n2, int n3) {
        this.solid = bl;
        this.xMeshShowing = bl2;
        this.yMeshShowing = bl3;
        this.xMeshFilter = n2;
        this.yMeshFilter = n3;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public void setSolid(boolean bl) {
        if (this.solid == bl) {
            return;
        }
        this.solid = bl;
        this.callParentSetChanged(true, 2);
    }

    public boolean isXMeshShowing() {
        return this.xMeshShowing;
    }

    public void setXMeshShowing(boolean bl) {
        if (this.xMeshShowing == bl) {
            return;
        }
        this.xMeshShowing = bl;
        this.callParentSetChanged(true, 1);
    }

    public boolean isYMeshShowing() {
        return this.yMeshShowing;
    }

    public void setYMeshShowing(boolean bl) {
        if (this.yMeshShowing == bl) {
            return;
        }
        this.yMeshShowing = bl;
        this.callParentSetChanged(true, 1);
    }

    public int getXMeshFilter() {
        return this.xMeshFilter;
    }

    public void setXMeshFilter(int n2) {
        if (this.xMeshFilter == n2) {
            return;
        }
        this.xMeshFilter = n2;
        this.callParentSetChanged(true, 1);
    }

    public int getYMeshFilter() {
        return this.yMeshFilter;
    }

    public void setYMeshFilter(int n2) {
        if (this.yMeshFilter == n2) {
            return;
        }
        this.yMeshFilter = n2;
        this.callParentSetChanged(true, 1);
    }

    public boolean[] getXMesh() {
        return this.xMesh;
    }

    public boolean[] getYMesh() {
        return this.yMesh;
    }

    public void computeMeshFiltering(Chart3dDataView chart3dDataView) {
        int n2;
        int n3;
        Chart3dData chart3dData = chart3dDataView.getElevationData();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        this.xMesh = null;
        this.yMesh = null;
        if (!chart3dDataView.getElevation().isMeshed() || chart3dDataView.getChartType() != 0 || !(chart3dData instanceof Chart3dGridData)) {
            return;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)chart3dData;
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        Transform transform = jCChart3dArea.getTransform();
        JCBox jCBox = transform.getCurrentViewport();
        Matrix4d matrix4d = transform.getScreen();
        int n4 = (int)(jCBox.width * matrix4d.m00);
        int n5 = (int)(-jCBox.height * matrix4d.m11);
        this.xMesh = new boolean[chart3dGridData.getNumY()];
        if (this.xMeshShowing) {
            n3 = this.xMeshFilter;
            if (n3 == 0) {
                n3 = (int)(10.0 / ((double)n5 / (double)gridLimits.getNumY()));
                n3 = Math.max(1, n3);
            }
            if (n3 == 1) {
                JCChart3dUtil.booleanfill(this.xMesh, true);
            } else {
                for (n2 = gridLimits.getYOffset(); n2 <= gridLimits.getYLast(); n2 += n3) {
                    this.xMesh[n2] = true;
                }
                this.xMesh[gridLimits.getYLast()] = true;
            }
        }
        this.yMesh = new boolean[chart3dGridData.getNumX()];
        if (this.yMeshShowing) {
            n3 = this.yMeshFilter;
            if (n3 == 0) {
                n3 = (int)(10.0 / ((double)n4 / (double)gridLimits.getNumX()));
                n3 = Math.max(1, n3);
            }
            if (n3 == 1) {
                JCChart3dUtil.booleanfill(this.yMesh, true);
            } else {
                for (n2 = gridLimits.getXOffset(); n2 <= gridLimits.getXLast(); n2 += n3) {
                    this.yMesh[n2] = true;
                }
                this.yMesh[gridLimits.getXLast()] = true;
            }
        }
    }
}

